/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.datastream.DSArea;
import jet.datastream.DSContainable;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSLabel;
import jet.datastream.DSPage;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.util.JRInterruptedException;
import jet.util.Propertiable;
import jet.util.VersionControlable;

public class DSAreaLabel
extends DSLabel
implements DSContainable {
    private boolean SEDU = false;
    Vector children = new Vector(10);
    private double add = 1.0;
    private double addElement = 1.0;

    @Override
    public void add(JRObjectResult jRObjectResult) {
        if (jRObjectResult == null) {
            return;
        }
        this.children.addElement(jRObjectResult);
        jRObjectResult.setParent(this);
    }

    @Override
    public void remove(JRObjectResult jRObjectResult) {
        int n = this.children.indexOf(jRObjectResult);
        if (n >= 0) {
            this.children.removeElementAt(n);
            jRObjectResult.setParent(null);
        }
    }

    public void setZoom(double d, double d2) {
        this.add = d;
        this.addElement = d2;
    }

    @Override
    public void paint(Graphics graphics) {
        Render render = this.getRender();
        render.setPaintCalledByField(true);
        double d = render.getRotation();
        if (this.SEDU) {
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, this.getBounds());
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            graphics2D.rotate(d, render.getRotationX(), render.getRotationY());
            render.paintFieldBackground(graphics2D);
            render.paintFieldBorder(graphics2D);
            Graphics2D graphics2D2 = (Graphics2D)graphics;
            graphics2D2.scale(this.add, this.addElement);
            render.paint(graphics2D2);
            graphics2D.rotate(-d, render.getRotationX(), render.getRotationY());
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else if (render instanceof RenderBarCode && !this.SEDU) {
            Rectangle rectangle = new Rectangle(0, 0, 1, 1);
            if (this.getWidth() <= 0) {
                rectangle.setBounds(0, 0, 1, 1);
            } else {
                rectangle = this.getBounds();
            }
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, rectangle);
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            render.paintFieldBackground(graphics2D);
            render.paintFieldBorder(graphics2D);
            Graphics2D graphics2D3 = (Graphics2D)graphics;
            graphics2D3.scale(this.add, this.addElement);
            render.paint(graphics2D3);
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else {
            render.paintFieldBackground(graphics);
            render.paintFieldBorder(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.scale(this.add, this.addElement);
            render.paint(graphics2D);
        }
        render.setPaintCalledByField(false);
    }

    @Override
    public void removeAll() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            JRObjectResult jRObjectResult = (JRObjectResult)this.children.elementAt(i);
            this.children.removeElementAt(i);
            jRObjectResult.setParent(null);
        }
    }

    @Override
    public Vector getChildren() {
        return this.children;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        int n = ((VersionControlable)((Object)dataInput)).getVersion();
        if (n < 262416 && n != 0) {
            return;
        }
        int n2 = dataInput.readInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = dataInput.readInt();
            JRObjectResult jRObjectResult = DSPage.createJRObjectResult(n3, this.locale, this.timezone);
            jRObjectResult.read(dataInput, dSDataStreamable);
            this.add(jRObjectResult);
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        int n = this.children.size();
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            ((JRObjectResult)this.children.elementAt(i)).write(dataOutput);
        }
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 4;
        int n2 = this.children.size();
        for (int i = 0; i < n2; ++i) {
            n += ((JRObjectResult)this.children.elementAt(i)).length();
        }
        return n;
    }

    @Override
    public void dump(PrintStream printStream) {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            ((JRObjectResult)this.children.elementAt(i)).dump(printStream);
        }
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timezone;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSAreaLabel());
    }

    public DSAreaLabel dup(DSAreaLabel dSAreaLabel) {
        super.dup(dSAreaLabel);
        for (int i = 0; i < this.children.size(); ++i) {
            dSAreaLabel.add((JRObjectResult)((JRObjectResult)this.children.elementAt(i)).copyObject());
        }
        dSAreaLabel.locale = this.locale;
        dSAreaLabel.timezone = this.timezone;
        return dSAreaLabel;
    }

    @Override
    public int getLinkCondition() {
        return ((DSArea)this.getParent()).getLinkCondition();
    }

    @Override
    public int getLinkPage() {
        return ((DSArea)this.getParent()).getLinkPage();
    }

    @Override
    public int getLinkComm() {
        return ((DSArea)this.getParent()).getLinkComm();
    }

    @Override
    public Record getSynRecord() {
        return ((DSArea)this.getParent()).getSynRecord();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Propertiable getPropertyByName(String string, Record record) {
        Propertiable propertiable = null;
        if (((Boolean)this.template.getPropertyByName("UseDefault").getObject()).booleanValue() && this.template.getBasedMapTextField() != null) {
            if (string.equals("X")) return super.getPropertyByName(string, record);
            if (string.equals("Y")) return super.getPropertyByName(string, record);
            if (string.equals("Width")) return super.getPropertyByName(string, record);
            if (string.equals("Height")) return super.getPropertyByName(string, record);
            if (string.equals("UseDefault")) return super.getPropertyByName(string, record);
            propertiable = this.template.getBasedMapTextField().getPropertyByName(string);
            if (propertiable == null) return propertiable;
            boolean bl = propertiable.isChangeByOther();
            boolean bl2 = propertiable.isChagneByFmtt();
            boolean bl3 = propertiable.isChangeByBL();
            if (!bl && !bl2) {
                if (!bl3) return propertiable;
            }
            Object object = null;
            object = bl2 ? propertiable.getUnifiedObject() : (bl ? propertiable.getObject() : propertiable.getChangeByBL());
            try {
                String string2 = object.toString().toUpperCase();
                DSArea dSArea = (DSArea)this.getParent();
                if (dSArea != null && dSArea.componentLevelValues != null && dSArea.componentLevelValues.size() > 0 && dSArea.componentLevelValues.containsKey(string2)) {
                    return this.SEDU(string, dSArea, propertiable);
                }
                if (bl2 && record == null) {
                    return propertiable;
                }
                DbValue dbValue = null;
                if (dbValue != null) return this.initialProperty(string, string2, propertiable, dbValue);
                if (record == null) return this.initialProperty(string, string2, propertiable, dbValue);
                dbValue = record.getCell(string2);
                return this.initialProperty(string, string2, propertiable, dbValue);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (!JRLog.isError(2)) throw jRInterruptedException;
                JRLog.error(2, jRInterruptedException);
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) return propertiable;
                JRLog.error(2, exception);
            }
            return propertiable;
        }
        propertiable = this.template.getPropertyByName(string);
        if (propertiable != null) {
            boolean bl = propertiable.isChangeByOther();
            boolean bl4 = propertiable.isChagneByFmtt();
            boolean bl5 = propertiable.isChangeByBL();
            if (!bl && !bl4) {
                if (!bl5) return super.getPropertyByName(string, record);
            }
            Object object = null;
            object = bl4 ? propertiable.getUnifiedObject() : (bl ? propertiable.getObject() : propertiable.getChangeByBL());
            try {
                String string3 = object.toString().toUpperCase();
                DSArea dSArea = (DSArea)this.getParent();
                if (dSArea != null && dSArea.componentLevelValues != null && dSArea.componentLevelValues.size() > 0 && dSArea.componentLevelValues.containsKey(string3)) {
                    return this.SEDU(string, dSArea, propertiable);
                }
                if (bl4 && record == null) {
                    return propertiable;
                }
                DbValue dbValue = null;
                if (dbValue != null) return this.initialProperty(string, string3, propertiable, dbValue);
                if (record == null) return this.initialProperty(string, string3, propertiable, dbValue);
                dbValue = record.getCell(string3);
                return this.initialProperty(string, string3, propertiable, dbValue);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (!JRLog.isError(2)) throw jRInterruptedException;
                JRLog.error(2, jRInterruptedException);
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) return propertiable;
                JRLog.error(2, exception);
                return propertiable;
            }
        } else {
            if (!JRLog.isTrace(6)) return propertiable;
            JRLog.trace(6, 6300148, new Object[]{string});
        }
        return propertiable;
    }

    private Propertiable SEDU(String string, JRVisiableResult jRVisiableResult, Propertiable propertiable) {
        block5: {
            Object object = propertiable.getObject();
            String string2 = object.toString().toUpperCase();
            Hashtable hashtable = jRVisiableResult.componentLevelValues;
            try {
                if (hashtable != null && hashtable.containsKey(string2)) {
                    DbValue dbValue = (DbValue)jRVisiableResult.getCompLevelValue(string2);
                    propertiable = jRVisiableResult.initialProperty(string, string2, propertiable, dbValue);
                }
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, exception);
            }
        }
        return propertiable;
    }
}

