/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Groupable;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.groupengine.LeafGroupList;
import jet.datastream.DSSection;
import jet.datastream.DSTableRow;
import jet.report.ChartDefine;
import jet.udo.chart.SingleChartDataset;
import jet.util.CharBinaryFormat;
import jet.util.IntVector;
import jet.util.Propertiable;

public class DSChartDataset
extends ChartDefine
implements SingleChartDataset {
    public int recordIndex = -1;
    public int groupLevel = -1;
    public int leafIndex = -1;
    public int branchIndex = -1;
    IntVector xRecords = new IntVector();
    Vector zRecords = null;
    public Groupable groupList;
    JRecord record;
    boolean bFooter = false;
    boolean bReportOrder = true;
    Vector vzmap;
    Object[] zValues;
    Vector vZValues;
    Vector vXValues;
    Vector vZGroupValues;
    Vector vXGroupValues;
    public int xGroupIndex = -1;
    public int zGroupIndex = -1;
    boolean samelevel = false;
    boolean bDHtml = false;
    CharBinaryFormat charFormat;
    String encoding = "XXXXXXXXX...";

    public DSChartDataset() {
    }

    public DSChartDataset(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, Object object) {
        super(string, string2, string3, bl, bl2, bl3, object);
    }

    public DSChartDataset(ChartDefine chartDefine) {
        super(chartDefine.x, chartDefine.y, chartDefine.z, chartDefine.xGroup, chartDefine.zGroup, chartDefine.b3D, chartDefine.owner);
    }

    public DSChartDataset(DSSection dSSection) {
        this.setDSSection(dSSection);
    }

    public void setDSSection(DSSection dSSection) {
        block3: {
            this.recordIndex = dSSection.recordIndex;
            this.groupLevel = dSSection.groupLevel;
            JRecord jRecord = dSSection.getRecord();
            this.groupList = jRecord.getRecordModel().getGroupable();
            this.leafIndex = ((DbNumber)jRecord.getCell(0)).intValue();
            try {
                this.record = jRecord.getDependCursor().createRecord();
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, dSException);
            }
        }
        this.bFooter = dSSection.getObjectType() == 518 || dSSection.getObjectType() == 516 || dSSection.getObjectType() == 2562;
        Propertiable propertiable = dSSection.getTemplate().getPropertyByName("BranchIdx");
        if (propertiable != null) {
            this.branchIndex = (Integer)propertiable.getNormalObject();
        }
    }

    public void setDSSection(DSTableRow dSTableRow) {
        block3: {
            this.recordIndex = dSTableRow.getRecordIndex();
            this.groupLevel = dSTableRow.getGroupLevel();
            JRecord jRecord = dSTableRow.getRecord();
            this.groupList = jRecord.getRecordModel().getGroupable();
            this.leafIndex = ((DbNumber)jRecord.getCell(0)).intValue();
            try {
                this.record = jRecord.getDependCursor().createRecord();
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, dSException);
            }
        }
        this.bFooter = dSTableRow.getObjectType() == 0x1000005 || dSTableRow.getObjectType() == 0x1000003;
        Propertiable propertiable = dSTableRow.getTemplate().getPropertyByName("BranchIdx");
        if (propertiable != null) {
            this.branchIndex = (Integer)propertiable.getNormalObject();
        }
    }

    public void setReportOrder(boolean bl) {
        this.bReportOrder = bl;
    }

    public boolean isFooter() {
        return this.bFooter;
    }

    @Override
    public boolean is3D() {
        return this.b3D;
    }

    public void initZ(String string) {
        this.encoding = string;
        boolean bl = false;
        if (this.b3D) {
            Vector<Object> vector = this.vZValues;
            if (this.vZValues == null) {
                vector = new Vector<Object>();
                Object[] objectArray = this.getX(this.encoding);
                if (objectArray == null) {
                    return;
                }
                int n = objectArray.length;
                this.vzmap = new Vector(n);
                for (int i = 0; i < n; ++i) {
                    Object[] objectArray2 = this.SEDU(i, this.z);
                    IntVector intVector = new IntVector();
                    for (int j = 0; j < objectArray2.length; ++j) {
                        int n2 = vector.indexOf(objectArray2[j]);
                        if (n2 == -1) {
                            bl = true;
                            vector.addElement(((DbValue)objectArray2[j]).clone());
                            n2 = vector.size() - 1;
                        }
                        intVector.addElement(n2);
                    }
                    this.vzmap.addElement(intVector);
                }
            }
            this.zValues = new Object[vector.size()];
            for (int i = 0; i < this.zValues.length; ++i) {
                this.zValues[i] = vector.elementAt(i);
                if (bl || !(this.zValues[i] instanceof DbChar)) continue;
                this.zValues[i] = this.format(this.zValues[i]);
            }
        }
    }

    public void initZ() {
        if (this.b3D) {
            Vector<Object> vector = this.vZValues;
            if (this.vZValues == null) {
                vector = new Vector<Object>();
                Object[] objectArray = this.getX(this.encoding);
                if (objectArray == null) {
                    return;
                }
                int n = objectArray.length;
                this.vzmap = new Vector(n);
                for (int i = 0; i < n; ++i) {
                    Object[] objectArray2 = this.SEDU(i, this.z);
                    IntVector intVector = new IntVector();
                    for (int j = 0; j < objectArray2.length; ++j) {
                        int n2 = vector.indexOf(objectArray2[j]);
                        if (n2 == -1) {
                            vector.addElement(((DbValue)objectArray2[j]).clone());
                            n2 = vector.size() - 1;
                        }
                        intVector.addElement(n2);
                    }
                    this.vzmap.addElement(intVector);
                }
            }
            this.zValues = new Object[vector.size()];
            for (int i = 0; i < this.zValues.length; ++i) {
                this.zValues[i] = vector.elementAt(i);
                if (!(this.zValues[i] instanceof DbChar)) continue;
                this.zValues[i] = this.format(this.zValues[i]);
            }
        }
    }

    public void addXValue(DbValue dbValue) {
        if (this.vXValues == null) {
            this.vXValues = new Vector();
        }
        this.vXValues.addElement(dbValue.clone());
    }

    public void addXRecord(int n) {
        this.xRecords.addElement(n);
        if (this.b3D) {
            if (this.zRecords == null) {
                this.zRecords = new Vector();
            }
            this.zRecords.addElement(new IntVector());
        }
    }

    public void addZRecord(int n, int n2) {
        IntVector intVector = (IntVector)this.zRecords.elementAt(n);
        intVector.addElement(n2);
    }

    public void addZValue(int n, DbValue dbValue, DbValue dbValue2) {
        if (this.vZValues == null) {
            this.vZValues = new Vector();
            this.vZGroupValues = new Vector();
        }
        if (this.vzmap == null) {
            this.vzmap = new Vector();
        }
        if (this.vzmap.size() <= n) {
            this.vzmap.addElement(new IntVector());
        }
        IntVector intVector = (IntVector)this.vzmap.elementAt(n);
        int n2 = this.vZValues.indexOf(dbValue);
        int n3 = ((IntVector)this.zRecords.elementAt(n)).size();
        if (n2 == -1 || n3 > this.vZValues.size()) {
            this.vZValues.addElement(dbValue.clone());
            n2 = this.vZValues.size() - 1;
            this.vZGroupValues.addElement(dbValue2.clone());
        } else if (intVector.contains(n2)) {
            while (intVector.contains(n2 = this.vZValues.indexOf(dbValue, n2 + 1))) {
            }
            if (n2 == -1) {
                this.vZValues.addElement(dbValue.clone());
                n2 = this.vZValues.size() - 1;
                this.vZGroupValues.addElement(dbValue2.clone());
            }
        }
        intVector.addElement(n2);
    }

    public Object[] getX(String string) {
        JRLog.indent("getX");
        if (string != null && !string.equals("XXXXXXXXX...")) {
            this.encoding = string;
        }
        if (this.bReportOrder || !this.b3D) {
            if (this.vXValues != null) {
                Object[] objectArray = new DbValue[this.vXValues.size()];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.vXValues.elementAt(i);
                    if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                    objectArray[i] = this.format(objectArray[i]);
                }
                JRLog.deIndent("getX");
                return objectArray;
            }
            JRLog.deIndent("getX");
            return this.addElement(this.x);
        }
        JRLog.deIndent("getX");
        return this.zValues;
    }

    public Object[] getZ(String string) {
        JRLog.indent("getZ");
        this.encoding = string;
        if (this.bReportOrder || !this.b3D) {
            return this.zValues;
        }
        if (this.vXValues != null) {
            Object[] objectArray = new DbValue[this.vXValues.size()];
            for (int i = 0; i < this.zValues.length; ++i) {
                objectArray[i] = this.vXValues.elementAt(i);
                if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                objectArray[i] = this.format(objectArray[i]);
            }
            JRLog.deIndent("getZ");
            return objectArray;
        }
        JRLog.deIndent("getZ");
        return this.add(this.x);
    }

    @Override
    public Object[] getY(int n) {
        JRLog.indent("getY");
        JRLog.deIndent("getY");
        return this.getValues(n, this.y.toUpperCase());
    }

    @Override
    public Object[] getValues(int n, String string) {
        if (this.bReportOrder) {
            Object[] objectArray = this.SEDU(n, string);
            if (this.b3D) {
                IntVector intVector = (IntVector)this.vzmap.elementAt(n);
                Object[] objectArray2 = new Object[this.zValues.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[intVector.elementAt((int)i)] = objectArray[i];
                }
                objectArray = objectArray2;
            }
            return objectArray;
        }
        int n2 = this.xRecords.size();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray3 = this.SEDU(i, string);
            if (this.b3D) {
                IntVector intVector = (IntVector)this.vzmap.elementAt(i);
                Object[] objectArray4 = new Object[this.zValues.length];
                for (int j = 0; j < objectArray3.length; ++j) {
                    objectArray4[intVector.elementAt((int)j)] = objectArray3[j];
                }
                objectArray3 = objectArray4;
            }
            objectArray[i] = objectArray3[n];
        }
        return objectArray;
    }

    @Override
    public Object[] getValues(String string) {
        return this.add(string);
    }

    private Object[] SEDU(int n, String string) {
        Object[] objectArray = null;
        if (!this.b3D) {
            objectArray = this.add(string);
        } else {
            IntVector intVector = (IntVector)this.zRecords.elementAt(n);
            if (this.zGroup) {
                int n2 = intVector.size();
                int n3 = n2 == 0 ? 0 : intVector.firstElement();
                objectArray = new DbValue[n2];
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    n4 = i == 0 ? n3 + 1 : (n4 += intVector.elementAt(i));
                    this.record.setRecordIndex(n4);
                    this.record.refresh(false);
                    objectArray[i] = (DbValue)this.record.getCell(string).clone();
                    if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                    objectArray[i] = this.format(objectArray[i]);
                }
            } else {
                int n5;
                int n6 = intVector.size();
                int n7 = n5 = n6 == 0 ? 0 : intVector.firstElement();
                if (!this.bDHtml && n6 > 1) {
                    n6 = intVector.elementAt(1);
                }
                objectArray = new DbValue[n6];
                if (!this.bDHtml) {
                    for (int i = 0; i < n6; ++i) {
                        this.record.setRecordIndex(i + n5);
                        this.record.refresh(false);
                        objectArray[i] = (DbValue)this.record.getCell(string).clone();
                        if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                        objectArray[i] = this.format(objectArray[i]);
                    }
                } else {
                    for (int i = 0; i < n6; ++i) {
                        this.record.setRecordIndex(intVector.elementAt(i));
                        this.record.refresh(false);
                        objectArray[i] = (DbValue)this.record.getCell(string).clone();
                        if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                        objectArray[i] = this.format(objectArray[i]);
                    }
                }
            }
        }
        return objectArray;
    }

    public void setDhtml(boolean bl) {
        this.bDHtml = bl;
    }

    private Object[] add(String string) {
        int n = this.xRecords.size();
        if (n == 0) {
            return null;
        }
        if (!this.bDHtml && !this.xGroup && n > 1) {
            n = this.xRecords.elementAt(1);
        }
        if (this.bDHtml && !this.xGroup) {
            --n;
        }
        int n2 = n == 0 ? 0 : this.xRecords.firstElement();
        Object[] objectArray = new DbValue[n];
        if (string == null || string.length() < 1) {
            if (this.xGroup) {
                objectArray[0] = new DbChar("Report");
                ((DbChar)objectArray[0]).setColDesc(new DbColDesc(((DbChar)objectArray[0]).get(), 1, 0, 0, 2));
            } else {
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new DbChar("" + i);
                    ((DbChar)objectArray[i]).setColDesc(new DbColDesc(((DbChar)objectArray[i]).get(), 1, 0, 0, 2));
                }
            }
        } else if (this.xGroup) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n3 = i == 0 ? n2 : (n3 += this.xRecords.elementAt(i));
                this.record.setRecordIndex(n3);
                this.record.refresh(false);
                objectArray[i] = (DbValue)this.record.getCell(string).clone();
                if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                objectArray[i] = this.format(objectArray[i]);
            }
        } else if (!this.bDHtml) {
            for (int i = 0; i < n; ++i) {
                this.record.setRecordIndex(i + n2);
                this.record.refresh(false);
                objectArray[i] = (DbValue)this.record.getCell(string).clone();
                if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                objectArray[i] = this.format(objectArray[i]);
            }
        } else {
            Group group = (Group)((LeafGroupList)this.groupList).getLeafGroups().elementAt(this.leafIndex);
            if (this.record.getDependCursor() == group.getDbBuffer()) {
                for (int i = 1; i < n + 1; ++i) {
                    this.record.setRecordIndex(this.xRecords.elementAt(i));
                    this.record.refresh(false);
                    objectArray[i - 1] = (DbValue)this.record.getCell(string).clone();
                    if (!((DbValue)objectArray[i - 1] instanceof DbChar)) continue;
                    objectArray[i - 1] = this.format(objectArray[i - 1]);
                }
            } else {
                int n4 = this.xRecords.elementAt(0);
                int n5 = -1;
                for (int i = 0; i < n; ++i) {
                    n5 = 0 == i ? n4 : ++n5;
                    this.record.setRecordIndex(n5);
                    this.record.refresh(false);
                    objectArray[i] = (DbValue)this.record.getCell(string).clone();
                    if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                    objectArray[i] = this.format(objectArray[i]);
                }
            }
        }
        return objectArray;
    }

    private Object[] addElement(String string) {
        int n = this.xRecords.size();
        if (n == 0) {
            return null;
        }
        if (!this.bDHtml && !this.xGroup && n > 1) {
            n = this.xRecords.elementAt(1);
        }
        if (this.bDHtml && !this.xGroup) {
            --n;
        }
        int n2 = n == 0 ? 0 : this.xRecords.firstElement();
        Object[] objectArray = new DbValue[n];
        if (string == null || string.length() < 1) {
            if (this.xGroup) {
                objectArray[0] = new DbChar("Report");
                ((DbChar)objectArray[0]).setColDesc(new DbColDesc(((DbChar)objectArray[0]).get(), 1, 0, 0, 2));
            } else {
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new DbChar("" + i);
                    ((DbChar)objectArray[i]).setColDesc(new DbColDesc(((DbChar)objectArray[0]).get(), 1, 0, 0, 2));
                }
            }
        } else if (this.xGroup) {
            int n3 = 0;
            boolean bl = false;
            if (this.vXValues == null) {
                this.vXValues = new Vector();
                this.vXGroupValues = new Vector();
                bl = true;
            }
            for (int i = 0; i < n; ++i) {
                n3 = i == 0 ? n2 : (n3 += this.xRecords.elementAt(i));
                this.record.setRecordIndex(n3);
                this.record.refresh(false);
                objectArray[i] = (DbValue)this.record.getCell(string).clone();
                if (bl) {
                    this.vXValues.add(objectArray[i]);
                    this.vXGroupValues.add(objectArray[i]);
                }
                if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                objectArray[i] = this.format(objectArray[i]);
            }
        } else if (!this.bDHtml) {
            for (int i = 0; i < n; ++i) {
                this.record.setRecordIndex(i + n2);
                this.record.refresh(false);
                objectArray[i] = (DbValue)this.record.getCell(string).clone();
                if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                objectArray[i] = this.format(objectArray[i]);
            }
        } else {
            Group group = (Group)((LeafGroupList)this.groupList).getLeafGroups().elementAt(this.leafIndex);
            if (this.record.getDependCursor() == group.getDbBuffer()) {
                for (int i = 1; i < n + 1; ++i) {
                    this.record.setRecordIndex(this.xRecords.elementAt(i));
                    this.record.refresh(false);
                    objectArray[i - 1] = (DbValue)this.record.getCell(string).clone();
                    if (!((DbValue)objectArray[i - 1] instanceof DbChar)) continue;
                    objectArray[i - 1] = this.format(objectArray[i - 1]);
                }
            } else {
                int n4 = this.xRecords.elementAt(0);
                int n5 = -1;
                for (int i = 0; i < n; ++i) {
                    n5 = 0 == i ? n4 : ++n5;
                    this.record.setRecordIndex(n5);
                    this.record.refresh(false);
                    objectArray[i] = (DbValue)this.record.getCell(string).clone();
                    if (!((DbValue)objectArray[i] instanceof DbChar)) continue;
                    objectArray[i] = this.format(objectArray[i]);
                }
            }
        }
        return objectArray;
    }

    public void setSLevel(boolean bl) {
        this.samelevel = bl;
    }

    public boolean getSLevel() {
        return this.samelevel;
    }

    private DbValue format(Object object) {
        this.charFormat = new CharBinaryFormat(this.encoding);
        DbChar dbChar = new DbChar(this.charFormat.format(object.toString()));
        if (object instanceof DbValue) {
            dbChar.setColDesc(((DbValue)object).getColDesc());
        }
        object = null;
        object = dbChar;
        this.charFormat = null;
        return (DbValue)object;
    }

    @Override
    public Object[] getX() {
        return null;
    }

    @Override
    public Object[] getZ() {
        return null;
    }

    public void addXGroupValue(DbValue dbValue) {
        if (this.vXGroupValues == null) {
            this.vXGroupValues = new Vector();
        }
        this.vXGroupValues.addElement(dbValue.clone());
    }
}

