/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import guitools.toolkit.TContainer;
import guitools.toolkit.Unit;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import jet.JRStopEngineException;
import jet.connect.Record;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSChartCoordinatepaper;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTextBox;
import jet.rptengine.RecordWithoutBuffer;
import jet.thinviewer.JReportChartORGNode;
import jet.thinviewer.JReportContainer;

public class DSChartORGNode
extends DSTextBox {
    private Record SEDU = null;
    private String UTFLength = "";
    private float[] convertUnitToPixel;
    public static final int COORDS_NUMBER = 12;

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.UTFLength = dataInput.readUTF();
        this.convertUnitToPixel = new float[12];
        for (int i = 0; i < 12; ++i) {
            this.convertUnitToPixel[i] = dataInput.readFloat();
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeUTF(this.UTFLength);
        for (int i = 0; i < 12; ++i) {
            if (this.convertUnitToPixel != null && i < this.convertUnitToPixel.length) {
                dataOutput.writeFloat(this.convertUnitToPixel[i]);
                continue;
            }
            dataOutput.writeFloat(-1.0f);
        }
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n = n + 2 + DSChartORGNode.UTFLength(this.UTFLength);
        for (int i = 0; i < 12; ++i) {
            n += 4;
            n += 4;
        }
        return n;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSChartORGNode());
    }

    public DSTextBox dup(DSChartORGNode dSChartORGNode) {
        super.dup(dSChartORGNode);
        dSChartORGNode.setRecID(this.UTFLength);
        return dSChartORGNode;
    }

    public void paintForORGImage(Graphics graphics) {
        JReportChartORGNode jReportChartORGNode = new JReportChartORGNode();
        ((JReportContainer)jReportChartORGNode).setProperty(this);
        jReportChartORGNode.setBounds(this.getBounds());
        jReportChartORGNode.createChildren(this);
        Rectangle rectangle = this.getBounds();
        DSChartCoordinatepaper dSChartCoordinatepaper = (DSChartCoordinatepaper)this.parent;
        int n = Unit.convertUnitToPixel(dSChartCoordinatepaper.getX(), this.getResolution());
        int n2 = Unit.convertUnitToPixel(dSChartCoordinatepaper.getY(), this.getResolution());
        Graphics graphics2 = graphics.create(rectangle.x + n, rectangle.y + n2, rectangle.width, rectangle.height);
        ((TContainer)jReportChartORGNode).paint(graphics2);
    }

    public void setLocation(float f, float f2) {
        this.x = (int)f;
        this.y = (int)f2;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    public String getRecID() {
        return this.UTFLength;
    }

    @Override
    public void setRecID(String string) {
        this.UTFLength = string;
    }

    @Override
    public Record getSynRecord() {
        Hashtable hashtable;
        if (this.SEDU == null && (hashtable = this.componentLevelValues) != null && hashtable.size() != 0) {
            this.SEDU = new RecordWithoutBuffer(hashtable);
        }
        return this.SEDU;
    }

    @Override
    public Record getSynRecord2() {
        return this.getSynRecord();
    }

    @Override
    public JRecord getRecord() {
        return (JRecord)this.getSynRecord();
    }

    public void setLinePath(float[] fArray2) {
        this.convertUnitToPixel = fArray2;
    }

    public float[] getLinePath() {
        return this.convertUnitToPixel;
    }
}

