/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import chart.chart3d.ChartMatrix;
import chart.data.ChartDataFilter;
import chart.graphics.ChartBackground;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartCustomizedPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartIcon;
import chart.graphics.ChartLineStyle;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.graphics.ChartTexturePattern;
import chart.properties.ChartAxisProperties;
import chart.properties.ChartCoordinatePaperProperties;
import chart.properties.ChartGraphProperties;
import chart.properties.ChartLabelProperties;
import chart.properties.ChartLegendProperties;
import chart.properties.ChartLineProperties;
import chart.properties.ChartNodeProperties;
import chart.properties.ChartNumericAxisProperties;
import chart.properties.ChartPlatformProperties;
import chart.properties.ChartWallProperties;
import guitools.Encoding;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.datastream.DSChartCoordinatePaperChild;
import jet.datastream.DSChartCoordinatepaper;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSContainer;
import jet.datastream.JRObjectResult;
import jet.datastream.JetChartPropertyValues;
import jet.util.CharBinaryFormat;
import jet.util.ImageListPropertiable;
import jet.util.ImagePropertiable;
import jet.util.JFieldValueNLSManager;
import jet.util.Propertiable;
import jet.util.PropertySetable;

public class DSChartPropertiesLoader {
    protected final DSChartPlatform platform;
    ChartPlatformProperties platformP;
    ChartCoordinatePaperProperties paperP;
    ChartLegendProperties legendP;
    List labelPs;
    Rectangle platformB;
    Rectangle paperB;
    Rectangle legendB;
    List labelBs;
    protected int res;
    List nodes;

    DSChartPropertiesLoader(DSChartPlatform dSChartPlatform) {
        this.platform = dSChartPlatform;
    }

    void init() {
        this.res = this.platform.getResolution();
        this.platformB = DSChartPropertiesLoader.getObjectBounds(this.platform);
        this.platformP = DSChartPropertiesLoader.BUILTINICON(this.platform);
        Vector vector = this.platform.getChildren();
        JRObjectResult jRObjectResult = null;
        this.labelPs = new ArrayList();
        this.labelBs = new ArrayList();
        block5: for (int i = 0; i < vector.size(); ++i) {
            jRObjectResult = (JRObjectResult)vector.elementAt(i);
            int n = jRObjectResult.getObjectType();
            switch (n) {
                case 69: {
                    this.labelBs.add(DSChartPropertiesLoader.getObjectBounds(jRObjectResult));
                    this.labelPs.add(DSChartPropertiesLoader.booleanValue(jRObjectResult));
                    continue block5;
                }
                case 70: 
                case 80: {
                    this.legendB = DSChartPropertiesLoader.getObjectBounds(jRObjectResult);
                    this.legendP = DSChartPropertiesLoader.append(jRObjectResult);
                    ChartDataFilter chartDataFilter = this.legendP.getValueFormat();
                    if (chartDataFilter == null) {
                        chartDataFilter = new ChartDataFilter();
                    }
                    ChartDataFilter.setDefaultNumberFormat(chartDataFilter);
                    chartDataFilter.setRoundMode(this.platform.getRoundingMode());
                    this.legendP.setValueFormat(chartDataFilter);
                    chartDataFilter = this.legendP.getPercentFormat();
                    if (chartDataFilter != null) {
                        chartDataFilter.setRoundMode(this.platform.getRoundingMode());
                    }
                    if ((chartDataFilter = this.legendP.getLegendFilter()) != null) {
                        chartDataFilter.setRoundMode(this.platform.getRoundingMode());
                        if (this.platform.getTimeZone() != null) {
                            chartDataFilter.setTimeZone(this.platform.getTimeZone());
                        }
                    }
                    if (this.platform.getMapColorInfo() == null) continue block5;
                    chartDataFilter = this.legendP.getLegendFilter();
                    Object object = null;
                    object = this.platform.getFieldNLSManager();
                    Object object2 = this.legendP.getDataMappingFile();
                    if (chartDataFilter == null) {
                        ChartDataFilter chartDataFilter2 = new ChartDataFilter();
                        chartDataFilter2.setDataMappingManager((JFieldValueNLSManager)object);
                        chartDataFilter2.setDataMappingFile((String)object2);
                        this.legendP.setLegendFilter(chartDataFilter2);
                    } else {
                        chartDataFilter.setDataMappingFile((String)object2);
                        chartDataFilter.setDataMappingManager((JFieldValueNLSManager)object);
                    }
                    this.platform.getMapColorInfo().setGroupNameTable(this.platform.getHeatmapNLSGroupName());
                    this.platform.getMapColorInfo().setLegendProperty(this.legendP);
                    continue block5;
                }
                case 72: {
                    Object object2;
                    this.paperB = DSChartPropertiesLoader.getObjectBounds(jRObjectResult);
                    this.paperP = DSChartPropertiesLoader.add(jRObjectResult);
                    if (this.platform.isORGChart()) {
                        this.paperP.setLineProperties(DSChartPropertiesLoader.getDataLoader(jRObjectResult));
                    }
                    if (this.platform.isORGChart() || this.platform.isHeatMapChart()) continue block5;
                    Object object = (DSChartCoordinatepaper)vector.elementAt(i);
                    if (this.nodes == null) {
                        this.nodes = new ArrayList();
                    }
                    if (((Vector)(object2 = ((DSContainer)object).getChildren())).size() > 0) {
                        for (int j = 0; j < ((Vector)object2).size(); ++j) {
                            jRObjectResult = (JRObjectResult)((Vector)object2).elementAt(j);
                            if (jRObjectResult.getObjectType() != 76) continue;
                            this.nodes.add(DSChartPropertiesLoader.getChartDefinition(jRObjectResult));
                        }
                        this.paperP.getGraphProperties().setLineNodeList(this.nodes);
                        continue block5;
                    }
                    this.paperP.getGraphProperties().setLineNodeList(DSChartPropertiesLoader.getChildren(this.paperP.getGraphProperties(), jRObjectResult, this.legendP));
                    continue block5;
                }
            }
        }
        if (this.platformP != null) {
            this.platformP.setChartPaperProperties(this.paperP);
        }
    }

    protected static Rectangle getObjectBounds(JRObjectResult jRObjectResult) {
        int n = Unit.convertUnitToPixel(jRObjectResult.getTemplate().getX(jRObjectResult), jRObjectResult.getResolution());
        int n2 = Unit.convertUnitToPixel(jRObjectResult.getTemplate().getY(jRObjectResult), jRObjectResult.getResolution());
        int n3 = Unit.convertUnitToPixel(jRObjectResult.getTemplate().getWidth(jRObjectResult), jRObjectResult.getResolution());
        int n4 = Unit.convertUnitToPixel(jRObjectResult.getTemplate().getHeight(jRObjectResult), jRObjectResult.getResolution());
        return new Rectangle(n, n2, n3, n4);
    }

    private static ChartPlatformProperties BUILTINICON(PropertySetable propertySetable) {
        ChartPlatformProperties chartPlatformProperties = new ChartPlatformProperties();
        int n = ((JRObjectResult)propertySetable).getResolution();
        chartPlatformProperties.setTopMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("TopMargin").getObject()).intValue(), n));
        chartPlatformProperties.setLeftMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LeftMargin").getObject()).intValue(), n));
        chartPlatformProperties.setRightMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("RightMargin").getObject()).intValue(), n));
        chartPlatformProperties.setBottomMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("BottomMargin").getObject()).intValue(), n));
        chartPlatformProperties.setBackground(DSChartPropertiesLoader.getAngleZ("Platform", propertySetable));
        chartPlatformProperties.setAutoLayout((Boolean)propertySetable.getPropertyByName("AutoLayout").getObject());
        chartPlatformProperties.setShowLegend((Boolean)propertySetable.getPropertyByName("ShowLegend").getObject());
        chartPlatformProperties.setPatterns(JetChartPropertyValues.mapPatterns((Vector)propertySetable.getPropertyByName("PatternList").getObject()));
        chartPlatformProperties.setAntiAliasing((Boolean)propertySetable.getPropertyByName("AntiAliasing").getObject());
        chartPlatformProperties.setInstanceName(((JRObjectResult)propertySetable).getJetObjInstName());
        chartPlatformProperties.setBindedPatterns(DSChartPropertiesLoader.SEDU(propertySetable));
        chartPlatformProperties.setBindedLineStyles(DSChartPropertiesLoader._xrot(propertySetable));
        boolean bl = ((DSChartPlatform)propertySetable).getDataLoader().getChartDefinition().isSparklineChart();
        if (bl) {
            chartPlatformProperties.setShowLegend(false);
        }
        if (propertySetable.getPropertyByName("MinSpaceInTickMarks") != null) {
            chartPlatformProperties.setMinTickMarkerSpace(((Number)propertySetable.getPropertyByName("MinSpaceInTickMarks").getObject()).intValue());
        }
        return chartPlatformProperties;
    }

    private static Map SEDU(PropertySetable propertySetable) {
        Vector vector;
        Vector vector2;
        Hashtable hashtable = new Hashtable();
        if (propertySetable.getPropertyByName("BindedValues") == null) {
            vector2 = new Vector();
            vector = new Vector();
        } else {
            vector2 = (Vector)propertySetable.getPropertyByName("BindedValues").getObject();
            vector = (Vector)propertySetable.getPropertyByName("BindedPatterns").getObject();
        }
        ChartFillPattern[] chartFillPatternArray = JetChartPropertyValues.mapPatterns(vector);
        for (int i = 0; i != vector2.size(); ++i) {
            if (chartFillPatternArray[i] != null) {
                hashtable.put(vector2.get(i), chartFillPatternArray[i]);
                continue;
            }
            ChartColorPattern chartColorPattern = new ChartColorPattern();
            chartColorPattern.setNoFill(true);
            hashtable.put(vector2.get(i), chartColorPattern);
        }
        return hashtable;
    }

    private static Map _xrot(PropertySetable propertySetable) {
        int n;
        Vector vector;
        Vector vector2;
        Hashtable hashtable = new Hashtable();
        if (propertySetable.getPropertyByName("BindedLineValues") == null) {
            vector2 = new Vector();
            vector = new Vector();
        } else {
            vector2 = (Vector)propertySetable.getPropertyByName("BindedLineValues").getObject();
            vector = (Vector)propertySetable.getPropertyByName("BindedLineStyles").getObject();
        }
        ChartLineStyle[] chartLineStyleArray = new ChartLineStyle[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            int n2 = 1;
            int n3 = 9;
            int n4 = 2;
            String[] stringArray = vector.get(n).toString().split(",");
            if (stringArray != null) {
                n2 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                if (stringArray.length > 2) {
                    n4 = Unit.convertUnitToPixel(Integer.parseInt(stringArray[2]));
                }
            } else {
                n2 = 1;
                n3 = 9;
                n4 = Unit.convertUnitToPixel(180);
            }
            chartLineStyleArray[n] = new ChartLineStyle(n2, n3, n4);
        }
        for (n = 0; n != vector2.size(); ++n) {
            hashtable.put(vector2.get(n), chartLineStyleArray[n]);
        }
        return hashtable;
    }

    private static ChartCoordinatePaperProperties add(PropertySetable propertySetable) {
        ChartCoordinatePaperProperties chartCoordinatePaperProperties = new ChartCoordinatePaperProperties();
        int n = ((JRObjectResult)propertySetable).getResolution();
        chartCoordinatePaperProperties.setTopMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("TopMargin").getObject()).intValue(), n));
        chartCoordinatePaperProperties.setLeftMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LeftMargin").getObject()).intValue(), n));
        chartCoordinatePaperProperties.setRightMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("RightMargin").getObject()).intValue(), n));
        chartCoordinatePaperProperties.setBottomMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("BottomMargin").getObject()).intValue(), n));
        chartCoordinatePaperProperties.setBackground(DSChartPropertiesLoader.getAngleZ("Paper", propertySetable));
        chartCoordinatePaperProperties.setScaleX((float)((Number)propertySetable.getPropertyByName("ScaleX").getObject()).intValue() / 100.0f);
        chartCoordinatePaperProperties.setScaleY((float)((Number)propertySetable.getPropertyByName("ScaleY").getObject()).intValue() / 100.0f);
        chartCoordinatePaperProperties.setScaleZ((float)((Number)propertySetable.getPropertyByName("ScaleZ").getObject()).intValue() / 100.0f);
        chartCoordinatePaperProperties.setAngleX(((Number)propertySetable.getPropertyByName("AngleX").getObject()).intValue());
        chartCoordinatePaperProperties.setAngleY(((Number)propertySetable.getPropertyByName("AngleY").getObject()).intValue());
        chartCoordinatePaperProperties.setAngleZ(((Number)propertySetable.getPropertyByName("AngleZ").getObject()).intValue());
        ChartMatrix chartMatrix = new ChartMatrix();
        chartMatrix._xrot(chartCoordinatePaperProperties.getAngleX());
        chartMatrix.yrot(chartCoordinatePaperProperties.getAngleY());
        chartMatrix.zrot(chartCoordinatePaperProperties.getAngleZ());
        chartCoordinatePaperProperties.setRotationMatrix(chartMatrix.getMatrix());
        chartCoordinatePaperProperties.setGraphPosition(((Number)propertySetable.getPropertyByName("GraphPosition").getObject()).intValue());
        chartCoordinatePaperProperties.setReversePaintingOrder((Boolean)propertySetable.getPropertyByName("ReversePaintingOrder").getObject());
        chartCoordinatePaperProperties.setPerspective(((Number)propertySetable.getPropertyByName("Perspective").getObject()).intValue());
        chartCoordinatePaperProperties.setInteractive((Boolean)propertySetable.getPropertyByName("Interactive").getObject());
        chartCoordinatePaperProperties.setValueLabelPositionList(JetChartPropertyValues.mapValueLabelPositions((String)propertySetable.getPropertyByName("ValueLabelPositionList").getObject()));
        if (propertySetable.getPropertyByName("ValueLabelSmartShowList") != null) {
            chartCoordinatePaperProperties.setValueLabelSmartShow(JetChartPropertyValues.mapVectorToIntArray((Vector)propertySetable.getPropertyByName("ValueLabelSmartShowList").getObject()));
        }
        chartCoordinatePaperProperties.setHintTextStyle(DSChartPropertiesLoader.getAngleY("Hint", propertySetable));
        chartCoordinatePaperProperties.setShowTips((Boolean)propertySetable.getPropertyByName("ShowTips").getObject());
        chartCoordinatePaperProperties.setShadowContents((Boolean)propertySetable.getPropertyByName("ShadowContents").getObject());
        chartCoordinatePaperProperties.setShowWall((Boolean)propertySetable.getPropertyByName("ShowWall").getObject());
        chartCoordinatePaperProperties.setWallProperties(DSChartPropertiesLoader.doubleValue("Wall", propertySetable));
        chartCoordinatePaperProperties.setShowFloor((Boolean)propertySetable.getPropertyByName("ShowFloor").getObject());
        chartCoordinatePaperProperties.setFloorProperties(DSChartPropertiesLoader.doubleValue("Floor", propertySetable));
        chartCoordinatePaperProperties.setShowAxisX((Boolean)propertySetable.getPropertyByName("ShowAxisX").getObject());
        chartCoordinatePaperProperties.setAxisXProperties(DSChartPropertiesLoader.convertUnitToPixel("X", propertySetable, true));
        chartCoordinatePaperProperties.setShowAxisY((Boolean)propertySetable.getPropertyByName("ShowAxisY").getObject());
        chartCoordinatePaperProperties.setAxisYProperties((ChartNumericAxisProperties)DSChartPropertiesLoader.convertUnitToPixel("Y", propertySetable, true));
        chartCoordinatePaperProperties.setShowAxisY2((Boolean)propertySetable.getPropertyByName("ShowAxisY2").getObject());
        chartCoordinatePaperProperties.setAxisY2Properties((ChartNumericAxisProperties)DSChartPropertiesLoader.convertUnitToPixel("Y2", propertySetable, true));
        chartCoordinatePaperProperties.setShowAxisZ((Boolean)propertySetable.getPropertyByName("ShowAxisZ").getObject());
        chartCoordinatePaperProperties.setAxisZProperties(DSChartPropertiesLoader.convertUnitToPixel("Z", propertySetable, false));
        ChartGraphProperties chartGraphProperties = chartCoordinatePaperProperties.getGraphProperties();
        boolean bl = false;
        if (propertySetable.getPropertyByName("ShowCategoryAndSeries") != null) {
            chartCoordinatePaperProperties.setShowCategoryAndSeries((Boolean)propertySetable.getPropertyByName("ShowCategoryAndSeries").getObject());
            chartGraphProperties.setAreaPatternList(JetChartPropertyValues.mapPatterns((Vector)propertySetable.getPropertyByName("AreaPatternList").getObject()));
            chartGraphProperties.setLineStyleList((String)propertySetable.getPropertyByName("LineStyleList").getObject());
        } else {
            chartCoordinatePaperProperties.setShowCategoryAndSeries(bl);
            chartGraphProperties.setAreaPatternList(JetChartPropertyValues.mapPatterns(JetChartPropertyValues.getDefaultAreaPatternString()));
            chartGraphProperties.setLineStyleList((String)propertySetable.getPropertyByName(JetChartPropertyValues.getDefaultLineSyleList()).getObject());
        }
        chartGraphProperties.setContour((Boolean)propertySetable.getPropertyByName("Contour").getObject());
        chartGraphProperties.setContourPen(DSChartPropertiesLoader.getAngleX("Contour", propertySetable));
        chartGraphProperties.setBarWidth((float)((Number)propertySetable.getPropertyByName("BarWidth").getObject()).intValue() / 100.0f);
        chartGraphProperties.setDepth(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("BarDepth").getObject()).intValue(), n));
        chartGraphProperties.setUseDepth((Boolean)propertySetable.getPropertyByName("UseDepth").getObject());
        chartGraphProperties.setDepthDirection(((Number)propertySetable.getPropertyByName("BarDepthDirection").getObject()).intValue());
        chartGraphProperties.setVaryColorbyValues((Boolean)propertySetable.getPropertyByName("VaryColorByValues").getObject());
        chartGraphProperties.setBarGap((float)((Number)propertySetable.getPropertyByName("BarGap").getObject()).intValue() / 100.0f);
        chartGraphProperties.setBarStyle(((Number)propertySetable.getPropertyByName("BarStyle").getObject()).intValue());
        chartGraphProperties.setUseDropline((Boolean)propertySetable.getPropertyByName("UseDropline").getObject());
        chartGraphProperties.setLineThickness(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LineThickness").getObject()).intValue(), n));
        chartGraphProperties.setLineNodeStyle(((Number)propertySetable.getPropertyByName("LineNodeStyle").getObject()).intValue());
        chartGraphProperties.setLineNodeWidth(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LineNodeWidth").getObject()).intValue(), n));
        chartGraphProperties.setLineNodeHeight(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LineNodeHeight").getObject()).intValue(), n));
        chartGraphProperties.setLineNodePen(DSChartPropertiesLoader.getAngleX("LineNodeBorder", propertySetable));
        chartGraphProperties.setLineNodeColor((Color)propertySetable.getPropertyByName("LineNodeFillColor").getObject());
        chartGraphProperties.setLineNodeFillTransparency(((Number)propertySetable.getPropertyByName("LineNodeFillColorTransparency").getObject()).floatValue() / 100.0f);
        Propertiable propertiable = propertySetable.getPropertyByName("LineStyleList");
        String string = (String)propertiable.getObject();
        chartGraphProperties.setLineStyleList(string);
        chartGraphProperties.setLineStyleList(DSChartPropertiesLoader.mappingLineStyleLists(string, n));
        chartGraphProperties.setRadarIsFill((Boolean)propertySetable.getPropertyByName("RadarIsFill").getObject());
        chartGraphProperties.setRadarFillTransparence((float)((Number)propertySetable.getPropertyByName("RadarFillTransparence").getObject()).intValue() / 100.0f);
        chartGraphProperties.setRadarIsShowColumnName((Boolean)propertySetable.getPropertyByName("RadarIsShowColumnName").getObject());
        chartGraphProperties.setRadarArrowStyle(((Number)propertySetable.getPropertyByName("RadarArrowStyle").getObject()).intValue());
        chartGraphProperties.setPieExplodeDistance(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("SectionExplodeGap").getObject()).doubleValue()));
        chartGraphProperties.setPieGap(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("PieGap").getObject()).intValue()));
        chartGraphProperties.setValueLabelType(((Number)propertySetable.getPropertyByName("ValueLabelType").getObject()).intValue());
        chartGraphProperties.setShowPieName((Boolean)propertySetable.getPropertyByName("ShowPieName").getObject());
        chartGraphProperties.setSuppressZeroLabel((Boolean)propertySetable.getPropertyByName("SuppressZeroLabel").getObject());
        chartGraphProperties.setDonutWidth(((Number)propertySetable.getPropertyByName("PieDoughnutPercent").getObject()).intValue());
        chartGraphProperties.setStockUpBarColor((Color)propertySetable.getPropertyByName("StockUpBarColor").getObject());
        chartGraphProperties.setStockDownBarColor((Color)propertySetable.getPropertyByName("StockDownBarColor").getObject());
        chartGraphProperties.setStockLineColor((Color)propertySetable.getPropertyByName("StockLineColor").getObject());
        chartGraphProperties.setGaugeNormalValueMin(((Number)propertySetable.getPropertyByName("GaugeNormalValueMin").getObject()).doubleValue());
        chartGraphProperties.setGaugeNormalValueMax(((Number)propertySetable.getPropertyByName("GaugeNormalValueMax").getObject()).doubleValue());
        chartGraphProperties.setGaugeAlertValueMin(((Number)propertySetable.getPropertyByName("GaugeAlertValueMin").getObject()).doubleValue());
        chartGraphProperties.setGaugeAlertValueMax(((Number)propertySetable.getPropertyByName("GaugeAlertValueMax").getObject()).doubleValue());
        chartGraphProperties.setGaugeErrorValueMin(((Number)propertySetable.getPropertyByName("GaugeErrorValueMin").getObject()).doubleValue());
        chartGraphProperties.setGaugeErrorValueMax(((Number)propertySetable.getPropertyByName("GaugeErrorValueMax").getObject()).doubleValue());
        chartGraphProperties.setGuagePatterns(DSChartPropertiesLoader.format("GaugeNormal", propertySetable), DSChartPropertiesLoader.format("GaugeAlert", propertySetable), DSChartPropertiesLoader.format("GaugeError", propertySetable));
        chartGraphProperties.setGaugeDialStartAngle(((Number)propertySetable.getPropertyByName("GaugeDialStartAngle").getObject()).intValue());
        chartGraphProperties.setGaugeDialStopAngle(((Number)propertySetable.getPropertyByName("GaugeDialStopAngle").getObject()).intValue());
        chartGraphProperties.setGaugeDialLineStyle(((Number)propertySetable.getPropertyByName("GaugeDialLineStyle").getObject()).intValue());
        chartGraphProperties.setGaugeDialLineArrowStyle(((Number)propertySetable.getPropertyByName("GaugeDialLineArrowStyle").getObject()).intValue());
        chartGraphProperties.setGaugeDialCurveIsFill((Boolean)propertySetable.getPropertyByName("GaugeDialCurveIsFill").getObject());
        chartGraphProperties.setGaugeDialOuterInnerGap(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("GaugeDialOuterInnerGap").getObject()).intValue(), n));
        chartGraphProperties.setGaugeDialCurveStyle(((Number)propertySetable.getPropertyByName("GaugeDialCurveStyle").getObject()).intValue());
        chartGraphProperties.setRadiusRange(((Number)propertySetable.getPropertyByName("RadiusRange").getObject()).floatValue() / 100.0f);
        chartGraphProperties.setHorizonalMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("HorizontalMargin").getObject()).intValue()));
        chartGraphProperties.setVerticalMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("VerticalMargin").getObject()).intValue()));
        chartGraphProperties.setGaugeBarLayout(((Number)propertySetable.getPropertyByName("GaugeBarLayout").getObject()).intValue());
        chartGraphProperties.setGaugeBarPen(DSChartPropertiesLoader.getAngleX("GaugeBar", propertySetable));
        chartGraphProperties.setShowThresholdLine((Boolean)propertySetable.getPropertyByName("ShowThresholdLine").getObject());
        chartGraphProperties.setThresholdValue(((Number)propertySetable.getPropertyByName("ThresholdValue").getObject()).doubleValue());
        chartGraphProperties.setThresholdLineColor((Color)propertySetable.getPropertyByName("ThresholdLineColor").getObject());
        chartGraphProperties.setFillThreshold((Boolean)propertySetable.getPropertyByName("FillThreshold").getObject());
        chartGraphProperties.setShowThresholdLine2((Boolean)propertySetable.getPropertyByName("ShowThresholdLine2").getObject());
        chartGraphProperties.setThresholdValue2(((Number)propertySetable.getPropertyByName("ThresholdValue2").getObject()).doubleValue());
        chartGraphProperties.setThresholdLineColor2((Color)propertySetable.getPropertyByName("ThresholdLineColor2").getObject());
        chartGraphProperties.setFillThreshold2((Boolean)propertySetable.getPropertyByName("FillThreshold2").getObject());
        chartGraphProperties.setThresholdLineStyle(((Number)propertySetable.getPropertyByName("ThresholdLineStyle").getObject()).intValue());
        chartGraphProperties.setThresholdFillTransparency((float)((Number)propertySetable.getPropertyByName("FillTransparent").getObject()).intValue() / 100.0f);
        chartGraphProperties.setShowMeanLine((Boolean)propertySetable.getPropertyByName("ShowMeanLine").getObject());
        chartGraphProperties.setMeanLineColor((Color)propertySetable.getPropertyByName("MeanLineColor").getObject());
        chartGraphProperties.setMeanLineNodeStyle(((Number)propertySetable.getPropertyByName("MeanLineNodeStyle").getObject()).intValue());
        chartGraphProperties.setMeanLineType(((Number)propertySetable.getPropertyByName("MeanLineType").getObject()).intValue());
        if (propertySetable.getPropertyByName("PieSlimLegPatternColor") != null) {
            chartGraphProperties.setPieSlimLegColor((Color)propertySetable.getPropertyByName("PieSlimLegPatternColor").getObject());
        }
        if (propertySetable.getPropertyByName("PieAngleX") != null) {
            chartGraphProperties.setPieXRotation(((Number)propertySetable.getPropertyByName("PieAngleX").getObject()).floatValue());
        }
        if (propertySetable.getPropertyByName("PieAngleY") != null) {
            chartGraphProperties.setPieYRotation(((Number)propertySetable.getPropertyByName("PieAngleY").getObject()).floatValue());
        }
        chartGraphProperties.setUse3DEffect((Boolean)propertySetable.getPropertyByName("Use3DEffect").getObject());
        if (propertySetable.getPropertyByName("BulletData") != null) {
            chartGraphProperties.setBulletDataSize((String)propertySetable.getPropertyByName("BulletData").getObject());
            chartGraphProperties.setIsHorizontal((Boolean)propertySetable.getPropertyByName("IsHorizontal").getObject());
            chartGraphProperties.setQualitativeRangesColorList(JetChartPropertyValues.mapPatterns((Vector)propertySetable.getPropertyByName("QualitativeRangesColorList").getObject()));
            chartGraphProperties.setComparativeMeasureColorList(JetChartPropertyValues.mapPatterns((Vector)propertySetable.getPropertyByName("ComparativeMeasureColorList").getObject()));
            chartGraphProperties.setComparativeMeasureWidth(((Number)propertySetable.getPropertyByName("ComparativeMeasureWidth").getObject()).intValue());
            chartGraphProperties.setSpecialFeatureMeasureWidth(((Number)propertySetable.getPropertyByName("FeatureMeasureWidth").getObject()).intValue());
            chartGraphProperties.setSpecialFeatureMeasureType(((Number)propertySetable.getPropertyByName("SpecialFeatureMeasureType").getObject()).intValue());
            chartGraphProperties.setQualitativeRangesWidth(((Number)propertySetable.getPropertyByName("QualitativeRangesWidth").getObject()).intValue());
        } else {
            chartGraphProperties.setBulletDataSize("3;1;1");
            chartGraphProperties.setIsHorizontal(false);
            chartGraphProperties.setComparativeMeasureWidth(40);
            chartGraphProperties.setSpecialFeatureMeasureWidth(60);
            chartGraphProperties.setSpecialFeatureMeasureType(0);
            chartGraphProperties.setQualitativeRangesWidth(80);
        }
        if (propertySetable.getPropertyByName("CutBubbleBasedOnXYArea") != null) {
            chartGraphProperties.setCutBubble((Boolean)propertySetable.getPropertyByName("CutBubbleBasedOnXYArea").getObject());
        }
        if (propertySetable.getPropertyByName("MotionSpeedControl") != null) {
            chartGraphProperties.setMotionControlSpeed(((Number)propertySetable.getPropertyByName("MotionSpeedControl").getObject()).intValue());
        }
        if (propertySetable.getPropertyByName("LEDChartBorderStyle") != null) {
            chartGraphProperties.setIndicatorOtherColor(JetChartPropertyValues.mapFillPattern((String)propertySetable.getPropertyByName("LEDChartOtherColor").getObject()));
            chartGraphProperties.setIndicatorOtherImage(DSChartPropertiesLoader.elementAt("LEDChartOtherImage", propertySetable));
            chartGraphProperties.setIndicatorOtherName((String)propertySetable.getPropertyByName("LEDChartOtherName").getObject());
            chartGraphProperties.setIndicatorColors(JetChartPropertyValues.mapPatterns((Vector)propertySetable.getPropertyByName("LEDChartColorItems").getObject()));
            chartGraphProperties.setIndicatorImages(DSChartPropertiesLoader.floatValue("LEDChartImageItems", propertySetable));
            chartGraphProperties.setIndicatorMinValues((Vector)propertySetable.getPropertyByName("LEDChartMinValues").getObject());
            chartGraphProperties.setIndicatorMaxValues((Vector)propertySetable.getPropertyByName("LEDChartMaxValues").getObject());
            chartGraphProperties.setIndicatorRangeNames((Vector)propertySetable.getPropertyByName("LEDChartNameItems").getObject());
            chartGraphProperties.setLEDStyle(((Number)propertySetable.getPropertyByName("LEDChartBorderStyle").getObject()).intValue());
            chartGraphProperties.setLEDUsedImage((Boolean)propertySetable.getPropertyByName("LEDChartUseImage").getObject());
            chartGraphProperties.setIndictorImagePath(DSChartPropertiesLoader.equals("LEDChartOtherImage", "LEDChartImageItems", propertySetable));
        }
        chartCoordinatePaperProperties.setInstanceName(((JRObjectResult)propertySetable).getJetObjInstName());
        boolean bl2 = ((DSChartPlatform)((DSChartCoordinatepaper)propertySetable).getParent()).getDataLoader().getChartDefinition().isSparklineChart();
        if (bl2) {
            chartCoordinatePaperProperties.setShowAxisX(false);
            chartCoordinatePaperProperties.setShowAxisY(false);
            chartCoordinatePaperProperties.setShowAxisY2(false);
        }
        if (propertySetable.getPropertyByName("IgnoreNullValue") != null) {
            chartCoordinatePaperProperties.setIsIgnoreNullValue((Boolean)propertySetable.getPropertyByName("IgnoreNullValue").getObject());
        } else {
            chartCoordinatePaperProperties.setIsIgnoreNullValue(false);
        }
        if (propertySetable.getPropertyByName("IsApplyNodeToLine") != null) {
            chartGraphProperties.setUseNodeColor((Boolean)propertySetable.getPropertyByName("IsApplyNodeToLine").getObject());
        }
        return chartCoordinatePaperProperties;
    }

    private static ChartLegendProperties append(PropertySetable propertySetable) {
        Object object;
        Object object2;
        ChartLegendProperties chartLegendProperties = new ChartLegendProperties();
        int n = ((JRObjectResult)propertySetable).getResolution();
        chartLegendProperties.setTopMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("TopMargin").getObject()).intValue(), n));
        chartLegendProperties.setLeftMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LeftMargin").getObject()).intValue(), n));
        chartLegendProperties.setRightMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("RightMargin").getObject()).intValue(), n));
        chartLegendProperties.setBottomMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("BottomMargin").getObject()).intValue(), n));
        chartLegendProperties.setBackground(DSChartPropertiesLoader.getAngleZ("Legend", propertySetable));
        chartLegendProperties.setAutoSize((Boolean)propertySetable.getPropertyByName("AutoSize").getObject());
        chartLegendProperties.setPlacement(((Number)propertySetable.getPropertyByName("Placement").getObject()).intValue());
        chartLegendProperties.setSubPlacement(((Number)propertySetable.getPropertyByName("SubPlacement").getObject()).intValue());
        chartLegendProperties.setLabelFilterSource(((Number)propertySetable.getPropertyByName("LabelFilterSource").getObject()).intValue());
        chartLegendProperties.setLegendFilter(JetChartPropertyValues.mapChartDataFilter((Vector)propertySetable.getPropertyByName("LegendFilter").getObject()));
        chartLegendProperties.setLabelVSpacing(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LabelVSpacing").getObject()).intValue(), n));
        chartLegendProperties.setLabelHSpacing(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LabelHSpacing").getObject()).intValue(), n));
        chartLegendProperties.setIconStyleList(JetChartPropertyValues.mapIconStyles((String)propertySetable.getPropertyByName("IconStyleList").getObject()));
        chartLegendProperties.setReverseLabels((Boolean)propertySetable.getPropertyByName("ReverseLabels").getObject());
        ChartLabelProperties chartLabelProperties = chartLegendProperties.getLabelStyle();
        chartLabelProperties.setTextStyle(DSChartPropertiesLoader.getAngleY("Label", propertySetable));
        chartLabelProperties.setTextAlignment(((Number)propertySetable.getPropertyByName("TextAlignment").getObject()).intValue());
        chartLabelProperties.setIconAlignment(((Number)propertySetable.getPropertyByName("IconAlignment").getObject()).intValue());
        chartLabelProperties.setIconTextGap(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("IconTextGap").getObject()).intValue(), n));
        ChartIcon chartIcon = new ChartIcon();
        chartIcon.setIconWidth(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("IconWidth").getObject()).intValue(), n));
        chartIcon.setIconHeight(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("IconHeight").getObject()).intValue(), n));
        chartIcon.setPen(DSChartPropertiesLoader.getAngleX("IconBorder", propertySetable));
        chartIcon.setColor(DSChartPropertiesLoader.get("IconFill", propertySetable));
        chartLabelProperties.setIcon(chartIcon);
        chartLegendProperties.setInstanceName(((JRObjectResult)propertySetable).getJetObjInstName());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (propertySetable.getPropertyByName("ShowTips") != null) {
            chartLegendProperties.setShowTips((Boolean)propertySetable.getPropertyByName("ShowTips").getObject());
            chartLegendProperties.setShowValues((Boolean)propertySetable.getPropertyByName("ShowValues").getObject());
            chartLegendProperties.setValueFormat(JetChartPropertyValues.mapChartDataFilter((Vector)propertySetable.getPropertyByName("ValueFormat").getObject()));
            chartLegendProperties.setShowPercent((Boolean)propertySetable.getPropertyByName("ShowPercent").getObject());
            chartLegendProperties.setPercentFormat(JetChartPropertyValues.mapChartDataFilter((Vector)propertySetable.getPropertyByName("PercentFormat").getObject()));
        } else {
            chartLegendProperties.setShowTips(bl);
            chartLegendProperties.setShowValues(bl2);
            object2 = new Vector<String>();
            ((Vector)object2).add("00.00");
            chartLegendProperties.setValueFormat(JetChartPropertyValues.mapChartDataFilter(object2));
            chartLegendProperties.setShowPercent(bl3);
            object = new Vector<String>();
            ((Vector)object).add("10.00%");
            chartLegendProperties.setPercentFormat(JetChartPropertyValues.mapChartDataFilter(object));
        }
        if (propertySetable.getPropertyByName("MarkNodeUsage") != null) {
            int n2 = ((Number)propertySetable.getPropertyByName("MarkNodeUsage").getObject()).intValue();
            switch (n2) {
                case 0: {
                    chartLegendProperties.setShowLineForLineChart(false);
                    chartLegendProperties.setInheritShapeFromNode(false);
                    break;
                }
                case 1: {
                    chartLegendProperties.setShowLineForLineChart(true);
                    chartLegendProperties.setInheritShapeFromNode(false);
                    break;
                }
                case 2: {
                    chartLegendProperties.setShowLineForLineChart(false);
                    chartLegendProperties.setInheritShapeFromNode(true);
                }
            }
        }
        if (propertySetable.getPropertyByName("ShowScrollbar") != null) {
            chartLegendProperties.setIsScroll((Boolean)propertySetable.getPropertyByName("ShowScrollbar").getObject());
        }
        if (propertySetable.getPropertyByName("Truncate") != null) {
            chartLegendProperties.setIsTruncate((Boolean)propertySetable.getPropertyByName("Truncate").getObject());
        }
        if (propertySetable.getPropertyByName("TotalValueText") != null) {
            object2 = (String)propertySetable.getPropertyByName("TotalValueText").getObject();
            if (object2 != null && propertySetable.getPropertyByName("TotalValueText").isChangeByOther()) {
                object = Encoding.getEncoding();
                CharBinaryFormat charBinaryFormat = new CharBinaryFormat((String)object);
                object2 = charBinaryFormat.format((String)object2);
            }
            chartLegendProperties.setCustomerTotalLabel((String)object2);
        }
        if (propertySetable.getPropertyByName("DataMappingFile") != null) {
            chartLegendProperties.setDataMappingFile((String)propertySetable.getPropertyByName("DataMappingFile").getObject());
        }
        return chartLegendProperties;
    }

    private static ChartLabelProperties booleanValue(PropertySetable propertySetable) {
        Object object;
        ChartLabelProperties chartLabelProperties = new ChartLabelProperties();
        int n = ((JRObjectResult)propertySetable).getResolution();
        chartLabelProperties.setTopMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("TopMargin").getObject()).intValue(), n));
        chartLabelProperties.setLeftMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LeftMargin").getObject()).intValue(), n));
        chartLabelProperties.setRightMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("RightMargin").getObject()).intValue(), n));
        chartLabelProperties.setBottomMargin(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("BottomMargin").getObject()).intValue(), n));
        chartLabelProperties.setBackground(DSChartPropertiesLoader.getAngleZ("Label", propertySetable));
        Propertiable propertiable = propertySetable.getPropertyByName("Text");
        String string = (String)propertiable.getObject();
        if (string != null && propertiable.isChangeByOther()) {
            object = Encoding.getEncoding();
            CharBinaryFormat charBinaryFormat = new CharBinaryFormat((String)object);
            string = charBinaryFormat.format(string);
        }
        chartLabelProperties.setText(string);
        chartLabelProperties.setTextStyle(DSChartPropertiesLoader.getAngleY("Label", propertySetable));
        chartLabelProperties.setTextAlignment(((Number)propertySetable.getPropertyByName("TextAlignment").getObject()).intValue());
        chartLabelProperties.setIconAlignment(((Number)propertySetable.getPropertyByName("IconAlignment").getObject()).intValue());
        chartLabelProperties.setIconTextGap(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("IconTextGap").getObject()).intValue(), n));
        object = new ChartIcon();
        int n2 = ((Number)propertySetable.getPropertyByName("IconStyle").getObject()).intValue();
        if (n2 == 0) {
            ((ChartIcon)object).setIconStyle(ChartIcon.BUILTINICON.length);
        } else {
            ((ChartIcon)object).setIconStyle(n2 - 1);
        }
        ((ChartIcon)object).setIconWidth(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("IconWidth").getObject()).intValue(), n));
        ((ChartIcon)object).setIconHeight(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("IconHeight").getObject()).intValue(), n));
        ((ChartIcon)object).setPen(DSChartPropertiesLoader.getAngleX("IconBorder", propertySetable));
        ((ChartIcon)object).setColor(DSChartPropertiesLoader.get("IconFill", propertySetable));
        chartLabelProperties.setIcon((ChartIcon)object);
        chartLabelProperties.setTitleType(((Number)propertySetable.getPropertyByName("TitleType").getObject()).intValue());
        chartLabelProperties.setInstanceName(((JRObjectResult)propertySetable).getJetObjInstName());
        return chartLabelProperties;
    }

    private static ChartAxisProperties convertUnitToPixel(String string, PropertySetable propertySetable, boolean bl) {
        boolean bl2;
        String string2 = "Axis" + string;
        int n = ((JRObjectResult)propertySetable).getResolution();
        ChartAxisProperties chartAxisProperties = bl ? new ChartNumericAxisProperties() : new ChartAxisProperties();
        chartAxisProperties.setAxisPen(DSChartPropertiesLoader.getAngleX(string2, propertySetable));
        chartAxisProperties.setShowGrid((Boolean)propertySetable.getPropertyByName(string2 + "ShowGrid").getObject());
        chartAxisProperties.setGridPen(DSChartPropertiesLoader.getAngleX(string2 + "Grid", propertySetable));
        chartAxisProperties.setShowTickMarkLabels((Boolean)propertySetable.getPropertyByName(string2 + "ShowTickMarkLabels").getObject());
        chartAxisProperties.setTickMarkPen(DSChartPropertiesLoader.getAngleX(string2 + "TickMark", propertySetable));
        chartAxisProperties.setTickMarkType(((Number)propertySetable.getPropertyByName(string2 + "TickMarkType").getObject()).intValue());
        chartAxisProperties.setTickMarkLength(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName(string2 + "TickMarkLength").getObject()).intValue(), n));
        chartAxisProperties.setMinorTickMarkType(((Number)propertySetable.getPropertyByName(string2 + "MinorTickMarkType").getObject()).intValue());
        chartAxisProperties.setMinorTickMarkLength(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName(string2 + "MinorTickMarkLength").getObject()).intValue(), n));
        chartAxisProperties.setLabelTextStyle(DSChartPropertiesLoader.getAngleY(string2 + "Label", propertySetable));
        chartAxisProperties.setLabelEveryNTickMarks(((Number)propertySetable.getPropertyByName(string2 + "LabelEveryNTickMarks").getObject()).intValue());
        chartAxisProperties.setNumOfLabels(((Number)propertySetable.getPropertyByName(string2 + "NumOfLabels").getObject()).intValue());
        chartAxisProperties.setBestEffort((Boolean)propertySetable.getPropertyByName(string2 + "IsBestEffort").getObject());
        chartAxisProperties.setLabelAxisGap(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName(string2 + "LabelAxisGap").getObject()).intValue(), n));
        chartAxisProperties.setPlacement(((Number)propertySetable.getPropertyByName(string2 + "Placement").getObject()).intValue());
        if (bl) {
            ((ChartNumericAxisProperties)chartAxisProperties).setMaxValue(((Number)propertySetable.getPropertyByName(string2 + "MaxValue").getObject()).doubleValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setMinValue(((Number)propertySetable.getPropertyByName(string2 + "MinValue").getObject()).doubleValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setNumOfTickMarks(((Number)propertySetable.getPropertyByName(string2 + "NumOfTickMarks").getObject()).intValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setAxisIncrement(((Number)propertySetable.getPropertyByName(string2 + "Increment").getObject()).doubleValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setLabelStartValue(((Number)propertySetable.getPropertyByName(string2 + "LabelStartValue").getObject()).doubleValue());
            ((ChartNumericAxisProperties)chartAxisProperties).setUseLabelStartValue((Boolean)propertySetable.getPropertyByName(string2 + "UseLabelStartValue").getObject());
            if (propertySetable.getPropertyByName(string2 + "ShowPercent") != null) {
                ((ChartNumericAxisProperties)chartAxisProperties).setIsShowPercent((Boolean)propertySetable.getPropertyByName(string2 + "ShowPercent").getObject());
            } else {
                ((ChartNumericAxisProperties)chartAxisProperties).setIsShowPercent(false);
            }
        }
        if (propertySetable.getPropertyByName(string2 + "LabelPosition") != null) {
            chartAxisProperties.setLabelPosition(((Number)propertySetable.getPropertyByName(string2 + "LabelPosition").getObject()).intValue());
            chartAxisProperties.setLabelFontAutomaticOrientation((Boolean)propertySetable.getPropertyByName(string2 + "LabelFontAutomaticOrientation").getObject());
            chartAxisProperties.setShowLabelTips((Boolean)propertySetable.getPropertyByName(string2 + "ShowLabelTips").getObject());
        } else {
            chartAxisProperties.setLabelPosition(0);
            chartAxisProperties.setLabelFontAutomaticOrientation(false);
            chartAxisProperties.setShowLabelTips(false);
        }
        if (propertySetable.getPropertyByName(string2 + "Position") != null) {
            chartAxisProperties.setPositionAxis(((Number)propertySetable.getPropertyByName(string2 + "Position").getObject()).intValue());
        } else {
            chartAxisProperties.setPositionAxis(0);
        }
        if (propertySetable.getPropertyByName(string2 + "ScrollableChart") != null) {
            chartAxisProperties.setScrollableChart((Boolean)propertySetable.getPropertyByName(string2 + "ScrollableChart").getObject());
        } else {
            chartAxisProperties.setScrollableChart(false);
        }
        if (propertySetable.getPropertyByName(string2 + "ScrollableVisibleValue") != null) {
            chartAxisProperties.setScrollableVisibleValue(((Number)propertySetable.getPropertyByName(string2 + "ScrollableVisibleValue").getObject()).intValue());
        }
        if (propertySetable.getPropertyByName(string2 + "DisplayAreaPercentage") != null) {
            chartAxisProperties.setDisplayAreaPercent(((Number)propertySetable.getPropertyByName(string2 + "DisplayAreaPercentage").getObject()).intValue());
        }
        if (propertySetable.getPropertyByName(string2 + "ScaleUseConstant") != null) {
            chartAxisProperties.getMajorTickMarkProperties().setCorrelateTickMark((Boolean)propertySetable.getPropertyByName(string2 + "CorrelateAxisInMajorTickMark").getObject());
            chartAxisProperties.getMinorTickMarkProperties().setCorrelateTickMark((Boolean)propertySetable.getPropertyByName(string2 + "CorrelateAxisInMinorTickMark").getObject());
            chartAxisProperties.getMinorTickMarkProperties().setCorrelateLabel((Boolean)propertySetable.getPropertyByName(string2 + "CorrelateFontInMinorTickMark").getObject());
            chartAxisProperties.getMinorTickMarkProperties().setTickMarkPen(DSChartPropertiesLoader.getAngleX(string2 + "MinorTickMark", propertySetable));
            chartAxisProperties.getMinorTickMarkProperties().setShowTickMarkLabels((Boolean)propertySetable.getPropertyByName(string2 + "ShowMinorTickMarkLabels").getObject());
            chartAxisProperties.getMinorTickMarkProperties().setLabelNumber(((Number)propertySetable.getPropertyByName(string2 + "NumOfMinorTickMarkLabels").getObject()).intValue());
            chartAxisProperties.getMinorTickMarkProperties().setLabelEveryTickMark(((Number)propertySetable.getPropertyByName(string2 + "LabelEveryNMinorTickMarks").getObject()).intValue());
            chartAxisProperties.getMinorTickMarkProperties().setTickMarkLabel(DSChartPropertiesLoader.getAngleY(string2 + "MinorLabel", propertySetable));
            chartAxisProperties.getMinorTickMarkProperties().setAutoRotate((Boolean)propertySetable.getPropertyByName(string2 + "MinorLabelFontAutomaticOrientation").getObject());
            chartAxisProperties.getUnitProperties().setUseConstantInterval((Boolean)propertySetable.getPropertyByName(string2 + "ScaleUseConstant").getObject());
            chartAxisProperties.getUnitProperties().setStart((Boolean)propertySetable.getPropertyByName(string2 + "ScaleMinValueAuto").getObject(), propertySetable.getPropertyByName(string2 + "ScaleMinValue").getObject().toString());
            chartAxisProperties.getUnitProperties().setEnd((Boolean)propertySetable.getPropertyByName(string2 + "ScaleMaxValueAuto").getObject(), propertySetable.getPropertyByName(string2 + "ScaleMaxValue").getObject().toString());
            chartAxisProperties.getUnitProperties().setMajorUnit((Boolean)propertySetable.getPropertyByName(string2 + "ScaleMajorUnitAuto").getObject(), propertySetable.getPropertyByName(string2 + "ScaleMajorInterval").getObject().toString());
            chartAxisProperties.getUnitProperties().setMinorUnit((Boolean)propertySetable.getPropertyByName(string2 + "ScaleMinorUnitAuto").getObject(), propertySetable.getPropertyByName(string2 + "ScaleMinorInterval").getObject().toString());
            chartAxisProperties.getUnitProperties().setDataType(((Number)propertySetable.getPropertyByName(string2 + "ScaleValueSQLType").getObject()).intValue());
            chartAxisProperties.getUnitProperties().setMajorUnitDateType(((Number)propertySetable.getPropertyByName(string2 + "ScaleMajorIntervalUnit").getObject()).intValue());
            chartAxisProperties.getUnitProperties().setMinorUnitDateType(((Number)propertySetable.getPropertyByName(string2 + "ScaleMinorIntervalUnit").getObject()).intValue());
            chartAxisProperties.setMinorDataFilter(JetChartPropertyValues.mapChartDataFilter((Vector)propertySetable.getPropertyByName(string2 + "DataFilterInMinorTickMark").getObject()));
            chartAxisProperties.getMinorTickMarkProperties().setCorelateLabelFormat((Boolean)propertySetable.getPropertyByName(string2 + "CorrelateDataFilterInMinorTickMark").getObject());
        }
        if (propertySetable.getPropertyByName(string2 + "AutoNumOfMinorTickMarkLabels") != null) {
            chartAxisProperties.getMinorTickMarkProperties().setAutoLabelNumber((Boolean)propertySetable.getPropertyByName(string2 + "AutoNumOfMinorTickMarkLabels").getObject());
        }
        if (propertySetable.getPropertyByName(string2 + "AutoNumOfLabels") != null) {
            chartAxisProperties.getMajorTickMarkProperties().setAutoLabelNumber((Boolean)propertySetable.getPropertyByName(string2 + "AutoNumOfLabels").getObject());
        }
        if (propertySetable.getPropertyByName(string2 + "ShowChartInScroll") != null) {
            chartAxisProperties.setIsShowChartInScroll((Boolean)propertySetable.getPropertyByName(string2 + "ShowChartInScroll").getObject());
        }
        if (bl2 = ((DSChartPlatform)((DSChartCoordinatepaper)propertySetable).getParent()).getDataLoader().getChartDefinition().isSparklineChart()) {
            chartAxisProperties.setShowGrid(false);
        }
        if (propertySetable.getPropertyByName(string2 + "AutoScaleYAxis") != null) {
            chartAxisProperties.setAutoScaleYAxis((Boolean)propertySetable.getPropertyByName(string2 + "AutoScaleYAxis").getObject());
        }
        return chartAxisProperties;
    }

    private static ChartWallProperties doubleValue(String string, PropertySetable propertySetable) {
        String string2 = string;
        ChartWallProperties chartWallProperties = new ChartWallProperties();
        chartWallProperties.setBorder(DSChartPropertiesLoader.getAngleX(string2 + "Border", propertySetable));
        chartWallProperties.setPattern1(DSChartPropertiesLoader.get(string2 + "Fill", propertySetable));
        chartWallProperties.setPattern2(DSChartPropertiesLoader.get(string2 + "BoundFill", propertySetable));
        return chartWallProperties;
    }

    private static String elementAt(String string, PropertySetable propertySetable) {
        String string2 = "";
        if (propertySetable.getPropertyByName(string) != null) {
            string2 = ((ImagePropertiable)propertySetable.getPropertyByName(string)).get();
        }
        return string2;
    }

    private static String equals(String string, String string2, PropertySetable propertySetable) {
        String string3 = "";
        String string4 = "";
        if (((JRObjectResult)propertySetable).getImgInfo() != null) {
            string3 = ((JRObjectResult)propertySetable).getImgInfo().isWithPath() ? ((JRObjectResult)propertySetable).getImgInfo().getImgPath() : ((JRObjectResult)propertySetable).getImgInfo().getImgScopeId();
        }
        return string3;
    }

    private static Vector floatValue(String string, PropertySetable propertySetable) {
        Vector vector = (Vector)((ImageListPropertiable)propertySetable.getPropertyByName(string)).get();
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string2 = "";
                string2 = (String)vector.get(i);
                vector2.add(string2);
            }
        }
        return vector2;
    }

    private static ChartFillPattern format(String string, PropertySetable propertySetable) {
        String string2 = string;
        ChartFillPattern chartFillPattern = null;
        switch (((Number)propertySetable.getPropertyByName(string2 + "Type").getObject()).intValue()) {
            case 1: {
                chartFillPattern = new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "Color").getObject());
                chartFillPattern.setAlpha((float)((Number)propertySetable.getPropertyByName(string2 + "Transparency").getObject()).intValue() / 100.0f);
                break;
            }
            case 2: {
                chartFillPattern = new ChartTexturePattern(((Number)propertySetable.getPropertyByName(string2 + "TextureStyle").getObject()).intValue(), new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "TextureForeColor").getObject()), new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "TextureBackColor").getObject()));
                ((ChartTexturePattern)chartFillPattern).setAlpha((float)((Number)propertySetable.getPropertyByName(string2 + "Transparency").getObject()).intValue() / 100.0f);
                break;
            }
            case 3: {
                chartFillPattern = new ChartGradientPattern(((Number)propertySetable.getPropertyByName(string2 + "GradientStyle").getObject()).intValue());
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "GradientStartColor").getObject()));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "GradientEndColor").getObject()));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float((float)((Number)propertySetable.getPropertyByName(string2 + "GradientStartX").getObject()).intValue() / 100.0f, 1.0f - (float)((Number)propertySetable.getPropertyByName(string2 + "GradientStartY").getObject()).intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float((float)((Number)propertySetable.getPropertyByName(string2 + "GradientEndX").getObject()).intValue() / 100.0f, 1.0f - (float)((Number)propertySetable.getPropertyByName(string2 + "GradientEndY").getObject()).intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setAlpha((float)((Number)propertySetable.getPropertyByName(string2 + "Transparency").getObject()).intValue() / 100.0f);
                break;
            }
            case 4: {
                Image image = ((JRObjectResult)propertySetable).getImgResourceByPropertyName(string2 + "ImageFile").getImage();
                if (image == null) break;
                float f = (float)((Number)propertySetable.getPropertyByName(string2 + "ImageX").getObject()).intValue() / 100.0f;
                float f2 = 1.0f - (float)((Number)propertySetable.getPropertyByName(string2 + "ImageY").getObject()).intValue() / 100.0f;
                float f3 = (float)((Number)propertySetable.getPropertyByName(string2 + "ImageWidth").getObject()).intValue() / 100.0f;
                float f4 = (float)((Number)propertySetable.getPropertyByName(string2 + "ImageHeight").getObject()).intValue() / 100.0f;
                f3 = f + f3 > 1.0f ? 1.0f - f : f3;
                f4 = f2 + f4 > 1.0f ? 1.0f - f2 : f4;
                Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
                int n = ((Number)propertySetable.getPropertyByName(string2 + "ImageLayout").getObject()).intValue();
                float f5 = (float)((Number)propertySetable.getPropertyByName(string2 + "Transparency").getObject()).intValue() / 100.0f;
                chartFillPattern = new ChartCustomizedPattern(image, float_, n, f5);
            }
        }
        return chartFillPattern;
    }

    private static ChartFillPattern get(String string, PropertySetable propertySetable) {
        String string2 = string + "Pattern";
        ChartFillPattern chartFillPattern = null;
        switch (((Number)propertySetable.getPropertyByName(string2 + "Type").getObject()).intValue()) {
            case 1: {
                chartFillPattern = new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "Color").getObject());
                chartFillPattern.setAlpha((float)((Number)propertySetable.getPropertyByName(string2 + "Transparency").getObject()).intValue() / 100.0f);
                break;
            }
            case 2: {
                chartFillPattern = new ChartTexturePattern(((Number)propertySetable.getPropertyByName(string2 + "TextureStyle").getObject()).intValue(), new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "TextureForeColor").getObject()), new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "TextureBackColor").getObject()));
                ((ChartTexturePattern)chartFillPattern).setAlpha((float)((Number)propertySetable.getPropertyByName(string2 + "Transparency").getObject()).intValue() / 100.0f);
                break;
            }
            case 3: {
                chartFillPattern = new ChartGradientPattern(((Number)propertySetable.getPropertyByName(string2 + "GradientStyle").getObject()).intValue());
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "GradientStartColor").getObject()));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern((Color)propertySetable.getPropertyByName(string2 + "GradientEndColor").getObject()));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float((float)((Number)propertySetable.getPropertyByName(string2 + "GradientStartX").getObject()).intValue() / 100.0f, 1.0f - (float)((Number)propertySetable.getPropertyByName(string2 + "GradientStartY").getObject()).intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float((float)((Number)propertySetable.getPropertyByName(string2 + "GradientEndX").getObject()).intValue() / 100.0f, 1.0f - (float)((Number)propertySetable.getPropertyByName(string2 + "GradientEndY").getObject()).intValue() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setAlpha((float)((Number)propertySetable.getPropertyByName(string2 + "Transparency").getObject()).intValue() / 100.0f);
                break;
            }
            case 4: {
                Image image = ((JRObjectResult)propertySetable).getImgResourceByPropertyName(string2 + "ImageFile").getImage();
                if (image == null) break;
                float f = (float)((Number)propertySetable.getPropertyByName(string2 + "ImageX").getObject()).intValue() / 100.0f;
                float f2 = 1.0f - (float)((Number)propertySetable.getPropertyByName(string2 + "ImageY").getObject()).intValue() / 100.0f;
                float f3 = (float)((Number)propertySetable.getPropertyByName(string2 + "ImageWidth").getObject()).intValue() / 100.0f;
                float f4 = (float)((Number)propertySetable.getPropertyByName(string2 + "ImageHeight").getObject()).intValue() / 100.0f;
                f3 = f + f3 > 1.0f ? 1.0f - f : f3;
                f4 = f2 + f4 > 1.0f ? 1.0f - f2 : f4;
                Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
                int n = ((Number)propertySetable.getPropertyByName(string2 + "ImageLayout").getObject()).intValue();
                float f5 = (float)((Number)propertySetable.getPropertyByName(string2 + "Transparency").getObject()).intValue() / 100.0f;
                chartFillPattern = new ChartCustomizedPattern(image, float_, n, f5);
            }
        }
        return chartFillPattern;
    }

    private static ChartPenStyle getAngleX(String string, PropertySetable propertySetable) {
        String string2 = string + "Pen";
        int n = ((JRObjectResult)propertySetable).getResolution();
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setDashPattern(((Number)propertySetable.getPropertyByName(string2 + "Style").getObject()).intValue());
        chartPenStyle.setPenWidth(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName(string2 + "Thickness").getObject()).intValue(), n));
        chartPenStyle.setEndCaps(((Number)propertySetable.getPropertyByName(string2 + "EndCaps").getObject()).intValue());
        chartPenStyle.setLineJoints(((Number)propertySetable.getPropertyByName(string2 + "LineJoint").getObject()).intValue());
        chartPenStyle.setOutlined((Boolean)propertySetable.getPropertyByName(string2 + "Outlined").getObject());
        chartPenStyle.setVariabledDash((Boolean)propertySetable.getPropertyByName(string2 + "VariabledDash").getObject());
        ChartColorPattern chartColorPattern = new ChartColorPattern();
        chartColorPattern.setColor((Color)propertySetable.getPropertyByName(string2 + "Color").getObject());
        chartColorPattern.setAlpha((float)((Number)propertySetable.getPropertyByName(string2 + "Transparency").getObject()).intValue() / 100.0f);
        chartPenStyle.setPenColor(chartColorPattern);
        if (string.equals("PlatformBackgroundBorder")) {
            chartPenStyle.setJointRadiusPixel(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName(string2 + "LineJointRadius").getObject()).intValue(), n));
        }
        return chartPenStyle;
    }

    private static ChartTextStyle getAngleY(String string, PropertySetable propertySetable) {
        String string2 = string + "Text";
        int n = ((JRObjectResult)propertySetable).getResolution();
        ChartTextStyle chartTextStyle = new ChartTextStyle();
        chartTextStyle.setFontName((String)propertySetable.getPropertyByName(string2 + "FontName").getObject());
        chartTextStyle.setFontSize(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName(string2 + "FontSize").getObject()).intValue(), n));
        chartTextStyle.setFontStyle(((Number)propertySetable.getPropertyByName(string2 + "FontStyle").getObject()).intValue());
        chartTextStyle.setUnderline(((Number)propertySetable.getPropertyByName(string2 + "Underline").getObject()).intValue());
        chartTextStyle.setStrikethrough(((Number)propertySetable.getPropertyByName(string2 + "Strikethrough").getObject()).intValue());
        chartTextStyle.setShearing((float)((Number)propertySetable.getPropertyByName(string2 + "Shearing").getObject()).intValue() / 100.0f);
        chartTextStyle.setRotation(((Number)propertySetable.getPropertyByName(string2 + "Rotation").getObject()).doubleValue() * Math.PI / 180.0);
        chartTextStyle.setFontPen(DSChartPropertiesLoader.getAngleX(string2, propertySetable));
        chartTextStyle.setFontColor(DSChartPropertiesLoader.get(string2, propertySetable));
        JetChartPropertyValues.setFontSpecialEffect1(chartTextStyle, ((Number)propertySetable.getPropertyByName(string2 + "SpecialEffect1").getObject()).intValue());
        JetChartPropertyValues.setFontSpecialEffect2(chartTextStyle, ((Number)propertySetable.getPropertyByName(string2 + "SpecialEffect2").getObject()).intValue());
        chartTextStyle.setWordWrapper((Boolean)propertySetable.getPropertyByName(string2 + "WordWrap").getObject());
        return chartTextStyle;
    }

    private static ChartBackground getAngleZ(String string, PropertySetable propertySetable) {
        String string2 = string + "Background";
        ChartBackground chartBackground = new ChartBackground();
        chartBackground.setBorderStyle(((Number)propertySetable.getPropertyByName(string2 + "BorderStyle").getObject()).intValue());
        chartBackground.setPen(DSChartPropertiesLoader.getAngleX(string2 + "Border", propertySetable));
        chartBackground.setPattern(DSChartPropertiesLoader.get(string2 + "Fill", propertySetable));
        chartBackground.setTop((float)((Number)propertySetable.getPropertyByName(string2 + "Top").getObject()).intValue() / 100.0f);
        chartBackground.setLeft((float)((Number)propertySetable.getPropertyByName(string2 + "Left").getObject()).intValue() / 100.0f);
        chartBackground.setRight((float)((Number)propertySetable.getPropertyByName(string2 + "Right").getObject()).intValue() / 100.0f);
        chartBackground.setBottom((float)((Number)propertySetable.getPropertyByName(string2 + "Bottom").getObject()).intValue() / 100.0f);
        return chartBackground;
    }

    public int getResolution() {
        return this.res;
    }

    public void setResolution(int n) {
        this.res = n;
    }

    public static int[][] mappingLineStyleLists(String string, int n) {
        String[] stringArray = string.split(";");
        int n2 = stringArray.length;
        int n3 = 2;
        int[][] nArray = null;
        if (n2 > 0) {
            String[] stringArray2 = stringArray[0].split(",");
            n3 = stringArray2.length;
            nArray = new int[n2][n3];
        }
        for (int i = 0; i < n2; ++i) {
            String[] stringArray3 = stringArray[i].split(",");
            if (stringArray3 != null) {
                nArray[i][0] = Integer.parseInt(stringArray3[0]);
                nArray[i][1] = Integer.parseInt(stringArray3[1]);
                if (stringArray3.length <= 2) continue;
                nArray[i][2] = Unit.convertUnitToPixel(Integer.parseInt(stringArray3[2]), n);
                continue;
            }
            nArray[i][0] = 1;
            nArray[i][1] = 0;
            if (n3 <= 2) continue;
            nArray[i][2] = Unit.convertUnitToPixel(180, n);
        }
        return nArray;
    }

    private static ChartNodeProperties getChartDefinition(PropertySetable propertySetable) {
        ChartNodeProperties chartNodeProperties = new ChartNodeProperties();
        JRObjectResult jRObjectResult = (JRObjectResult)((Object)((DSChartCoordinatePaperChild)propertySetable).getParent());
        int n = jRObjectResult.getResolution();
        chartNodeProperties.setShapeStyle(((Number)propertySetable.getPropertyByName("LineNodeStyle").getObject()).intValue());
        chartNodeProperties.setShapeWidth(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LineNodeWidth").getObject()).intValue(), n));
        chartNodeProperties.setShapeHeight(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LineNodeHeight").getObject()).intValue(), n));
        chartNodeProperties.setCusNFill((Boolean)propertySetable.getPropertyByName("CusNormalPointFillColor").getObject());
        chartNodeProperties.setNFillClr((Color)propertySetable.getPropertyByName("NormalPointFillColor").getObject());
        chartNodeProperties.setNFillClrTrans(((Number)propertySetable.getPropertyByName("NormalFillColorTransparency").getObject()).floatValue());
        chartNodeProperties.setCusLFill((Boolean)propertySetable.getPropertyByName("CusLowestPointFillColor").getObject());
        chartNodeProperties.setLFillClr((Color)propertySetable.getPropertyByName("LowestPointFillColor").getObject());
        chartNodeProperties.setCusHFill((Boolean)propertySetable.getPropertyByName("CusHighestPointFillColor").getObject());
        chartNodeProperties.setHFillClr((Color)propertySetable.getPropertyByName("HighestPointFillColor").getObject());
        chartNodeProperties.setBorderClr((Color)propertySetable.getPropertyByName("LineNodeBorderPenColor").getObject());
        chartNodeProperties.setBorderClrTrans(((Number)propertySetable.getPropertyByName("LineNodeBorderPenTransparency").getObject()).intValue());
        chartNodeProperties.setBorderStyle(((Number)propertySetable.getPropertyByName("LineNodeBorderPenStyle").getObject()).intValue());
        chartNodeProperties.setBorderThickness(Unit.convertUnitToPixel(((Number)propertySetable.getPropertyByName("LineNodeBorderPenThickness").getObject()).intValue()));
        if (propertySetable.getPropertyByName("ShowHighLightNode") != null) {
            chartNodeProperties.setShowHighLightNode((Boolean)propertySetable.getPropertyByName("ShowHighLightNode").getObject());
            chartNodeProperties.setHighLightNodeClr((Color)propertySetable.getPropertyByName("HighLightNodeColor").getObject());
        }
        return chartNodeProperties;
    }

    private static List getChildren(ChartGraphProperties chartGraphProperties, PropertySetable propertySetable, ChartLegendProperties chartLegendProperties) {
        ArrayList arrayList = new ArrayList();
        ChartNodeProperties chartNodeProperties = new ChartNodeProperties();
        chartNodeProperties.setShapeStyle(chartGraphProperties.getLineNodeStyle());
        chartNodeProperties.setShapeWidth(chartGraphProperties.getLineNodeWidth());
        chartNodeProperties.setShapeHeight(chartGraphProperties.getLineNodeHeight());
        if (propertySetable.getPropertyByName("LineNodeFillColor") != null) {
            chartNodeProperties.setNFillClr((Color)propertySetable.getPropertyByName("LineNodeFillColor").getObject());
        }
        return arrayList;
    }

    public ChartCoordinatePaperProperties getPaperProperties() {
        return this.paperP;
    }

    public ChartLegendProperties getLegendProperties() {
        return this.legendP;
    }

    private static ChartLineProperties getDataLoader(PropertySetable propertySetable) {
        ChartLineProperties chartLineProperties = new ChartLineProperties();
        Vector vector = ((DSChartCoordinatepaper)propertySetable).getChildren();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                JRObjectResult jRObjectResult;
                if (vector.get(i) == null || (jRObjectResult = (JRObjectResult)vector.get(i)).getObjectType() != 78) continue;
                if (jRObjectResult.getPropertyByName("LineColor") != null) {
                    chartLineProperties.setLineColor((Color)jRObjectResult.getPropertyByName("LineColor").getObject());
                }
                if (jRObjectResult.getPropertyByName("LineStyle") != null) {
                    chartLineProperties.setLineStyle((Integer)jRObjectResult.getPropertyByName("LineStyle").getObject());
                    chartLineProperties.setLineStyleName(jRObjectResult.getPropertyByName("LineStyle").toString());
                }
                if (jRObjectResult.getPropertyByName("LineWidth") == null) break;
                chartLineProperties.setThickness(Unit.convertUnitToPixel(((Number)jRObjectResult.getPropertyByName("LineWidth").getObject()).intValue()));
                break;
            }
        }
        return chartLineProperties;
    }
}

