/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbChar;
import jet.connect.Record;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTextObj;
import jet.datastream.JRVisiableResult;
import jet.datastream.TextobjFieldable;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderText;
import jet.util.Containable;
import jet.util.Converter;
import jet.util.DbValueFormat;
import jet.util.HashVector;
import jet.util.JFieldValueNLSManager;
import jet.util.JRInterruptedException;
import jet.util.NLSBundleInfo;
import jet.util.Propertiable;
import jet.util.ReportFormat;
import jet.util.VersionControlable;

public class DSField
extends JRVisiableResult {
    Render render = null;
    Integer renderType = null;
    int stretchHeight = -1;
    int lineNum;
    int startPos;
    int stringLength;
    int baseline;
    int underlineWidth;
    int strikeline;
    int strikelineWidth;
    int[][] lineBreakPos = null;
    int startLine;
    int endLine;
    protected Locale locale;
    protected int resolution = -1;
    protected TimeZone timezone;
    private boolean B = false;
    private int clearCacheRecord = 0;
    private int convertGraphicsToGraphics2D = 0;
    private int convertString = -1;
    private ImageObserver convertTextForTextObject;
    protected boolean isRuntimeConvert = false;
    protected int fromEncoding = -1;
    protected int toEncoding = -1;
    protected JFieldValueNLSManager nlsManager = null;
    protected JFieldValueNLSManager catlogNLSManager = null;
    protected NLSBundleInfo nlsBundle;
    private boolean convertUnitToPixel = false;
    private Rectangle createConcreteRender = null;
    private String createRender = null;
    private boolean doEncodingConvert = false;
    private int doNLSMapping = -1;
    boolean isPipe = false;
    private int drawImage = -1;
    private Record dup = null;

    public void setStringValue(String string) {
    }

    public void setLineBreakPos(int[][] nArray) {
        if (nArray.length > 0) {
            this.lineBreakPos = nArray;
        }
    }

    public int[][] getLineBreakPos() {
        return this.lineBreakPos;
    }

    public void setStartLine(int n) {
        this.startLine = n;
    }

    public void setStartLine_split(int n) {
        this.startLine = n + 1;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setEndLine(int n) {
        this.endLine = n;
    }

    public int getEndLine() {
        return this.endLine;
    }

    @Override
    protected void beforeWrite() {
        super.beforeWrite();
        this.flag = (byte)(this.flag | (this.convertString != -1 ? 64 : 0));
        this.flag = (byte)(this.flag | (this.lineBreakPos != null ? -128 : 0));
    }

    public String getText(JRecord jRecord) {
        String string;
        if (this.getObjectType() == 257 || this.getObjectType() == 393473) {
            Propertiable propertiable = this.getPropertyByName("DispTextInfo", jRecord);
            string = propertiable == null || propertiable.getObject().equals("") ? (String)this.getPropertyByName("Text", jRecord).getObject() : (String)propertiable.getObject();
        } else {
            throw new RuntimeException();
        }
        string = this.doEncodingConvert(string);
        return string;
    }

    public String getText() {
        String string;
        if (this.getObjectType() == 257 || this.getObjectType() == 393473) {
            Propertiable propertiable = this.getPropertyByName("DispTextInfo");
            string = propertiable == null || propertiable.getObject().equals("") ? this.getTemplate().getText(this) : (String)propertiable.getObject();
        } else {
            throw new RuntimeException();
        }
        string = this.doNLSMapping(string);
        string = this.doEncodingConvert(string);
        return string;
    }

    protected String doEncodingConvert(String string) {
        if (this.isRuntimeConvert) {
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        } else {
            Communicator communicator = this.getCommunicator();
            this.fromEncoding = communicator.getFromEncoding();
            this.toEncoding = communicator.getToEncoding();
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        }
        return string;
    }

    protected String doNLSMapping(String object) throws JRInterruptedException {
        Object object2;
        boolean bl = true;
        boolean bl2 = false;
        Propertiable propertiable = this.getPropertyByName("DataMappingFile");
        if (propertiable == null) {
            bl = false;
        } else {
            object2 = propertiable.getObject();
            if (object2 == null || object2.toString().equals("")) {
                bl = false;
            }
        }
        object2 = null;
        if (this.nlsBundle != null) {
            object2 = this.nlsBundle.getDataMapped((String)object);
        } else {
            if (bl) {
                String string = null;
                if (propertiable != null) {
                    string = (String)this.getPropertyByName("DataMappingFile").getObject();
                }
                if (string != null) {
                    JFieldValueNLSManager jFieldValueNLSManager;
                    if (this.nlsManager != null) {
                        object2 = this.nlsManager.getFieldBindNLSValue(string, (String)object);
                    } else if (string.length() != 0 && (jFieldValueNLSManager = this.getFieldNLSManager()) != null) {
                        object2 = jFieldValueNLSManager.getFieldBindNLSValue(string, (String)object);
                    }
                }
            } else {
                String string = this.getCatlogNLSPreFix();
                if (string != null) {
                    JFieldValueNLSManager jFieldValueNLSManager = this.catlogNLSManager;
                    if (jFieldValueNLSManager == null) {
                        jFieldValueNLSManager = this.getCommunicator().getCatalogNlsManager(this.getSubIdxOfRpt());
                    }
                    if (jFieldValueNLSManager != null) {
                        object2 = jFieldValueNLSManager.getFieldBindNLSValue(string, (String)object);
                    }
                }
            }
            if (object2 != null) {
                object = object2;
            }
        }
        return object;
    }

    protected String getCatlogNLSPreFix() {
        if (this.getParent() == null) {
            return this.createRender;
        }
        return this.getCommunicator().getCatalogNlsPrefix(this.getSubIdxOfRpt() + "_" + this.getTemplate().getInstName());
    }

    public String getDataEntity() {
        Propertiable propertiable;
        String string = null;
        int n = this.getObjectType();
        if ((n == 257 || n == 393473) && (propertiable = this.template.getPropertyByName("Text")) != null && propertiable.isSetRuntimeChgBy()) {
            if (propertiable.isChangeByBL()) {
                this.doEncodingConvert = true;
                string = propertiable.getChangeByBL().toString();
            } else {
                string = propertiable.getRuntimeChangeBy().toString();
            }
        }
        return string;
    }

    public void setStretchHeight(int n) {
        this.stretchHeight = n;
    }

    public int getStretchHeight() {
        return this.stretchHeight == -1 ? this.getHeight() : this.stretchHeight;
    }

    public void setLineNum(int n) {
        this.lineNum = n;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public void setStartChar(short s) {
        this.startPos = s;
    }

    public int getStartChar() {
        return this.startPos;
    }

    public void setCharLength(short s) {
        this.stringLength = s;
    }

    public int getCharLength() {
        return this.stringLength;
    }

    public void setBaseline(int n) {
        this.baseline = n;
    }

    public int getBaseline() {
        return Unit.convertUnitToPixel(this.baseline, this.getResolution());
    }

    public void setUnderlineWidth(int n) {
        this.underlineWidth = n;
    }

    public int getUnderlineWidth() {
        return Unit.convertUnitToPixel(this.underlineWidth, this.getResolution());
    }

    public void setStrikeline(int n) {
        this.strikeline = n;
    }

    public int getStrikeline() {
        return Unit.convertUnitToPixel(this.strikeline, this.getResolution());
    }

    public void setStrikelineWidth(int n) {
        this.strikelineWidth = n;
    }

    public int getStrikelineWidth() {
        return Unit.convertUnitToPixel(this.strikelineWidth, this.getResolution());
    }

    public static final String convertTextForTextObject(String string) {
        string = string.replace('\t', ' ');
        string = string.replace('\r', ' ');
        string = string.replace('\n', ' ');
        return string;
    }

    public String toString() {
        String string = this.getText();
        if (this.isTextobjFieldable()) {
            int n = (string = DSField.convertTextForTextObject(string)).length();
            if (this.startPos < n && this.startPos + this.stringLength <= n) {
                string = string.substring(this.startPos, this.startPos + this.stringLength);
            } else if (this.getObjectType() == 257 && this.startPos < n && this.startPos + this.stringLength > n) {
                String string2 = string;
                for (int i = this.startPos; i < this.startPos + this.stringLength; i += n) {
                    string2 = string2 + string;
                }
                string = string2.substring(this.startPos, this.startPos + this.stringLength);
            }
        }
        return string;
    }

    private void B(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        boolean bl = true;
        if (dataInput instanceof VersionControlable && (0 == (n = ((VersionControlable)((Object)dataInput)).getVersion()) || n > 262160)) {
            bl = false;
        }
        if (bl) {
            if (this.isTextobjFieldable()) {
                if (dataInput instanceof VersionControlable) {
                    n = ((VersionControlable)((Object)dataInput)).getVersion();
                    if (n >= 131072 || n == 0) {
                        this.lineNum = dataInput.readInt();
                        this.startPos = dataInput.readInt();
                        this.stringLength = dataInput.readInt();
                        this.baseline = dataInput.readInt();
                        this.underlineWidth = dataInput.readInt();
                        this.strikeline = dataInput.readInt();
                        this.strikelineWidth = dataInput.readInt();
                        if (n < 131087 && n != 0) {
                            this.baseline = (int)Math.round((double)this.baseline * 5760.0 / 65535.0);
                            this.underlineWidth = (int)Math.round((double)this.underlineWidth * 5760.0 / 65535.0);
                            this.strikeline = (int)Math.round((double)this.strikeline * 5760.0 / 65535.0);
                            this.strikelineWidth = (int)Math.round((double)this.strikelineWidth * 5760.0 / 65535.0);
                        }
                    } else {
                        this.lineNum = dataInput.readShort();
                        this.startPos = dataInput.readShort();
                        this.stringLength = dataInput.readShort();
                        this.baseline = dataInput.readShort();
                        this.underlineWidth = dataInput.readShort();
                        this.strikeline = dataInput.readShort();
                        this.strikelineWidth = dataInput.readShort();
                    }
                }
            } else {
                this.stretchHeight = dataInput.readInt();
            }
        }
        if (dataInput instanceof VersionControlable) {
            int n2;
            n = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n >= 7 && n < 131076) {
                for (n2 = 0; n2 < 2; ++n2) {
                    dataInput.readInt();
                }
            }
            if (n >= 10 && n < 131085) {
                n2 = dataInput.readShort();
                if (n2 != 0) {
                    this.lineBreakPos = new int[n2][2];
                    for (int i = 0; i < n2; ++i) {
                        this.lineBreakPos[i][0] = dataInput.readShort();
                        this.lineBreakPos[i][1] = dataInput.readShort();
                    }
                    this.startLine = dataInput.readShort();
                    this.endLine = dataInput.readShort();
                }
            } else if (n >= 131085 && n <= 262160) {
                n2 = dataInput.readInt();
                if (n2 != 0) {
                    this.lineBreakPos = new int[n2][2];
                    for (int i = 0; i < n2; ++i) {
                        this.lineBreakPos[i][0] = dataInput.readInt();
                        this.lineBreakPos[i][1] = dataInput.readInt();
                    }
                    this.startLine = dataInput.readInt();
                    this.endLine = dataInput.readInt();
                }
            } else if ((n > 262160 || n == 0) && (this.flag & 0xFFFFFF80) != 0 && (n2 = dataInput.readInt()) != 0) {
                this.lineBreakPos = new int[n2][2];
                for (int i = 0; i < n2; ++i) {
                    this.lineBreakPos[i][0] = dataInput.readInt();
                    this.lineBreakPos[i][1] = dataInput.readInt();
                }
                this.startLine = dataInput.readInt();
                this.endLine = dataInput.readInt();
            }
            if (n >= 131098 && n <= 262160) {
                this.drawImage = dataInput.readInt();
            }
            if (n >= 262145 || n == 0) {
                n2 = dataInput.readBoolean() ? 1 : 0;
                if (n2 != 0) {
                    this.SEDU(dataInput);
                }
                if (n > 0 && n <= 262160) {
                    this.convertString = dataInput.readInt();
                } else if ((this.flag & 0x40) != 0) {
                    this.convertString = dataInput.readInt();
                }
            }
        }
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.B(dataInput, dSDataStreamable);
    }

    public int getRenderType() {
        int n = 0;
        if (this.renderType != null) {
            n = this.renderType;
        } else {
            Propertiable propertiable = this.getPropertyByName("renderType");
            if (propertiable != null) {
                this.renderType = (Integer)propertiable.getObject();
                n = this.renderType;
            }
        }
        return n;
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        int n;
        super.writeProperties(dataOutput);
        if (this.lineBreakPos != null) {
            dataOutput.writeInt(this.lineBreakPos.length);
            for (n = 0; n < this.lineBreakPos.length; ++n) {
                dataOutput.writeInt(this.lineBreakPos[n][0]);
                dataOutput.writeInt(this.lineBreakPos[n][1]);
            }
            dataOutput.writeInt(this.startLine);
            dataOutput.writeInt(this.endLine);
        }
        n = 1;
        if (this.render == null || this.renderType != null && this.renderType != 0) {
            n = 0;
        }
        dataOutput.writeBoolean(n != 0);
        if (n != 0) {
            this.writeRenderTextProperties(dataOutput);
        }
        if (this.convertString != -1) {
            dataOutput.writeInt(this.convertString);
        }
    }

    protected void writeRenderTextProperties(DataOutput dataOutput) throws IOException {
        RenderText renderText = (RenderText)this.render;
        dataOutput.writeInt(this.render.getX());
        dataOutput.writeInt(this.render.getY());
        dataOutput.writeInt(this.render.getWidth());
        dataOutput.writeInt(this.render.getHeight());
        Vector vector = renderText.getVLines();
        int n = vector == null ? 0 : vector.size();
        dataOutput.writeInt(n);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                dataOutput.writeUTF((String)vector.get(i));
            }
            int[][] nArray = renderText.getEveryLinePos();
            for (int i = 0; i < n; ++i) {
                dataOutput.writeInt(nArray[i][0]);
                dataOutput.writeInt(nArray[i][1]);
            }
        }
    }

    private void SEDU(DataInput dataInput) throws IOException {
        this.render = new RenderText(this);
        this.render.setX(dataInput.readInt());
        this.render.setY(dataInput.readInt());
        this.render.setWidth(dataInput.readInt());
        this.render.setHeight(dataInput.readInt());
        int n = dataInput.readInt();
        if (n != 0) {
            Vector<String> vector = new Vector<String>(n);
            for (int i = 0; i < n; ++i) {
                String string = dataInput.readUTF();
                vector.add(string);
            }
            ((RenderText)this.render).setVLines(vector);
            int[][] nArray = new int[n][2];
            for (int i = 0; i < n; ++i) {
                nArray[i][0] = dataInput.readInt();
                nArray[i][1] = dataInput.readInt();
            }
            ((RenderText)this.render).setEveryLinePos(nArray);
        }
    }

    private int UTFLength(Render render) {
        int n = 0;
        if (render != null && render instanceof RenderText) {
            n += 16;
            Vector vector = ((RenderText)render).getVLines();
            int n2 = vector == null ? 0 : vector.size();
            n += 4;
            if (n2 != 0) {
                for (int i = 0; i < n2; ++i) {
                    n += DSField.UTFLength((String)vector.get(i)) + 2;
                }
                n += n2 * 2 * 4;
            }
        }
        return n;
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        if (this.lineBreakPos != null) {
            n += 12 + 8 * this.lineBreakPos.length;
        }
        ++n;
        n += this.UTFLength(this.render);
        if (this.convertString != -1) {
            n += 4;
        }
        return n;
    }

    public boolean isTextobjFieldable() {
        return ((TextobjFieldable)((Object)this.getTemplate())).isTextobjFieldable();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        try {
            this.locale = this.getCommunicator().getLocale();
        }
        catch (NullPointerException nullPointerException) {
            this.locale = null;
        }
        return this.locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    public TimeZone getTimeZone() {
        if (this.timezone != null) {
            return this.timezone;
        }
        try {
            this.timezone = this.getCommunicator().getTimeZone();
        }
        catch (NullPointerException nullPointerException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "2300073", (Throwable)nullPointerException);
            }
            this.timezone = null;
        }
        if (this.timezone == null && JRLog.isError(2)) {
            JRLog.error(2, "2300073");
        }
        return this.timezone;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSField());
    }

    public DSField dup(DSField dSField) {
        super.dup(dSField);
        dSField.stretchHeight = this.stretchHeight;
        dSField.lineNum = this.lineNum;
        dSField.startPos = this.startPos;
        dSField.stringLength = this.stringLength;
        dSField.baseline = this.baseline;
        dSField.underlineWidth = this.underlineWidth;
        dSField.strikeline = this.strikeline;
        dSField.strikelineWidth = this.strikelineWidth;
        dSField.lineBreakPos = this.lineBreakPos;
        dSField.startLine = this.startLine;
        dSField.endLine = this.endLine;
        dSField.locale = this.locale;
        dSField.timezone = this.timezone;
        dSField.drawImage = this.drawImage;
        if (this.render != null && this.render instanceof RenderText) {
            dSField.render = this.dupRenderText((RenderText)this.render);
        }
        dSField.convertString = this.convertString;
        return dSField;
    }

    public Render dupRenderText(RenderText renderText) {
        renderText.setX(this.render.getX());
        renderText.setY(this.render.getY());
        renderText.setWidth(this.render.getWidth());
        renderText.setHeight(this.render.getHeight());
        renderText.setVLines(((RenderText)this.render).getVLines());
        renderText.setEveryLineHeight(((RenderText)this.render).getEveryLineHeight());
        renderText.setEveryLinePos(((RenderText)this.render).getEveryLinePos());
        return renderText;
    }

    @Override
    protected String get(DbChar dbChar) {
        String string = this.getTemplate().getFormat(this);
        DbValueFormat dbValueFormat = null;
        try {
            dbValueFormat = ReportFormat.getOneFormat(dbChar.getSqlType(), string, this.locale);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2300027, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            dbValueFormat = null;
        }
        return dbValueFormat != null ? dbValueFormat.format(dbChar) : dbChar.toString();
    }

    public String toStringPipe() {
        this.isPipe = true;
        return this.toString();
    }

    public int getTextObjParaFmtNO() {
        return this.drawImage;
    }

    public void setTextObjParaFmtNO(int n) {
        this.drawImage = n;
    }

    public HashVector getTextObjParaFmts() {
        Containable containable = this.getParent();
        if (this.drawImage < 0 || containable == null || !(containable instanceof DSTextObj)) {
            return null;
        }
        return ((DSTextObj)containable).getParaFormat(this.drawImage);
    }

    protected Render createRender() {
        Propertiable propertiable = this.getPropertyByName("renderType");
        if (propertiable == null) {
            if (JRLog.isTrace(3)) {
                JRLog.trace(3, 3300025);
            }
            this.renderType = null;
            return RenderCreator.createConcreteRender(0, this);
        }
        this.renderType = (Integer)propertiable.getObject();
        return RenderCreator.createConcreteRender(this.renderType, this);
    }

    @Override
    public Record getSynRecord() {
        if (this.dup != null) {
            return this.dup;
        }
        return super.getSynRecord();
    }

    @Override
    public Record getSynRecord2() {
        if (this.dup != null) {
            return this.dup;
        }
        return super.getSynRecord2();
    }

    public void clearCacheRecord() {
        this.dup = null;
    }

    public Render getRenderWithCascade() {
        this.convertUnitToPixel = true;
        this.render = this.createRender();
        return this.render;
    }

    public Render getRender() {
        if (this.render == null) {
            Render render = this.createRender();
            this.clearCacheRecord();
            return render;
        }
        this.render.setField(this);
        RenderCreator.setCommonRenderProperteis(this.render, this);
        this.clearCacheRecord();
        return this.render;
    }

    public boolean hasRender() {
        return this.render != null;
    }

    public Render getRender(ImageObserver imageObserver) {
        if (this.render == null) {
            this.render = this.createRender();
        }
        this.render.setResolution(this.getResolution());
        this.render.setImageObserver(imageObserver);
        this.convertTextForTextObject = imageObserver;
        return this.render;
    }

    @Override
    public void paint(Graphics graphics) {
        Render render = this.getRender();
        render.setPaintCalledByField(true);
        double d = render.getRotation();
        if (this.B) {
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, this.getBounds());
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            graphics2D.rotate(d, render.getRotationX(), render.getRotationY());
            render.paintFieldBackground(graphics2D);
            render.paint(graphics2D);
            render.paintFieldBorder(graphics2D);
            graphics2D.rotate(-d, render.getRotationX(), render.getRotationY());
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else if (render instanceof RenderBarCode && !this.B) {
            Rectangle rectangle = new Rectangle(0, 0, 1, 1);
            if (this.getWidth() <= 0) {
                rectangle.setBounds(0, 0, 1, 1);
            } else {
                rectangle = this.getBounds();
            }
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, rectangle);
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            render.paintFieldBackground(graphics2D);
            render.paint(graphics2D);
            render.paintFieldBorder(graphics2D);
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else {
            render.paintFieldBackground(graphics);
            render.paint(graphics);
            render.paintFieldBorder(graphics);
        }
        render.setPaintCalledByField(false);
    }

    public int getBeforeRotationHeight() {
        return this.convertGraphicsToGraphics2D;
    }

    public void setBeforeRotationHeight(int n) {
        this.convertGraphicsToGraphics2D = n;
    }

    public int getBeforeRotationWidth() {
        return this.clearCacheRecord;
    }

    public void setBeforeRotationWidth(int n) {
        this.clearCacheRecord = n;
    }

    public void setFormIndex(int n) {
        this.convertString = n;
    }

    public int getFormIndex() {
        return this.convertString;
    }

    public String getPreviousText() {
        if (this.dup != null) {
            return this.getText((JRecord)this.dup);
        }
        return this.getText();
    }

    public void setCacheRecord(Record record) {
        this.dup = record;
    }

    public Record getCacheRecord() {
        return this.dup;
    }

    public void setRender(Render render) {
        this.render = render;
    }

    @Override
    public void setNLSManager(JFieldValueNLSManager jFieldValueNLSManager) {
        this.nlsManager = jFieldValueNLSManager;
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.convertTextForTextObject = imageObserver;
    }

    public ImageObserver getImageObserver() {
        return this.convertTextForTextObject;
    }

    public NLSBundleInfo getNlsBundle() {
        return this.nlsBundle;
    }

    public void setNlsBundle(NLSBundleInfo nLSBundleInfo) {
        this.nlsBundle = nLSBundleInfo;
    }

    public void setRuntimeComvert(boolean bl) {
        this.isRuntimeConvert = bl;
    }

    public void setFromEncoding(int n) {
        this.fromEncoding = n;
    }

    public void setToEncoding(int n) {
        this.toEncoding = n;
    }

    @Override
    public int getResolution() {
        if (this.resolution != -1) {
            return this.resolution;
        }
        return super.getResolution();
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public boolean isParagraphField() {
        return this.convertUnitToPixel;
    }

    public Rectangle getAutoExpandedRec() {
        return this.createConcreteRender;
    }

    public void setAutoExpandedRec(Rectangle rectangle) {
        this.createConcreteRender = rectangle;
    }

    public boolean isValid() {
        return true;
    }

    public JFieldValueNLSManager getFieldNLSManager() {
        if (null != this.nlsManager) {
            return this.nlsManager;
        }
        int n = this.getSubIdxOfRpt();
        Communicator communicator = this.getCommunicator();
        if (communicator != null) {
            this.nlsManager = communicator.getFiledNlsManager(n);
        }
        return this.nlsManager;
    }

    public void setCatlogNLSManager(JFieldValueNLSManager jFieldValueNLSManager) {
        this.catlogNLSManager = jFieldValueNLSManager;
    }

    public String getRuntimeCatlogNLSPreFix() {
        return this.createRender;
    }

    public void setRuntimeCatlogNLSPreFix(String string) {
        this.createRender = string;
    }

    public void resetLineBreakPos() {
        this.lineBreakPos = null;
    }

    @Override
    public int getSubIdxOfRpt() {
        if (this.doNLSMapping != -1) {
            return this.doNLSMapping;
        }
        return super.getSubIdxOfRpt();
    }

    public void setSubIdxOfRpt(int n) {
        this.doNLSMapping = n;
    }

    public boolean isTextChangeByBL() {
        return this.doEncodingConvert;
    }
}

