/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.datastream.DSLeafGroup;

public class DSGroupModel {
    int[] colIndex;
    int[] dbColIndex;
    int groupByColIndex;
    String groupby;
    String groupMask;
    boolean underline;
    int level;
    JDbBufferCursor[] parallelBuffers;
    int branchIdx = -1;
    int[] grouplevelBranchIdxs;
    int[] childBranches;

    public DSGroupModel(int[] nArray, int n) {
        this.colIndex = nArray;
        this.groupByColIndex = n;
    }

    public void setParallelBuffers(JDbBufferCursor[] jDbBufferCursorArray) {
        this.parallelBuffers = jDbBufferCursorArray;
    }

    public int[] getColIndexs() {
        return this.colIndex;
    }

    public int[] getDbColIndexs() {
        return this.dbColIndex;
    }

    public void setDbColIndexs(int[] nArray) {
        this.dbColIndex = nArray;
    }

    public int getGroupByIndex() {
        return this.groupByColIndex;
    }

    public String getGroupBy() {
        return this.groupby;
    }

    public void setGroupBy(String string) {
        this.groupby = string;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public DSLeafGroup makeGroup(JDbBufferCursor jDbBufferCursor) {
        DbColDesc[] dbColDescArray;
        JRecordModel jRecordModel;
        DSLeafGroup dSLeafGroup = new DSLeafGroup(this.colIndex.length);
        if (this.branchIdx != -1 && this.parallelBuffers != null) {
            jRecordModel = this.parallelBuffers[this.branchIdx].getRecordModel();
            dbColDescArray = jRecordModel.getColDescs();
        } else {
            jRecordModel = jDbBufferCursor.getRecordModel();
            dbColDescArray = jRecordModel.getColDescs();
        }
        if (this.groupByColIndex == -1) {
            dSLeafGroup.groupValue = null;
        } else if (this.groupByColIndex < -1) {
            DbColDesc dbColDesc = new DbColDesc(DbValue.CHAR_DESC);
            dSLeafGroup.groupValue = DbValue.makeDbValue(dbColDesc);
            dbColDesc.setColIndex(this.groupByColIndex * -1 - 1);
        } else {
            dSLeafGroup.groupValue = DbValue.makeDbValue(dbColDescArray[this.groupByColIndex]);
        }
        if (this.colIndex.length != 0) {
            for (int i = 0; i < this.colIndex.length; ++i) {
                dSLeafGroup.values[i] = this.grouplevelBranchIdxs != null && this.parallelBuffers != null && this.grouplevelBranchIdxs[i] != -1 ? DbValue.makeDbValue(this.parallelBuffers[this.grouplevelBranchIdxs[i]].getRecordModel().getColDescs()[this.colIndex[i]]) : DbValue.makeDbValue(dbColDescArray[this.colIndex[i]]);
            }
        }
        if (this.dbColIndex != null && this.dbColIndex.length != 0) {
            dSLeafGroup.dbValues = new DbValue[this.dbColIndex.length];
            for (int i = 0; i < this.dbColIndex.length; ++i) {
                dSLeafGroup.dbValues[i] = DbValue.makeDbValue(dbColDescArray[this.dbColIndex[i]]);
            }
        }
        if (this.groupby == null) {
            this.groupby = this.groupByColIndex == -1 ? "Report" : (this.groupByColIndex < -1 ? dbColDescArray[this.groupByColIndex * -1 - 1].getColName() : dbColDescArray[this.groupByColIndex].getColName());
        }
        dSLeafGroup.model = this;
        return dSLeafGroup;
    }

    public void setTOCParams(String string, boolean bl) {
        this.groupMask = string;
        this.underline = bl;
    }

    public String getGroupMask() {
        return this.groupMask;
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public void setBranchIdx(int n) {
        this.branchIdx = n;
    }

    public int getBranchIdx() {
        return this.branchIdx;
    }

    public void setGroupLevelBranchIdx(int[] nArray) {
        this.grouplevelBranchIdxs = nArray;
    }

    public void setChildBranches(int[] nArray) {
        this.childBranches = nArray;
    }

    public boolean isChildBranch(int n) {
        if (n == this.branchIdx) {
            return true;
        }
        if (this.childBranches != null) {
            int n2 = this.childBranches.length;
            for (int i = 0; i < n2; ++i) {
                if (this.childBranches[i] != n) continue;
                return true;
            }
        }
        return false;
    }
}

