/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import jet.connect.DbChar;
import jet.connect.DbValue;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSGroupModel;
import jet.util.Containable;

public class DSLeafGroup
implements Containable {
    DSGroupModel model;
    DSLeafGroup parent;
    DbValue[] values;
    DbValue[] dbValues;
    public DbValue groupValue;
    Vector subs;
    private int SEDU = 0;
    private Hashtable add;
    private String addElement;
    int branchIdx = -1;
    Vector siblingIdxs;
    Vector siblings;

    public DSLeafGroup(int n) {
        if (n != 0) {
            this.values = new DbValue[n];
        }
    }

    public DSLeafGroup(int n, DSGroupModel dSGroupModel, DbValue dbValue) {
        if (n != 0) {
            this.values = new DbValue[n];
        }
        this.model = dSGroupModel;
        this.groupValue = dbValue;
    }

    public void setRecordCount(int n) {
        this.SEDU = n;
    }

    public void setBranchToRecordSize(Hashtable hashtable) {
        this.add = hashtable;
    }

    void peekValues(JRecord jRecord) {
        DbValue dbValue;
        int n;
        if (this.values != null) {
            for (n = 0; n < this.values.length; ++n) {
                if (jRecord.getRecordModel().indexOfCell(this.values[n].getColDesc().colName) == -1) continue;
                dbValue = jRecord.getCell(this.values[n].getColDesc());
                dbValue.set(this.values[n]);
            }
        }
        if (this.dbValues != null) {
            for (n = 0; n < this.dbValues.length; ++n) {
                dbValue = jRecord.getCell(this.dbValues[n].getColDesc());
                dbValue.set(this.dbValues[n]);
            }
        }
    }

    public void add(DSLeafGroup dSLeafGroup) {
        if (this.subs == null) {
            this.subs = new Vector();
        }
        if (!this.subs.contains(dSLeafGroup)) {
            this.subs.addElement(dSLeafGroup);
            dSLeafGroup.setParent(this);
        }
    }

    @Override
    public Vector getChildren() {
        return this.subs;
    }

    public DSLeafGroup getParent() {
        return this.parent;
    }

    public void setParent(DSLeafGroup dSLeafGroup) {
        this.parent = dSLeafGroup;
    }

    public DbValue[] getValues() {
        return this.values;
    }

    public DbValue[] getDbValues() {
        return this.dbValues;
    }

    public DbValue getGroupValue() {
        return this.groupValue;
    }

    public String getEncodedGroupName(String string) {
        if (this.groupValue == null) {
            return "Report";
        }
        if (this.groupValue instanceof DbChar && string != null) {
            try {
                return new String(((DbChar)this.groupValue).getRaw(), string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return this.groupValue.toString();
            }
        }
        return this.groupValue.toString();
    }

    public String getGroupName() {
        if (this.groupValue == null) {
            return "Report";
        }
        return this.groupValue.toString();
    }

    public String getGroupBy() {
        return this.model.groupby;
    }

    public int sizeOfRecords() {
        return this.SEDU;
    }

    public int sizeOfRecords(int n) {
        if (n == -1 || this.add == null) {
            return this.SEDU;
        }
        return (Integer)this.add.get(n);
    }

    public DSGroupModel getGroupModel() {
        return this.model;
    }

    public void setBranchIdx(int n) {
        this.branchIdx = n;
    }

    public int getBranchIdx() {
        return this.branchIdx;
    }

    public void addSibling(int n, DSLeafGroup dSLeafGroup) {
        if (this.siblingIdxs == null) {
            this.siblingIdxs = new Vector();
            this.siblings = new Vector();
        }
        this.siblingIdxs.add(n);
        this.siblings.add(dSLeafGroup);
    }

    public DSLeafGroup get(int n) {
        int n2;
        if (n == -1 || n == this.branchIdx || this.siblingIdxs == null) {
            return this;
        }
        int n3 = n2 = this.siblingIdxs == null ? -1 : this.siblingIdxs.indexOf(n);
        if (n2 != -1) {
            return (DSLeafGroup)this.siblings.elementAt(n2);
        }
        int n4 = this.siblings.size();
        for (int i = 0; i < n4; ++i) {
            DSLeafGroup dSLeafGroup = (DSLeafGroup)this.siblings.elementAt(i);
            if (!dSLeafGroup.model.isChildBranch(n)) continue;
            return dSLeafGroup;
        }
        return this;
    }

    public void setDSGroupName(String string) {
        this.addElement = string;
    }

    public String getDSGroupName() {
        if (this.addElement == null) {
            return this.getGroupName();
        }
        return this.addElement;
    }
}

