/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.datatypes.DataTypeUtils;
import com.jinfonet.util.JRLog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import jet.JRStopEngineException;
import jet.connect.DbArray;
import jet.connect.DbBinary;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine8.util.dataswap.ArrayTool;
import jet.datastream.DSDBField;
import jet.datastream.DSDataStreamable;
import jet.datastream.util.DSTool;
import jet.ie.ArrayBaseDbArray;
import jet.util.DbValueFormat;
import jet.util.JRInterruptedException;
import jet.util.ReportFormat;
import jet.util.UpdLFString;
import jet.util.VersionControlable;

public class DSOtherField
extends DSDBField {
    public DSOtherField() {
    }

    public DSOtherField(DbValue dbValue) {
        this.value = (DbValue)dbValue.clone();
    }

    @Override
    public DbValue getValue() {
        return this.value;
    }

    @Override
    public void setValue(DbValue dbValue) {
        this.value = dbValue == null ? dbValue : (DbValue)dbValue.clone();
    }

    @Override
    public String getText(JRecord jRecord) {
        String string;
        DbValue dbValue = this.getValue();
        if (dbValue != null && !dbValue.isNull()) {
            String string2 = this.getTemplate().getFormat(this, jRecord);
            if (string2 == null || string2.equals("")) {
                string2 = DataTypeUtils.getDefaultFormat(dbValue.getSqlType());
            }
            if (string2 == null || string2.equals("") || string2.equalsIgnoreCase("null")) {
                string = dbValue.toString();
            } else {
                DbValueFormat dbValueFormat = null;
                try {
                    dbValueFormat = ReportFormat.getOneFormat(dbValue.getSqlType(), string2, this.getLocale(), this.getTimeZone());
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2300027, (Throwable)jRInterruptedException);
                    }
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    dbValueFormat = null;
                }
                if (DSTool.isNumericSqlData(dbValue.getSqlType()) && dbValueFormat instanceof DecimalFormat) {
                    ((DecimalFormat)((Object)dbValueFormat)).setRoundingMode(DSTool.getRoundingMode(this));
                }
                if (dbValue instanceof DbArray) {
                    String string3 = UpdLFString.getUpdString((String)this.getPropertyByName("ValueDelimiter").getObject());
                    string = dbValueFormat != null ? dbValueFormat.format(dbValue, string3) : dbValue.toString();
                } else {
                    string = dbValueFormat != null ? dbValueFormat.format(dbValue) : dbValue.toString();
                }
            }
        } else {
            block17: {
                string = null;
                try {
                    string = this.getTemplate().getDisplayNull(this, jRecord) == null ? "NULL" : this.getTemplate().getDisplayNull(this, jRecord);
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2300027, (Throwable)jRInterruptedException);
                    }
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block17;
                    JRLog.error(2, 3300024, (Throwable)exception);
                }
            }
            if (string == null) {
                string = "NULL";
            }
        }
        this.doNLSMapping(string);
        this.doEncodingConvert(string);
        return string;
    }

    @Override
    public String getText() {
        DbValue dbValue = this.getValue();
        String string = this.formatValueToString(dbValue);
        string = this.doNLSMapping(string);
        if ((string = this.doEncodingConvert(string)) == null) {
            string = "";
        }
        return string;
    }

    @Override
    protected void readPorpertiesForV8ParameterField(DataInput dataInput, DSDataStreamable dSDataStreamable) throws JRStopEngineException, IOException {
        super.readPorpertiesForV8ParameterField(dataInput, dSDataStreamable);
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.value = DSOtherField.readDbValue(dataInput);
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        DSOtherField.writeDbValue(dataOutput, this.value);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        return n += DSOtherField.valueLength(this.value);
    }

    static int valueLength(DbValue dbValue) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        if (dbValue == null) {
            bl = true;
        } else {
            bl = dbValue.isNull();
            bl2 = dbValue.desc.isArray();
            string = dbValue.desc.colName;
            bl3 = string != null;
        }
        ++n;
        n += 4;
        ++n;
        if (bl3) {
            n += 2 + DSOtherField.UTFLength(string);
        }
        if (!bl) {
            ++n;
            if (bl2) {
                byte[] byArray;
                block10: {
                    ArrayBaseDbArray arrayBaseDbArray = new ArrayBaseDbArray((DbArray)dbValue);
                    byArray = new byte[]{};
                    try {
                        byArray = ArrayTool.array2Bytes(arrayBaseDbArray);
                    }
                    catch (DSException dSException) {
                        if (!JRLog.isError(2)) break block10;
                        JRLog.error(2, 2300046, (Throwable)dSException);
                    }
                }
                n += 4;
                n += byArray.length * 1;
            } else {
                String string2 = dbValue.toString();
                if (string2 == null) {
                    string2 = "";
                }
                n += 2 + DSOtherField.UTFLength(string2);
                if (dbValue instanceof DbBinary) {
                    byte[] byArray = ((DbBinary)dbValue).get();
                    n += 4;
                    n += byArray.length * 1;
                }
            }
        }
        return n;
    }

    static DbValue readDbValue(DataInput dataInput) throws IOException {
        String string;
        boolean bl;
        DbValue dbValue = null;
        boolean bl2 = dataInput.readBoolean();
        int n = ((VersionControlable)((Object)dataInput)).getVersion();
        DbColDesc dbColDesc = null;
        if (n >= 131084 || n == 0 || !bl2) {
            int n2 = dataInput.readInt();
            if (n >= 262656 || n == 0) {
                bl = dataInput.readBoolean();
                if (bl) {
                    string = dataInput.readUTF();
                    dbColDesc = new DbColDesc(string, n2, 0, 0, 2);
                } else {
                    dbColDesc = new DbColDesc(null, n2, 0, 0, 2);
                }
            } else if (!(bl2 || n < 262145 && n != 0)) {
                bl = dataInput.readBoolean();
                if (bl) {
                    string = dataInput.readUTF();
                    dbColDesc = new DbColDesc(string, n2, 0, 0, 2);
                } else {
                    dbColDesc = new DbColDesc(null, n2, 0, 0, 2);
                }
            } else {
                dbColDesc = new DbColDesc(null, n2, 0, 0, 2);
            }
            dbValue = DbValue.makeDbValue(dbColDesc);
        }
        if (!bl2) {
            String string2 = null;
            bl = false;
            if (n >= 263424 || n == 0) {
                bl = dataInput.readBoolean();
            }
            if (bl) {
                int n3 = dataInput.readInt();
                byte[] byArray = new byte[n3];
                dataInput.readFully(byArray, 0, n3);
                Array array = ArrayTool.bytes2Array(byArray);
                if (dbColDesc != null) {
                    dbColDesc.setArray(true);
                    dbValue = DbValue.makeDbValue(dbColDesc);
                    try {
                        ((DbArray)dbValue).set(array);
                    }
                    catch (DSException dSException) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2300047, (Throwable)dSException);
                        }
                    }
                }
            } else {
                if (n >= 262400 || n == 0) {
                    string2 = dataInput.readUTF();
                } else if (n >= 131094) {
                    string = dataInput.readUTF();
                    if (string != null && !string.equals("") && !string.startsWith("X")) {
                        dbColDesc.setEncodingName(string);
                    }
                    int n4 = dataInput.readInt();
                    byte[] byArray = new byte[n4];
                    dataInput.readFully(byArray, 0, n4);
                    String string3 = dbColDesc.getEncodingName();
                    if (string3 == null || string3.equals("")) {
                        string2 = new String(byArray);
                    } else {
                        try {
                            string2 = new String(byArray, string3);
                        }
                        catch (JRInterruptedException jRInterruptedException) {
                            if (JRLog.isError(2)) {
                                JRLog.error(2, 2300027, (Throwable)jRInterruptedException);
                            }
                            throw jRInterruptedException;
                        }
                        catch (Exception exception) {
                            string2 = "";
                        }
                    }
                }
                if (dbColDesc.getSqlType() == 3 && string2.charAt(0) == '$') {
                    string2 = string2.substring(1);
                }
                if (dbValue != null) {
                    if (n >= 263936 || n == 0) {
                        if (dbValue instanceof DbBinary) {
                            int n5 = dataInput.readInt();
                            byte[] byArray = new byte[n5];
                            dataInput.readFully(byArray);
                            ((DbBinary)dbValue).set(byArray);
                        } else {
                            dbValue.setValue(string2);
                        }
                    } else {
                        dbValue.setValue(string2);
                    }
                }
            }
        } else if (dbValue != null) {
            dbValue.setNull();
        }
        return dbValue;
    }

    static void writeDbValue(DataOutput dataOutput, DbValue dbValue) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        int n = -7;
        if (dbValue == null) {
            bl = true;
        } else {
            bl = dbValue.isNull();
            bl2 = dbValue.desc.isArray();
            n = dbValue.getSqlType();
            string = dbValue.desc.colName;
            bl3 = string != null;
        }
        dataOutput.writeBoolean(bl);
        dataOutput.writeInt(n);
        dataOutput.writeBoolean(bl3);
        if (bl3) {
            dataOutput.writeUTF(string);
        }
        if (!bl) {
            dataOutput.writeBoolean(bl2);
            if (bl2) {
                byte[] byArray;
                block10: {
                    ArrayBaseDbArray arrayBaseDbArray = new ArrayBaseDbArray((DbArray)dbValue);
                    byArray = new byte[]{};
                    try {
                        byArray = ArrayTool.array2Bytes(arrayBaseDbArray);
                    }
                    catch (DSException dSException) {
                        if (!JRLog.isError(2)) break block10;
                        JRLog.error(2, 2300048, (Throwable)dSException);
                    }
                }
                int n2 = byArray.length;
                dataOutput.writeInt(n2);
                dataOutput.write(byArray);
            } else {
                String string2 = dbValue.toString();
                if (string2 == null) {
                    string2 = "";
                }
                dataOutput.writeUTF(string2);
                if (dbValue instanceof DbBinary) {
                    byte[] byArray = ((DbBinary)dbValue).get();
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                }
            }
        }
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSOtherField());
    }

    public DSOtherField dup(DSOtherField dSOtherField) {
        super.dup(dSOtherField);
        dSOtherField.value = this.value;
        return dSOtherField;
    }
}

