/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import guitools.Painter;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.JResource;
import jet.connect.DbValue;
import jet.datastream.Communicator;
import jet.datastream.DSArea;
import jet.datastream.DSAreaDBField;
import jet.datastream.DSAreaLabel;
import jet.datastream.DSBarcode;
import jet.datastream.DSBody;
import jet.datastream.DSCTField;
import jet.datastream.DSChartCoordinatePaperChild;
import jet.datastream.DSChartCoordinatepaper;
import jet.datastream.DSChartHeatMapGroupRect;
import jet.datastream.DSChartORGNode;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSChartPlatformChild;
import jet.datastream.DSColumn;
import jet.datastream.DSContainable;
import jet.datastream.DSContainer;
import jet.datastream.DSControlSymbol;
import jet.datastream.DSCrossTab;
import jet.datastream.DSDBField;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSField;
import jet.datastream.DSFilterControl;
import jet.datastream.DSForm;
import jet.datastream.DSGMap;
import jet.datastream.DSGeoMap;
import jet.datastream.DSGroup;
import jet.datastream.DSGroupControlImg;
import jet.datastream.DSInputControlObject;
import jet.datastream.DSLabel;
import jet.datastream.DSMap;
import jet.datastream.DSMapTextField;
import jet.datastream.DSMarker;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSNavigateButton;
import jet.datastream.DSNavigateControl;
import jet.datastream.DSOLEObj;
import jet.datastream.DSOtherField;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterField;
import jet.datastream.DSParameterForm;
import jet.datastream.DSPicture;
import jet.datastream.DSPolyLine;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSelectControlObject;
import jet.datastream.DSShape;
import jet.datastream.DSSlider;
import jet.datastream.DSSubBody;
import jet.datastream.DSSubReport;
import jet.datastream.DSSystemField;
import jet.datastream.DSTable;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableField;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.DSTabular;
import jet.datastream.DSTabularCell;
import jet.datastream.DSTemplatible;
import jet.datastream.DSTextBox;
import jet.datastream.DSTextObj;
import jet.datastream.DataStream;
import jet.datastream.ImgInfo;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.ie.PageDecl;
import jet.util.FontSets;
import jet.util.JRInterruptedException;
import jet.util.VersionControlable;

public class DSPage
implements DSContainable,
Printable {
    private static final int B = 72;
    int pageNum = -1;
    int res = Unit.getResolution();
    DataStream dataStream;
    Vector objects = new Vector();
    Locale locale;
    TimeZone timezone;
    boolean dirty;
    boolean ignore;
    boolean lastPg = false;
    Hashtable pageHLevelValues;
    Hashtable pageFLevelValues;
    private Rectangle SEDU = new Rectangle(0, 0, 0, 0);
    private Rectangle UTFLength = new Rectangle(0, 0, 0, 0);
    private transient int addElement = 0;
    private transient int append = 0;
    private ImgInfo background = null;
    Rectangle area;

    public DSPage(DataStream dataStream) {
        this.dataStream = dataStream;
    }

    public DSPage(DataStream dataStream, int n) {
        this.dataStream = dataStream;
        this.pageNum = n;
    }

    public DSDataStreamable getDataStream() {
        return this.dataStream;
    }

    @Override
    public void add(JRObjectResult jRObjectResult) {
        this.objects.addElement(jRObjectResult);
        jRObjectResult.setParent(this);
    }

    public void addHLevelValue(String string, DbValue dbValue) {
        if (this.pageHLevelValues == null) {
            this.pageHLevelValues = new Hashtable();
        }
        if (this.pageHLevelValues.get(string) == null) {
            this.pageHLevelValues.put(string, dbValue);
        }
    }

    public void addFLevelValue(String string, DbValue dbValue) {
        if (this.pageFLevelValues == null) {
            this.pageFLevelValues = new Hashtable();
        }
        this.pageFLevelValues.put(string, dbValue);
    }

    public Object getHLevelValue(String string) {
        if (this.pageHLevelValues == null) {
            return null;
        }
        return this.pageHLevelValues.get(string);
    }

    public Object getFLevelValue(String string) {
        if (this.pageFLevelValues == null) {
            return null;
        }
        return this.pageFLevelValues.get(string);
    }

    @Override
    public void remove(JRObjectResult jRObjectResult) {
        int n = this.objects.indexOf(jRObjectResult);
        if (n >= 0) {
            this.objects.removeElementAt(n);
            jRObjectResult.setParent(this);
        }
    }

    @Override
    public void removeAll() {
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            JRObjectResult jRObjectResult = (JRObjectResult)this.objects.elementAt(i);
            this.objects.removeElementAt(i);
            jRObjectResult.setParent(null);
        }
    }

    public void setPageNumber(int n) {
        this.pageNum = n;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int size() {
        return this.objects.size();
    }

    public JRObjectResult getObject(int n) {
        return (JRObjectResult)this.objects.elementAt(n);
    }

    @Override
    public Vector getChildren() {
        return this.objects;
    }

    public void read(DataInput dataInput) throws IOException, JRStopEngineException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (dataInput instanceof VersionControlable) {
            n5 = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n5 >= 262145 || n5 == 0) {
                n4 = dataInput.readInt();
                n3 = dataInput.readInt();
                n2 = dataInput.readInt();
                n = dataInput.readInt();
                this.SEDU = new Rectangle(n4, n3, n2, n);
                n4 = dataInput.readInt();
                n3 = dataInput.readInt();
                n2 = dataInput.readInt();
                n = dataInput.readInt();
                this.UTFLength = new Rectangle(n4, n3, n2, n);
            }
            if (n5 >= 131082 || n5 == 0) {
                n2 = dataInput.readShort();
                if (n2 > 0) {
                    if (this.pageHLevelValues == null) {
                        this.pageHLevelValues = new Hashtable();
                    }
                    for (n = 0; n < n2; n = (int)((short)(n + 1))) {
                        String string = dataInput.readUTF();
                        DbValue dbValue = DSOtherField.readDbValue(dataInput);
                        this.pageHLevelValues.put(string, dbValue);
                    }
                }
                if ((n2 = (int)dataInput.readShort()) > 0) {
                    if (this.pageFLevelValues == null) {
                        this.pageFLevelValues = new Hashtable();
                    }
                    for (n = 0; n < n2; n = (int)((short)(n + 1))) {
                        String string = dataInput.readUTF();
                        DbValue dbValue = DSOtherField.readDbValue(dataInput);
                        this.pageFLevelValues.put(string, dbValue);
                    }
                }
            }
        }
        n5 = dataInput instanceof VersionControlable ? ((n4 = ((VersionControlable)((Object)dataInput)).getVersion()) >= 131100 || n4 == 0 ? dataInput.readInt() : (int)dataInput.readShort()) : (int)dataInput.readShort();
        n3 = ((VersionControlable)((Object)dataInput)).getVersion();
        for (n2 = 0; n2 < n5; ++n2) {
            JRObjectResult jRObjectResult;
            n = n3 >= 131097 || n3 == 0 ? dataInput.readInt() : (int)dataInput.readShort();
            if ((n & 0x1000) == 0) {
                jRObjectResult = DSPage.createJRObjectResult(n, this.locale, this.timezone);
                jRObjectResult.read(dataInput, this.dataStream);
            } else {
                jRObjectResult = DSPage.readUDO(dataInput, this.dataStream);
            }
            jRObjectResult.setParent(this);
            this.objects.addElement(jRObjectResult);
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        DbValue dbValue;
        String string;
        Enumeration enumeration;
        dataOutput.writeInt(this.SEDU.x);
        dataOutput.writeInt(this.SEDU.y);
        dataOutput.writeInt(this.SEDU.width);
        dataOutput.writeInt(this.SEDU.height);
        dataOutput.writeInt(this.UTFLength.x);
        dataOutput.writeInt(this.UTFLength.y);
        dataOutput.writeInt(this.UTFLength.width);
        dataOutput.writeInt(this.UTFLength.height);
        dataOutput.writeShort((short)(this.pageHLevelValues == null ? 0 : (short)this.pageHLevelValues.size()));
        if (this.pageHLevelValues != null) {
            enumeration = this.pageHLevelValues.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                dbValue = (DbValue)this.pageHLevelValues.get(string);
                dataOutput.writeUTF(string);
                DSOtherField.writeDbValue(dataOutput, dbValue);
            }
        }
        dataOutput.writeShort((short)(this.pageFLevelValues == null ? 0 : (short)this.pageFLevelValues.size()));
        if (this.pageFLevelValues != null) {
            enumeration = this.pageFLevelValues.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                dbValue = (DbValue)this.pageFLevelValues.get(string);
                dataOutput.writeUTF(string);
                DSOtherField.writeDbValue(dataOutput, dbValue);
            }
        }
        int n = this.objects.size();
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            ((JRObjectResult)this.objects.elementAt(i)).write(dataOutput);
        }
    }

    public int length() {
        DbValue dbValue;
        String string;
        Enumeration<Object> enumeration;
        int n = 4;
        n += 32;
        if (this.pageHLevelValues != null) {
            enumeration = this.pageHLevelValues.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                dbValue = (DbValue)this.pageHLevelValues.get(string);
                n += 2 + JRObjectResult.UTFLength(string) + DSOtherField.valueLength(dbValue);
            }
        }
        if (this.pageFLevelValues != null) {
            enumeration = this.pageFLevelValues.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                dbValue = (DbValue)this.pageFLevelValues.get(string);
                n += 2 + JRObjectResult.UTFLength(string) + DSOtherField.valueLength(dbValue);
            }
        }
        n += 4;
        enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            n += ((JRObjectResult)enumeration.nextElement()).length();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JRObjectResult createJRObjectResult(int n, Locale locale, TimeZone timeZone) {
        void var3_64;
        Object var3_3 = null;
        if ((n & 0x2000) == 8192) {
            DSReference dSReference = new DSReference();
        } else if (n == 0x100001) {
            DSForm dSForm = new DSForm();
        } else if (n == 0x100002) {
            DSOLEObj dSOLEObj = new DSOLEObj();
        } else if ((n & 0x200) == 512) {
            DSSection dSSection = new DSSection();
        } else if (n == 44) {
            DSGroup dSGroup = new DSGroup();
        } else if ((n & 0x20) == 32) {
            if (n == 33 || n == 37 || n == 45) {
                DSSubReport dSSubReport = new DSSubReport();
                ((DSContainer)dSSubReport).setLocale(locale);
                ((DSContainer)dSSubReport).setTimeZone(timeZone);
            } else if (n == 34) {
                DSCrossTab dSCrossTab = new DSCrossTab();
                ((DSContainer)dSCrossTab).setLocale(locale);
                ((DSContainer)dSCrossTab).setTimeZone(timeZone);
            } else if (n == 36) {
                DSTextObj dSTextObj = new DSTextObj();
                ((DSContainer)dSTextObj).setLocale(locale);
                ((DSContainer)dSTextObj).setTimeZone(timeZone);
            } else if (n == 40) {
                DSMap dSMap = new DSMap();
                ((DSContainer)dSMap).setLocale(locale);
                ((DSContainer)dSMap).setTimeZone(timeZone);
            } else if (n == 41) {
                DSArea dSArea = new DSArea();
                ((DSContainer)dSArea).setLocale(locale);
                ((DSContainer)dSArea).setTimeZone(timeZone);
            } else if (n == 393513) {
                DSAreaLabel dSAreaLabel = new DSAreaLabel();
                dSAreaLabel.setLocale(locale);
                dSAreaLabel.setTimeZone(timeZone);
            } else if (n == 393514) {
                DSAreaDBField dSAreaDBField = new DSAreaDBField();
                dSAreaDBField.setLocale(locale);
                dSAreaDBField.setTimeZone(timeZone);
            } else if (n == 262177) {
                DSBody dSBody = new DSBody();
            } else if (n == 262182) {
                DSSubBody dSSubBody = new DSSubBody();
            } else if (n == 262178) {
                DSParagraph dSParagraph = new DSParagraph();
            } else if (n == 46) {
                DSTabular dSTabular = new DSTabular();
            } else if (n == 47) {
                DSTabularCell dSTabularCell = new DSTabularCell();
            } else if (n == 262179) {
                DSTableObject dSTableObject = new DSTableObject();
            } else if (n == 262180) {
                DSTableCell dSTableCell = new DSTableCell();
            } else if (n == 0x2000021) {
                DSGMap dSGMap = new DSGMap();
            } else if (n == 0x2000022) {
                DSMarker dSMarker = new DSMarker();
            } else if (n == 67108897) {
                DSGeoMap dSGeoMap = new DSGeoMap();
            } else if (n == 262181) {
                DSTextBox dSTextBox = new DSTextBox();
            } else if (n == 262183) {
                DSMultiValueContainer dSMultiValueContainer = new DSMultiValueContainer();
            } else if (n == 262184) {
                DSParameterForm dSParameterForm = new DSParameterForm();
            } else {
                if (n != 262185) throw new RuntimeException("unKnow object:" + n);
                DSNavigateControl dSNavigateControl = new DSNavigateControl();
            }
        } else if ((n & 0x100) == 256) {
            void var3_40;
            switch (n) {
                case 257: {
                    DSField dSField = new DSField();
                    break;
                }
                case 258: {
                    DSDBField dSDBField = new DSDBField();
                    break;
                }
                case 260: {
                    DSSystemField dSSystemField = new DSSystemField();
                    break;
                }
                case 263: {
                    DSCTField dSCTField = new DSCTField();
                    break;
                }
                case 261: {
                    DSParameterField dSParameterField = new DSParameterField();
                    break;
                }
                case 393473: {
                    DSMapTextField dSMapTextField = new DSMapTextField();
                    break;
                }
                case 266: {
                    DSOtherField dSOtherField = new DSOtherField();
                    break;
                }
                case 264: {
                    DSBarcode dSBarcode = new DSBarcode();
                    break;
                }
                case 265: {
                    DSLabel dSLabel = new DSLabel();
                    break;
                }
                case 267: {
                    DSTableField dSTableField = new DSTableField();
                    break;
                }
                default: {
                    throw new RuntimeException("Error Object Type:" + n);
                }
            }
            ((DSField)var3_40).setLocale(locale);
            ((DSField)var3_40).setTimeZone(timeZone);
        } else if ((n & 0x40) == 64) {
            if (n == 71) {
                DSChartPlatform dSChartPlatform = new DSChartPlatform();
            } else if (n == 72) {
                DSChartCoordinatepaper dSChartCoordinatepaper = new DSChartCoordinatepaper();
            } else if (n == 76) {
                DSChartCoordinatePaperChild dSChartCoordinatePaperChild = new DSChartCoordinatePaperChild();
            } else if (n == 77) {
                DSChartORGNode dSChartORGNode = new DSChartORGNode();
            } else if (n == 78) {
                DSChartCoordinatePaperChild dSChartCoordinatePaperChild = new DSChartCoordinatePaperChild();
            } else if (n == 79) {
                DSChartHeatMapGroupRect dSChartHeatMapGroupRect = new DSChartHeatMapGroupRect();
            } else {
                DSChartPlatformChild dSChartPlatformChild = new DSChartPlatformChild();
            }
        } else if (n == 128 || n == 129) {
            DSPicture dSPicture = new DSPicture();
        } else if (n == 393238) {
            DSPolyLine dSPolyLine = new DSPolyLine();
        } else if ((n & 0x10) == 16) {
            DSShape dSShape = new DSShape();
        } else if ((n & 0x4001) == 16385) {
            DSTable dSTable = new DSTable();
        } else if ((n & 0x4002) == 16386) {
            DSColumn dSColumn = new DSColumn();
        } else if ((n & 0x10000) == 65536) {
            switch (n) {
                case 65537: {
                    DSInputControlObject dSInputControlObject = new DSInputControlObject();
                    break;
                }
                case 65538: {
                    DSSelectControlObject dSSelectControlObject = new DSSelectControlObject();
                    break;
                }
                case 65539: {
                    DSGroupControlImg dSGroupControlImg = new DSGroupControlImg();
                    break;
                }
                case 65541: {
                    DSNavigateButton dSNavigateButton = new DSNavigateButton();
                    break;
                }
                case 65540: {
                    DSFilterControl dSFilterControl = new DSFilterControl();
                    break;
                }
                case 65542: {
                    DSSlider dSSlider = new DSSlider();
                    break;
                }
                default: {
                    JRObjectResult jRObjectResult = new JRObjectResult();
                    break;
                }
            }
        } else if (n == 524291) {
            DSParagraphText dSParagraphText = new DSParagraphText();
        } else if (n == 524294) {
            DSControlSymbol dSControlSymbol = new DSControlSymbol();
        } else if ((n & 0x1000000) == 0x1000000) {
            DSTableRow dSTableRow = new DSTableRow();
        } else if (n != 524294) {
            JRObjectResult jRObjectResult = new JRObjectResult();
        }
        if (!(var3_64 instanceof DSContainer)) return var3_64;
        DSContainer dSContainer = (DSContainer)var3_64;
        dSContainer.setLocale(locale);
        dSContainer.setTimeZone(timeZone);
        return var3_64;
    }

    public static final JRObjectResult readUDO(DataInput dataInput, DSDataStreamable dSDataStreamable) {
        JRObjectResult jRObjectResult = null;
        try {
            int n;
            short s = dataInput.readShort();
            DSTemplatible dSTemplatible = dSDataStreamable.getTemplate(s);
            byte by = dataInput.readByte();
            jRObjectResult = (JRObjectResult)Class.forName((String)dSTemplatible.getPropertyByName("UDOResultName").getObject()).newInstance();
            jRObjectResult.setTemplateIndex(s);
            jRObjectResult.setTemplate(dSTemplatible);
            jRObjectResult.flag = by;
            if (dataInput instanceof VersionControlable && ((n = ((VersionControlable)((Object)dataInput)).getVersion()) >= 263184 || n == 0)) {
                boolean bl = dataInput.readBoolean();
                jRObjectResult.setHasLink(bl);
                if (bl) {
                    int n2 = dataInput.readInt();
                    int n3 = dataInput.readInt();
                    int n4 = dataInput.readInt();
                    jRObjectResult.setLink(n2, n3, n4);
                }
            }
            n = dataInput.readInt();
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray);
            jRObjectResult.readProperties(new DataInputStream(new ByteArrayInputStream(byArray)), dSDataStreamable);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2300080, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2300077, (Throwable)exception);
            }
            jRObjectResult = new JRObjectResult();
        }
        return jRObjectResult;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public boolean beDirty() {
        return this.dirty;
    }

    public void setBeDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        boolean bl = false;
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            if (!((JRObjectResult)enumeration.nextElement()).isDirty()) continue;
            return true;
        }
        return bl;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.paint(graphics.create((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getWidth(), (int)pageFormat.getHeight()));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Object object;
        Object object2;
        block33: {
            Rectangle rectangle;
            Vector vector;
            block31: {
                DSSection dSSection = null;
                vector = this.getChildren();
                for (int i = 0; i < vector.size(); ++i) {
                    if (!(vector.elementAt(i) instanceof DSSection)) continue;
                    dSSection = (DSSection)vector.elementAt(i);
                    break;
                }
                if (dSSection != null) {
                    this.res = dSSection.getResolution();
                }
                rectangle = graphics.getClipBounds();
                this.area = (Rectangle)rectangle.clone();
                Communicator communicator = this.dataStream.getCommunicator();
                try {
                    if (communicator.getHeaderInfo((int)0).background != null) {
                        graphics.setColor(communicator.getHeaderInfo((int)0).background);
                        graphics.fillRect(this.area.x, this.area.y, this.area.width - 1, this.area.height - 1);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!JRLog.isError(2)) break block31;
                    JRLog.error(2, 2300086, (Throwable)arrayIndexOutOfBoundsException);
                }
            }
            this.setGeoProperties();
            try {
                Object object3;
                int n;
                Object object4;
                int n2;
                int n3 = vector.size();
                object2 = new Vector();
                Vector<Object> vector2 = new Vector<Object>();
                JRVisiableResult jRVisiableResult = null;
                int n4 = -1;
                int n5 = n3;
                while (--n5 >= 0) {
                    JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(n5);
                    if (jRObjectResult instanceof JRVisiableResult) {
                        object = (JRVisiableResult)jRObjectResult;
                        rectangle = (Rectangle)((JRVisiableResult)object).getBounds().clone();
                        n2 = ((JRObjectResult)object).getTemplate().getInvisible((JRObjectResult)object) ? 1 : 0;
                        if (n2 != 0) continue;
                        object4 = ((JRObjectResult)object).getTemplate().getBackground((JRObjectResult)object);
                        if (object instanceof DSTable) {
                            n4 = rectangle.width;
                            jRVisiableResult = (DSTable)object;
                            if (object4 == null) continue;
                            graphics.setColor((Color)object4);
                            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            continue;
                        }
                        if (!(object instanceof DSContainer)) continue;
                        if (n4 != -1 && object instanceof DSSection) {
                            ((DSSection)object).setLineWidth(n4);
                        }
                        vector2.addElement(object);
                        if (object4 == null) continue;
                        graphics.setColor((Color)object4);
                        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        continue;
                    }
                    if (!(jRObjectResult instanceof DSShape)) continue;
                    ((Vector)object2).addElement(jRObjectResult);
                }
                if (jRVisiableResult != null) {
                    rectangle = jRVisiableResult.getBounds();
                    Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    try {
                        ((DSTable)jRVisiableResult).paint(graphics2);
                    }
                    finally {
                        graphics2.dispose();
                    }
                }
                n5 = ((Vector)object2).size();
                n2 = vector2.size();
                object4 = null;
                for (n = 0; n < n5; ++n) {
                    object4 = (DSShape)((Vector)object2).elementAt(n);
                    object3 = ((JRObjectResult)object4).getTemplate().getBackground((JRObjectResult)object4);
                    if (object3 == null || !((DSShape)object4).getInv()) continue;
                    rectangle = ((DSShape)object4).getBounds();
                    Graphics graphics3 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    try {
                        ((DSShape)object4).paintInterior(graphics3);
                        continue;
                    }
                    finally {
                        graphics3.dispose();
                    }
                }
                for (n = 0; n < n2; ++n) {
                    object = (JRVisiableResult)vector2.elementAt(n);
                    rectangle = ((JRVisiableResult)object).getBounds();
                    object3 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    try {
                        ((JRVisiableResult)object).paint((Graphics)object3);
                        continue;
                    }
                    finally {
                        ((Graphics)object3).dispose();
                    }
                }
                for (n = 0; n < n5; ++n) {
                    object4 = (DSShape)((Vector)object2).elementAt(n);
                    if (!((DSShape)object4).getInv()) continue;
                    rectangle = ((DSShape)object4).getBounds();
                    object3 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    try {
                        ((DSShape)object4).paintShape((Graphics)object3);
                        continue;
                    }
                    finally {
                        ((Graphics)object3).dispose();
                    }
                }
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2300080, (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block33;
                JRLog.error(2, 2300077, (Throwable)exception);
            }
        }
        if (this.dataStream.ie() == 1) {
            int n = Unit.convertInchToPixel(2.0);
            int n6 = Unit.convertInchToPixel(1.0);
            do {
                graphics.setColor(Color.cyan);
                object = FontSets.getFont("*ArialNarrow", 0, 20);
                graphics.setFont((Font)object);
                object2 = "JReport Evaluation Copy";
                Painter.drawText(graphics, (String)object2, n - Toolkit.getDefaultToolkit().getFontMetrics((Font)object).stringWidth((String)object2) / 2, n6);
                object = FontSets.getFont("*ArialNarrow", 0, 12);
                object2 = "To purchase contact " + JResource.getMessage("Sale");
                graphics.setFont((Font)object);
                Painter.drawText(graphics, (String)object2, n - Toolkit.getDefaultToolkit().getFontMetrics((Font)object).stringWidth((String)object2) / 2, n6 + 14);
                object = FontSets.getFont("*ArialNarrow", 0, 12);
                object2 = JResource.getMessage("SalePhone") + " / " + JResource.getMessage("homeURL");
                graphics.setFont((Font)object);
                Painter.drawText(graphics, (String)object2, n - Toolkit.getDefaultToolkit().getFontMetrics((Font)object).stringWidth((String)object2) / 2, 28 + n6);
                n += Unit.convertInchToPixel(3.0);
            } while ((n6 += Unit.convertInchToPixel(2.0)) < graphics.getClipBounds().y + graphics.getClipBounds().height);
        }
    }

    public void setLastPage(boolean bl) {
        this.lastPg = bl;
    }

    protected void setGeoProperties() {
        int n = 0;
        int n2 = this.area.height - 1;
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        int n3 = this.objects.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            Rectangle rectangle;
            DSContainer dSContainer;
            JRObjectResult jRObjectResult;
            Object object;
            JRObjectResult jRObjectResult2;
            int n5;
            JRObjectResult jRObjectResult3;
            block20: {
                jRObjectResult3 = (JRObjectResult)this.objects.elementAt(i);
                n5 = jRObjectResult3.getObjectType();
                if ((n5 & 0x200) == 512) {
                    jRObjectResult2 = (DSSection)jRObjectResult3;
                    if (jRObjectResult2.getTemplate().getInvisible(jRObjectResult2)) continue;
                    object = ((JRVisiableResult)jRObjectResult2).getBounds();
                    if (!jRObjectResult2.getTemplate().getUnderlay(jRObjectResult2) && n5 == 514) {
                        n = Math.max(n, ((Rectangle)object).y + ((Rectangle)object).height);
                    }
                    if (n5 == 517) {
                        n2 = Math.min(n2, ((Rectangle)object).y);
                    }
                    vector.addElement(jRObjectResult2);
                    continue;
                }
                if (n5 != 18 && n5 != 23 && n5 != 22 && n5 != 19 && n5 != 20) continue;
                try {
                    if (jRObjectResult3.getTemplate().getInvisible(jRObjectResult3)) {
                        continue;
                    }
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2300080, (Throwable)jRInterruptedException);
                    }
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block20;
                    JRLog.error(2, 2300077, (Throwable)exception);
                }
            }
            jRObjectResult2 = (DSShape)jRObjectResult3;
            object = jRObjectResult2.getTemplate();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = ((DSShape)jRObjectResult2).getTopAttachIndex();
            int n11 = ((DSShape)jRObjectResult2).getBottomAttachIndex();
            boolean bl = true;
            if (n10 == -1) {
                n6 = n;
            } else {
                jRObjectResult = this.getObject(n10);
                if (jRObjectResult instanceof DSContainer && vector.contains(jRObjectResult)) {
                    dSContainer = (DSContainer)jRObjectResult;
                    rectangle = dSContainer.getBounds();
                    n8 = rectangle.x;
                    n4 = object.getTopAttachPosY(jRObjectResult2) - dSContainer.getStartYPos();
                    n6 = rectangle.y + Math.min(Unit.convertUnitToPixel(n4, this.res), rectangle.height - 1);
                } else {
                    bl = false;
                }
            }
            if (n11 == -1) {
                n7 = n2;
            } else {
                jRObjectResult = this.getObject(n11);
                if (jRObjectResult instanceof DSContainer && vector.contains(jRObjectResult)) {
                    dSContainer = (DSContainer)jRObjectResult;
                    rectangle = dSContainer.getBounds();
                    n9 = rectangle.x;
                    n4 = object.getBottomAttachPosY(jRObjectResult2);
                    int n12 = n4 - dSContainer.getStartYPos();
                    n7 = rectangle.y + Math.min(Unit.convertUnitToPixel(n12, this.res), rectangle.height - 1);
                    if (n4 == 0 && n6 != n7) {
                        --n7;
                    }
                } else {
                    bl = false;
                }
            }
            int n13 = 0;
            int n14 = 0;
            if (bl) {
                n13 = n8 + Unit.convertUnitToPixel(object.getTopAttachPosX(jRObjectResult2), this.res);
                n14 = n9 + Unit.convertUnitToPixel(object.getBottomAttachPosX(jRObjectResult2), this.res);
                if (n5 == 22) {
                    ((DSShape)jRObjectResult2).setCoordinates(n13, n6, n14, n7);
                    continue;
                }
                ((DSShape)jRObjectResult2).setBounds(n13, n6, n14 - n13 + 1, n7 - n6 + 1);
                continue;
            }
            ((DSShape)jRObjectResult2).setInv(false);
        }
    }

    public int getFirstRIdx() {
        int n = -1;
        for (int i = 0; i < this.objects.size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)this.objects.elementAt(i);
            if (!(jRObjectResult instanceof DSSection)) continue;
            n = ((DSSection)jRObjectResult).getRecordIndex() - 1;
            break;
        }
        return n;
    }

    public Rectangle getPageArea() {
        return this.SEDU;
    }

    public Rectangle getPrintableArea() {
        return this.UTFLength;
    }

    public void setPageArea(Rectangle rectangle) {
        this.SEDU = rectangle;
    }

    public void setPrintableArea(Rectangle rectangle) {
        this.UTFLength = rectangle;
    }

    public void setPageDescription(PageDecl pageDecl) {
        this.SEDU.x = 0;
        this.SEDU.y = 0;
        this.SEDU.width = pageDecl.width;
        this.SEDU.height = pageDecl.height;
        this.UTFLength.x = pageDecl.leftmargin;
        this.UTFLength.y = pageDecl.topmargin;
        this.UTFLength.width = pageDecl.width - pageDecl.rightmargin - pageDecl.leftmargin;
        this.UTFLength.height = pageDecl.height - pageDecl.topmargin - pageDecl.bottommargin;
    }

    public DSSubReport searchLastSubReport(short s) {
        Vector vector = this.getChildren();
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            DSSubReport dSSubReport;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
            if (jRObjectResult.getTemplateIndex() == s) {
                return (DSSubReport)jRObjectResult;
            }
            if (!(jRObjectResult instanceof DSContainer) || (dSSubReport = this.B((DSContainer)jRObjectResult, s)) == null) continue;
            return dSSubReport;
        }
        return null;
    }

    private DSSubReport B(DSContainer dSContainer, short s) {
        Vector vector = dSContainer.getChildren();
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            DSSubReport dSSubReport;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
            if (jRObjectResult.getObjectType() == 45 && jRObjectResult.getTemplateIndex() == s) {
                return (DSSubReport)jRObjectResult;
            }
            if (!(jRObjectResult instanceof DSContainer) || (dSSubReport = this.B((DSContainer)jRObjectResult, s)) == null) continue;
            return dSSubReport;
        }
        return null;
    }

    public DSSubReport searchLastSubReport(short s, int n) {
        Vector vector = this.getChildren();
        int n2 = vector.size();
        for (int i = n2 - 1; i >= 0; --i) {
            DSSubReport dSSubReport;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
            if (jRObjectResult instanceof DSSubReport && jRObjectResult.getTemplateIndex() == s && ((DSSubReport)jRObjectResult).getSubIdx() == n) {
                return (DSSubReport)jRObjectResult;
            }
            if (!(jRObjectResult instanceof DSContainer) || (dSSubReport = this.SEDU((DSContainer)jRObjectResult, s, n)) == null) continue;
            return dSSubReport;
        }
        return null;
    }

    private DSSubReport SEDU(DSContainer dSContainer, short s, int n) {
        Vector vector = dSContainer.getChildren();
        int n2 = vector.size();
        for (int i = n2 - 1; i >= 0; --i) {
            DSSubReport dSSubReport;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
            if (jRObjectResult instanceof DSSubReport && jRObjectResult.getTemplateIndex() == s && ((DSSubReport)jRObjectResult).getSubIdx() == n) {
                return (DSSubReport)jRObjectResult;
            }
            if (!(jRObjectResult instanceof DSContainer) || (dSSubReport = this.SEDU((DSContainer)jRObjectResult, s, n)) == null) continue;
            return dSSubReport;
        }
        return null;
    }

    public DSSubReport searchFirstSubReport(short s, int n) {
        Vector vector = this.getChildren();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            DSSubReport dSSubReport;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
            if (jRObjectResult.getTemplateIndex() == s && ((DSSubReport)jRObjectResult).getSubIdx() == n) {
                return (DSSubReport)jRObjectResult;
            }
            if (!(jRObjectResult instanceof DSContainer) || (dSSubReport = this.UTFLength((DSContainer)jRObjectResult, s, n)) == null) continue;
            return dSSubReport;
        }
        return null;
    }

    public DSSubReport searchFirstSubReport(short s) {
        Vector vector = this.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DSSubReport dSSubReport;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
            if (jRObjectResult.getTemplateIndex() == s) {
                return (DSSubReport)jRObjectResult;
            }
            if (!(jRObjectResult instanceof DSContainer) || (dSSubReport = this.addElement((DSContainer)jRObjectResult, s)) == null) continue;
            return dSSubReport;
        }
        return null;
    }

    private DSSubReport UTFLength(DSContainer dSContainer, short s, int n) {
        Vector vector = dSContainer.getChildren();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            DSSubReport dSSubReport;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
            if (jRObjectResult.getObjectType() == 45 && jRObjectResult.getTemplateIndex() == s && ((DSSubReport)jRObjectResult).getSubIdx() == n) {
                return (DSSubReport)jRObjectResult;
            }
            if (!(jRObjectResult instanceof DSContainer) || (dSSubReport = this.UTFLength((DSContainer)jRObjectResult, s, n)) == null) continue;
            return dSSubReport;
        }
        return null;
    }

    private DSSubReport addElement(DSContainer dSContainer, short s) {
        Vector vector = dSContainer.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DSSubReport dSSubReport;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
            if (jRObjectResult.getObjectType() == 45 && jRObjectResult.getTemplateIndex() == s) {
                return (DSSubReport)jRObjectResult;
            }
            if (!(jRObjectResult instanceof DSContainer) || (dSSubReport = this.addElement((DSContainer)jRObjectResult, s)) == null) continue;
            return dSSubReport;
        }
        return null;
    }

    public int getAvailableHeight() {
        return this.append;
    }

    public void setAvailableHeight(int n) {
        this.append = n;
    }

    public int getAvailableWidth() {
        return this.addElement;
    }

    public void setAvailableWidth(int n) {
        this.addElement = n;
    }

    public ImgInfo getImgInfo() {
        if (null == this.background) {
            this.background = this.dataStream.communicator.getImgInfoInMainRpt();
        }
        return this.background;
    }

    public void setImgInfo(ImgInfo imgInfo) {
        this.background = imgInfo;
    }
}

