/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.datastream.DSDataStreamable;
import jet.datastream.JRObjectResult;

public class DSPolyLine
extends JRObjectResult {
    int[][] polygon = new int[0][2];
    int lineWidth = 0;
    int lineColor = -1;
    int lineStyle = -1;
    boolean lineColorTrans = false;

    public boolean isLineColorTrans() {
        return this.lineColorTrans;
    }

    public void setLineColorTrans(boolean bl) {
        this.lineColorTrans = bl;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.lineWidth = dataInput.readInt();
        this.lineStyle = dataInput.readInt();
        this.lineColor = dataInput.readInt();
        int n = dataInput.readInt();
        this.polygon = new int[n][2];
        for (int i = 0; i < n; ++i) {
            this.polygon[i][0] = dataInput.readInt();
            this.polygon[i][1] = dataInput.readInt();
        }
        this.lineColorTrans = dataInput.readBoolean();
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeInt(this.lineWidth);
        dataOutput.writeInt(this.lineStyle);
        dataOutput.writeInt(this.lineColor);
        int n = this.polygon.length;
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutput.writeInt(this.polygon[i][0]);
            dataOutput.writeInt(this.polygon[i][1]);
        }
        dataOutput.writeBoolean(this.lineColorTrans);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 16;
        n += this.polygon.length * 4 * 2;
        return ++n;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSPolyLine());
    }

    public DSPolyLine dup(DSPolyLine dSPolyLine) {
        super.dup(dSPolyLine);
        dSPolyLine.lineWidth = this.lineWidth;
        dSPolyLine.lineStyle = this.lineStyle;
        dSPolyLine.lineColor = this.lineColor;
        dSPolyLine.polygon = this.polygon;
        dSPolyLine.lineColorTrans = this.lineColorTrans;
        return dSPolyLine;
    }

    public int[][] getPolygon() {
        return this.polygon;
    }

    public void setPolygon(int[][] nArray) {
        this.polygon = nArray;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(int n) {
        this.lineColor = n;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public Color getLineColorValue() {
        Color color = null;
        if (!this.lineColorTrans) {
            color = new Color(this.lineColor);
        }
        return color;
    }
}

