/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.datastream.DSContainable;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.util.Containable;
import jet.util.IntVector;
import jet.util.TreeIterater;
import jet.util.VersionControlable;

public final class DSReference
extends JRObjectResult {
    JRObjectResult refObj;
    int pageNum = 0;
    int[] index;
    int sectionNum = 0;
    int objectNum = 0;
    private int SEDU = 0;

    private void SEDU(JRObjectResult jRObjectResult) {
        Object object = jRObjectResult;
        Containable containable = jRObjectResult.getParent();
        DSPage dSPage = null;
        IntVector intVector = new IntVector();
        while (containable != null) {
            intVector.addElement(containable.getChildren().indexOf(object));
            if (containable instanceof DSPage) {
                dSPage = (DSPage)containable;
                break;
            }
            object = containable;
            containable = ((JRObjectResult)((Object)containable)).getParent();
        }
        intVector.trimToSize();
        this.index = intVector.getAllElements();
        this.pageNum = dSPage.getPageNum();
    }

    public final void setRefData(JRObjectResult jRObjectResult) {
        this.refObj = jRObjectResult;
        this.SEDU(jRObjectResult);
    }

    public final JRObjectResult getRefData() {
        JRVisiableResult jRVisiableResult = (JRVisiableResult)this.refObj.copyObject();
        jRVisiableResult.setY(this.SEDU);
        return jRVisiableResult;
    }

    @Override
    protected final void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        this.pageNum = dataInput.readShort();
        Communicator communicator = dSDataStreamable.getCommunicator();
        DataStream dataStream = (DataStream)communicator.getDataStream(0);
        if (dataInput instanceof VersionControlable) {
            DSPage dSPage = dataStream.getPage(this.pageNum);
            int n = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n < 262176 && n != 0) {
                this.sectionNum = dataInput.readShort();
                this.objectNum = dataInput.readShort();
                Vector vector = dSPage.getChildren();
                DSSection dSSection = (DSSection)vector.elementAt(this.sectionNum);
                TreeIterater treeIterater = new TreeIterater(dSSection, false);
                Object object = null;
                for (int i = 0; i <= this.objectNum; ++i) {
                    object = treeIterater.next();
                }
                this.refObj = (JRObjectResult)object;
            } else {
                int n2 = dataInput.readShort();
                if (n2 > 0) {
                    this.index = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        this.index[i] = dataInput.readShort();
                    }
                }
                this.refObj = DSReference.addElement(dSPage, this.index);
            }
            if (n > 263184 || n == 0) {
                this.SEDU = dataInput.readInt();
            }
        }
        if (dataStream.bufFile != null) {
            dataStream.bufFile.seek(dataStream.bufFile.getPosition());
        }
    }

    private static JRObjectResult addElement(DSPage dSPage, int[] nArray) {
        int n = nArray.length;
        if (n < 1) {
            return null;
        }
        DSPage dSPage2 = dSPage;
        Vector vector = null;
        for (int i = n - 1; i >= 0; --i) {
            if (dSPage2 instanceof DSContainable) {
                vector = ((DSContainable)dSPage2).getChildren();
                if (vector == null || vector.size() <= nArray[i]) {
                    return null;
                }
            } else {
                return null;
            }
            dSPage2 = vector.elementAt(nArray[i]);
        }
        return (JRObjectResult)((Object)dSPage2);
    }

    @Override
    protected final void writeProperties(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.pageNum);
        int n = this.index == null ? 0 : this.index.length;
        dataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            dataOutput.writeShort(this.index[i]);
        }
        dataOutput.writeInt(this.SEDU);
    }

    @Override
    protected int propLength() {
        int n = 0;
        n += 4;
        if (this.index != null) {
            n += 2 * this.index.length;
        }
        return n += 4;
    }

    @Override
    public final int getObjectType() {
        return 8192;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSReference());
    }

    public DSReference dup(DSReference dSReference) {
        super.dup(dSReference);
        dSReference.refObj = this.refObj;
        dSReference.pageNum = this.pageNum;
        dSReference.sectionNum = this.sectionNum;
        dSReference.objectNum = this.objectNum;
        if (this.index != null) {
            int n = this.index.length;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.index[i];
            }
            dSReference.index = nArray;
        }
        dSReference.SEDU = this.SEDU;
        return dSReference;
    }

    public int getYPos() {
        return this.SEDU;
    }

    public void setYPos(int n) {
        this.SEDU = n;
    }
}

