/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import guitools.Painter;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSPage;
import jet.datastream.JRObjectResult;
import jet.util.Containable;

public class DSShape
extends JRObjectResult {
    int topAttach = -1;
    int bottomAttach = -1;
    int lineWidth = -1;
    Rectangle bound = null;
    int x1 = -1;
    int x2 = -1;
    int y1 = -1;
    int y2 = -1;
    boolean inv = true;

    public void setTopAttachIndex(int n) {
        this.topAttach = n;
    }

    public int getTopAttachIndex() {
        return this.topAttach;
    }

    public void setBottomAttachIndex(int n) {
        this.bottomAttach = n;
    }

    public int getBottomAttachIndex() {
        return this.bottomAttach;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.topAttach = dataInput.readInt();
        this.bottomAttach = dataInput.readInt();
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeInt(this.topAttach);
        dataOutput.writeInt(this.bottomAttach);
    }

    @Override
    protected int propLength() {
        int n = 8;
        return n;
    }

    @Override
    public final int getResolution() {
        Containable containable;
        DSPage dSPage = null;
        JRObjectResult jRObjectResult = this;
        while ((containable = jRObjectResult.getParent()) != null) {
            if (containable instanceof DSPage) {
                dSPage = (DSPage)containable;
                break;
            }
            jRObjectResult = (JRObjectResult)((Object)containable);
        }
        if (dSPage == null) {
            return Unit.getResolution();
        }
        return dSPage.dataStream.getCommunicator().getResolution();
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSShape());
    }

    public DSShape dup(DSShape dSShape) {
        super.dup(dSShape);
        dSShape.topAttach = this.topAttach;
        dSShape.bottomAttach = this.bottomAttach;
        return dSShape;
    }

    public final void paintShape(Graphics graphics) {
        Color color = null;
        Color color2 = null;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = this.getObjectType();
        if (n6 != 22) {
            color = this.getTemplate().getBorderColor(this);
            n = this.getTemplate().getBorderWidth(this);
            n2 = this.getTemplate().getBorderStyle(this);
            n = Unit.convertUnitToPixel(n, this.getResolution());
        } else {
            color2 = this.getTemplate().getLineColor(this);
            n5 = this.getTemplate().getLineStyle(this);
        }
        switch (n6) {
            case 22: {
                Painter.drawLine(graphics, this.x1 - this.bound.x, this.y1 - this.bound.y, this.x2 - this.bound.x, this.y2 - this.bound.y, color2, this.lineWidth, n5);
                break;
            }
            case 20: {
                int n7 = this.getTemplate().getCornerFactor(this);
                n7 = Unit.convertUnitToPixel(n7);
                Painter.drawRoundBox(graphics, 0, 0, this.bound.width, this.bound.height, null, color, n, n2, n7);
                break;
            }
            case 18: {
                n3 = this.getTemplate().getStartAngle(this);
                n4 = this.getTemplate().getArcAngle(this);
                Painter.drawArc(graphics, 0, 0, this.bound.width, this.bound.height, null, color, n, n2, n3, n4);
                break;
            }
            case 19: {
                Painter.drawOval(graphics, 0, 0, this.bound.width, this.bound.height, null, color, n, n2);
                break;
            }
            case 23: {
                Painter.drawBox(graphics, 0, 0, this.bound.width, this.bound.height, null, color, n, n2);
            }
        }
    }

    public final void paintInterior(Graphics graphics) {
        Color color = null;
        Color color2 = null;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getObjectType();
        if (n4 != 22) {
            color = this.getTemplate().getBackground(this);
            color2 = this.getTemplate().getBorderColor(this);
            n = this.getTemplate().getBorderStyle(this);
        }
        if (color != null) {
            switch (n4) {
                case 20: {
                    int n5 = this.getTemplate().getCornerFactor(this);
                    n5 = Unit.convertUnitToPixel(n5);
                    Painter.drawRoundBox(graphics, 0, 0, this.bound.width, this.bound.height, color, color2, 0, n, n5);
                    break;
                }
                case 18: {
                    n2 = this.getTemplate().getStartAngle(this);
                    n3 = this.getTemplate().getArcAngle(this);
                    Painter.drawArc(graphics, 0, 0, this.bound.width, this.bound.height, color, color2, 0, n, n2, n3);
                    break;
                }
                case 19: {
                    Painter.drawOval(graphics, 0, 0, this.bound.width, this.bound.height, color, color2, 0, n);
                    break;
                }
                case 23: {
                    Painter.drawBox(graphics, 0, 0, this.bound.width, this.bound.height, color, color2, 0, n);
                    break;
                }
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.bound = new Rectangle(n, n2, n3, n4);
    }

    public Rectangle getBounds() {
        return this.bound;
    }

    public void setCoordinates(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
        this.bound = new Rectangle(n3 < n ? n3 : n, n4 < n2 ? n4 : n2, n3 > n ? n3 - n + 1 : n - n3 + 1, n4 > n2 ? n4 - n2 + 1 : n2 - n4 + 1);
        this.lineWidth = this.getTemplate().getLineWidth(this);
        this.lineWidth = Unit.convertUnitToPixel(this.lineWidth, this.getResolution());
        if (this.lineWidth > 1) {
            if (Math.abs(n3 - n) < this.lineWidth) {
                this.bound.x -= this.lineWidth / 2;
                this.bound.width = this.lineWidth;
            }
            if (Math.abs(n4 - n2) < this.lineWidth) {
                this.bound.y -= this.lineWidth / 2;
                this.bound.height = this.lineWidth;
            }
        }
    }

    public void setInv(boolean bl) {
        this.inv = bl;
    }

    public boolean getInv() {
        return this.inv;
    }
}

