/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSField;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.JRObjectResult;
import jet.util.Containable;

public class DSTable
extends DSContainer {
    int topAttach = -1;
    int bottomAttach = -1;
    Vector fields = new Vector();

    public void setTopAttachIndex(int n) {
        this.topAttach = n;
    }

    public int getTopAttachIndex() {
        return this.topAttach;
    }

    public void setBottomAttachIndex(int n) {
        this.bottomAttach = n;
    }

    public int getBottomAttachIndex() {
        return this.bottomAttach;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.topAttach = dataInput.readInt();
        this.bottomAttach = dataInput.readInt();
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeInt(this.topAttach);
        dataOutput.writeInt(this.bottomAttach);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        return n += 8;
    }

    @Override
    public final int getResolution() {
        Containable containable;
        DSPage dSPage = null;
        JRObjectResult jRObjectResult = this;
        while ((containable = jRObjectResult.getParent()) != null) {
            if (containable instanceof DSPage) {
                dSPage = (DSPage)containable;
                break;
            }
            jRObjectResult = (JRObjectResult)((Object)containable);
        }
        if (dSPage == null) {
            return Unit.getResolution();
        }
        return dSPage.dataStream.getCommunicator().getResolution();
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSTable());
    }

    public DSTable dup(DSTable dSTable) {
        super.dup(dSTable);
        dSTable.topAttach = this.topAttach;
        dSTable.bottomAttach = this.bottomAttach;
        return dSTable;
    }

    Vector getAllDSFields() {
        if (this.fields.size() == 0) {
            Containable containable = this.getParent();
            Vector vector = containable.getChildren();
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.elementAt(i) instanceof DSSection)) continue;
                Vector vector2 = ((DSSection)vector.elementAt(i)).getChildren();
                for (int j = 0; j < vector2.size(); ++j) {
                    if (!(vector2.elementAt(j) instanceof DSField)) continue;
                    this.fields.addElement(vector2.elementAt(j));
                }
            }
        }
        return this.fields;
    }

    @Override
    public void paint(Graphics graphics) {
        boolean bl = this.getTemplate().getShowBorder(this);
        super.paint(graphics);
        if (bl) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
        }
    }
}

