/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.connect.Record;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.util.VersionControlable;

public class DSTableCell
extends DSContainer {
    public static final String TOC_ANCHOR_PREFIX = "TabelAnchor";
    private static final int SEDU = 1;
    int gridX;
    int gridY;
    int colSpan;
    int rowSpan;
    String tocAnchor;
    int recordIdx = 0;
    private boolean append = false;

    public boolean isFinished() {
        return this.append;
    }

    public void setFinished(boolean bl) {
        this.append = bl;
    }

    @Override
    public JRecord getRecord() {
        if (this.recordIdx == -1) {
            return null;
        }
        return ((DSTableObject)((DSTableRow)this.getParent()).getParent()).getRecord(this.recordIdx);
    }

    @Override
    public Record getSynRecord() {
        return ((DSTableObject)((DSTableRow)this.getParent()).getParent()).getSynRecord(this.recordIdx);
    }

    @Override
    public Record getSynRecord2() {
        return ((DSTableObject)((DSTableRow)this.getParent()).getParent()).getSynRecord2(this.recordIdx);
    }

    public int getRecordIdx() {
        return this.recordIdx;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int n) {
        this.colSpan = n;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int n) {
        this.rowSpan = n;
    }

    public int getGridX() {
        return this.gridX;
    }

    public void setGridX(int n) {
        this.gridX = n;
    }

    public int getGridY() {
        return this.gridY;
    }

    public void setGridY(int n) {
        this.gridY = n;
    }

    public String getTocAnchor() {
        return this.tocAnchor;
    }

    public void setTocAnchor(String string) {
        this.tocAnchor = string;
    }

    public void setRecordIdx(int n) {
        this.recordIdx = n;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        if (dataInput instanceof VersionControlable) {
            int n = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n >= 262176 || n == 0) {
                this.gridX = dataInput.readShort();
                this.gridY = dataInput.readShort();
                boolean bl = dataInput.readBoolean();
                this.colSpan = bl ? 1 : (int)dataInput.readShort();
            } else {
                int n2;
                this.gridX = dataInput.readInt();
                this.gridY = dataInput.readInt();
                if (n >= 262160 || n == 0) {
                    this.colSpan = dataInput.readInt();
                }
                if ((n2 = dataInput.readInt()) >= 0) {
                    this.tocAnchor = DSTableCell.getTocAnchor(n2);
                }
            }
            if (n >= 262400 || n == 0) {
                this.rowSpan = dataInput.readShort();
            }
            if (n >= 262656 || n == 0) {
                this.recordIdx = dataInput.readInt();
            }
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeShort(this.gridX);
        dataOutput.writeShort(this.gridY);
        if (this.colSpan == 1) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            dataOutput.writeShort(this.colSpan);
        }
        dataOutput.writeShort(this.rowSpan);
        dataOutput.writeInt(this.recordIdx);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 6;
        if (this.colSpan == 1) {
            ++n;
        } else {
            ++n;
            n += 2;
        }
        return n += 4;
    }

    public static final int getTocIndex(String string) {
        return Integer.parseInt(string.substring(TOC_ANCHOR_PREFIX.length()));
    }

    public static final String getTocAnchor(int n) {
        return TOC_ANCHOR_PREFIX + n;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSTableCell());
    }

    public DSTableCell dup(DSTableCell dSTableCell) {
        super.dup(dSTableCell);
        dSTableCell.setGridX(this.gridX);
        dSTableCell.setGridY(this.gridY);
        dSTableCell.setColSpan(this.colSpan);
        dSTableCell.setRowSpan(this.rowSpan);
        dSTableCell.setRecordIdx(this.recordIdx);
        dSTableCell.tocAnchor = this.tocAnchor == null ? null : this.tocAnchor;
        return dSTableCell;
    }
}

