/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableRow;
import jet.datastream.JRObjectResult;
import jet.util.VersionControlable;

public class DSTableObject
extends DSContainer {
    public static final int NoPara = -1;
    DSDataStreamable stream;
    private int SEDU;
    private int add;
    private boolean containsKey;
    private boolean dup;
    private int get;
    private int getCalculateRecord;
    private int getChildren;
    private boolean getColSpan;
    private int getCommunicator;
    private boolean getDataStream;
    private int getGridX;

    public JRecord getRecord(DSTableRow dSTableRow) {
        int n = dSTableRow.getRecordIndex();
        return this.stream.getRecord(n);
    }

    public JRecord getRecord(int n) {
        return this.stream.getRecord(n);
    }

    public JRecord getSynRecord(int n) {
        return this.stream.getSynRecord(n);
    }

    public JRecord getSynRecord2(int n) {
        return this.stream.getSynRecord2(n);
    }

    public int getSubIdx() {
        if (this.stream == null) {
            return -1;
        }
        return this.stream.getSubIndex();
    }

    public List getCells_old() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.add; ++i) {
            arrayList.add(new ArrayList());
        }
        Vector vector = this.getChildren();
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            if ((((JRObjectResult)vector.get(i)).getObjectType() & 0x1000000) != 0x1000000) {
                ++n;
                continue;
            }
            DSTableRow dSTableRow = (DSTableRow)vector.get(i);
            Vector vector2 = dSTableRow.getChildren();
            int n2 = 0;
            for (int j = 0; j < vector2.size(); ++j) {
                DSTableCell dSTableCell = (DSTableCell)vector2.get(j);
                if (this.dup) {
                    ((ArrayList)arrayList.get(n2)).add(dSTableCell);
                    int n3 = dSTableCell.getColSpan();
                    n2 += n3 - 1;
                } else {
                    ((ArrayList)arrayList.get(i - n)).add(dSTableCell);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public List getCells() {
        Vector vector = this.getChildren();
        TreeMap treeMap = new TreeMap();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            if ((((JRObjectResult)vector.get(i)).getObjectType() & 0x1000000) != 0x1000000) continue;
            DSTableRow dSTableRow = (DSTableRow)vector.get(i);
            n = dSTableRow.getY();
            Vector vector2 = dSTableRow.getChildren();
            for (int j = 0; j < vector2.size(); ++j) {
                DSTableCell dSTableCell = (DSTableCell)vector2.get(j);
                n2 = this.isHorizontal() ? dSTableCell.getGridX() : dSTableCell.getGridY();
                if (treeMap.containsKey(n2)) {
                    ((List)treeMap.get(n2)).add(dSTableCell);
                    continue;
                }
                ArrayList<DSTableCell> arrayList = new ArrayList<DSTableCell>();
                arrayList.add(dSTableCell);
                treeMap.put(n2, arrayList);
            }
        }
        ArrayList arrayList = new ArrayList(treeMap.values());
        return arrayList;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        Communicator communicator = dSDataStreamable.getCommunicator();
        int n = communicator.getSubIdx(this.getTemplate());
        this.stream = n > -1 ? communicator.getDataStream(n) : communicator.getDataStream(0);
        this.SEDU = dataInput.readInt();
        this.add = dataInput.readInt();
        this.dup = dataInput.readBoolean();
        this.get = dataInput.readInt();
        this.getCalculateRecord = dataInput.readInt();
        int n2 = ((VersionControlable)((Object)dataInput)).getVersion();
        VersionControlable cfr_ignored_0 = (VersionControlable)((Object)dataInput);
        if (n2 >= 262176 || n2 == 0) {
            this.getChildren = dataInput.readBoolean() ? dataInput.readInt() : -1;
        }
        VersionControlable cfr_ignored_1 = (VersionControlable)((Object)dataInput);
        if (n2 >= 262400 || n2 == 0) {
            this.getColSpan = dataInput.readBoolean();
            this.getCommunicator = dataInput.readInt();
        }
        VersionControlable cfr_ignored_2 = (VersionControlable)((Object)dataInput);
        if (n2 >= 262656 || n2 == 0) {
            this.getDataStream = dataInput.readBoolean();
        }
        if (n2 >= 263168 || n2 == 0) {
            this.getGridX = dataInput.readInt();
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeInt(this.SEDU);
        dataOutput.writeInt(this.add);
        dataOutput.writeBoolean(this.dup);
        dataOutput.writeInt(this.get);
        dataOutput.writeInt(this.getCalculateRecord);
        dataOutput.writeBoolean(this.containsKey);
        if (this.containsKey) {
            dataOutput.writeInt(this.getChildren);
        }
        dataOutput.writeBoolean(this.getColSpan);
        dataOutput.writeInt(this.getCommunicator);
        dataOutput.writeBoolean(this.getDataStream);
        dataOutput.writeInt(this.getGridX);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 24;
        n += 4;
        if (this.containsKey) {
            n += 4;
        }
        return n;
    }

    public int getColCnt() {
        return this.SEDU;
    }

    public void setColCnt(int n) {
        this.SEDU = n;
    }

    public int getRowCnt() {
        return this.add;
    }

    public void setRowCnt(int n) {
        this.add = n;
    }

    public void setGroupTreeIDX(int n) {
        this.getCalculateRecord = n;
    }

    public int getGroupTreeIDX() {
        return this.getCalculateRecord;
    }

    public boolean isHorizontal() {
        return this.dup;
    }

    public void setHorizontal(boolean bl) {
        this.dup = bl;
    }

    public DSDataStreamable getStream() {
        return this.stream;
    }

    public void setStream(DSDataStreamable dSDataStreamable) {
        this.stream = dSDataStreamable;
    }

    public int getTotalBlockNum() {
        return this.get;
    }

    public void setTotalBlockNum(int n) {
        this.get = n;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSTableObject());
    }

    public DSTableObject dup(DSTableObject dSTableObject) {
        super.dup(dSTableObject);
        dSTableObject.setStream(this.stream);
        dSTableObject.setColCnt(this.SEDU);
        dSTableObject.setRowCnt(this.add);
        dSTableObject.setHorizontal(this.dup);
        dSTableObject.setGroupTreeIDX(this.getCalculateRecord);
        dSTableObject.setTotalBlockNum(this.get);
        dSTableObject.containsKey = this.containsKey;
        dSTableObject.setParameterKey(this.getChildren);
        dSTableObject.setInlinePanel(this.getColSpan);
        dSTableObject.setBeginRecIdx(this.getCommunicator);
        dSTableObject.setIsFirstTable(this.getDataStream);
        dSTableObject.setRoundingMode(this.getGridX);
        return dSTableObject;
    }

    public void setParameterKey(int n) {
        this.containsKey = n != -1;
        this.getChildren = n;
    }

    public int getParameterKey() {
        return this.getChildren;
    }

    public JRecord getCalculateRecord(DSTableRow dSTableRow) {
        int n = dSTableRow.getRecordIndex();
        return this.stream.getCalculateRecord(n);
    }

    public void setInlinePanel(boolean bl) {
        this.getColSpan = bl;
    }

    public boolean hasInlinePanel() {
        return this.getColSpan;
    }

    public int getBeginRecIdx() {
        return this.getCommunicator;
    }

    public void setBeginRecIdx(int n) {
        this.getCommunicator = n;
    }

    public boolean getIsFirstTable() {
        return this.getDataStream;
    }

    public void setIsFirstTable(boolean bl) {
        this.getDataStream = bl;
    }

    @Override
    public int getRoundingMode() {
        return this.getGridX;
    }

    @Override
    public void setRoundingMode(int n) {
        this.getGridX = n;
    }
}

