/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import guitools.Painter;
import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSField;
import jet.datastream.DSPicture;
import jet.datastream.JRObjectResult;
import jet.util.HashVector;
import jet.util.VersionControlable;

public class DSTextObj
extends DSContainer {
    boolean finish = true;
    int startLine = 0;
    Vector lines = new Vector();
    public static final String DEFAULT_PARA_FONT_FACE = "DefaultParaFontFace";
    public static final String DEFAULT_PARA_FONT_SIZE = "DefaultParaFontSize";
    public static final String[] FMTMAPPINGNAMES_DOC = new String[]{"Default Tab", "Paper Width", "Paper Height", "Left Margin", "Right Margin", "Top Margin", "Bottom Margin", "Text Vertical Alignment", "Background"};
    private int DEFAULT_SHADOW_WIDTH = 1;
    public static final String[] FMTMAPPINGNAMES_PARA = new String[]{"para alignment", "First-line indent", "Left indent", "Right indent", "Space before", "Space after", "Line spacing", "DefaultParaFontFace", "DefaultParaFontSize"};
    private HashVector SEDU = null;
    private Vector add = new Vector();

    public void setStartLine(int n) {
        this.startLine = n;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setFinish(boolean bl) {
        this.finish = bl;
    }

    public boolean isFinish() {
        return this.finish;
    }

    public Vector getLines() {
        return this.lines;
    }

    @Override
    public void add(JRObjectResult jRObjectResult) {
        super.add(jRObjectResult);
        if (jRObjectResult instanceof DSField) {
            Vector vector = null;
            int n = ((DSField)jRObjectResult).lineNum - this.startLine;
            if (n >= this.lines.size()) {
                vector = new Vector();
                this.lines.setSize(n + 1);
                this.lines.setElementAt(vector, n);
            } else {
                vector = (Vector)this.lines.elementAt(n);
            }
            vector.addElement(jRObjectResult);
        }
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        this.startLine = dataInput.readShort();
        this.finish = dataInput.readBoolean();
        if (dataInput instanceof VersionControlable && ((n = ((VersionControlable)((Object)dataInput)).getVersion()) >= 131098 || n == 0)) {
            this.DEFAULT_SHADOW_WIDTH(dataInput);
            this.DEFAULT_SHADOW_WIDTH = dataInput.readInt();
            this.addAll(dataInput, this.DEFAULT_SHADOW_WIDTH);
        }
        super.readProperties(dataInput, dSDataStreamable);
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort((short)this.startLine);
        dataOutput.writeBoolean(this.finish);
        this.SEDU(dataOutput);
        this.DEFAULT_SHADOW_WIDTH = this.add.size();
        dataOutput.writeInt(this.DEFAULT_SHADOW_WIDTH);
        this.FMTMAPPINGNAMES_DOC(dataOutput);
        super.writeProperties(dataOutput);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 3;
        n += 4 * FMTMAPPINGNAMES_DOC.length;
        n += 4;
        return n += 4 * FMTMAPPINGNAMES_PARA.length * this.DEFAULT_SHADOW_WIDTH;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSTextObj());
    }

    public DSTextObj dup(DSTextObj dSTextObj) {
        super.dup(dSTextObj);
        dSTextObj.finish = this.finish;
        dSTextObj.startLine = this.startLine;
        dSTextObj.lines = (Vector)this.lines.clone();
        dSTextObj.add = this.add == null ? null : (Vector)this.add.clone();
        dSTextObj.SEDU = this.SEDU == null ? null : this.SEDU.clone();
        dSTextObj.DEFAULT_SHADOW_WIDTH = this.DEFAULT_SHADOW_WIDTH;
        return dSTextObj;
    }

    @Override
    public void paint(Graphics graphics) {
        int n = 0;
        boolean bl = this.getStartYPos() == 0;
        Color color = this.getTemplate().getBackground(this);
        Color color2 = this.getTemplate().getBorderColor(this);
        int n2 = this.getTemplate().getBorderWidth(this);
        int n3 = this.getTemplate().getLeftLine(this);
        int n4 = bl ? this.getTemplate().getTopLine(this) : 0;
        n = this.finish ? this.getTemplate().getBottomLine(this) : 0;
        int n5 = this.getTemplate().getRightLine(this);
        boolean bl2 = this.getTemplate().getShadow(this);
        Color color3 = this.getTemplate().getShadowColor(this);
        n2 = Unit.convertUnitToPixel(n2, this.getResolution());
        int n6 = Unit.convertUnitToPixel(PainterConstants.DEFAULT_SHADOW_WIDTH, this.getResolution());
        Rectangle rectangle = this.getBounds();
        Painter.drawBorder(graphics, new Dimension(rectangle.width, rectangle.height), color, color2, n2, n4, n, n3, n5, bl2 && this.finish, bl2, bl2 && this.finish, bl, color3, n6);
        super.paint(graphics);
    }

    private void DEFAULT_SHADOW_WIDTH(DataInput dataInput) throws IOException {
        this.SEDU = new HashVector(FMTMAPPINGNAMES_DOC.length);
        this.addElement(this.SEDU, FMTMAPPINGNAMES_DOC, dataInput, 0, FMTMAPPINGNAMES_DOC.length);
    }

    private void FMTMAPPINGNAMES_DOC(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.DEFAULT_SHADOW_WIDTH; ++i) {
            HashVector hashVector = (HashVector)this.add.get(i);
            this.FMTMAPPINGNAMES_PARA(dataOutput, hashVector);
        }
    }

    private void FMTMAPPINGNAMES_PARA(DataOutput dataOutput, HashVector hashVector) throws IOException {
        this.add(dataOutput, FMTMAPPINGNAMES_PARA, hashVector);
    }

    private void SEDU(DataOutput dataOutput) throws IOException {
        this.add(dataOutput, FMTMAPPINGNAMES_DOC, this.SEDU);
    }

    private void add(DataOutput dataOutput, String[] stringArray, HashVector hashVector) throws IOException {
        for (String string : stringArray) {
            Integer n = (Integer)hashVector.get(string);
            dataOutput.writeInt(n);
        }
    }

    private void addAll(DataInput dataInput, int n) throws IOException {
        this.add.clear();
        for (int i = 0; i < n; ++i) {
            HashVector hashVector = new HashVector(FMTMAPPINGNAMES_PARA.length);
            this.addElement(hashVector, FMTMAPPINGNAMES_PARA, dataInput, 0, 6);
            int n2 = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n2 >= 131099 || n2 == 0) {
                this.addElement(hashVector, FMTMAPPINGNAMES_PARA, dataInput, 7, 8);
            }
            this.add.add(hashVector);
        }
    }

    private void addElement(HashVector hashVector, String[] stringArray, DataInput dataInput, int n, int n2) throws IOException {
        for (int i = n; i < stringArray.length && i <= n2; ++i) {
            String string = stringArray[i];
            int n3 = dataInput.readInt();
            hashVector.put(string, n3);
        }
    }

    public void CopyDocParaFormatInfo(DSTextObj dSTextObj) {
        this.setDocFormat(dSTextObj.SEDU);
        this.add = dSTextObj.add;
        this.append();
    }

    private void append() {
        int n = this.getChildren().size();
        if (n <= 0) {
            return;
        }
        JRObjectResult jRObjectResult = (JRObjectResult)this.getChildren().get(0);
        int n2 = this.clone(jRObjectResult);
        if (n2 == 0) {
            return;
        }
        Vector vector = new Vector();
        vector.addAll(this.add.subList(n2, this.add.size()));
        this.add = vector;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            JRObjectResult jRObjectResult2 = null;
            jRObjectResult2 = (JRObjectResult)this.getChildren().get(i);
            this.clear(jRObjectResult2, n2);
        }
    }

    private void clear(JRObjectResult jRObjectResult, int n) {
        if (jRObjectResult instanceof DSField) {
            DSField dSField = (DSField)jRObjectResult;
            int n2 = dSField.getTextObjParaFmtNO() - n;
            dSField.setTextObjParaFmtNO(n2);
        } else if (jRObjectResult instanceof DSPicture) {
            DSPicture dSPicture = (DSPicture)jRObjectResult;
            int n3 = dSPicture.getTextObjParaFmtNO() - n;
            dSPicture.setTextObjParaFmtNO(n3);
        }
    }

    private int clone(JRObjectResult jRObjectResult) {
        if (jRObjectResult instanceof DSField) {
            return ((DSField)jRObjectResult).getTextObjParaFmtNO();
        }
        if (jRObjectResult instanceof DSPicture) {
            return ((DSPicture)jRObjectResult).getTextObjParaFmtNO();
        }
        return 0;
    }

    public Vector getAllParasFormat() {
        return this.add;
    }

    public HashVector getParaFormat(int n) {
        return (HashVector)this.add.get(n);
    }

    public void addParaFormat(HashVector hashVector) {
        this.add.add(hashVector);
    }

    public HashVector getDocFormat() {
        return this.SEDU;
    }

    public void setDocFormat(HashVector hashVector) {
        this.add.clear();
        this.SEDU = hashVector;
    }

    public String getFormatString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Document Properies: " + string);
        stringBuffer.append(this.convertUnitToPixel(this.SEDU)).append(string);
        for (int i = 0; i < this.add.size(); ++i) {
            stringBuffer.append(i + 1).append(" ").append("paragraph properties").append(string);
            HashVector hashVector = (HashVector)this.add.get(i);
            stringBuffer.append(this.convertUnitToPixel(hashVector)).append(string);
        }
        return stringBuffer.toString();
    }

    private String convertUnitToPixel(HashVector hashVector) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{" + string);
        stringBuffer.append(string);
        for (int i = 0; i < hashVector.size(); ++i) {
            Object e = hashVector.get(i);
            Object f = hashVector.get(e);
            stringBuffer.append(e + "= " + f);
            stringBuffer.append(string);
        }
        stringBuffer.append("}" + string);
        return stringBuffer.toString();
    }
}

