/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.controls.JetUnitNumber;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSBody;
import jet.datastream.DSChartHeatMapGroupRect;
import jet.datastream.DSChartORGNode;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSGroup;
import jet.datastream.DSPage;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubBody;
import jet.datastream.DSSubReport;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableRow;
import jet.datastream.DSTemplatible;
import jet.datastream.ImgInfo;
import jet.datastream.JRVisiableResult;
import jet.datastream.PropertyMapTable;
import jet.datastream.PropertyValue;
import jet.datastream.RecordLocation;
import jet.util.Containable;
import jet.util.ImagePropertiable;
import jet.util.JFieldValueNLSManager;
import jet.util.JRInterruptedException;
import jet.util.MiscTools;
import jet.util.Propertiable;
import jet.util.PropertySetable;
import jet.util.VersionControlable;
import jet.util.image.ImageResource;
import jet.util.image.ImageResourceUtil;

@Deprecated
public class JRObjectResult
implements PropertySetable,
RecordLocation {
    protected short modelIndex;
    protected byte flag;
    protected transient DSTemplatible template;
    transient Containable parent;
    protected int linkedCommIdx = -1;
    protected int linkedPageIdx = -1;
    protected int linkedCondition = -1;
    protected boolean dirty;
    transient DSSection pageSec = null;
    static final byte NULL = 0;
    static final byte NONULL = 1;
    protected boolean hasLink = false;
    private int ver = 0;

    public boolean isHasLink() {
        return this.hasLink;
    }

    public void setHasLink(boolean hasLink) {
        this.hasLink = hasLink;
    }

    public short getTemplateIndex() {
        return this.modelIndex;
    }

    public short getParentContainerTemplateIndex() {
        if (this instanceof DSContainer) {
            return this.modelIndex;
        }
        if (this.getParent() == null) {
            return -1;
        }
        return ((JRObjectResult)((Object)this.getParent())).getParentContainerTemplateIndex();
    }

    public void setTemplateIndex(short index) {
        this.modelIndex = index;
    }

    public DSTemplatible getTemplate() {
        return this.template;
    }

    public String getJetObjInstName() {
        return this.getTemplate().getInstName();
    }

    public void setTemplate(DSTemplatible template) {
        this.template = template;
    }

    public void setParent(Containable parent) {
        this.parent = parent;
    }

    public Containable getParent() {
        return this.parent;
    }

    public int getObjectType() {
        return this.template.getObjectType();
    }

    public final String getUDOName() {
        return (String)this.template.getPropertyByName("UDOName").getObject();
    }

    @Override
    public final Hashtable getProperties() {
        return this.template.getProperties();
    }

    @Override
    @Deprecated
    public Propertiable getPropertyByName(String propertyName) {
        return this.getPropertyByName(propertyName, null);
    }

    public boolean isChangeByF(Propertiable ret) {
        boolean changeBy = false;
        if (ret != null) {
            changeBy = ret.isChangeByOther() || ret.isChagneByFmtt() || ret.isChangeByBL();
        }
        return changeBy;
    }

    @Deprecated
    public Propertiable getPropertyByName(String propertyName, Record record) {
        Propertiable ret;
        block38: {
            ret = this.template.getPropertyByName(propertyName);
            if (ret != null) {
                boolean changeByFmtt = ret.isChagneByFmtt();
                boolean changeByFlyF = ret.isChangeByBL();
                if (ret.isSetRuntimeChgBy() || ret.getRuntimeChangeBy() != null) {
                    boolean isPropertyValue = false;
                    Object changeBy = null;
                    changeBy = ret.getRuntimeChangeBy();
                    try {
                        String qName;
                        if (record == null) {
                            record = Thread.currentThread().getName().indexOf("paging") != -1 ? this.getSynRecord() : this.getRecord();
                        }
                        if (changeByFmtt && record == null) {
                            return ret;
                        }
                        DbValue value = null;
                        String fName = changeBy.toString().toUpperCase();
                        int pType = 0;
                        if (this.pageSec == null) {
                            this.pageSec = this.getSection();
                        }
                        if (this.pageSec != null) {
                            pType = this.pageSec.getObjectType();
                        }
                        if (pType == 517 || pType == 514 || pType == 2564 || pType == 2563) {
                            value = this.getPagelevel(fName, pType);
                        }
                        if (value == null) {
                            value = record.getCell(fName);
                        }
                        int tag2 = 0;
                        if (ret instanceof PropertyValue) {
                            isPropertyValue = true;
                            tag2 = ((PropertyValue)ret).getPropType();
                        }
                        Propertiable oldProp = ret;
                        ret = (Propertiable)ret.getClass().newInstance();
                        if (isPropertyValue) {
                            ((PropertyValue)ret).resetPropertyType(tag2);
                        }
                        if (value.isNull() && JRLog.isAd()) {
                            JRLog.print("Trace info\nproperty " + propertyName + ", value " + fName + " is null");
                        }
                        if ((qName = this.getChangeByQName(ret)) != null) {
                            HashSet denyListByQualify;
                            int subIndex = this.getSubIdxOfRpt();
                            short dcTempIndex = this.getParentContainerTemplateIndex();
                            if (subIndex >= 0 && dcTempIndex != -1 && (denyListByQualify = this.getCommunicator().getExportTimeInfo().getSecurityExportInfo().getDenyListByQualify(subIndex, dcTempIndex)) != null && denyListByQualify.contains(qName)) {
                                value = (DbValue)value.clone();
                                value.setNull();
                            }
                        }
                        if (!value.isNull() || propertyName.equals("Format")) {
                            if (value instanceof DbBinary) {
                                Image img;
                                block37: {
                                    byte[] bytes = ((DbBinary)value).get();
                                    img = null;
                                    if (bytes != null) {
                                        img = Toolkit.getDefaultToolkit().createImage(bytes);
                                    }
                                    MediaTracker tracker = new MediaTracker(new Canvas());
                                    tracker.addImage(img, 0);
                                    try {
                                        tracker.waitForID(0);
                                    }
                                    catch (InterruptedException e) {
                                        if (!JRLog.isError(2)) break block37;
                                        JRLog.error(2, 35427, (Throwable)e);
                                    }
                                }
                                ret.setObject(img);
                            } else if (propertyName.equals("X") || propertyName.equals("Y") || propertyName.equals("Width") || propertyName.equals("Height")) {
                                ret.set(Integer.toString(Unit.convertInchToPixel(Double.valueOf(value.toString()))));
                            } else if (changeByFmtt && propertyName.equalsIgnoreCase("FontSize")) {
                                if (isPropertyValue) {
                                    ret.set(value.toString());
                                } else {
                                    ((JetUnitNumber)ret).setUnitValue(value.toString());
                                }
                            } else if (value instanceof DbChar && (propertyName.equals("DisplayNull") || propertyName.equals("Text"))) {
                                ret.set(this.get((DbChar)value));
                            } else if (propertyName.equals("TopLine") || propertyName.equals("BottomLine") || propertyName.equals("LeftLine") || propertyName.equals("RightLine")) {
                                ret.setObject(Integer.valueOf(value.toString()));
                            } else {
                                ret.set(value.toString());
                            }
                        } else {
                            ret.setObject(oldProp.getNormalObject());
                        }
                        ret.setChangeByObject(ret.getObject());
                        if (changeByFmtt) {
                            ret.setChangeByFmtt(ret.getObject());
                        } else if (changeByFlyF) {
                            ret.setChangeByBL(ret.getObject());
                        }
                    }
                    catch (JRInterruptedException e) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2300080, (Throwable)e);
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        if (!JRLog.isError(2)) break block38;
                        JRLog.error(2, 2300077, (Throwable)e);
                    }
                }
            }
        }
        return ret;
    }

    private String getChangeByQName(Propertiable prop) {
        String qualifyName = null;
        boolean changeBy = prop.isSetRuntimeChgBy();
        if (changeBy) {
            if (prop.isChagneByFmtt()) {
                qualifyName = ((String)prop.getChangeByFmtt()).toUpperCase();
            }
            if (prop.isChangeByBL()) {
                qualifyName = ((String)prop.getChangeByBL()).toUpperCase();
            }
            if (prop.isChangeByOther()) {
                qualifyName = ((String)prop.getObject()).toUpperCase();
            }
        }
        return qualifyName;
    }

    public ImageResource getImgResourceByPropertyName(String name2) {
        return this.getImgResourceByPropertyName(name2, null);
    }

    public ImageResource getImgResourceByPropertyName(String propertyName, Record record) {
        ImageResource imgResource = ImageResource.BLANK_IMAGERES;
        Propertiable property = this.template.getPropertyByName(propertyName);
        if (property != null) {
            if (property.isSetRuntimeChgBy() || property.getRuntimeChangeBy() != null) {
                boolean isPropertyValue;
                int tag2;
                DbValue value;
                block20: {
                    Object changeBy = null;
                    changeBy = property.getRuntimeChangeBy();
                    if (record == null) {
                        record = Thread.currentThread().getName().indexOf("paging") != -1 ? this.getSynRecord() : this.getRecord();
                    }
                    int pType = 0;
                    if (this.pageSec == null) {
                        this.pageSec = this.getSection();
                    }
                    if (this.pageSec != null) {
                        pType = this.pageSec.getObjectType();
                    }
                    value = null;
                    String fName = changeBy.toString().toUpperCase();
                    if (pType == 517 || pType == 514 || pType == 2564 || pType == 2563) {
                        value = this.getPagelevel(fName, pType);
                    }
                    if (value == null) {
                        value = record.getCell(fName);
                    }
                    tag2 = 0;
                    isPropertyValue = false;
                    if (property instanceof PropertyValue) {
                        isPropertyValue = true;
                        tag2 = ((PropertyValue)property).getPropType();
                    }
                    Propertiable oldProp = property;
                    try {
                        property = (Propertiable)property.getClass().newInstance();
                    }
                    catch (Exception e) {
                        if (!JRLog.isError(2)) break block20;
                        JRLog.error(2, 2300077, (Throwable)e);
                    }
                }
                if (isPropertyValue) {
                    ((PropertyValue)property).resetPropertyType(tag2);
                }
                if (!value.isNull()) {
                    if (value instanceof DbBinary) {
                        byte[] bytes = ((DbBinary)value).get();
                        try {
                            imgResource = ImageResourceUtil.loadImageResourceFromBytes(bytes);
                        }
                        catch (IOException e) {
                            if (JRLog.isError(2)) {
                                JRLog.error(2, 2300086, (Throwable)e);
                            }
                        }
                    } else {
                        property.set(value.toString());
                        imgResource = this.getImgResource((ImagePropertiable)property);
                    }
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6300078, new Object[]{propertyName});
                }
            } else {
                imgResource = this.getImgResource((ImagePropertiable)property);
            }
        }
        return imgResource;
    }

    protected DbValue getPagelevel(String fName, int pType) {
        Containable pp = this.parent;
        if (!(pp instanceof DSPage) && !(pp instanceof DSSubReport)) {
            pp = this.pageSec.getParent();
        }
        if (pType == 517 || pType == 2564) {
            if (pp instanceof DSPage) {
                return (DbValue)((DSPage)pp).getFLevelValue(fName);
            }
            if (pp instanceof DSSubReport) {
                return (DbValue)((DSSubReport)pp).getFLevelValue(fName);
            }
        } else if (pType == 514 || pType == 2563) {
            if (pp instanceof DSPage) {
                return (DbValue)((DSPage)pp).getHLevelValue(fName);
            }
            if (pp instanceof DSSubReport) {
                DbValue hvalue = (DbValue)((DSSubReport)pp).getHLevelValue(fName);
                return hvalue;
            }
        }
        return null;
    }

    protected String get(DbChar value) {
        return value.toString();
    }

    @Override
    public final Propertiable getProperty(short propertyName) {
        return this.getPropertyByName(PropertyMapTable.getPropertyName(propertyName));
    }

    public Record getSynRecord() {
        JRObjectResult ret = this;
        Containable cur = null;
        while (ret != null) {
            int objType = ret.template.getObjectType();
            if (this instanceof DSGroup) {
                return ((DSGroup)this).getSynRecord();
            }
            if ((objType & 0x200) == 512 || (objType & 0xA00) == 2560) {
                if (objType != 517 && objType != 514 || this.ver != 0 && this.ver < 262145) {
                    ret = this.validateDSSection((DSSection)ret);
                    return ((DSSection)ret).getSynRecord();
                }
                Containable dsParent = ret.getParent();
                if (dsParent instanceof DSPage) {
                    DSBody body = this.searchBodyInPage((DSPage)dsParent);
                    return (JRecord)body.getSynRecord();
                }
                DSSubBody subBody = this.searchBodyInSubReport((DSSubReport)dsParent);
                return (JRecord)subBody.getSynRecord();
            }
            if ((objType & 0x1000000) == 0x1000000) {
                return ((DSTableRow)ret).getSynRecord();
            }
            if (objType == 262180) {
                return ((DSTableCell)ret).getSynRecord();
            }
            if (objType == 262177) {
                return ((DSBody)ret).getSynRecord();
            }
            if (objType == 77) {
                return ((DSChartORGNode)ret).getSynRecord();
            }
            if (objType == 79) {
                return ((DSChartHeatMapGroupRect)ret).getSynRecord();
            }
            cur = ret.getParent();
            if (!(cur instanceof JRObjectResult)) break;
            ret = (JRObjectResult)((Object)cur);
        }
        return null;
    }

    public Record getSynRecord2() {
        JRObjectResult ret = this;
        Containable cur = null;
        while (ret != null) {
            int objType = ret.template.getObjectType();
            if (this instanceof DSGroup) {
                return ((DSGroup)this).getSynRecord2();
            }
            if ((objType & 0x200) == 512 || (objType & 0xA00) == 2560) {
                if (objType != 517 && objType != 514) {
                    ret = this.validateDSSection((DSSection)ret);
                    return ((DSSection)ret).getSynRecord2();
                }
                Containable dsParent = ret.getParent();
                if (dsParent instanceof DSPage) {
                    DSBody body = this.searchBodyInPage((DSPage)dsParent);
                    return (JRecord)body.getSynRecord2();
                }
                DSSubBody subBody = this.searchBodyInSubReport((DSSubReport)dsParent);
                return (JRecord)subBody.getSynRecord2();
            }
            if (objType == 262180) {
                return ((DSTableCell)ret).getSynRecord2();
            }
            if ((objType & 0x1000000) == 0x1000000) {
                return ((DSTableRow)ret).getSynRecord2();
            }
            if (objType == 262177) {
                return ((DSBody)ret).getSynRecord2();
            }
            if (objType == 77) {
                return ((DSChartORGNode)ret).getSynRecord2();
            }
            if (objType == 79) {
                return ((DSChartHeatMapGroupRect)ret).getSynRecord2();
            }
            cur = ret.getParent();
            if (!(cur instanceof JRObjectResult)) break;
            ret = (JRObjectResult)((Object)cur);
        }
        return null;
    }

    protected DSBody searchBodyInPage(DSPage page) {
        int s = page.objects.size();
        for (int j = 0; j < s; ++j) {
            JRObjectResult dsObj = (JRObjectResult)page.objects.elementAt(j);
            if (dsObj.getObjectType() != 262177) continue;
            return (DSBody)dsObj;
        }
        return null;
    }

    public int getSubIdxOfRpt() {
        JRObjectResult ret = this;
        Containable cur = null;
        while (null != ret) {
            int objType = ret.getObjectType();
            if (objType == 262177) {
                return ((DSBody)ret).getDataStream().getSubIndex();
            }
            if (objType == 33) {
                return ((DSSubReport)ret).getSubIdx();
            }
            cur = ret.getParent();
            if (cur instanceof DSPage) {
                return 0;
            }
            if (!(cur instanceof JRObjectResult)) break;
            ret = (JRObjectResult)((Object)cur);
        }
        if (JRLog.isError(2)) {
            JRLog.error(2, 2300030);
        }
        return -1;
    }

    public JRecord getCalculateRecord() {
        JRObjectResult ret = this;
        Containable cur = null;
        while (ret != null) {
            int objType = ret.template.getObjectType();
            if (this instanceof DSGroup) {
                return ((DSGroup)this).getCalculateRecord();
            }
            if ((objType & 0x200) == 512 || (objType & 0xA00) == 2560) {
                ret = this.validateDSSection((DSSection)ret);
                return ((DSSection)ret).getCalculateRecord();
            }
            if ((objType & 0x1000000) == 0x1000000) {
                return ((DSTableRow)ret).getCalculateRecord();
            }
            if (objType == 262177) {
                return (JRecord)((DSBody)ret).getSynRecord();
            }
            if (objType == 77) {
                return (JRecord)((DSChartORGNode)ret).getSynRecord();
            }
            if (objType == 79) {
                return (JRecord)((DSChartHeatMapGroupRect)ret).getSynRecord();
            }
            cur = ret.getParent();
            if (!(cur instanceof JRObjectResult)) break;
            ret = (JRObjectResult)((Object)cur);
        }
        return null;
    }

    @Deprecated
    public JRecord getRecord() {
        JRObjectResult ret = this;
        Containable cur = null;
        while (ret != null) {
            int objType = ret.template.getObjectType();
            if (this instanceof DSGroup) {
                return ((DSGroup)this).getRecord();
            }
            if ((objType & 0x200) == 512 || (objType & 0xA00) == 2560) {
                if (objType != 517 && objType != 514 || this.ver != 0 && this.ver < 262145) {
                    ret = this.validateDSSection((DSSection)ret);
                    return ((DSSection)ret).getRecord();
                }
                Containable dsParent = ret.getParent();
                if (dsParent instanceof DSPage) {
                    DSBody body = this.searchBodyInPage((DSPage)dsParent);
                    return body.getRecord();
                }
                DSSubBody subBody = this.searchBodyInSubReport((DSSubReport)dsParent);
                return subBody.getRecord();
            }
            if (objType == 262180) {
                return ((DSTableCell)ret).getRecord();
            }
            if ((objType & 0x1000000) == 0x1000000) {
                return ((DSTableRow)ret).getRecord();
            }
            if (objType == 262177) {
                return ((DSBody)ret).getRecord();
            }
            if (objType == 77) {
                return ((DSChartORGNode)ret).getRecord();
            }
            if (objType == 79) {
                return ((DSChartHeatMapGroupRect)ret).getRecord();
            }
            cur = ret.getParent();
            if (!(cur instanceof JRObjectResult)) break;
            ret = (JRObjectResult)((Object)cur);
        }
        return null;
    }

    protected DSSubBody searchBodyInSubReport(DSSubReport report) {
        Vector childs = report.getChildren();
        int s = childs.size();
        for (int j = 0; j < s; ++j) {
            JRObjectResult dsObj = (JRObjectResult)childs.elementAt(j);
            if (dsObj.getObjectType() != 262182) continue;
            return (DSSubBody)dsObj;
        }
        return null;
    }

    @Deprecated
    public int getResolution() {
        JRObjectResult object = this.searchParent(this);
        if (object != null) {
            if (object instanceof DSSection) {
                this.pageSec = (DSSection)object;
                return this.pageSec.getResolution();
            }
            if (object.getObjectType() == 262177) {
                return ((DSBody)object).getDataStream().getCommunicator().getResolution();
            }
        }
        return Unit.getResolution();
    }

    public Communicator getCommunicator() {
        Containable parentDS = this.getParent();
        if (null == parentDS) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "parent DSObject is null, it should be due to not create parent-child chain at this time. so only return null when get communicator from parent DSObject.");
            }
            return null;
        }
        return ((JRObjectResult)((Object)parentDS)).getCommunicator();
    }

    private JRObjectResult searchParent(JRObjectResult son) {
        while (son != null) {
            if (son.getObjectType() == 262177) {
                return son;
            }
            if (son instanceof DSSection) {
                son = this.validateDSSection((DSSection)son);
                return son;
            }
            if (!(son instanceof JRObjectResult)) {
                return null;
            }
            son = (JRObjectResult)((Object)son.getParent());
        }
        return son;
    }

    protected DSSection validateDSSection(DSSection ret) {
        block7: {
            Vector v;
            int location;
            block8: {
                Containable par;
                block6: {
                    location = 0;
                    try {
                        location = this.getTemplate().getRecordLocation(this);
                    }
                    catch (JRInterruptedException e) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2300080, (Throwable)e);
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        if (!JRLog.isError(2)) break block6;
                        JRLog.error(2, e);
                    }
                }
                if (location == 0 || (par = ret.getParent()) == null || !(par instanceof DSPage) && !(par instanceof DSSubReport)) break block7;
                v = par.getChildren();
                if (location != 2) break block8;
                for (int i = v.size() - 1; i >= 0; --i) {
                    JRObjectResult o = (JRObjectResult)v.elementAt(i);
                    if (o.getObjectType() != 517 && o.getObjectType() != 2564) continue;
                    ret = (DSSection)v.elementAt(i);
                    break block7;
                }
                break block7;
            }
            if (location != 1) break block7;
            for (int i = 0; i < v.size(); ++i) {
                JRObjectResult o = (JRObjectResult)v.elementAt(i);
                if (o.getObjectType() != 514) continue;
                ret = (DSSection)o;
                break;
            }
        }
        return ret;
    }

    public final DSSection getSection() {
        DSSection ret = null;
        Object cur = this;
        while (cur != null) {
            if (cur instanceof DSSection) {
                ret = (DSSection)cur;
                ret = this.validateDSSection(ret);
                break;
            }
            if ((cur = ((JRObjectResult)cur).getParent()) instanceof JRObjectResult) continue;
            break;
        }
        return ret;
    }

    public final DSTableRow getTableRow() {
        DSTableRow ret = null;
        Object cur = this;
        while (cur != null) {
            if (cur instanceof DSTableRow) {
                ret = (DSTableRow)cur;
                break;
            }
            if ((cur = ((JRObjectResult)cur).getParent()) instanceof JRObjectResult) continue;
            break;
        }
        return ret;
    }

    public final void read(DataInput in, DSDataStreamable ds) throws IOException, JRStopEngineException {
        if (in instanceof VersionControlable) {
            this.ver = ((VersionControlable)((Object)in)).getVersion();
        }
        if (this instanceof DSReference) {
            this.readProperties(in, ds);
            return;
        }
        this.modelIndex = in.readShort();
        this.template = ds.getTemplate(this.modelIndex);
        this.setNLSManager(ds.getNlsManager());
        this.flag = in.readByte();
        if (this.ver >= 263184 || this.ver == 0) {
            this.hasLink = in.readBoolean();
            if (this.hasLink) {
                this.linkedCommIdx = in.readInt();
                this.linkedPageIdx = in.readInt();
                this.linkedCondition = in.readInt();
            }
        } else if (this.template.isLinkable()) {
            if (in instanceof VersionControlable) {
                if (this.ver >= 131073 || this.ver == 0) {
                    this.linkedCommIdx = in.readInt();
                    this.linkedPageIdx = in.readInt();
                }
                if (this.ver >= 131081 || this.ver == 0) {
                    this.linkedCondition = in.readInt();
                }
            }
        } else if (this.template.getObjectType() == 41 && (this.ver >= 262416 || this.ver == 0)) {
            this.linkedCommIdx = in.readInt();
            this.linkedPageIdx = in.readInt();
            this.linkedCondition = in.readInt();
        }
        this.readProperties(in, ds);
    }

    public void write(DataOutput out) throws IOException {
        this.beforeWrite();
        int iType = this.getObjectType();
        out.writeInt(iType);
        if (this instanceof DSReference) {
            this.writeProperties(out);
            return;
        }
        out.writeShort(this.modelIndex);
        out.writeByte(this.flag);
        out.writeBoolean(this.hasLink);
        if (this.hasLink) {
            out.writeInt(this.linkedCommIdx);
            out.writeInt(this.linkedPageIdx);
            out.writeInt(this.linkedCondition);
        }
        ByteArrayOutputStream bOut = null;
        DataOutput udoOut = null;
        if ((iType & 0x1000) != 0) {
            bOut = new ByteArrayOutputStream();
            udoOut = new DataOutputStream(bOut);
            DataOutput temp = out;
            out = udoOut;
            udoOut = temp;
        }
        this.writeProperties(out);
        if (udoOut != null) {
            byte[] bytes = bOut.toByteArray();
            udoOut.writeInt(bytes.length);
            udoOut.write(bytes);
        }
    }

    protected int propLength() {
        int length;
        block4: {
            length = 0;
            if ((this.getObjectType() & 0x1000) != 0) {
                length = 4;
                if (!(this instanceof JRVisiableResult)) {
                    try {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        DataOutputStream out = new DataOutputStream(stream);
                        this.writeProperties(out);
                        length += stream.size();
                        stream.close();
                        out.close();
                    }
                    catch (IOException e) {
                        if (!JRLog.isError(2)) break block4;
                        JRLog.error(2, 2300086, (Throwable)e);
                    }
                }
            }
        }
        return length;
    }

    int length() {
        int length = 4;
        if (this instanceof DSReference) {
            return length += this.propLength();
        }
        length += 3;
        ++length;
        if (this.hasLink) {
            length += 12;
        }
        return length += this.propLength();
    }

    protected void readProperties(DataInput in, DSDataStreamable ds) throws IOException, JRStopEngineException {
    }

    protected void writeProperties(DataOutput out) throws IOException {
    }

    protected void beforeWrite() {
    }

    public void dump(PrintStream stream) {
    }

    public void setLink(int comm, int page, int comparerIdx) {
        this.linkedCommIdx = comm;
        this.linkedPageIdx = page;
        this.linkedCondition = comparerIdx;
        this.hasLink = this.linkedCommIdx != -1 || this.linkedPageIdx != -1 || this.linkedCondition != -1;
    }

    public int getLinkCondition() {
        return this.linkedCondition;
    }

    public int getLinkPage() {
        return this.linkedPageIdx;
    }

    public int getLinkComm() {
        return this.linkedCommIdx;
    }

    public Object copyObject() {
        return this.dup(new JRObjectResult());
    }

    public JRObjectResult dup(JRObjectResult obj) {
        obj.modelIndex = this.modelIndex;
        obj.flag = this.flag;
        obj.template = this.template;
        obj.parent = this.parent;
        obj.linkedCommIdx = this.linkedCommIdx;
        obj.linkedPageIdx = this.linkedPageIdx;
        obj.linkedCondition = this.linkedCondition;
        obj.hasLink = this.hasLink;
        return obj;
    }

    public void setDirty(boolean d) {
        this.dirty = d;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public static int UTFLength(String str) {
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            char c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public void setNLSManager(JFieldValueNLSManager nlsManager) {
    }

    public int getInt(String name2, boolean isUnit, int defaultV) {
        DbValue dv = this.getDbValue(name2, null);
        if (dv == null || dv.isNull()) {
            return defaultV;
        }
        if (isUnit) {
            return Unit.convertInchToUnit(Double.valueOf(dv.toString()));
        }
        return ((DbNumber)dv).intValue();
    }

    public int getInt(String name2, boolean isUnit, Record rec, int defaultV) {
        DbValue dv = this.getDbValue(name2, rec);
        if (dv == null || dv.isNull()) {
            return 0;
        }
        if (isUnit) {
            return Unit.convertInchToUnit(Double.valueOf(dv.toString()));
        }
        return ((DbNumber)dv).intValue();
    }

    public boolean getBoolean(String name2, boolean defaultV) {
        DbValue dv = this.getDbValue(name2, null);
        if (dv == null || dv.isNull()) {
            return defaultV;
        }
        return ((DbBit)dv).get();
    }

    public boolean getBoolean(String name2, Record rec, boolean defaultV) {
        DbValue dv = this.getDbValue(name2, rec);
        if (dv == null || dv.isNull()) {
            return defaultV;
        }
        return ((DbBit)dv).get();
    }

    public String getString(String name2, String defaultV) {
        DbValue dv = this.getDbValue(name2, null);
        if (dv == null || dv.isNull()) {
            return defaultV;
        }
        return dv.toString();
    }

    public String getString(String name2, Record rec, String defaultV) {
        DbValue dv = this.getDbValue(name2, rec);
        if (dv == null || dv.isNull()) {
            return defaultV;
        }
        return dv.toString();
    }

    public Color getColor(String name2, Color defaultV) {
        DbValue dv = this.getDbValue(name2, null);
        if (dv == null || dv.isNull()) {
            return defaultV;
        }
        return MiscTools._mapStringToColor(dv.toString());
    }

    public Color getColor(String name2, Record rec, Color defaultV) {
        DbValue dv = this.getDbValue(name2, rec);
        if (dv == null || dv.isNull()) {
            return defaultV;
        }
        return MiscTools._mapStringToColor(dv.toString());
    }

    public DbValue getDbValue(String name2, Record record) {
        DbValue value;
        block9: {
            value = null;
            try {
                if (record == null) {
                    record = this.getSynRecord();
                }
                String fName = name2.toUpperCase();
                int pType = 0;
                if (this.pageSec == null) {
                    this.pageSec = this.getSection();
                }
                if (this.pageSec != null) {
                    pType = this.pageSec.getObjectType();
                }
                if (pType == 517 || pType == 514 || pType == 2564 || pType == 2563) {
                    value = this.getPagelevel(fName, pType);
                }
                if (value == null) {
                    value = record.getCell(fName);
                }
            }
            catch (JRInterruptedException e) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2300087, (Throwable)e);
                }
                throw e;
            }
            catch (Exception ex) {
                if (!JRLog.isError(2)) break block9;
                JRLog.error(2, 2300077, (Throwable)ex);
            }
        }
        return value;
    }

    protected JRObjectResult findBody(JRObjectResult current) {
        JRObjectResult jParent = null;
        Containable parent = current.getParent();
        if (parent instanceof DSPage) {
            jParent = this.searchBodyInPage((DSPage)parent);
        } else {
            jParent = (JRObjectResult)((Object)parent);
            if (parent != null) {
                if (jParent.getObjectType() == 33) {
                    jParent = this.searchBodyInSubReport((DSSubReport)jParent);
                } else {
                    if (jParent.getObjectType() == 262177 || jParent.getObjectType() == 262182) {
                        return jParent;
                    }
                    jParent = this.findBody(jParent);
                }
            }
        }
        return jParent;
    }

    public ImgInfo getImgInfo() {
        ImgInfo imgInfo = null;
        Containable parent = this.getParent();
        while (parent != null) {
            if (parent instanceof DSPage) {
                imgInfo = ((DSPage)parent).getImgInfo();
                break;
            }
            JRObjectResult jParent = (JRObjectResult)((Object)parent);
            if (jParent.getObjectType() == 33) {
                imgInfo = jParent.getImgInfo();
                break;
            }
            parent = jParent.getParent();
        }
        return imgInfo;
    }

    protected ImageResource getImgResource(ImagePropertiable property) {
        ImageResource imgResource;
        block8: {
            imgResource = null;
            ImgInfo imgInfo = this.getImgInfo();
            if (imgInfo.isWithPath()) {
                File currentUsedCatalogFile = new File(imgInfo.getImgPath());
                try {
                    imgResource = this.getCommunicator().getDataStream(0).getResourceStore().getMemoryStore().loadImage(currentUsedCatalogFile, property.get());
                }
                catch (ResourceNotFoundException e) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2300088, (Throwable)e);
                    }
                    break block8;
                }
                catch (ResourceLoadException e) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2300089, (Throwable)e);
                    }
                    break block8;
                }
                catch (JRStopEngineException e) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2300090, (Throwable)e);
                    }
                    break block8;
                }
            }
            imgResource = property.getImageResourceByID(imgInfo.getImgScopeId());
        }
        return imgResource;
    }
}

