/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.awt.JFont;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.util.Vector;
import jet.datastream.DSControlSymbol;
import jet.datastream.DSParagraphText;
import jet.datastream.DSPicture;
import jet.datastream.JRVisiableResult;

public class ParagraphTools {
    public static boolean canNotBeginChar(char c) {
        int n = Character.getType(c);
        return Character.isWhitespace(c) || n == 20 || n == 22 || n == 24 || n == 14;
    }

    public static boolean isBreakChar(char c) {
        return Character.isWhitespace(c) || c == ' ' || Character.getType(c) == 14 || c > '\u2e80' && c < '\u9fff';
    }

    public static boolean isDoubleChar(char c) {
        return c > '\u2e80' && c < '\u9fff';
    }

    public static FontMetrics getFontMetrics(Font font) {
        return font instanceof JFont ? ((JFont)((Object)font)).getFontMetrics() : Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int charsWidth(String string, int n, int n2, FontMetrics fontMetrics) {
        return fontMetrics.stringWidth(new String(string.toCharArray(), n, n2));
    }

    public static int textWidth(String string, int n, int n2, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        return (int)font.getStringBounds(new String(string.toCharArray(), n, n2), fontRenderContext).getBounds().getWidth();
    }

    public static int textWidthUsePrecision(String string, int n, int n2, Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl);
        return (int)Math.round(font.getStringBounds(new String(string.toCharArray(), n, n2), fontRenderContext).getBounds().getWidth());
    }

    public static int textWidth(String string, FontMetrics fontMetrics) {
        return ParagraphTools.charsWidth(string, 0, string.length(), fontMetrics);
    }

    public static int textWidth(String string, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        int n = (int)font.getStringBounds(string, fontRenderContext).getBounds().getWidth();
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public static int textWidthUsePrecision(String string, Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl);
        int n = (int)Math.round(font.getStringBounds(string, fontRenderContext).getBounds().getWidth());
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public static int textHeight(Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        return ParagraphTools.getFontMetrics(font).getHeight();
    }

    public static int textHeightUsePrecision(Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl);
        return ParagraphTools.getFontMetrics(font).getHeight();
    }

    public static double textHeight(String string, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        return ParagraphTools.getFontMetrics(font).getHeight();
    }

    public static int textHeightUsePrecision(String string, Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl);
        return ParagraphTools.getFontMetrics(font).getHeight();
    }

    public static double getTextAscent(String string, Font font) {
        return ParagraphTools.getFontMetrics(font).getAscent();
    }

    public static double getTextDscent(String string, Font font) {
        return ParagraphTools.getFontMetrics(font).getDescent();
    }

    public static double getLeading(String string, Font font) {
        return ParagraphTools.getFontMetrics(font).getLeading();
    }

    public static int lastBreakPos(int n, int n2, String string) {
        int n3;
        int n4 = -1;
        char[] cArray = string.toCharArray();
        int n5 = n3 = n + n2 >= cArray.length ? n + n2 - 1 : n + n2;
        while (n3 >= 0) {
            if (ParagraphTools.isDoubleChar(cArray[n3])) {
                n4 = n2;
                break;
            }
            if (ParagraphTools.isBreakChar(cArray[n3])) {
                n4 = n3 + 1;
                break;
            }
            --n3;
        }
        return n4;
    }

    public static int getFirstDecimal(String string) {
        int n = -1;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < string.length() - 1; ++i) {
            if (('0' <= cArray[i] || cArray[i] <= '9') && '0' > cArray[i + 1] && cArray[i + 1] > '9') {
                n = i;
                if (cArray[i + 1] != '.') break;
                n = i + 1;
                break;
            }
            if (cArray[i] != '.') continue;
            n = i;
            break;
        }
        if (n == -1) {
            n = string.length();
        }
        return n;
    }

    public static int getWidthBeforeFirstDecimalUsePrecision(String string, Font font, boolean bl) {
        return ParagraphTools.textWidthUsePrecision(string, 0, ParagraphTools.getFirstDecimal(string), font, bl);
    }

    public static int[] getWrapPostion(String string, Font font, int n) {
        int[] nArray = new int[]{-1, -1};
        int n2 = Math.round(string.length() * n / ParagraphTools.textWidth(string, font));
        if (string.length() * n / ParagraphTools.textWidth(string, font) < 1) {
            return nArray;
        }
        if (ParagraphTools.textWidth(string, 0, n2, font) <= n) {
            if (ParagraphTools.textWidth(string, 0, n2, font) == n) {
                nArray[1] = n2;
            }
            for (int i = n2 + 1; i <= string.length(); ++i) {
                if (ParagraphTools.textWidth(string, 0, i, font) > n) {
                    nArray[1] = i - 1;
                } else {
                    if (ParagraphTools.textWidth(string, 0, i, font) != n) continue;
                    nArray[1] = i;
                }
                break;
            }
        } else {
            for (int i = n2 - 1; i >= 0; --i) {
                if (ParagraphTools.textWidth(string, 0, i, font) <= n) {
                    nArray[1] = i;
                } else {
                    if (ParagraphTools.textWidth(string, 0, i, font) != n) continue;
                    nArray[1] = i;
                }
                break;
            }
        }
        nArray[0] = ParagraphTools.lastBreakPos(0, nArray[1], string);
        return nArray;
    }

    public static int[] getWrapPostionUsePrecision(String string, Font font, int n, boolean bl) {
        int[] nArray = new int[]{-1, -1};
        int n2 = Math.round(string.length() * n / ParagraphTools.textWidthUsePrecision(string, font, bl));
        if (string.length() * n / ParagraphTools.textWidthUsePrecision(string, font, bl) < 1) {
            return nArray;
        }
        if (n2 > string.length()) {
            n2 = string.length() - 1;
            nArray[1] = n2 + 1;
        }
        if (ParagraphTools.textWidthUsePrecision(string, 0, n2, font, bl) <= n) {
            if (ParagraphTools.textWidthUsePrecision(string, 0, n2, font, bl) == n) {
                nArray[1] = n2;
            }
            for (int i = n2 + 1; i <= string.length(); ++i) {
                if (ParagraphTools.textWidthUsePrecision(string, 0, i, font, bl) > n) {
                    nArray[1] = i - 1;
                } else {
                    if (ParagraphTools.textWidthUsePrecision(string, 0, i, font, bl) != n) continue;
                    nArray[1] = i;
                }
                break;
            }
        } else {
            for (int i = n2 - 1; i >= 0; --i) {
                if (ParagraphTools.textWidthUsePrecision(string, 0, i, font, bl) <= n) {
                    nArray[1] = i;
                } else {
                    if (ParagraphTools.textWidthUsePrecision(string, 0, i, font, bl) != n) continue;
                    nArray[1] = i;
                }
                break;
            }
        }
        nArray[0] = ParagraphTools.lastBreakPos(0, nArray[1], string);
        return nArray;
    }

    public static Vector layoutLineElements(Vector vector, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14 = n;
        for (n13 = 0; n13 < vector.size(); ++n13) {
            if (vector.elementAt(n13) instanceof DSParagraphText) {
                ((DSParagraphText)vector.elementAt(n13)).setX(n14);
                n14 += ((DSParagraphText)vector.elementAt(n13)).getTextWidth();
                continue;
            }
            if (vector.elementAt(n13) instanceof DSControlSymbol) {
                n12 = 0;
                n11 = 0;
                n10 = n14;
                n9 = 0;
                n8 = 0;
                n7 = ((DSControlSymbol)vector.elementAt(n13)).getAlignment(n14);
                ((DSControlSymbol)vector.elementAt(n13)).setX(n14);
                switch (n7) {
                    case 0: {
                        n14 = ((DSControlSymbol)vector.elementAt(n13)).getStop(n14);
                        ((DSControlSymbol)vector.elementAt(n13)).setTabWidth(n14 - n10);
                        break;
                    }
                    case 1: {
                        n11 = ((DSControlSymbol)vector.elementAt(n13)).getStop(n14) - n10;
                        n9 = n13;
                        for (n6 = n13 + 1; n6 < vector.size(); ++n6) {
                            n9 = n6;
                            if (vector.elementAt(n6) instanceof DSParagraphText) {
                                n12 += ((DSParagraphText)vector.elementAt(n6)).getTextWidth();
                                continue;
                            }
                            if (vector.elementAt(n6) instanceof DSControlSymbol) {
                                n9 = n6 - 1;
                                break;
                            }
                            n12 += ((JRVisiableResult)vector.elementAt(n6)).getWidth();
                        }
                        if (n11 > n12) {
                            n8 = n11 - n12;
                            n14 = ((DSControlSymbol)vector.elementAt(n13)).getStop(n14);
                        } else {
                            n14 += n12;
                        }
                        ((DSControlSymbol)vector.elementAt(n13)).setTabWidth(n8);
                        for (n6 = n13; n6 < n9 + 1; ++n6) {
                            if (vector.elementAt(n6) instanceof DSParagraphText) {
                                ((DSParagraphText)vector.elementAt(n6)).setX(n10);
                                n10 += ((DSParagraphText)vector.elementAt(n6)).getTextWidth();
                                continue;
                            }
                            if (vector.elementAt(n6) instanceof DSControlSymbol) {
                                n10 += n8;
                                continue;
                            }
                            ((JRVisiableResult)vector.elementAt(n6)).setX(n10);
                            n10 += ((JRVisiableResult)vector.elementAt(n6)).getWidth();
                        }
                        n13 = n9;
                        break;
                    }
                    case 2: {
                        n11 = ((DSControlSymbol)vector.elementAt(n13)).getStop(n14) - n10;
                        n9 = n13;
                        for (n6 = n13 + 1; n6 < vector.size(); ++n6) {
                            n9 = n6;
                            if (vector.elementAt(n6) instanceof DSParagraphText) {
                                n12 += ((DSParagraphText)vector.elementAt(n6)).getTextWidth();
                                continue;
                            }
                            if (vector.elementAt(n6) instanceof DSControlSymbol) {
                                n9 = n6 - 1;
                                break;
                            }
                            n12 += ((JRVisiableResult)vector.elementAt(n6)).getWidth();
                        }
                        if (n11 > n12 / 2) {
                            n8 = n11 - n12 / 2;
                            n14 = ((DSControlSymbol)vector.elementAt(n13)).getStop(n14) + n12 / 2;
                            if (n14 > n + n2) {
                                if (n2 - n10 + n > n12) {
                                    n14 = n + n2;
                                    n8 = n11 - n12;
                                } else {
                                    n14 = n10 + n12;
                                    n8 = 0;
                                }
                            }
                        } else {
                            n14 += n12;
                            n8 = 0;
                        }
                        ((DSControlSymbol)vector.elementAt(n13)).setX(n10);
                        ((DSControlSymbol)vector.elementAt(n13)).setTabWidth(n8);
                        for (n6 = n13; n6 < n9 + 1; ++n6) {
                            if (vector.elementAt(n6) instanceof DSParagraphText) {
                                ((DSParagraphText)vector.elementAt(n6)).setX(n10);
                                n10 += ((DSParagraphText)vector.elementAt(n6)).getTextWidth();
                                continue;
                            }
                            if (vector.elementAt(n6) instanceof DSControlSymbol) {
                                n10 += n8;
                                continue;
                            }
                            ((JRVisiableResult)vector.elementAt(n6)).setX(n10);
                            n10 += ((JRVisiableResult)vector.elementAt(n6)).getWidth();
                        }
                        n13 = n9;
                        break;
                    }
                    case 3: {
                        n6 = 0;
                        n5 = 0;
                        n11 = ((DSControlSymbol)vector.elementAt(n13)).getStop(n14) - n10;
                        n9 = n13;
                        for (n4 = n13 + 1; n4 < vector.size(); ++n4) {
                            n9 = n4;
                            if (vector.elementAt(n4) instanceof DSParagraphText) {
                                if (((DSParagraphText)vector.elementAt(n4)).getBeforeDecimalWidth() != ((DSParagraphText)vector.elementAt(n4)).getTextWidth()) {
                                    ++n6;
                                }
                                if (n6 < 2) {
                                    n5 += ((DSParagraphText)vector.elementAt(n4)).getBeforeDecimalWidth();
                                }
                                n12 += ((DSParagraphText)vector.elementAt(n4)).getTextWidth();
                                continue;
                            }
                            if (vector.elementAt(n4) instanceof DSControlSymbol) {
                                n9 = n4 - 1;
                                break;
                            }
                            n12 += ((JRVisiableResult)vector.elementAt(n4)).getWidth();
                            if (n5 != 0) continue;
                            n5 = n12;
                        }
                        if (n5 == 0) {
                            n5 = n12;
                        }
                        if (n11 > n5) {
                            n8 = n11 - n5;
                            n14 = ((DSControlSymbol)vector.elementAt(n13)).getStop(n14) + n12 - n5;
                            if (n14 > n + n2) {
                                if (n2 - n10 + n > n12) {
                                    n14 = n + n2;
                                    n8 = n11 - n12;
                                } else {
                                    n14 = n10 + n12;
                                    n8 = 0;
                                }
                            }
                        } else {
                            n14 += n12;
                        }
                        ((DSControlSymbol)vector.elementAt(n13)).setX(n10);
                        ((DSControlSymbol)vector.elementAt(n13)).setTabWidth(n8);
                        for (n4 = n13; n4 < n9 + 1; ++n4) {
                            if (vector.elementAt(n4) instanceof DSParagraphText) {
                                ((DSParagraphText)vector.elementAt(n4)).setX(n10);
                                n10 += ((DSParagraphText)vector.elementAt(n4)).getTextWidth();
                                continue;
                            }
                            if (vector.elementAt(n4) instanceof DSControlSymbol) {
                                n10 += n8;
                                continue;
                            }
                            ((JRVisiableResult)vector.elementAt(n4)).setX(n10);
                            n10 += ((JRVisiableResult)vector.elementAt(n4)).getWidth();
                        }
                        n13 = n9;
                        break;
                    }
                }
                continue;
            }
            ((JRVisiableResult)vector.elementAt(n13)).setX(n14);
            n14 += ((JRVisiableResult)vector.elementAt(n13)).getWidth();
        }
        n13 = 0;
        n12 = 0;
        n12 = n2 - n14 + n;
        if (n12 < 0) {
            n12 = 0;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                if (n12 <= 0) break;
                n13 = n12;
                n11 = 0;
                for (n10 = 0; n10 < vector.size(); ++n10) {
                    if (vector.elementAt(n10) instanceof DSParagraphText) {
                        n11 = ((DSParagraphText)vector.elementAt(n10)).getX();
                        ((DSParagraphText)vector.elementAt(n10)).setX(n11 + n13);
                        continue;
                    }
                    if (vector.elementAt(n10) instanceof DSControlSymbol) {
                        n11 = ((DSControlSymbol)vector.elementAt(n10)).getX();
                        ((DSControlSymbol)vector.elementAt(n10)).setX(n11 + n13);
                        continue;
                    }
                    n11 = ((JRVisiableResult)vector.elementAt(n10)).getX();
                    ((JRVisiableResult)vector.elementAt(n10)).setX(n11 + n13);
                }
                break;
            }
            case 2: {
                if (n12 <= 0) break;
                n13 = n12 / 2;
                n11 = 0;
                for (n10 = 0; n10 < vector.size(); ++n10) {
                    if (vector.elementAt(n10) instanceof DSParagraphText) {
                        n11 = ((DSParagraphText)vector.elementAt(n10)).getX();
                        ((DSParagraphText)vector.elementAt(n10)).setX(n11 + n13);
                        continue;
                    }
                    if (vector.elementAt(n10) instanceof DSControlSymbol) {
                        n11 = ((DSControlSymbol)vector.elementAt(n10)).getX();
                        ((DSControlSymbol)vector.elementAt(n10)).setX(n11 + n13);
                        continue;
                    }
                    n11 = ((JRVisiableResult)vector.elementAt(n10)).getX();
                    ((JRVisiableResult)vector.elementAt(n10)).setX(n11 + n13);
                }
                break;
            }
            case 3: {
                int n15;
                int n16;
                int n17;
                if (n12 <= 0) break;
                n13 = n12;
                n11 = 0;
                n10 = vector.size();
                n9 = 0;
                n8 = 0;
                n7 = 0;
                n6 = -1;
                n5 = 0;
                n4 = 0;
                for (n17 = 0; n17 < vector.size(); ++n17) {
                    if (vector.elementAt(n17) instanceof DSParagraphText) {
                        n9 += ((DSParagraphText)vector.elementAt(n17)).getWhiteSpaceNum();
                        continue;
                    }
                    if (!(vector.elementAt(n17) instanceof DSControlSymbol)) continue;
                    n6 = n17;
                    n9 = 0;
                }
                if (n6 != -1 && ((DSControlSymbol)vector.elementAt(n6)).getAlignment(((DSControlSymbol)vector.elementAt(n6)).getX()) != 0) {
                    n13 += ((DSControlSymbol)vector.elementAt(n6)).getTabWidth();
                    ((DSControlSymbol)vector.elementAt(n6)).setTabWidth(0);
                }
                if (n6 != -1 && vector.elementAt(n6 + 1) instanceof DSParagraphText) {
                    n8 = ((DSParagraphText)vector.elementAt(n6 + 1)).getBeforeWordWNum();
                }
                if (vector.size() > 0 && vector.elementAt(vector.size() - 1) instanceof DSParagraphText) {
                    n7 = ((DSParagraphText)vector.elementAt(n6 + 1)).getAfterWordWNum();
                }
                if ((n9 = n9 - n8 - n7) != 0) {
                    n5 = n13 / n9;
                }
                if (n6 != -1 && vector.elementAt(n6 + 1) instanceof DSParagraphText) {
                    int[] nArray = new int[((DSParagraphText)vector.elementAt(n6 + 1)).getWhiteSpaceNum()];
                    for (n16 = 0; n16 < n8; ++n16) {
                        nArray[n16] = 0;
                    }
                    for (n16 = n8; n16 < nArray.length; ++n16) {
                        nArray[n16] = n5;
                    }
                    ((DSParagraphText)vector.elementAt(n6 + 1)).setWhitSpaceWidth(nArray);
                }
                for (n17 = n6 + 1; n17 < vector.size() - 1; ++n17) {
                    if (!(vector.elementAt(n17) instanceof DSParagraphText)) continue;
                    int[] nArray = new int[((DSParagraphText)vector.elementAt(n17)).getWhiteSpaceNum()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = n5;
                    }
                    ((DSParagraphText)vector.elementAt(n17)).setWhitSpaceWidth(nArray);
                }
                if (vector.size() > 0 && vector.elementAt(vector.size() - 1) instanceof DSParagraphText) {
                    int[] nArray = new int[((DSParagraphText)vector.elementAt(vector.size() - 1)).getWhiteSpaceNum()];
                    for (n16 = 0; n16 < nArray.length - n7; ++n16) {
                        nArray[n16] = n5;
                    }
                    for (n16 = nArray.length - n7; n16 < nArray.length; ++n16) {
                        nArray[n16] = 0;
                    }
                    ((DSParagraphText)vector.elementAt(vector.size() - 1)).setWhitSpaceWidth(nArray);
                }
                n4 = n6 != -1 ? ((DSControlSymbol)vector.elementAt(n6)).getTabWidth() + ((DSControlSymbol)vector.elementAt(n6)).getX() : n;
                for (n15 = n6 + 1; n15 < vector.size(); ++n15) {
                    n16 = 0;
                    if (vector.elementAt(n15) instanceof DSParagraphText) {
                        int[] nArray = new int[((DSParagraphText)vector.elementAt(n15)).getWhiteSpaceNum()];
                        nArray = ((DSParagraphText)vector.elementAt(n15)).getWhiteSpaceWidth();
                        ((DSParagraphText)vector.elementAt(n15)).setX(n4);
                        for (int i = 0; i < nArray.length; ++i) {
                            n16 += nArray[i];
                        }
                        n4 = n4 + n16 + ((DSParagraphText)vector.elementAt(n15)).getTextWidth();
                        continue;
                    }
                    ((JRVisiableResult)vector.elementAt(n15)).setX(n4);
                    n4 += ((JRVisiableResult)vector.elementAt(n15)).getWidth();
                }
                for (n15 = 0; n15 < vector.size(); ++n15) {
                    if (!(vector.elementAt(n15) instanceof DSParagraphText)) continue;
                    ((DSParagraphText)vector.elementAt(n15)).calculateJustifyWords();
                }
                break;
            }
        }
        return vector;
    }

    public static int getBeforeWordWNum(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < string.length() && cArray[i] == ' '; ++i) {
            ++n;
        }
        return n;
    }

    public static int getAfterWordWNum(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int i = string.length() - 1; i >= 0 && cArray[i] == ' '; --i) {
            ++n;
        }
        return n;
    }

    public static int getWhiteSpaceNum(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < string.length(); ++i) {
            if (cArray[i] != ' ') continue;
            ++n;
        }
        return n;
    }

    public static int getMaxHeight(Vector vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            n = vector.elementAt(i) instanceof DSParagraphText ? Math.max(n, ((DSParagraphText)vector.elementAt(i)).getTextHeight()) : (vector.elementAt(i) instanceof DSControlSymbol ? Math.max(n, ((DSControlSymbol)vector.elementAt(i)).getTabHeight()) : Math.max(n, ((JRVisiableResult)vector.elementAt(i)).getHeight()));
        }
        return n;
    }

    public static int getMaxTextHeight(Vector vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof DSParagraphText)) continue;
            n = Math.max(n, ((DSParagraphText)vector.elementAt(i)).getTextHeight());
        }
        return n;
    }

    public static float getBaseLineY(Vector vector) {
        float f = 0.0f;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof DSParagraphText)) continue;
            f = Math.max(f, (float)((DSParagraphText)vector.elementAt(i)).getTextBaseLineY());
        }
        return f;
    }

    public static float getTextBaseLineY(String string, Font font) {
        return (float)ParagraphTools.getTextAscent(string, font);
    }

    public static boolean haveOtherObject(Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof DSParagraphText || vector.elementAt(i) instanceof DSControlSymbol) continue;
            bl = true;
        }
        return bl;
    }

    public static void paintText(Graphics graphics, String string, int n, int n2, int n3, Font font) {
    }

    public static int[] getPictureWH(DSPicture dSPicture) {
        int[] nArray = new int[]{dSPicture.getWidth(), dSPicture.getHeight()};
        return nArray;
    }

    public static int getPictureW(DSPicture dSPicture) {
        return ParagraphTools.getPictureWH(dSPicture)[0];
    }

    public static int getPictureH(DSPicture dSPicture) {
        return ParagraphTools.getPictureWH(dSPicture)[1];
    }

    public static int getErrorWidth(String string, Vector vector, Font font) {
        int n;
        int n2 = ParagraphTools.textWidth(string, font);
        int n3 = 0;
        for (n = 0; n < vector.size(); ++n) {
            n3 += ParagraphTools.textWidth((String)vector.elementAt(n), font);
        }
        n = Unit.convertPixelToUnit(n3 - n2) / vector.size();
        return n;
    }

    public static int splitDrityData(String string, int n, Font font) {
        int[] nArray = new int[]{n};
        int n2 = ParagraphTools.layoutText(string, nArray, font)[0][1];
        return n2;
    }

    public static int[][] layoutText(String string, int[] nArray, Font font) {
        int n;
        int[][] nArray2 = new int[nArray.length][2];
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            if (n == 0) {
                nArray2[n][0] = 0;
                if (ParagraphTools.textWidth(string, font) > nArray[0]) {
                    int[] nArray3 = ParagraphTools.getWrapPostion(string, font, nArray[0]);
                    nArray2[n][1] = nArray3[0] != -1 ? nArray3[0] : nArray3[1];
                    continue;
                }
                nArray2[n][1] = string.length();
                continue;
            }
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n3 += nArray2[i][1];
            }
            if (n3 == string.length()) {
                nArray2[n][0] = 0;
                nArray2[n][1] = 0;
                break;
            }
            nArray2[n][0] = n3;
            if (ParagraphTools.textWidth(string.substring(nArray2[n][0]), font) > nArray[n]) {
                int[] nArray4 = ParagraphTools.getWrapPostion(string.substring(nArray2[n][0]), font, nArray[n]);
                nArray2[n][1] = nArray4[0] != -1 ? nArray4[0] : nArray4[1];
                continue;
            }
            nArray2[n][1] = string.length() - nArray2[n][0];
        }
        n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            nArray2[n][1] = nArray2[n][1] + nArray2[n][0];
        }
        return nArray2;
    }
}

