/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSContainer;
import jet.datastream.DSField;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import util.Node;
import util.RandomAccessStream;
import util.StreamObject;

public class TOCNode
extends StreamObject {
    String img = "";
    String value = "";
    String anchor = "";
    String name = "";
    String nodeDisplayValue = "";
    int page = -1;
    DSField field;
    boolean tocAnchor;
    String format;
    int x = -1;
    int y = -1;
    int layoutTimeX = -1;
    int layoutTimeY = -1;
    int tempX = -1;
    int tempY = -1;
    boolean firstLayout = true;
    public JRVisiableResult dsObj = null;
    boolean needRefresh = true;
    int objType = 0;
    Vector tempXY = null;
    private boolean SEDU = false;
    int pageHeader = -1;
    private int add = 0;
    List removeDSObjs = null;

    @Override
    public int getLength() {
        int n = RandomAccessStream.getLength(this.value) + RandomAccessStream.getLength(this.name) + 16 + RandomAccessStream.getLength(this.nodeDisplayValue);
        return n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public String getImg() {
        return this.img;
    }

    public void setImg(String string) {
        this.img = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public DSField getField() {
        return this.field;
    }

    public void setField(DSField dSField) {
        this.field = dSField;
        this.format = dSField.getTemplate().getFormat(dSField);
        this.dsObj = dSField;
    }

    public void setRemoveDSObjs(List list) {
        this.removeDSObjs = list;
    }

    public boolean isRemoveTocNode() {
        if (this.removeDSObjs != null) {
            for (int i = 0; i < this.removeDSObjs.size(); ++i) {
                Object e = this.removeDSObjs.get(i);
                if (this.dsObj == null || this.dsObj != e) continue;
                return true;
            }
        }
        return false;
    }

    public void update() {
        if (!this.isRemoveTocNode()) {
            if (this.field != null) {
                JRecord jRecord = this.field.getCalculateRecord();
                this.value = this.field.getText(jRecord);
            }
            this.field = null;
            if (this.dsObj != null) {
                this.y += this.close(this.dsObj);
                this.dsObj = null;
            }
            int n = this.length;
            while (--n >= 0) {
                ((TOCNode)this.nodes[n]).setRemoveDSObjs(this.removeDSObjs);
                ((TOCNode)this.nodes[n]).update();
            }
        } else {
            this.parent.remove(this);
            this.field = null;
            this.dsObj = null;
        }
        this.removeDSObjs = null;
    }

    public String getFormat() {
        return this.format;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String string) {
    }

    public void setTocAnchor(boolean bl) {
        this.tocAnchor = bl;
    }

    public boolean getTocAnchor() {
        return this.tocAnchor;
    }

    @Override
    public int getType() {
        return 43;
    }

    public void setNodeDisplayValue(String string) {
        this.nodeDisplayValue = string;
    }

    public String getNodeDisplayValue() {
        return this.nodeDisplayValue;
    }

    public int getTotalLength() {
        Node[] nodeArray = this.getNodes();
        int n = 0;
        for (int i = 0; i < nodeArray.length; ++i) {
            n += ((TOCNode)nodeArray[i]).getTotalLength();
        }
        return this.getLength() + n;
    }

    @Override
    protected void outputProps(RandomAccessStream randomAccessStream) throws IOException {
        super.outputProps(randomAccessStream);
        randomAccessStream.writeString(this.value);
        randomAccessStream.writeString(this.name);
        randomAccessStream.writeInt(this.page);
        randomAccessStream.writeString(this.nodeDisplayValue);
        randomAccessStream.writeInt(this.x);
        randomAccessStream.writeInt(this.y);
        randomAccessStream.writeInt(this.objType);
    }

    public Object copyObject() {
        return this.dup(new TOCNode());
    }

    public TOCNode dup(TOCNode tOCNode) {
        tOCNode.setImg(this.img);
        tOCNode.setValue(this.value);
        tOCNode.setAnchor(this.anchor);
        tOCNode.setName(this.name);
        tOCNode.setPage(this.page);
        tOCNode.setNodeDisplayValue(this.nodeDisplayValue);
        tOCNode.setX(this.x);
        tOCNode.setY(this.y);
        tOCNode.setObjType(this.objType);
        int n = this.getNodeCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                TOCNode tOCNode2 = new TOCNode();
                tOCNode.add(((TOCNode)this.getNode(i)).dup(tOCNode2));
            }
        }
        return tOCNode;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setTempXY(int n, int n2) {
        this.tempXY = new Vector();
        if (this.tempXY != null) {
            int[] nArray = new int[]{n, n2};
            this.tempXY.add(nArray);
        }
    }

    private int[] SEDU() {
        int[] nArray = new int[2];
        if (this.tempXY != null && this.tempXY.size() != 0) {
            nArray = (int[])this.tempXY.elementAt(0);
        }
        return nArray;
    }

    public int getObjType() {
        return this.objType;
    }

    public void setObjType(int n) {
        this.objType = n;
    }

    public static void output(DataOutput dataOutput, TOCNode tOCNode) throws IOException {
        RandomAccessStream randomAccessStream = new RandomAccessStream(255);
        tOCNode.output(dataOutput, randomAccessStream);
        randomAccessStream.close();
    }

    public void setXY(int n, int n2) {
        if (this.firstLayout) {
            this.x = n;
            this.y = n2;
            this.firstLayout = false;
        }
        this.layoutTimeX = n;
        this.layoutTimeY = n2;
    }

    public int getLayoutTimeX() {
        return this.layoutTimeX;
    }

    public int getLayoutTimeY() {
        return this.layoutTimeY;
    }

    public void setIsFirstLayout(boolean bl) {
        this.firstLayout = bl;
    }

    public void updataChildrenNodeXY(int n, int n2) {
        this.x += n;
        this.y += n2;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            ((TOCNode)this.getNode(i)).updataChildrenNodeXY(n, n2);
        }
    }

    public void refreshDSY(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult != null && this.objType != 262177) {
            int[] nArray = new int[2];
            int n2 = this.close(jRVisiableResult);
            if (n2 == 0) {
                nArray = this.anchor(jRVisiableResult);
            }
            this.x = jRVisiableResult.getX() + nArray[0];
            this.y = n2 > 0 ? jRVisiableResult.getY() + n2 + n : jRVisiableResult.getY() + nArray[1] + this.y;
        } else {
            this.y = jRVisiableResult == null && this.getParent() != null && (this.objType == 45 || this.objType == 44) ? (this.y += n) : (this.y += n);
        }
    }

    public void refreshCurrentPageNode(int n) {
        this.dsObj = null;
        this.add();
        this.length = this.getNodeCount();
        for (int i = 0; i < this.length; ++i) {
            TOCNode tOCNode = (TOCNode)this.getNode(i);
            tOCNode.refreshCurrentPageNode(n);
        }
    }

    private void add() {
        int n = this.getNodeCount();
        int n2 = 0;
        int n3 = 0;
        if (this.add >= n) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            TOCNode tOCNode = (TOCNode)this.getNode(i);
            if (tOCNode.getNodeDisplayValue() != null && (tOCNode.getNodeDisplayValue() == null || !tOCNode.getNodeDisplayValue().equals(""))) continue;
            n3 = i;
            this.SEDU = true;
            break;
        }
        if (this.SEDU) {
            int n4;
            Vector<Integer> vector = new Vector<Integer>();
            for (n4 = n3; n4 < n; ++n4) {
                TOCNode tOCNode = (TOCNode)this.getNode(n4);
                if (tOCNode.getNodeDisplayValue() != null && (tOCNode.getNodeDisplayValue() == null || !tOCNode.getNodeDisplayValue().equals(""))) continue;
                ++n2;
                vector.add(n4);
            }
            for (n4 = 0; n4 < n2; ++n4) {
                this.remove((TOCNode)this.getNode((Integer)vector.get(n4) - n4));
            }
            this.SEDU = false;
        }
        this.add = this.getNodeCount();
    }

    private int[] anchor(JRVisiableResult jRVisiableResult) {
        int[] nArray = new int[2];
        if (jRVisiableResult.getParent() != null && jRVisiableResult.getObjectType() != 262177 && !(jRVisiableResult.getParent() instanceof DSPage)) {
            int[] nArray2 = new int[2];
            nArray2 = this.anchor((JRVisiableResult)((Object)jRVisiableResult.getParent()));
            nArray[0] = ((JRVisiableResult)((Object)jRVisiableResult.getParent())).getX() + nArray2[0];
            nArray[1] = ((JRVisiableResult)((Object)jRVisiableResult.getParent())).getY() + nArray2[1];
        }
        return nArray;
    }

    private int close(JRVisiableResult jRVisiableResult) {
        int n = 0;
        if (jRVisiableResult.getParent() != null && jRVisiableResult.getParent() instanceof DSSection) {
            JRObjectResult jRObjectResult = null;
            DSPage dSPage = null;
            if (((DSSection)jRVisiableResult.getParent()).getParent() != null) {
                if (!(((DSSection)jRVisiableResult.getParent()).getParent() instanceof DSPage)) {
                    jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult.getParent()).getParent());
                } else {
                    dSPage = (DSPage)((DSSection)jRVisiableResult.getParent()).getParent();
                }
            }
            int n2 = 0;
            int n3 = 0;
            DSSubReport dSSubReport = (DSSubReport)jRObjectResult;
            if (dSSubReport != null) {
                if (dSSubReport.getChildren() != null) {
                    n2 = dSSubReport.getChildren().size();
                }
                n3 = dSSubReport.getY();
            }
            Object object = null;
            for (int i = 0; i < n2 && !(object = (Object)dSSubReport.getChildren().get(i)).equals(jRVisiableResult.getParent()); ++i) {
                boolean bl;
                DSContainer dSContainer;
                if (object instanceof DSSection) {
                    dSContainer = (DSSection)object;
                    bl = dSContainer.getTemplate().getInvisible(dSContainer);
                    if (bl) continue;
                    n3 += dSContainer.getHeight();
                    continue;
                }
                if (!(object instanceof DSSubReport) || (bl = (dSContainer = (DSSubReport)object).getTemplate().getInvisible(dSContainer))) continue;
                n3 += dSContainer.getHeight();
            }
            if (dSPage != null) {
                n3 = ((DSSection)jRVisiableResult.getParent()).getY();
            }
            n = n3;
            if (jRObjectResult != null && jRObjectResult.getObjectType() != 262177) {
                n += this.close((JRVisiableResult)jRObjectResult);
            }
        }
        return n;
    }

    public void setIsRefreshAllNode(boolean bl) {
        this.needRefresh = bl;
        int n = this.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ((TOCNode)this.getNode(i)).setIsRefreshAllNode(bl);
        }
    }

    public void updataAllNodePageNum(int n) {
        this.page = n;
        int n2 = this.getNodeCount();
        for (int i = 0; i < n2; ++i) {
            ((TOCNode)this.getNode(i)).updataAllNodePageNum(n);
        }
    }
}

