/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import barcode.BarcodeConstants;
import barcode.linearBarcode.BarcodeConstraints;
import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.awt.Image;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbReal;
import jet.connect.DbValue;
import jet.datastream.Communicator;
import jet.datastream.DSDBField;
import jet.datastream.DSField;
import jet.datastream.DSParameterField;
import jet.datastream.ImgInfo;
import jet.datastream.JRObjectResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderButton;
import jet.datastream.render.RenderCheckBox;
import jet.datastream.render.RenderDateInput;
import jet.datastream.render.RenderDateInputDropdown;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderHidden;
import jet.datastream.render.RenderImage;
import jet.datastream.render.RenderImageButton;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderMultipleValuesSelect;
import jet.datastream.render.RenderRadioButton;
import jet.datastream.render.RenderRank;
import jet.datastream.render.RenderResetButton;
import jet.datastream.render.RenderSubmitButton;
import jet.datastream.render.RenderText;
import jet.datastream.render.RenderTextArea;
import jet.datastream.render.RenderTextField;
import jet.datastream.render.RenderUtil;
import jet.naming.PropertyNames;
import jet.util.ImageListPropertiable;
import jet.util.JRInterruptedException;
import jet.util.Propertiable;
import jet.util.image.ImageProviderFactory;
import jet.util.image.ImageResource;
import jet.util.nls.INLSMap;
import jet.util.nls.NLSFontValue;

public class RenderCreator {
    public static final int TEXT = 0;
    public static final int RANK = 1;
    public static final int BARCODE = 2;
    public static final int IMAGE = 3;
    public static final int TEXTFIELD = 4;
    public static final int TEXTAREA = 5;
    public static final int CHECKBOX = 6;
    public static final int RADIOBUTTON = 7;
    public static final int LIST = 8;
    public static final int DROPDOWNLIST = 9;
    public static final int IMAGEBUTTON = 10;
    public static final int BUTTON = 11;
    public static final int SUBMIT_BUTTON = 12;
    public static final int RESET_BUTTON = 13;
    public static final int HIDDEN = 14;
    public static final int RENDER_ADAPTIT = 15;
    public static final int DATE_INPUT = 17;
    public static final int MULTIPLE_VALUES_SELECT = 18;
    public static final int DATE_INPUT_DROPDOWN = 19;
    public static final int DEFAULT_SHADOW_WIDTH = Unit.convertInchToUnit(0.045777);

    public static Render createConcreteRender(int n, DSField dSField) {
        Render render = null;
        switch (n) {
            case 0: {
                render = new RenderText(dSField);
                break;
            }
            case 1: {
                render = new RenderRank(dSField);
                break;
            }
            case 2: {
                render = new RenderBarCode(dSField);
                break;
            }
            case 3: {
                render = new RenderImage(dSField);
                break;
            }
            case 4: {
                render = new RenderTextField(dSField);
                break;
            }
            case 6: {
                render = new RenderCheckBox(dSField);
                break;
            }
            case 7: {
                render = new RenderRadioButton(dSField);
                break;
            }
            case 11: {
                render = new RenderButton(dSField);
                break;
            }
            case 5: {
                render = new RenderTextArea(dSField);
                break;
            }
            case 10: {
                render = new RenderImageButton(dSField);
                break;
            }
            case 8: {
                render = new RenderList(dSField);
                break;
            }
            case 9: {
                render = new RenderDropDownList(dSField);
                break;
            }
            case 19: {
                render = new RenderDateInputDropdown(dSField);
                break;
            }
            case 12: {
                render = new RenderSubmitButton(dSField);
                break;
            }
            case 13: {
                render = new RenderResetButton(dSField);
                break;
            }
            case 14: {
                render = new RenderHidden(dSField);
                break;
            }
            case 17: {
                render = new RenderDateInput(dSField);
                break;
            }
            case 18: {
                render = new RenderMultipleValuesSelect(dSField);
                break;
            }
        }
        if (render != null) {
            RenderCreator.BUILTINTYPES(render, dSField, n);
            if (!dSField.isParagraphField()) {
                render.locate();
            }
            render.setType(n);
        }
        return render;
    }

    private static void BUILTINTYPES(Render render, DSField dSField, int n) {
        RenderCreator.setCommonRenderProperteis(render, dSField);
        switch (n) {
            case 0: {
                RenderCreator.convertInchToUnit(render, dSField);
                break;
            }
            case 1: {
                RenderCreator.convertUnitToPixel(render, dSField);
                break;
            }
            case 2: {
                RenderCreator.convertPixelToUnit(render, dSField);
                break;
            }
            case 3: {
                RenderCreator.createDefaultImageProvider(render, dSField);
                break;
            }
            case 4: 
            case 14: 
            case 17: {
                RenderCreator.doubleValue(render, dSField);
                break;
            }
            case 6: {
                RenderCreator.floatValue(render, dSField);
                break;
            }
            case 7: {
                RenderCreator.get(render, dSField);
                break;
            }
            case 11: {
                RenderCreator.error(render, dSField);
                break;
            }
            case 5: {
                RenderCreator.getBarCode(render, dSField);
                break;
            }
            case 10: {
                RenderCreator.checkConditionNLS(render, dSField);
                break;
            }
            case 8: {
                RenderCreator.booleanValue(render, dSField);
                break;
            }
            case 9: {
                RenderCreator.SEDU(render, dSField);
                break;
            }
            case 19: {
                RenderCreator.add(render, dSField);
                break;
            }
            case 18: {
                RenderCreator.DEFAULT_SHADOW_WIDTH(render, dSField);
                break;
            }
            case 12: {
                RenderCreator.getBooleanPropertyByName(render, dSField);
                break;
            }
            case 13: {
                RenderCreator.getCommunicator(render, dSField);
            }
        }
    }

    private static void DEFAULT_SHADOW_WIDTH(Render render, DSField dSField) {
        if (dSField instanceof DSParameterField) {
            int n;
            Vector vector = ((DSParameterField)dSField).getTexts();
            Vector vector2 = ((DSParameterField)dSField).getValues();
            Vector vector3 = ((DSParameterField)dSField).getSelectedValues();
            Vector<String> vector4 = new Vector<String>();
            String string = "";
            String string2 = "";
            if (vector3 != null && !((DSParameterField)dSField).isShowAll() && (n = vector3.size()) > 0) {
                for (int i = 0; i < n; ++i) {
                    string2 = (String)vector3.get(i);
                    int n2 = vector2.indexOf(string2);
                    if (n2 != -1) {
                        vector4.add((String)vector.get(n2));
                        continue;
                    }
                    vector4.add(string2);
                }
            }
            ((RenderMultipleValuesSelect)render).setTexts(vector);
            ((RenderMultipleValuesSelect)render).setValues(vector2);
            ((RenderMultipleValuesSelect)render).setSelectedTexts(vector4);
            ((RenderMultipleValuesSelect)render).setSelectedValues(vector3);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(dSField.toString());
            vector.add("1998");
            vector.add("1998");
            vector.add("1998");
            ((RenderMultipleValuesSelect)render).setTexts(vector);
            ((RenderMultipleValuesSelect)render).setFont(new Font("Default", 1, 10));
        }
    }

    private static void SEDU(Render render, DSField dSField) {
        if (dSField instanceof DSParameterField) {
            int n;
            Vector vector = ((DSParameterField)dSField).getTexts();
            Vector vector2 = ((DSParameterField)dSField).getValues();
            Vector vector3 = ((DSParameterField)dSField).getSelectedValues();
            String string = "";
            String string2 = "";
            if (vector3.size() > 0) {
                string2 = (String)vector3.get(0);
            }
            if ((n = vector2.indexOf(string2)) != -1) {
                string = (String)vector.get(n);
            } else if (vector.size() > 0 && vector2.size() > 0) {
                string = (String)vector.get(0);
                string2 = (String)vector2.get(0);
            }
            ((RenderDropDownList)render).setTexts(vector);
            ((RenderDropDownList)render).setValues(vector2);
            ((RenderDropDownList)render).setSelectedTexts(string);
            ((RenderDropDownList)render).setSelectedValues(string2);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(dSField.toString());
            vector.add("1998");
            vector.add("1998");
            vector.add("1998");
            ((RenderDropDownList)render).setTexts(vector);
            ((RenderDropDownList)render).setFont(new Font("Default", 1, 10));
        }
    }

    private static void add(Render render, DSField dSField) {
        if (dSField instanceof DSParameterField) {
            int n;
            Vector vector = ((DSParameterField)dSField).getTexts();
            Vector vector2 = ((DSParameterField)dSField).getValues();
            Vector vector3 = ((DSParameterField)dSField).getSelectedValues();
            String string = "";
            String string2 = "";
            if (vector3.size() > 0) {
                string2 = (String)vector3.get(0);
            }
            if ((n = vector2.indexOf(string2)) != -1) {
                string = (String)vector.get(n);
            } else if (vector.size() > 0 && vector2.size() > 0) {
                string = (String)vector.get(0);
                string2 = (String)vector2.get(0);
            }
            ((RenderDateInputDropdown)render).setTexts(vector);
            ((RenderDateInputDropdown)render).setValues(vector2);
            ((RenderDateInputDropdown)render).setSelectedTexts(string);
            ((RenderDateInputDropdown)render).setSelectedValues(string2);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(dSField.toString());
            vector.add("1998");
            vector.add("1998");
            vector.add("1998");
            ((RenderDateInputDropdown)render).setTexts(vector);
            ((RenderDateInputDropdown)render).setFont(new Font("Default", 1, 10));
        }
    }

    private static void booleanValue(Render render, DSField dSField) {
        if (dSField instanceof DSParameterField) {
            Vector vector = ((DSParameterField)dSField).getTexts();
            Vector vector2 = ((DSParameterField)dSField).getValues();
            Vector<String> vector3 = new Vector<String>();
            String string = "";
            Vector vector4 = ((DSParameterField)dSField).getSelectedValues();
            for (int i = 0; i < vector4.size(); ++i) {
                string = (String)vector4.get(i);
                int n = vector2.indexOf(string);
                if (n == -1) continue;
                String string2 = (String)vector.get(n);
                if (string2 == null) {
                    string2 = "";
                }
                vector3.add(string2);
                ((RenderList)render).setIndex(n);
            }
            ((RenderList)render).setSelectedText(vector3);
            ((RenderList)render).setTexts(vector);
            ((RenderList)render).setValues(vector2);
            ((RenderList)render).setSelectedValues(vector4);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(dSField.toString());
            vector.add("1998");
            vector.add("1998");
            vector.add("1998");
            ((RenderList)render).setTexts(vector);
        }
    }

    private static void checkConditionNLS(Render render, DSField dSField) {
        boolean bl = (Boolean)dSField.getPropertyByName("FromURL").getObject();
        ((RenderImageButton)render).setFromURL((Boolean)dSField.getPropertyByName("FromURL").getObject());
        ((RenderImageButton)render).setWidth((Integer)dSField.getPropertyByName("Image_Display_Width").getObject());
        ((RenderImageButton)render).setHeight((Integer)dSField.getPropertyByName("Image_Display_Height").getObject());
        ((RenderImageButton)render).setOriginalSize((Boolean)dSField.getPropertyByName("Original_Size").getObject());
        ((RenderImageButton)render).setScaleMode((Integer)dSField.getPropertyByName("ScalingMode").getObject());
        ((RenderImageButton)render).setMaxRatio(((Number)dSField.getPropertyByName("MaxScalingRatio").getObject()).floatValue());
        if (bl) {
            ImageResource imageResource = dSField.getImgResourceByPropertyName("Src");
            ((RenderImageButton)render).setImageResource(imageResource);
        } else if (dSField instanceof DSDBField) {
            DbValue dbValue = ((DSDBField)dSField).getValue();
            ((RenderImageButton)render).setValue(dbValue);
        } else if (JRLog.isError(3)) {
            JRLog.error(3, 3300017);
        }
    }

    private static void convertInchToUnit(Render render, DSField dSField) {
        block4: {
            try {
                render.setTopPadding(((Number)RenderUtil.getPropertyByName(dSField, PropertyNames.getDefinitionName(PropertyNames.padding_top))).intValue());
                render.setBottomPadding(((Number)RenderUtil.getPropertyByName(dSField, PropertyNames.getDefinitionName(PropertyNames.padding_bottom))).intValue());
                render.setLeftPadding(((Number)RenderUtil.getPropertyByName(dSField, PropertyNames.getDefinitionName(PropertyNames.padding_left))).intValue());
                render.setRightPadding(((Number)RenderUtil.getPropertyByName(dSField, PropertyNames.getDefinitionName(PropertyNames.padding_right))).intValue());
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "get JRInterruptedException ", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(3)) break block4;
                JRLog.error(3, 3300018);
            }
        }
        ((RenderText)render).setText(dSField.toString());
        ((RenderText)render).setStartLine(dSField.getStartLine());
        ((RenderText)render).setEndLine(dSField.getEndLine());
        ((RenderText)render).setLineBreakPos(dSField.getLineBreakPos());
    }

    private static void convertPixelToUnit(Render render, DSField dSField) {
        BarcodeConstraints barcodeConstraints;
        block9: {
            barcodeConstraints = ((RenderBarCode)render).getBarCode();
            barcodeConstraints.setBarHRFont(render.getFont());
            barcodeConstraints.setBarHeight(((Integer)dSField.getPropertyByName("BarHeight").getObject()).shortValue());
            barcodeConstraints.setBarNarrowWidth(((Integer)dSField.getPropertyByName("NarrowWidth").getObject()).shortValue());
            barcodeConstraints.setBarHRDisplay((Boolean)dSField.getPropertyByName("HRDisplay").getObject());
            try {
                barcodeConstraints.setBarRatio(((Number)dSField.getPropertyByName("Ratio").getObject()).floatValue());
                barcodeConstraints.setBarCheckEnable((Boolean)dSField.getPropertyByName("CheckEnable").getObject());
                barcodeConstraints.setBarQuietZone(((Integer)dSField.getPropertyByName("QuietZone").getObject()).shortValue());
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "get JRInterruptedException ", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isTrace(3)) break block9;
                JRLog.trace(3, "setRenderBarCodeProperties get error ", (Throwable)exception);
            }
        }
        int n = (Integer)dSField.getPropertyByName("Symbology").getObject();
        if (n >= BarcodeConstants.BUILTINTYPES.length) {
            barcodeConstraints.setBarSymbology(5);
            barcodeConstraints.setBar128Type(n - BarcodeConstants.BUILTINTYPES.length);
        } else {
            barcodeConstraints.setBarSymbology(n);
        }
        if (n == 5) {
            barcodeConstraints.setBarSymbology(5);
            barcodeConstraints.setBar128Type(3);
        }
        barcodeConstraints.setBarSupplement((String)dSField.getPropertyByName("Supplement").getObject());
        barcodeConstraints.setBarScaleMode((Integer)dSField.getPropertyByName("ScaleMode").getObject());
        int n2 = (Integer)dSField.getPropertyByName("Orientation").getObject();
        barcodeConstraints.setBarOrientation(n2);
        ((RenderBarCode)render).setOrientation(n2);
        boolean bl = (Boolean)dSField.getPropertyByName("UseDefaultMessage").getObject();
        if (bl) {
            barcodeConstraints.setBarMessage((String)dSField.getPropertyByName("Message").getObject());
        } else {
            barcodeConstraints.setBarMessage(dSField.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void convertUnitToPixel(Render render, DSField dSField) {
        List<ImageResource> list;
        Object object;
        Object object2;
        Vector vector = (Vector)dSField.getPropertyByName("MaxValueVector").getObject();
        Vector vector2 = (Vector)dSField.getPropertyByName("MinValueVector").getObject();
        int n = vector == null ? 0 : vector.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
            dArray2[i] = Double.parseDouble((String)vector2.get(i));
        }
        ((RenderRank)render).setMaxValue(dArray);
        ((RenderRank)render).setMinValue(dArray2);
        ImageResource imageResource = dSField.getImgResourceByPropertyName("DefaultImagePath");
        ((RenderRank)render).setDefImgType(imageResource.getImageType());
        ImgInfo imgInfo = dSField.getImgInfo();
        if (imgInfo.isWithPath()) {
            object2 = new File(imgInfo.getImgPath());
            try {
                object = ImageProviderFactory.createDefaultImageProvider((File)object2, dSField.getCommunicator().getDataStream(0).getResourceStore().getMemoryStore());
                list = object.getImageResources((ImageListPropertiable)dSField.getPropertyByName("ImagePathVector"));
            }
            catch (JRStopEngineException jRStopEngineException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, jRStopEngineException);
                }
                list = null;
            }
        } else {
            list = ((ImageListPropertiable)dSField.getPropertyByName("ImagePathVector")).getImageResourcesByID(imgInfo.getImgScopeId());
        }
        object2 = (String)dSField.getPropertyByName("DefaultName").getObject();
        object = (Vector)dSField.getPropertyByName("NameVector").getObject();
        double d = 0.0;
        Vector vector3 = null;
        String string = "";
        Vector vector4 = null;
        if (dSField.getPropertyByName("DefaultRotate") != null) {
            d = ((Number)dSField.getPropertyByName("DefaultRotate").getObject()).floatValue();
        }
        if (dSField.getPropertyByName("ImageRotateVector") != null) {
            vector3 = (Vector)dSField.getPropertyByName("ImageRotateVector").getObject();
        }
        if (dSField.getPropertyByName("DefaultTitle") != null) {
            string = (String)dSField.getPropertyByName("DefaultTitle").getObject();
        }
        if (dSField.getPropertyByName("ImageTitleVector") != null) {
            vector4 = (Vector)dSField.getPropertyByName("ImageTitleVector").getObject();
        }
        Image[] imageArray = null;
        int[] nArray = null;
        if (list != null) {
            n = list.size();
            imageArray = new Image[n];
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                imageArray[i] = list.get(i).getImage();
                nArray[i] = imageArray[i] != null ? list.get(i).getImageType() : -100;
            }
        }
        String[] stringArray = null;
        if (object != null) {
            n = ((Vector)object).size();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((String)((Vector)object).get(i)).trim();
            }
        }
        String[] stringArray2 = null;
        double[] dArray3 = null;
        if (vector3 != null) {
            n = vector3.size();
            stringArray2 = new String[n];
            dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = ((String)vector3.get(i)).trim();
                dArray3[i] = Double.parseDouble(stringArray2[i]);
            }
        }
        String[] stringArray3 = null;
        if (vector4 != null) {
            n = vector4.size();
            stringArray3 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray3[i] = ((String)vector4.get(i)).trim();
            }
        }
        ((RenderRank)render).setScopeImages(imageArray);
        ((RenderRank)render).setScopeImagesType(nArray);
        ((RenderRank)render).setDefImg(imageResource.getImage());
        ((RenderRank)render).setDefImageAlt((String)object2);
        ((RenderRank)render).setImageAlts(stringArray);
        ((RenderRank)render).setRotation(d);
        ((RenderRank)render).setImageRankRotate(dArray3);
        ((RenderRank)render).setImageRankTitles(stringArray3);
        ((RenderRank)render).setDefImageTitle(string);
        if (dSField instanceof DSDBField) {
            DbValue dbValue = ((DSDBField)dSField).getValue();
            if (dbValue != null && !dbValue.isNull() && dbValue instanceof DbNumber) {
                ((RenderRank)render).setValue(((DbNumber)dbValue).doubleValue());
                return;
            } else {
                if (!JRLog.isTrace(6)) return;
                JRLog.trace(6, 6300065);
            }
            return;
        } else if (dSField instanceof DSParameterField) {
            DbNumber dbNumber = null;
            Object e = ((DSParameterField)dSField).getSelectedValues().get(0);
            if (e instanceof Number) {
                dbNumber = e instanceof Integer ? new DbInteger() : (e instanceof Float ? new DbReal() : new DbDouble());
                dbNumber.setValue(e.toString());
                ((RenderRank)render).setValue(((DbNumber)dbNumber).doubleValue());
                return;
            } else if (e instanceof String) {
                double d2 = -1.0;
                try {
                    d2 = Double.parseDouble((String)e);
                    dbNumber = new DbDouble();
                    dbNumber.setValue(e.toString());
                    ((RenderRank)render).setValue(dbNumber.doubleValue());
                    return;
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (!JRLog.isError(2)) throw jRInterruptedException;
                    JRLog.error(2, "get JRInterruptedException ", (Throwable)jRInterruptedException);
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    if (!JRLog.isTrace(6)) return;
                    JRLog.trace(6, 6300065);
                    return;
                }
            } else {
                if (!JRLog.isTrace(6)) return;
                JRLog.trace(6, 6300065);
            }
            return;
        } else {
            if (!JRLog.isTrace(6)) return;
            JRLog.trace(6, 6300066);
        }
    }

    private static void createDefaultImageProvider(Render render, DSField dSField) {
        boolean bl = (Boolean)dSField.getPropertyByName("FromURL").getObject();
        ((RenderImage)render).setFromURL(bl);
        ((RenderImage)render).setWidth((Integer)dSField.getPropertyByName("Image_Display_Width").getObject());
        ((RenderImage)render).setHeight((Integer)dSField.getPropertyByName("Image_Display_Height").getObject());
        ((RenderImage)render).setOriginalSize((Boolean)dSField.getPropertyByName("Original_Size").getObject());
        ((RenderImage)render).setScaleMode((Integer)dSField.getPropertyByName("ScalingMode").getObject());
        ((RenderImage)render).setMaxRatio(((Number)dSField.getPropertyByName("MaxScalingRatio").getObject()).floatValue());
        ((RenderImage)render).setRotation(((Number)dSField.getPropertyByName("Rotation").getObject()).floatValue());
        if (bl) {
            ImageResource imageResource = dSField.getImgResourceByPropertyName("Src");
            if (imageResource.getImage() != null) {
                ((RenderImage)render).setImageResource(imageResource);
            }
        } else if (dSField instanceof DSDBField) {
            DbValue dbValue = ((DSDBField)dSField).getValue();
            ((RenderImage)render).setValue(dbValue);
        } else if (JRLog.isError(3)) {
            JRLog.error(3, 3300017);
        }
    }

    private static void doubleValue(Render render, DSField dSField) {
        String string;
        boolean bl = false;
        Propertiable propertiable = dSField.getPropertyByName("WebValue");
        if (propertiable != null && (string = (String)propertiable.getObject()) != null && string.length() > 0) {
            bl = true;
            render.setText(string);
        }
        if (!bl) {
            render.setText(dSField.toString());
        }
    }

    private static void error(Render render, DSField dSField) {
        String string;
        boolean bl = false;
        Propertiable propertiable = dSField.getPropertyByName("WebValue");
        if (propertiable != null && (string = (String)propertiable.getObject()) != null && string.length() > 0) {
            bl = true;
            render.setText(string);
        }
        if (!bl) {
            ((RenderButton)render).setText(dSField.toString());
        }
        ((RenderButton)render).setDisabled((Boolean)dSField.getPropertyByName("Disabled").getObject());
    }

    private static void floatValue(Render render, DSField dSField) {
        render.setResolution(96);
        ((RenderCheckBox)render).setChecked((Boolean)dSField.getPropertyByName("Check_Condition").getObject());
        ((RenderCheckBox)render).setText(dSField.toString());
    }

    private static void get(Render render, DSField dSField) {
        render.setResolution(96);
        ((RenderRadioButton)render).setChecked((Boolean)dSField.getPropertyByName("Check_Condition").getObject());
        ((RenderRadioButton)render).setText(dSField.toString());
    }

    private static void getBarCode(Render render, DSField dSField) {
        String string;
        boolean bl = false;
        Propertiable propertiable = dSField.getPropertyByName("WebValue");
        if (propertiable != null && (string = (String)propertiable.getObject()) != null && string.length() > 0) {
            bl = true;
            render.setText(string);
        }
        if (!bl) {
            render.setText(dSField.toString());
        }
    }

    private static void getBooleanPropertyByName(Render render, DSField dSField) {
        ((RenderButton)render).setText(dSField.toString());
        ((RenderButton)render).setDisabled((Boolean)dSField.getPropertyByName("Disabled").getObject());
    }

    private static void getCommunicator(Render render, DSField dSField) {
        ((RenderButton)render).setText(dSField.toString());
        ((RenderButton)render).setDisabled((Boolean)dSField.getPropertyByName("Disabled").getObject());
    }

    public static void setCommonRenderProperteis(Render render, DSField dSField) {
        INLSMap iNLSMap;
        int n;
        int n2;
        int n3 = ((JRObjectResult)dSField).getResolution();
        render.setResolution(n3);
        render.setBorderWidth(RenderUtil.getIntPropertyByName(dSField, "BorderWidth"));
        render.setLeftStyle(RenderUtil.getIntPropertyByName(dSField, "LeftLine"));
        render.setRightStyle(RenderUtil.getIntPropertyByName(dSField, "RightLine"));
        render.setTopStyle(RenderUtil.getIntPropertyByName(dSField, "TopLine"));
        render.setBottomStyle(RenderUtil.getIntPropertyByName(dSField, "BottomLine"));
        render.setShadow(RenderUtil.getBooleanPropertyByName(dSField, "Shadow"));
        if (render.isShadow()) {
            render.setShadowWidth(DEFAULT_SHADOW_WIDTH);
        }
        String string = RenderUtil.getStringPropertyByName(dSField, "FontFace");
        int n4 = 0;
        if (RenderUtil.getBooleanPropertyByName(dSField, "Bold")) {
            n4 |= 1;
        }
        if (RenderUtil.getBooleanPropertyByName(dSField, "Italic")) {
            n4 |= 2;
        }
        float f = RenderUtil.getIntPropertyByName(dSField, "FontSize");
        float f2 = Unit.convertUnitToPixel(f, n3);
        if (n3 == 60) {
            if (f2 > (float)((int)f2)) {
                f2 += 1.0f;
            }
            if ((n2 = RenderGraphicsToolkit.checkConditionNLS(dSField)) != 0) {
                n = dSField.getSubIdxOfRpt();
                if (n < 0) {
                    n = 0;
                }
                iNLSMap = null;
                Communicator communicator = dSField.getCommunicator();
                if (communicator != null) {
                    NLSFontValue nLSFontValue;
                    Hashtable<Integer, INLSMap> hashtable = dSField.getCommunicator().getINLSMaps();
                    if (hashtable != null) {
                        iNLSMap = hashtable.get(n);
                    }
                    if (iNLSMap != null && (nLSFontValue = iNLSMap.getFontValue(string, Unit.convertUnitToPixel(f, 72))) != null && !nLSFontValue.isEmptyValue()) {
                        string = nLSFontValue.getFontName();
                        f = (int)Unit.convertPixelToUnit(nLSFontValue.getFontSize(), 72);
                        f2 = Unit.convertUnitToPixel(f, n3);
                    }
                }
            }
            render.setFont(RenderGraphicsToolkit.getFont(string, n4, (int)f2));
        } else {
            if (dSField.getRenderType() == 0 && !((RenderText)render).isPrecision()) {
                f2 = Math.round(f2);
            }
            if ((n2 = RenderGraphicsToolkit.checkConditionNLS(dSField)) != 0) {
                n = dSField.getSubIdxOfRpt();
                if (n < 0) {
                    n = 0;
                }
                iNLSMap = null;
                Communicator communicator = dSField.getCommunicator();
                if (communicator != null) {
                    NLSFontValue nLSFontValue;
                    Hashtable<Integer, INLSMap> hashtable = dSField.getCommunicator().getINLSMaps();
                    if (hashtable != null) {
                        iNLSMap = hashtable.get(n);
                    }
                    if (iNLSMap != null && (nLSFontValue = iNLSMap.getFontValue(string, Unit.convertUnitToPixel(f, 72))) != null && !nLSFontValue.isEmptyValue()) {
                        string = nLSFontValue.getFontName();
                        f = (int)Unit.convertPixelToUnit(nLSFontValue.getFontSize(), 72);
                        f2 = Unit.convertUnitToPixel(f, n3);
                    }
                }
            }
            render.setFont(RenderGraphicsToolkit.getFont(string, n4, f2));
        }
        try {
            n2 = ((Number)RenderUtil.getPropertyByName(dSField, "HorizontalAlignment")).intValue();
            n = ((Number)RenderUtil.getPropertyByName(dSField, "VerticalAlignment")).intValue();
            int n5 = RenderUtil.parseAlignment(n2, n);
            render.setLayout(n5);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "get JRInterruptedException ", (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            render.setLayout(RenderUtil.getIntPropertyByName(dSField, "Alignment"));
        }
        render.setWordwrap(RenderUtil.getBooleanPropertyByName(dSField, "WordWrap"));
        if (dSField.getTemplate().getPropertyByName("AutoFit") == null) {
            render.setAutoFit(false);
        } else {
            render.setAutoFit(RenderUtil.getBooleanPropertyByName(dSField, "AutoFit"));
        }
    }

    private static float getDataStream(float f) {
        int n = 40;
        float f2 = 0.0f;
        f2 = f % 80.0f > (float)n ? f + (80.0f - f % 80.0f) : f - f % 80.0f;
        return f2;
    }
}

