/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import jet.datastream.DSField;
import jet.datastream.DSFilterControl;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.render.Render;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;
import jet.util.IntVector;

public class RenderList
extends Render {
    private Vector DEFAULT_SHADOW_WIDTH;
    private Vector I;
    private Vector SEDU;
    private Vector addElement;
    private boolean black;
    private Color booleanValue = Color.white;
    private Color convertPixelToUnit = Color.black;
    private IntVector convertUnitToPixel = new IntVector();
    private DSMultiValueContainer drawBorder;
    private DSFilterControl fillRect;

    public RenderList(DSField dSField) {
        this.dsField = dSField;
        this.resolution = dSField.getResolution();
    }

    public RenderList(DSMultiValueContainer dSMultiValueContainer) {
        this.drawBorder = dSMultiValueContainer;
        this.resolution = dSMultiValueContainer.getResolution();
    }

    public RenderList(DSFilterControl dSFilterControl) {
        this.fillRect = dSFilterControl;
        this.resolution = dSFilterControl.getResolution();
    }

    @Override
    protected void calculateAutoSize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.DEFAULT_SHADOW_WIDTH.size(); ++i) {
            int n3 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(i), this.font).getWidth(), this.resolution) + 4;
            int n4 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(i), this.font).getHeight(), this.resolution) + 4;
            if (n < n3) {
                n = n3;
            }
            n2 += n4;
        }
        this.width = n;
        this.height = n2;
    }

    @Override
    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = new Color(200, 200, 200);
        Color color2 = null;
        int n5 = -1;
        int n6 = 0;
        String string = "";
        boolean bl = false;
        if (this.drawBorder != null) {
            this.convertPixelToUnit = RenderUtil.getColorPropertyByName(this.drawBorder, "Foreground");
            this.booleanValue = RenderUtil.getColorPropertyByName(this.drawBorder, "Background");
        } else if (this.fillRect != null) {
            this.convertPixelToUnit = RenderUtil.getColorPropertyByName(this.fillRect, "Foreground");
            this.booleanValue = RenderUtil.getColorPropertyByName(this.fillRect, "Background");
            color = new Color(16758122);
            if (this.fillRect.isShowTitle()) {
                string = this.fillRect.getTitleText();
                n6 = Unit.convertUnitToPixel(this.fillRect.getTitleHeight());
                Color color3 = (Color)this.fillRect.getPropertyByName("TitleBackground").getObject();
                Color color4 = (Color)this.fillRect.getPropertyByName("TitleForeground").getObject();
                Font font = this.fillRect.getTitleFont();
                n5 = Unit.convertUnitToPixel((Integer)this.fillRect.getPropertyByName("BorderWidth").getObject());
                color2 = (Color)this.fillRect.getPropertyByName("BorderColor").getObject();
                boolean bl2 = RenderUtil.getBooleanPropertyByName(this.fillRect, "TitleUnderline");
                RenderGraphicsToolkit.paintTitle(string, graphics, color3, color4, font, new Rectangle(n, n2, n3, n6), bl2);
            }
            bl = RenderUtil.getBooleanPropertyByName(this.fillRect, "Underline");
        }
        RenderGraphicsToolkit.paintList(graphics, this.DEFAULT_SHADOW_WIDTH, this.convertUnitToPixel, this.font, n, n2 + n6, n3, n4 - n6, this.black, this.convertPixelToUnit, this.booleanValue, color, this.SEDU, n5, color2, bl);
        this.DEFAULT_SHADOW_WIDTH(graphics);
    }

    private void DEFAULT_SHADOW_WIDTH(Graphics graphics) {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Color color;
        Color color2;
        Color color3;
        int n7;
        if (this.drawBorder == null && this.fillRect == null) {
            return;
        }
        Rectangle rectangle = null;
        if (this.drawBorder != null) {
            n7 = this.drawBorder.getResolution();
            rectangle = new Rectangle(0, 0, Unit.convertUnitToPixel(this.drawBorder.getWidth(), n7), Unit.convertUnitToPixel(this.drawBorder.getHeight(), n7));
            color3 = RenderUtil.getColorPropertyByName(this.drawBorder, "Background");
            color2 = RenderUtil.getColorPropertyByName(this.drawBorder, "BorderColor");
            color = RenderUtil.getColorPropertyByName(this.drawBorder, "ShadowColor");
            n6 = RenderUtil.getIntPropertyByName(this.drawBorder, "LeftLine");
            n5 = RenderUtil.getIntPropertyByName(this.drawBorder, "RightLine");
            n4 = RenderUtil.getIntPropertyByName(this.drawBorder, "TopLine");
            n3 = RenderUtil.getIntPropertyByName(this.drawBorder, "BottomLine");
            n2 = RenderUtil.getIntPropertyByName(this.drawBorder, "BorderWidth");
            n = Unit.convertUnitToPixel(RenderCreator.DEFAULT_SHADOW_WIDTH, n7);
            bl = RenderUtil.getBooleanPropertyByName(this.drawBorder, "Shadow");
        } else {
            n7 = this.fillRect.getResolution();
            rectangle = new Rectangle(0, 0, Unit.convertUnitToPixel(this.fillRect.getWidth(), n7), Unit.convertUnitToPixel(this.fillRect.getHeight(), n7));
            color3 = RenderUtil.getColorPropertyByName(this.fillRect, "Background");
            color2 = RenderUtil.getColorPropertyByName(this.fillRect, "BorderColor");
            n6 = RenderUtil.getIntPropertyByName(this.fillRect, "LeftLine");
            n5 = RenderUtil.getIntPropertyByName(this.fillRect, "RightLine");
            n4 = RenderUtil.getIntPropertyByName(this.fillRect, "TopLine");
            n3 = RenderUtil.getIntPropertyByName(this.fillRect, "BottomLine");
            n2 = RenderUtil.getIntPropertyByName(this.fillRect, "BorderWidth");
            n = Unit.convertUnitToPixel(RenderCreator.DEFAULT_SHADOW_WIDTH, n7);
            bl = this.fillRect.getPropertyByName("Shadow") != null ? (Boolean)this.fillRect.getPropertyByName("Shadow").getObject() : false;
            color = this.fillRect.getPropertyByName("ShadowColor") != null ? (Color)this.fillRect.getPropertyByName("ShadowColor").getObject() : null;
        }
        boolean bl2 = color3 != null;
        Color color4 = graphics.getColor();
        RenderGraphicsToolkit.drawBorder(graphics, rectangle, bl2 ? color3 : null, color2, Unit.convertUnitToPixel(n2, n7), n4, n3, n6, n5, bl, color, n);
        graphics.setColor(color4);
    }

    public boolean isDisabled() {
        return this.black;
    }

    public void setDisabled(boolean bl) {
        this.black = bl;
    }

    public Vector getTexts() {
        return this.DEFAULT_SHADOW_WIDTH;
    }

    public void setTexts(Vector vector) {
        this.DEFAULT_SHADOW_WIDTH = vector;
    }

    public Vector getValues() {
        return this.I;
    }

    public void setValues(Vector vector) {
        this.I = vector;
    }

    public Vector getSelectedValues() {
        return this.addElement;
    }

    public void setSelectedValues(Vector vector) {
        this.addElement = vector;
    }

    public Vector getSelectedText() {
        return this.SEDU;
    }

    public void setSelectedText(Vector vector) {
        this.SEDU = vector;
    }

    public void setIndex(int n) {
        this.convertUnitToPixel.addElement(n);
    }

    @Override
    public void paintFieldBackground(Graphics graphics) {
        if (this.drawBorder == null && this.fillRect == null) {
            super.paintFieldBackground(graphics);
        } else if (this.fillRect != null) {
            Rectangle rectangle = null;
            rectangle = new Rectangle(0, 0, Unit.convertUnitToPixel(this.fillRect.getWidth(), this.resolution), Unit.convertUnitToPixel(this.fillRect.getHeight(), this.resolution));
            Color color = RenderUtil.getColorPropertyByName(this.fillRect, "Background");
            if (color != null) {
                graphics.setColor(color);
                int n = Unit.convertUnitToPixel(this.shadowWidth, this.resolution);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - n, rectangle.height - n);
            }
        }
    }

    @Override
    protected void calculatePadding(Render.Box box) {
        box.x = 0;
        box.y = 0;
        if (this.fillRect != null) {
            box.width = this.dsFieldWidth = this.fillRect.getWidth();
            box.height = this.dsFieldHeight = this.fillRect.getHeight();
        } else {
            box.width = this.dsFieldWidth = this.dsField.getWidth();
            box.height = this.dsFieldHeight = this.dsField.getHeight();
        }
        box.x += this.leftPadding;
        box.width -= this.leftPadding + this.rightPadding;
        box.y += this.topPadding;
        box.height -= this.topPadding + this.bottomPadding;
        if (this.leftStyle != 0) {
            this.lGap = (this.leftStyle == 5 ? 3 : 1) * this.borderWidth;
            box.x += this.lGap;
            box.width -= this.lGap;
        }
        if (this.topStyle != 0) {
            this.tGap = (this.topStyle == 5 ? 3 : 1) * this.borderWidth;
            box.y += this.tGap;
            box.height -= this.tGap;
        }
        if (this.rightStyle != 0) {
            this.rGap = (this.rightStyle == 5 ? 3 : 1) * this.borderWidth;
            box.width -= this.rGap;
        }
        if (this.bottomStyle != 0) {
            this.bGap = (this.bottomStyle == 5 ? 3 : 1) * this.borderWidth;
            box.height -= this.bGap;
        }
        box.width = box.width - (this.isShadow ? this.shadowWidth : 0);
        box.height = box.height - (this.isShadow ? this.shadowWidth : 0);
    }
}

