/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import com.jinfonet.util.JRLog;
import guitools.Painter;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import jet.JResource;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.datastream.DSField;
import jet.datastream.DSSlider;
import jet.datastream.render.Render;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;

public class RenderSlider
extends Render {
    private DSSlider DEFAULT_SHADOW_WIDTH;
    private List SEDU;
    private List append;
    private Rectangle black;
    private Rectangle booleanValue;
    private Rectangle[] close;
    private int convertInchToPixel;
    private int convertUnitToPixel;
    private float drawBorder = 0.805f;
    private float drawImage = 0.04f;
    private float drawLine = 0.125f;
    private float drawString = 0.01f;
    private Color error = new Color(15264489);
    private Color fillRect = new Color(0xFFFFFF);
    private Color formatValue = new Color(0xB0B0B0);
    private Color get = new Color(0xFFFFFF);
    private Color getAllTicksValues = new Color(0x999999);
    private Color getBounds = new Color(16757511);
    private Color getClass = new Color(14473936);
    private float getColor = 0.1f;
    private float getColorPropertyByName = 0.188f;
    private float getFont = 0.125f;
    private float getFontRenderContext = 0.068f;
    private float getHeight = 0.188f;
    private float getIntPropertyByName = 0.052f;
    private float getLabelFont = 0.1f;
    private boolean getMessage = false;
    private boolean getObject = false;
    private boolean getPropertyByName = false;

    public RenderSlider(DSField dSField) {
        this.dsField = dSField;
        this.resolution = dSField.getResolution();
    }

    public RenderSlider(DSSlider dSSlider) {
        this.resolution = dSSlider.getResolution();
        this.DEFAULT_SHADOW_WIDTH = dSSlider;
    }

    @Override
    protected void calculatePadding(Render.Box box) {
        box.x = 0;
        box.y = 0;
        if (this.DEFAULT_SHADOW_WIDTH != null) {
            box.width = this.dsFieldWidth = this.DEFAULT_SHADOW_WIDTH.getWidth();
            box.height = this.dsFieldHeight = this.DEFAULT_SHADOW_WIDTH.getHeight();
        } else {
            box.width = this.dsFieldWidth = this.dsField.getWidth();
            box.height = this.dsFieldHeight = this.dsField.getHeight();
        }
        box.x += this.leftPadding;
        box.width -= this.leftPadding + this.rightPadding;
        box.y += this.topPadding;
        box.height -= this.topPadding + this.bottomPadding;
        if (this.leftStyle != 0) {
            this.lGap = (this.leftStyle == 5 ? 3 : 1) * this.borderWidth;
            box.x += this.lGap;
            box.width -= this.lGap;
        }
        if (this.topStyle != 0) {
            this.tGap = (this.topStyle == 5 ? 3 : 1) * this.borderWidth;
            box.y += this.tGap;
            box.height -= this.tGap;
        }
        if (this.rightStyle != 0) {
            this.rGap = (this.rightStyle == 5 ? 3 : 1) * this.borderWidth;
            box.width -= this.rGap;
        }
        if (this.bottomStyle != 0) {
            this.bGap = (this.bottomStyle == 5 ? 3 : 1) * this.borderWidth;
            box.height -= this.bGap;
        }
        box.width = box.width - (this.isShadow ? this.shadowWidth : 0);
        box.height = box.height - (this.isShadow ? this.shadowWidth : 0);
    }

    @Override
    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        this.convertInchToPixel = n3;
        this.convertUnitToPixel = n4;
        this.DEFAULT_SHADOW_WIDTH();
        this.bottomPadding(graphics);
        this.dsFieldHeight(graphics);
        this.bottomStyle(graphics);
        this.dsField(graphics);
        graphics.setColor(color);
    }

    private void DEFAULT_SHADOW_WIDTH() {
        block9: {
            try {
                this.SEDU = this.DEFAULT_SHADOW_WIDTH.getAllTicksValues();
                this.append = this.DEFAULT_SHADOW_WIDTH.getSelectedTicksValues();
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) break block9;
                JRLog.error(2, "Slider get value list error.", (Throwable)dSException);
            }
        }
        if (this.SEDU.isEmpty()) {
            this.getObject = true;
        } else {
            int n;
            if (this.DEFAULT_SHADOW_WIDTH.getSliderType() == 0) {
                if (this.append.size() < 1) {
                    this.getMessage = true;
                }
            } else if (this.append.size() < 2) {
                this.getMessage = true;
            }
            if ((n = ((DbValue)this.SEDU.get(0)).getSqlType()) == 91 || n == 92 || n == 93) {
                this.getPropertyByName = true;
            }
        }
        this.SEDU();
    }

    private void SEDU() {
        this.black = new Rectangle();
        this.booleanValue = new Rectangle();
        this.close = new Rectangle[2];
        this.append();
        if (this.DEFAULT_SHADOW_WIDTH.getSliderType() == 0) {
            this.bGap();
            this.booleanValue();
        } else {
            this.black();
            this.borderWidth();
        }
    }

    private void append() {
        int n = Unit.convertInchToPixel(this.drawBorder, this.resolution);
        int n2 = (this.convertUnitToPixel - n) / 2;
        int n3 = Unit.convertInchToPixel(this.getLabelFont * 2.0f, this.resolution);
        int n4 = this.convertInchToPixel - n3;
        int n5 = n - n3;
        int n6 = 0;
        int n7 = n2;
        int n8 = Unit.convertInchToPixel(this.getLabelFont, this.resolution);
        if (this.DEFAULT_SHADOW_WIDTH.getSliderType() == 1) {
            int n9 = Unit.convertInchToPixel(this.getFont, this.resolution);
            n6 += n9;
            n4 -= 2 * n9;
        }
        this.black.setLocation(n6 += n8, n7 += n8);
        this.black.setSize(n4, n5);
    }

    private void bGap() {
        int n = this.black.x;
        int n2 = this.black.y;
        int n3 = this.error();
        int n4 = Unit.convertInchToPixel(this.drawImage, this.resolution);
        this.booleanValue.setLocation(n, n2 += Unit.convertInchToPixel(this.getHeight + this.getIntPropertyByName + this.getFontRenderContext, this.resolution));
        this.booleanValue.setSize(n3, n4);
    }

    private void black() {
        int n = this.black.x;
        int n2 = this.black.y;
        int n3 = this.error();
        int n4 = Unit.convertInchToPixel(this.drawLine, this.resolution);
        this.booleanValue.setLocation(n, n2 += Unit.convertInchToPixel(this.getHeight + this.getIntPropertyByName, this.resolution));
        this.booleanValue.setSize(n3, n4);
    }

    private void booleanValue() {
        int n;
        this.close[0] = new Rectangle();
        int n2 = 0;
        if (this.getObject || this.getMessage) {
            n2 = this.black.x;
        } else {
            float f = this.SEDU.size();
            float f2 = (float)this.error() / f;
            n = this.SEDU.indexOf(this.append.get(0));
            n2 = (int)((float)this.black.x + f2 * (float)(n + 1));
        }
        int n3 = Unit.convertInchToPixel(this.getColor, this.resolution);
        int n4 = Unit.convertInchToPixel(this.getHeight + this.getIntPropertyByName, this.resolution);
        n = this.black.y + n4;
        int n5 = Unit.convertInchToPixel(this.getColor, this.resolution);
        int n6 = Unit.convertInchToPixel(this.getColorPropertyByName, this.resolution);
        this.close[0].setLocation(n2 -= n3 / 2, n);
        this.close[0].setSize(n5, n6);
    }

    private void borderWidth() {
        this.close[0] = new Rectangle();
        this.close[1] = new Rectangle();
        int n = Unit.convertInchToPixel(this.getFont, this.resolution);
        int n2 = this.error();
        for (int i = 0; i < this.close.length; ++i) {
            int n3 = 0;
            int n4 = this.booleanValue.y;
            n3 = this.getObject ? this.black.x + n2 * i : (this.SEDU.size() == 1 ? this.black.x : (this.getMessage ? this.black.x + n2 * i : (int)((double)this.black.x + (double)n2 * this.DEFAULT_SHADOW_WIDTH.getRangeThumbPosScale(i))));
            this.close[i].setLocation(n3, n4);
            this.close[i].setSize(n, n);
        }
        this.close[0].x -= Unit.convertInchToPixel(this.getFont, this.resolution);
    }

    private void bottomPadding(Graphics graphics) {
        Color color = graphics.getColor();
        Rectangle rectangle = new Rectangle(0, 0, this.convertInchToPixel, this.convertUnitToPixel);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.convertInchToPixel, this.convertUnitToPixel);
        Color color2 = RenderUtil.getColorPropertyByName(this.DEFAULT_SHADOW_WIDTH, "Background");
        graphics.setColor(color2);
        graphics.fillRect(0, 0, this.convertInchToPixel, this.convertUnitToPixel);
        Color color3 = RenderUtil.getColorPropertyByName(this.DEFAULT_SHADOW_WIDTH, "BorderColor");
        int n = RenderUtil.getIntPropertyByName(this.DEFAULT_SHADOW_WIDTH, "LeftLine");
        int n2 = RenderUtil.getIntPropertyByName(this.DEFAULT_SHADOW_WIDTH, "RightLine");
        int n3 = RenderUtil.getIntPropertyByName(this.DEFAULT_SHADOW_WIDTH, "TopLine");
        int n4 = RenderUtil.getIntPropertyByName(this.DEFAULT_SHADOW_WIDTH, "BottomLine");
        int n5 = RenderUtil.getIntPropertyByName(this.DEFAULT_SHADOW_WIDTH, "BorderWidth");
        int n6 = Unit.convertUnitToPixel(RenderCreator.DEFAULT_SHADOW_WIDTH, this.resolution);
        boolean bl = this.DEFAULT_SHADOW_WIDTH.getPropertyByName("Shadow") != null ? (Boolean)this.DEFAULT_SHADOW_WIDTH.getPropertyByName("Shadow").getObject() : false;
        Color color4 = this.DEFAULT_SHADOW_WIDTH.getPropertyByName("ShadowColor") != null ? (Color)this.DEFAULT_SHADOW_WIDTH.getPropertyByName("ShadowColor").getObject() : null;
        RenderGraphicsToolkit.drawBorder(graphics, rectangle, color2, color3, Unit.convertUnitToPixel(n5, this.resolution), n3, n4, n, n2, bl, color4, n6);
        graphics.setColor(color);
    }

    private void bottomStyle(Graphics graphics) {
        graphics.setColor(RenderUtil.getColorPropertyByName(this.DEFAULT_SHADOW_WIDTH, "Foreground"));
        Font font = graphics.getFont();
        graphics.setFont(this.DEFAULT_SHADOW_WIDTH.getLabelFont());
        if (this.DEFAULT_SHADOW_WIDTH.getSliderType() == 1) {
            this.convertInchToPixel(graphics);
            this.drawLine(graphics);
        } else {
            this.close(graphics);
        }
        graphics.setFont(font);
    }

    private void close(Graphics graphics) {
        String string = "";
        if (this.getObject || this.getMessage) {
            string = "(" + JResource.getMessage("SliderLabel_All") + ")";
        } else if (this.append.size() > 0) {
            string = this.DEFAULT_SHADOW_WIDTH.formatValue((DbValue)this.append.get(0));
        }
        int n = this.booleanValue.x;
        int n2 = Unit.convertInchToPixel(this.getHeight, this.resolution);
        int n3 = this.black.y + n2;
        TextLayout textLayout = new TextLayout(string, graphics.getFont(), ((Graphics2D)graphics).getFontRenderContext());
        double d = textLayout.getBounds().getHeight();
        int n4 = (int)(((double)n2 - d) / 2.0);
        n3 = n4 > 0 ? n3 - n4 : n3;
        graphics.drawString(string, n, n3);
    }

    private void convertInchToPixel(Graphics graphics) {
        if (this.getMessage) {
            graphics.setColor(this.getClass);
        }
        String[] stringArray = this.drawImage();
        Point[] pointArray = this.drawBorder(stringArray, graphics);
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.drawString(stringArray[i], pointArray[i].x, pointArray[i].y);
        }
        if (this.getPropertyByName) {
            this.convertUnitToPixel(stringArray, pointArray, graphics);
        }
    }

    private void convertUnitToPixel(String[] stringArray, Point[] pointArray, Graphics graphics) {
        BufferedImage bufferedImage = this.get();
        if (bufferedImage == null) {
            return;
        }
        int n = bufferedImage.getHeight();
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            if (i == 0) {
                n2 = this.booleanValue.x < this.close[i].x ? this.booleanValue.x : this.close[i].x;
            } else {
                n2 = this.booleanValue.x + this.booleanValue.width > this.close[i].x + Unit.convertInchToPixel(this.getFont, this.resolution) ? this.booleanValue.x + this.booleanValue.width : this.close[i].x + Unit.convertInchToPixel(this.getFont, this.resolution);
                n2 -= bufferedImage.getWidth();
            }
            TextLayout textLayout = new TextLayout(stringArray[i], graphics.getFont(), ((Graphics2D)graphics).getFontRenderContext());
            int n3 = (int)Math.round(textLayout.getBounds().getHeight());
            int n4 = n < n3 ? pointArray[i].y - (n3 - n) / 2 - n : pointArray[i].y + (n - n3) / 2 - n;
            graphics.translate(n2, n4);
            graphics.drawImage(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            graphics.translate(-n2, -n4);
        }
    }

    private Point[] drawBorder(String[] stringArray, Graphics graphics) {
        Point[] pointArray;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.close[0].x;
        if (n4 < this.black.x) {
            n2 = n4 - this.black.x;
        }
        if ((n = this.close[1].x + Unit.convertInchToPixel(this.getFont, this.resolution)) > this.black.x + this.booleanValue.width) {
            n3 = n - (this.black.x + this.booleanValue.width);
        }
        if (this.getPropertyByName) {
            pointArray = this.get();
            n2 += pointArray.getWidth() + Unit.convertInchToPixel(0.06, this.resolution);
            n3 -= pointArray.getWidth() + Unit.convertInchToPixel(0.06, this.resolution);
        }
        pointArray = new Point[2];
        int n5 = Unit.convertInchToPixel(this.getHeight, this.resolution);
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0) {
                TextLayout textLayout = new TextLayout(stringArray[i], graphics.getFont(), ((Graphics2D)graphics).getFontRenderContext());
                int n8 = (int)Math.round(textLayout.getBounds().getWidth());
                int n9 = (int)Math.round(textLayout.getBounds().getHeight());
                n6 = n6 == 0 ? this.black.x + n2 : this.black.x + this.booleanValue.width - n8 + n3;
                n7 = this.black.y + n5;
                int n10 = Math.round((n5 - n9) / 2);
                n7 = n10 > 0 ? n7 - n10 : n7;
            }
            pointArray[i] = new Point(n6, n7);
        }
        return pointArray;
    }

    private String[] drawImage() {
        String[] stringArray = new String[2];
        if (this.getObject) {
            stringArray[0] = "xxx...";
            stringArray[1] = "xxx...";
        } else if (this.getMessage) {
            stringArray[0] = this.DEFAULT_SHADOW_WIDTH.formatValue((DbValue)this.SEDU.get(0));
            stringArray[1] = this.DEFAULT_SHADOW_WIDTH.formatValue((DbValue)this.SEDU.get(this.SEDU.size() - 1));
        } else if (!this.append.isEmpty()) {
            stringArray[0] = this.DEFAULT_SHADOW_WIDTH.formatValue((DbValue)this.append.get(0));
            stringArray[1] = this.DEFAULT_SHADOW_WIDTH.formatValue((DbValue)this.append.get(this.append.size() - 1));
        }
        return stringArray;
    }

    private void drawLine(Graphics graphics) {
        int n = this.booleanValue.x < this.close[0].x ? this.booleanValue.x : this.close[0].x;
        BufferedImage bufferedImage = this.getMessage ? this.getAllTicksValues() : this.getColor();
        int n2 = bufferedImage == null ? 0 : bufferedImage.getWidth();
        int n3 = Unit.convertInchToPixel(0.06, this.resolution);
        int n4 = n + n2 + n3;
        TextLayout textLayout = new TextLayout("All", graphics.getFont(), ((Graphics2D)graphics).getFontRenderContext());
        double d = textLayout.getBounds().getHeight();
        int n5 = Unit.convertInchToPixel(this.getHeight, this.resolution);
        int n6 = this.booleanValue.y + this.booleanValue.height + Unit.convertInchToPixel(this.getIntPropertyByName, this.resolution) + n5;
        int n7 = (int)Math.round(((double)n5 - d) / 2.0);
        n6 = (int)(n7 > 0 ? (double)(n6 - n7) : (double)n6 + d - (double)n5);
        graphics.setColor(Color.black);
        graphics.drawString(JResource.getMessage("SliderLabel_All"), n4, n6);
        this.drawString(graphics, n6);
    }

    private void drawString(Graphics graphics, int n) {
        BufferedImage bufferedImage = this.getMessage ? this.getAllTicksValues() : this.getColor();
        int n2 = this.booleanValue.x < this.close[0].x ? this.booleanValue.x : this.close[0].x;
        int n3 = n;
        TextLayout textLayout = new TextLayout("All", graphics.getFont(), ((Graphics2D)graphics).getFontRenderContext());
        double d = textLayout.getBounds().getHeight();
        n3 = (double)bufferedImage.getHeight() < d ? (int)((double)n3 - (d - (double)bufferedImage.getHeight()) / 2.0) - bufferedImage.getHeight() : (int)((double)n3 + ((double)bufferedImage.getHeight() - d) / 2.0) - bufferedImage.getHeight();
        graphics.translate(n2, n3);
        graphics.drawImage(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        graphics.translate(-n2, -n3);
    }

    private void dsField(Graphics graphics) {
        if (this.DEFAULT_SHADOW_WIDTH.getSliderType() == 0) {
            int n = Unit.convertInchToPixel(this.getColorPropertyByName, this.resolution);
            int n2 = Unit.convertInchToPixel(this.getColor, this.resolution);
            BufferedImage bufferedImage = this.fillRect();
            graphics.translate(this.close[0].x, this.close[0].y);
            graphics.drawImage(bufferedImage, 0, 0, n2, n, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            graphics.translate(-this.close[0].x, -this.close[0].y);
        } else {
            int n = Unit.convertInchToPixel(this.getFont, this.resolution);
            BufferedImage[] bufferedImageArray = this.formatValue();
            for (int i = 0; i < this.close.length; ++i) {
                graphics.translate(this.close[i].x, this.close[i].y);
                graphics.drawImage(bufferedImageArray[i], 0, 0, n, n, 0, 0, bufferedImageArray[i].getWidth(), bufferedImageArray[i].getHeight(), null);
                graphics.translate(-this.close[i].x, -this.close[i].y);
            }
        }
    }

    private void dsFieldHeight(Graphics graphics) {
        Color color = this.DEFAULT_SHADOW_WIDTH.getSliderType() == 0 ? this.error : (Color)this.DEFAULT_SHADOW_WIDTH.getPropertyByName("SliderBarColor").getObject();
        graphics.setColor(color);
        graphics.fillRect(this.booleanValue.x, this.booleanValue.y, this.booleanValue.width, this.booleanValue.height);
        if (this.DEFAULT_SHADOW_WIDTH.getSliderType() == 1) {
            this.dsFieldWidth(graphics);
        }
        int n = Unit.convertInchToPixel(this.drawString, this.resolution);
        int n2 = 1;
        Color color2 = this.DEFAULT_SHADOW_WIDTH.getSliderType() == 0 ? this.formatValue : this.getAllTicksValues;
        Painter.drawLine(graphics, this.booleanValue.x, this.booleanValue.y + (n - 1) / 2, this.booleanValue.width - 1 + this.booleanValue.x, (n - 1) / 2 + this.booleanValue.y, color2, n, n2);
        Painter.drawLine(graphics, (n - 1) / 2 + this.booleanValue.x, this.booleanValue.y, (n - 1) / 2 + this.booleanValue.x, this.booleanValue.height - 1 + this.booleanValue.y, color2, n, n2);
        Painter.drawLine(graphics, this.booleanValue.width - 1 - n / 2 + this.booleanValue.x, this.booleanValue.y, this.booleanValue.width - 1 - n / 2 + this.booleanValue.x, this.booleanValue.height - 1 + this.booleanValue.y, color2, n, n2);
        if (this.DEFAULT_SHADOW_WIDTH.getSliderType() == 0) {
            color2 = this.fillRect;
        }
        Painter.drawLine(graphics, this.booleanValue.x, this.booleanValue.y + this.booleanValue.height - 1 - n / 2, this.booleanValue.width - 1 + this.booleanValue.x, this.booleanValue.height - 1 - n / 2 + this.booleanValue.y, color2, n, n2);
    }

    private void dsFieldWidth(Graphics graphics) {
        int n = this.close[0].x + Unit.convertInchToPixel(this.getFont, this.resolution);
        int n2 = this.booleanValue.y;
        int n3 = this.close[1].x;
        int n4 = n3 - n;
        int n5 = this.booleanValue.height;
        graphics.setColor((Color)this.DEFAULT_SHADOW_WIDTH.getPropertyByName("SelectionColor").getObject());
        graphics.fillRect(n, n2, n4, n5);
    }

    private int error() {
        int n = Unit.convertInchToPixel(this.getLabelFont, this.resolution);
        int n2 = this.convertInchToPixel - n * 2;
        if (this.DEFAULT_SHADOW_WIDTH.getSliderType() == 1) {
            n2 -= 2 * Unit.convertInchToPixel(this.getFont, this.resolution);
        }
        return n2;
    }

    private BufferedImage fillRect() {
        return this.getColorPropertyByName("slider_single.png");
    }

    private BufferedImage[] formatValue() {
        BufferedImage[] bufferedImageArray = new BufferedImage[2];
        String string = "slider_range_start.png";
        String string2 = "slider_range_end.png";
        bufferedImageArray[0] = this.getColorPropertyByName(string);
        bufferedImageArray[1] = this.getColorPropertyByName(string2);
        return bufferedImageArray;
    }

    private BufferedImage get() {
        return this.getColorPropertyByName("slider_calendar.png");
    }

    private BufferedImage getAllTicksValues() {
        return this.getColorPropertyByName("slider_cked_box.png");
    }

    private BufferedImage getColor() {
        return this.getColorPropertyByName("slider_uncked_box.png");
    }

    private BufferedImage getColorPropertyByName(String string) {
        BufferedImage bufferedImage;
        block6: {
            InputStream inputStream;
            block5: {
                inputStream = this.getClass().getResourceAsStream("/resource/images/" + string);
                if (inputStream == null) {
                    return null;
                }
                bufferedImage = null;
                try {
                    bufferedImage = ImageIO.read(inputStream);
                }
                catch (IOException iOException) {
                    if (!JRLog.isError(2)) break block5;
                    JRLog.error(2, "Slider load image error.", (Throwable)iOException);
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block6;
                JRLog.error(2, "Slider load image error.", (Throwable)iOException);
            }
        }
        return bufferedImage;
    }
}

