/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import com.jinfonet.awt.JFont;
import com.jinfonet.util.JRLog;
import guitools.Painter;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Vector;
import jet.datastream.Communicator;
import jet.datastream.DSField;
import jet.datastream.DSParagraph;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;
import jet.util.JRInterruptedException;
import jet.util.Propertiable;
import jet.util.TextBreaker;
import jet.util.nls.INLSMap;
import jet.util.nls.NLSFontValue;

public class RenderText
extends Render {
    private int[][] SEDU;
    private int UTFLength = -1;
    private int add = -1;
    private int[][] addElement;
    private Vector adjustJustifyString;
    private int[] adjustString;
    private boolean calculatePadding = true;
    private Render.Box charAt = null;
    private int checkConditionNLS = -1;
    private boolean clipString = false;
    private boolean convertInchToUnit = false;
    boolean needWClip = false;

    public RenderText(DSField dSField) {
        this.dsField = dSField;
        JRObjectResult jRObjectResult = (JRObjectResult)((Object)dSField.getParent());
        if (jRObjectResult != null) {
            Communicator communicator = dSField.getCommunicator();
            this.calculatePadding = communicator.isHighPrecision();
            this.fromEncoding = communicator.getFromEncoding();
            this.toEncoding = communicator.getToEncoding();
            dSField.setRuntimeComvert(true);
            dSField.setFromEncoding(this.fromEncoding);
            dSField.setToEncoding(this.toEncoding);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void locate() {
        if (this.text == null || this.text.length() == 0) {
            this.adjustJustifyString = null;
            return;
        }
        this.charAt = new Render.Box();
        super.calculatePadding(this.charAt);
        this.x = this.charAt.x;
        this.y = this.charAt.y;
        this.width = this.charAt.width;
        this.height = this.charAt.height;
        if (this.SEDU != null) {
            if (this.UTFLength < 0) return;
            this.text = Painter.adjustString(this.text);
            int n = this.text.length();
            this.adjustJustifyString = new Vector(this.SEDU.length);
            int n2 = this.SEDU.length;
            for (int i = this.UTFLength; i <= Math.min(n2 - 1, this.add); ++i) {
                int n3 = this.SEDU[i][0] + this.SEDU[i][1];
                if (n3 > n) {
                    n3 = n;
                }
                if (this.SEDU[i][0] >= n || this.SEDU[i][0] < 0) continue;
                this.adjustJustifyString.addElement(this.text.substring(this.SEDU[i][0], n3));
            }
            if (this.adjustJustifyString.size() == 0) {
                this.adjustJustifyString.add(this.text);
            }
        } else {
            this.adjustJustifyString = new Vector(1);
            if (this.text != null) {
                this.text = this.text.replace('\n', ' ');
            }
            this.adjustJustifyString.add(this.text);
        }
        this.SEDU(this.charAt, this.layout);
        if (!this.isRotation || this.isWordwrap) return;
        this.rotation();
    }

    private void SEDU(Render.Box box, int n) {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        if (n == 4 || n == 1 || n == 7) {
            bl = true;
        }
        int n5 = box.x;
        int n6 = box.y;
        int n7 = 0;
        int n8 = this.adjustJustifyString.size();
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n8];
        this.adjustString = new int[n8];
        if (this.isWordwrap && !this.dsField.noChangedHeight()) {
            this.checkConditionNLS = box.height / n8;
            for (n4 = 0; n4 < n8; ++n4) {
                this.adjustString[n4] = this.checkConditionNLS;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < n8; ++n3) {
            Object object;
            if (!bl) {
                object = (String)this.adjustJustifyString.get(n3);
                boolean bl2 = this.calculatePadding;
                if (!bl2 && this.font.getFontName().equalsIgnoreCase("Times New Roman")) {
                    bl2 = true;
                }
                rectangle2DArray[n3] = RenderGraphicsToolkit.getBounds((String)object, this.font, bl2);
                this.adjustString[n3] = Unit.convertPixelToUnit((int)Math.round(rectangle2DArray[n3].getHeight() + 0.5), this.resolution);
                if (this.checkConditionNLS > 0) {
                    this.adjustString[n3] = Math.min(this.adjustString[n3], this.checkConditionNLS);
                }
            } else if (this.checkConditionNLS == -1) {
                rectangle2DArray[n3] = RenderGraphicsToolkit.getBounds((String)this.adjustJustifyString.get(n3), this.font, this.calculatePadding);
                this.adjustString[n3] = Unit.convertPixelToUnit((int)Math.round(rectangle2DArray[n3].getHeight() + 0.5), this.resolution);
                this.checkConditionNLS = this.adjustString[n3];
            } else {
                this.adjustString[n3] = this.checkConditionNLS;
            }
            if (n3 == 0) {
                object = this.font instanceof JFont ? ((JFont)((Object)this.font)).getFontMetrics() : TextBreaker.getDefaultToolkit().getFontMetrics(this.font);
                this.adjustString[0] = n4 = Unit.convertPixelToUnit(((FontMetrics)object).getHeight(), this.resolution);
            } else {
                this.adjustString[n3] = Math.min(this.adjustString[n3], n4);
            }
            n7 += this.adjustString[n3];
        }
        this.addElement = new int[n8][2];
        n3 = box.height - n7;
        if (n8 == 1 && this.adjustString[0] + this.topPadding + this.bottomPadding > this.dsField.getHeight()) {
            n6 = (this.dsField.getHeight() - this.adjustString[0]) / 2;
        } else {
            switch (n) {
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    n6 = box.y + n3 / 2;
                    if (this.calculatePadding || n8 != 1) break;
                    n6 += Unit.convertInchToUnit(0.01);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    n6 = box.y + n3;
                }
            }
        }
        int n9 = n5;
        int n10 = n6;
        for (n2 = 0; n2 < n8; ++n2) {
            int n11;
            String string = (String)this.adjustJustifyString.elementAt(n2);
            int n12 = this.adjustString[n2];
            int n13 = 0;
            if (!bl) {
                n13 = (int)Unit.convertPixelToUnit(rectangle2DArray[n2].getWidth(), this.resolution);
            }
            this.needWClip = (n11 = box.width - n13) < 0 || bl;
            switch (n) {
                case 2: 
                case 5: 
                case 8: {
                    n9 = n5 + n11 / 2;
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    n9 = n5 + n11;
                    break;
                }
                default: {
                    n9 = n5;
                }
            }
            if (n8 > 1 && this.layout > 9) {
                boolean bl3 = true;
                char[] cArray = string.toCharArray();
                int n14 = cArray.length;
                for (int i = 0; bl3 && i < n14; bl3 &= cArray[i] == ' ' || cArray[i] == '\n', ++i) {
                }
                if (n2 == n8 - 1) {
                    bl3 = true;
                }
                if (!bl3) {
                    int n15;
                    while ((n15 = string.length()) > 0 && string.charAt(n15 - 1) == ' ') {
                        string = string.substring(0, string.length() - 1);
                    }
                    n13 = (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds(string, this.font, this.calculatePadding).getWidth(), this.resolution);
                    int n16 = string.indexOf(32);
                    if (n16 > 0 && n16 < n15 - 1) {
                        int n17 = (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds(" ", this.font, this.calculatePadding).getWidth(), this.resolution);
                        while ((n13 = (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds(string, this.font, this.calculatePadding).getBounds().getWidth(), this.resolution)) < this.width - n17 && n17 != 0) {
                            int n18 = (this.width - n13) / n17;
                            string = Painter.adjustJustifyString(string, n18);
                        }
                    }
                }
                this.adjustJustifyString.set(n2, string);
            }
            this.addElement[n2][0] = n9;
            this.addElement[n2][1] = n10;
            n10 += n12;
        }
        this.isCutOff = false;
        this.clipString = false;
        this.convertInchToUnit = false;
        for (n2 = 0; n2 < n8; ++n2) {
            if (rectangle2DArray[n2] == null) {
                this.convertInchToUnit = false;
                break;
            }
            this.convertInchToUnit = true;
        }
        if (this.convertInchToUnit) {
            for (n2 = 0; n2 < n8; ++n2) {
                Rectangle2D rectangle2D = rectangle2DArray[n2];
                if (box.width + this.rightPadding >= (int)Unit.convertPixelToUnit(rectangle2D.getWidth(), this.resolution)) continue;
                this.isCutOff = true;
                break;
            }
            n2 = Unit.convertPixelToUnit(TextBreaker.getDefaultToolkit().getFontMetrics(this.font).getDescent(), this.resolution);
            if (this.add(box.height + this.bottomPadding) < n7 - n2) {
                this.clipString = true;
            }
        }
    }

    @Override
    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.dsField.getResolution();
        Vector vector = this.getVLines();
        if (vector == null) {
            return;
        }
        graphics.setColor(RenderUtil.getColorPropertyByName(this.dsField, "Foreground"));
        if (this.font == null) {
            Font font;
            String string = RenderUtil.getStringPropertyByName(this.dsField, "FontFace");
            n5 = 0;
            if (RenderUtil.getBooleanPropertyByName(this.dsField, "Bold")) {
                n5 |= 1;
            }
            if (RenderUtil.getBooleanPropertyByName(this.dsField, "Italic")) {
                n5 |= 2;
            }
            int n7 = RenderUtil.getIntPropertyByName(this.dsField, "FontSize");
            float f = Unit.convertUnitToPixel(n7, 72);
            f = f * (float)this.resolution / 72.0f;
            boolean bl = RenderGraphicsToolkit.checkConditionNLS(this.dsField);
            if (bl) {
                NLSFontValue nLSFontValue;
                int n8 = this.dsField.getSubIdxOfRpt();
                if (n8 < 0) {
                    n8 = 0;
                }
                INLSMap iNLSMap = null;
                Hashtable<Integer, INLSMap> hashtable = this.dsField.getCommunicator().getINLSMaps();
                if (hashtable != null) {
                    iNLSMap = hashtable.get(n8);
                }
                if (iNLSMap != null && (nLSFontValue = iNLSMap.getFontValue(string, Unit.convertUnitToPixel(n7, 72))) != null && !nLSFontValue.isEmptyValue()) {
                    string = nLSFontValue.getFontName();
                    n7 = (int)Unit.convertPixelToUnit(nLSFontValue.getFontSize(), 72);
                    f = Unit.convertUnitToPixel(n7, this.resolution);
                }
            }
            this.font = font = RenderGraphicsToolkit.getFont(string, n5, f);
            graphics.setFont(font);
        } else {
            graphics.setFont(this.font);
        }
        boolean bl = RenderUtil.getBooleanPropertyByName(this.dsField, "Underline");
        n5 = RenderUtil.getBooleanPropertyByName(this.dsField, "StrikeOut");
        graphics.setFont(this.font);
        int[][] nArray = this.getEveryLinePos();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = this.dsField.getAutoExpandedRec();
        int n9 = fontMetrics.getAscent();
        int n10 = vector.size();
        for (int i = 0; i < n10; ++i) {
            int n11 = Unit.convertUnitToPixel(nArray[i][0], n6);
            if (rectangle != null) {
                n11 += rectangle.x;
            }
            int n12 = Unit.convertUnitToPixel(nArray[i][1], n6) + n9;
            Painter.drawText(graphics, (String)vector.get(i), n11, n12, this.calculatePadding);
            int n13 = Math.max((this.font.getSize() + (this.font.isBold() ? 2 : 0)) / 10, 1);
            int n14 = (int)RenderGraphicsToolkit.getBounds((String)this.adjustJustifyString.get(i), this.font, this.calculatePadding).getWidth();
            if (bl) {
                int n15 = Math.min((this.font.getSize() + (this.font.isBold() ? 2 : 0)) / 10, 2);
                graphics.fillRect(n11, n12 + n15, n14, n13);
            }
            if (n5 == 0) continue;
            graphics.fillRect(n11, n12 - fontMetrics.getAscent() / 2 + 1, n14, n13);
        }
    }

    public int getEndLine() {
        return this.add;
    }

    public void setEndLine(int n) {
        this.add = n;
    }

    public int[][] getEveryLinePos() {
        return this.addElement;
    }

    public void setEveryLinePos(int[][] nArray) {
        this.addElement = nArray;
    }

    public int[][] getLineBreakPos() {
        return this.SEDU;
    }

    public void setLineBreakPos(int[][] nArray) {
        this.SEDU = nArray;
    }

    public int getStartLine() {
        return this.UTFLength;
    }

    public void setStartLine(int n) {
        this.UTFLength = n;
    }

    public Vector getVLines() {
        return this.adjustJustifyString;
    }

    public void setVLines(Vector vector) {
        this.adjustJustifyString = vector;
    }

    public int[] getEveryLineHeight() {
        return this.adjustString;
    }

    public void setEveryLineHeight(int[] nArray) {
        this.adjustString = nArray;
    }

    @Override
    public boolean canBeCatch() {
        if (this.dsField.getParent() instanceof DSParagraph) {
            return false;
        }
        DSTemplatible dSTemplatible = this.dsField.getTemplate();
        Propertiable propertiable = null;
        propertiable = dSTemplatible.getPropertyByName("Shadow");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("FontFace");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("Bold");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("Italic");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("WordWrap");
        if (propertiable != null && propertiable.isChangeByOther()) {
            return false;
        }
        propertiable = dSTemplatible.getPropertyByName("AutoFit");
        return propertiable == null || !propertiable.isChangeByOther();
    }

    @Override
    public void updateRender(DSField dSField) {
        this.dsField = dSField;
        dSField.setRuntimeComvert(true);
        dSField.setFromEncoding(this.fromEncoding);
        dSField.setToEncoding(this.toEncoding);
        this.setText(dSField.toString());
        this.setStartLine(dSField.getStartLine());
        this.setEndLine(dSField.getEndLine());
        this.setLineBreakPos(dSField.getLineBreakPos());
        this.locate();
    }

    @Override
    public int memoryLength() {
        int n;
        block11: {
            n = super.memoryLength();
            try {
                Vector vector;
                int n2;
                ++n;
                if (this.adjustString != null) {
                    n += 4 * this.adjustString.length;
                }
                if (this.addElement != null) {
                    for (n2 = 0; n2 < this.addElement.length; ++n2) {
                        n += 4 * this.addElement[n2].length;
                    }
                }
                if (this.SEDU != null) {
                    for (n2 = 0; n2 < this.SEDU.length; ++n2) {
                        n += 4 * this.SEDU[n2].length;
                    }
                }
                int n3 = (vector = this.getVLines()) == null ? 0 : vector.size();
                n += 4;
                if (n3 != 0) {
                    for (int i = 0; i < n3; ++i) {
                        n += JRObjectResult.UTFLength((String)vector.get(i)) + 2;
                    }
                    n += n3 * 2 * 4;
                    n += n3 * 4;
                }
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "get JRInterruptedException ", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isTrace(3)) break block11;
                JRLog.trace(3, "RenderText memoryLength get error ", (Throwable)exception);
            }
        }
        return n;
    }

    public boolean isPrecision() {
        return this.calculatePadding;
    }

    @Override
    public boolean isCutOff() {
        int n;
        int n2;
        int n3;
        if (this.convertInchToUnit) {
            return this.isCutOff;
        }
        this.isCutOff = false;
        if (this.charAt == null) {
            this.charAt = new Render.Box();
            super.calculatePadding(this.charAt);
        }
        if (this.adjustJustifyString == null) {
            return this.isCutOff;
        }
        int n4 = this.adjustJustifyString == null ? 0 : this.adjustJustifyString.size();
        boolean bl = false;
        if (this.adjustString == null) {
            this.adjustString = new int[n4];
            bl = true;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            Rectangle2D rectangle2D = RenderGraphicsToolkit.getBounds((String)this.adjustJustifyString.get(n3), this.font, this.calculatePadding);
            if (bl) {
                this.adjustString[n3] = (int)Unit.convertPixelToUnit(rectangle2D.getHeight(), this.resolution);
            }
            n2 = 0;
            int n5 = Unit.convertPixelToUnit(1, this.resolution);
            n2 = (this.charAt.width + this.rightPadding) % n5 == 0 ? this.charAt.width + this.rightPadding : this.add(this.charAt.width + this.rightPadding) - n5;
            if (n2 >= (int)Unit.convertPixelToUnit(rectangle2D.getWidth(), this.resolution)) continue;
            this.isCutOff = true;
            return this.isCutOff;
        }
        n3 = 0;
        n2 = this.adjustString.length;
        for (n = 0; n < n2; ++n) {
            n3 += this.adjustString[n];
        }
        n = Unit.convertPixelToUnit(TextBreaker.getDefaultToolkit().getFontMetrics(this.font).getDescent(), this.resolution);
        if (this.add(this.charAt.height + this.bottomPadding) < n3 - n) {
            this.clipString = true;
        }
        return this.isCutOff;
    }

    @Override
    public Rectangle getBox() {
        if (this.charAt == null) {
            return null;
        }
        return new Rectangle(this.charAt.x, this.charAt.y, this.dsField.getWidth(), this.dsField.getHeight());
    }

    @Override
    public void clipString() {
        int n;
        if (this.isAutoFit || this.isWordwrap || !this.needWClip) {
            return;
        }
        int n2 = n = this.adjustJustifyString == null ? 0 : this.adjustJustifyString.size();
        if (n == 1) {
            String string = (String)this.adjustJustifyString.get(0);
            int n3 = Unit.convertUnitToPixel(this.dsField.getWidth() - this.leftPadding - this.rightPadding - this.lGap - this.rGap - (this.isShadow ? this.shadowWidth : 0));
            String string2 = TextBreaker.clipString(string, this.font, this.UTFLength(), n3, this.calculatePadding);
            if (string2.length() < string.length()) {
                this.adjustJustifyString.set(0, string2);
                int n4 = this.addElement.length;
                if (this.charAt == null) {
                    this.getBox();
                }
                for (int i = 0; i < n4; ++i) {
                    this.SEDU(this.charAt, this.layout);
                }
            }
        } else {
            return;
        }
    }

    private int UTFLength() {
        switch (this.layout) {
            case 1: 
            case 4: 
            case 7: {
                return 0;
            }
            case 2: 
            case 5: 
            case 8: {
                return 1;
            }
            case 3: 
            case 6: 
            case 9: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int getRightOverflow() {
        int n = Integer.MIN_VALUE;
        if (this.adjustJustifyString != null) {
            int n2 = 0;
            int n3 = this.adjustJustifyString.size();
            for (int i = 0; i < n3; ++i) {
                int n4 = (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds((String)this.adjustJustifyString.get(i), this.font, this.calculatePadding).getWidth(), this.resolution);
                int n5 = this.dsField.getWidth();
                n2 = this.addElement[i][0] + n4 - n5 + this.rightPadding;
                n = Math.max(n2, n);
            }
        }
        return n;
    }

    private int add(int n) {
        int n2 = n;
        int n3 = n2;
        int n4 = 5760 / this.resolution;
        if (n3 % n4 == 0) {
            return n2;
        }
        return n3 - n3 % n4 + n4;
    }

    @Override
    public String getTooltip() {
        boolean bl;
        Propertiable propertiable;
        String string = null;
        if ((this.isCutOff() || this.clipString) && (propertiable = this.dsField.getPropertyByName("rTitle")) != null && (bl = propertiable.isCurrentAutoValue())) {
            string = this.dsField.getText();
        }
        if (string == null) {
            return super.getTooltip();
        }
        return string;
    }
}

