/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import guitools.Painter;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import jet.datastream.DSField;
import jet.datastream.render.Render;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;

public class RenderTextArea
extends Render {
    private boolean I = true;
    private Vector SEDU;

    public RenderTextArea(DSField dSField) {
        this.dsField = dSField;
        this.resolution = dSField.getResolution();
    }

    @Override
    public void locate() {
        this.SEDU = new Vector();
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        Render.Box box = new Render.Box();
        this.calculatePadding(box);
        this.x = box.x;
        this.y = box.y;
        this.width = box.width;
        this.height = box.height;
        if (this.I) {
            this.autoWrap(box);
        } else {
            this.SEDU.add(this.text);
            if (this.isAutoFit) {
                super.autoFit(box);
            }
        }
        this.calculateCoordinate(box);
        boolean bl = this.isRotation = this.getRotation() != 0.0;
        if (this.isRotation) {
            this.rotation();
        }
    }

    protected void autoWrap(Render.Box box) {
        int n;
        int n2;
        Painter.layoutText(this.SEDU, this.text, Unit.convertUnitToPixel(this.width, this.resolution) - 6, this.font);
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.SEDU.size(); ++n2) {
            n = (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds((String)this.SEDU.get(n2), this.font).getHeight(), this.resolution);
            int n5 = (int)Unit.convertPixelToUnit(RenderGraphicsToolkit.getBounds((String)this.SEDU.get(n2), this.font).getWidth(), this.resolution);
            n3 += n;
            if (n4 >= n5) continue;
            n4 = n5;
        }
        if (this.isAutoFit) {
            this.width = n4 + 2 * Unit.convertPixelToUnit(3, this.resolution);
            this.height = n3 + 2 * Unit.convertPixelToUnit(3, this.resolution);
            box.width = this.width;
            box.height = this.height;
            n2 = box.width;
            n = box.height;
            super.afterAutoFitResetFieldSize(n2, n);
        }
    }

    @Override
    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = RenderUtil.getColorPropertyByName(this.dsField, "Background");
        Color color2 = RenderUtil.getColorPropertyByName(this.dsField, "Foreground");
        Color color3 = RenderUtil.getColorPropertyByName(this.dsField, "PatternColor");
        int n5 = RenderUtil.getIntPropertyByName(this.dsField, "PatternStyle");
        if (color == null) {
            color = Color.white;
        }
        RenderGraphicsToolkit.paintTextArea(graphics, this.text, this.SEDU, this.font, color2, n, n2, n3, n4, color, color3, n5);
    }

    public Vector getLines() {
        return this.SEDU;
    }

    @Override
    public String getAlt() {
        return RenderUtil.getStringPropertyByName(this.dsField, "Alt");
    }
}

