/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import jet.datastream.JRObjectResult;
import jet.export.util.ImageTool;
import jet.log.JRLogger;

public class RenderUtil {
    public static final JRLogger logger = JRLogger.getLogger(RenderUtil.class);

    public static Object getPropertyByName(JRObjectResult jRObjectResult, String string) {
        return jRObjectResult.getPropertyByName(string).getObject();
    }

    public static int getIntPropertyByName(JRObjectResult jRObjectResult, String string) {
        int n = 0;
        if (RenderUtil.I(jRObjectResult)) {
            return ((Number)RenderUtil.getPropertyByName(jRObjectResult, string)).intValue();
        }
        if (string.equals("X")) {
            n = jRObjectResult.getTemplate().getX(jRObjectResult);
        } else if (string.equals("Y")) {
            n = jRObjectResult.getTemplate().getY(jRObjectResult);
        } else if (string.equals("Width")) {
            n = jRObjectResult.getTemplate().getWidth(jRObjectResult);
        } else if (string.equals("Height")) {
            n = jRObjectResult.getTemplate().getHeight(jRObjectResult);
        } else if (string.equals("Alignment")) {
            n = jRObjectResult.getTemplate().getAlignment(jRObjectResult);
        } else {
            if (string.equals("FontSize")) {
                short s = jRObjectResult.getTemplate().getFontSizeChangeByType();
                if (s < 2) {
                    return jRObjectResult.getTemplate().getFontSize(jRObjectResult);
                }
                return ((Number)RenderUtil.getPropertyByName(jRObjectResult, string)).intValue();
            }
            if (string.equals("BorderWidth")) {
                n = jRObjectResult.getTemplate().getBorderWidth(jRObjectResult);
            } else {
                if (string.equals("TopLine")) {
                    short s = jRObjectResult.getTemplate().getTopLineChangeByType();
                    if (s < 2) {
                        return jRObjectResult.getTemplate().getTopLine(jRObjectResult);
                    }
                    return ((Number)RenderUtil.getPropertyByName(jRObjectResult, string)).intValue();
                }
                if (string.equals("LeftLine")) {
                    short s = jRObjectResult.getTemplate().getLeftLineChangeByType();
                    if (s < 2) {
                        return jRObjectResult.getTemplate().getLeftLine(jRObjectResult);
                    }
                    return ((Number)RenderUtil.getPropertyByName(jRObjectResult, string)).intValue();
                }
                if (string.equals("BottomLine")) {
                    short s = jRObjectResult.getTemplate().getBottomLineChangeByType();
                    if (s < 2) {
                        return jRObjectResult.getTemplate().getBottomLine(jRObjectResult);
                    }
                    return ((Number)RenderUtil.getPropertyByName(jRObjectResult, string)).intValue();
                }
                if (string.equals("RightLine")) {
                    short s = jRObjectResult.getTemplate().getRightLineChangeByType();
                    if (s < 2) {
                        return jRObjectResult.getTemplate().getRightLine(jRObjectResult);
                    }
                    return ((Number)RenderUtil.getPropertyByName(jRObjectResult, string)).intValue();
                }
                if (string.equals("BorderStyle")) {
                    n = jRObjectResult.getTemplate().getBorderStyle(jRObjectResult);
                } else if (string.equals("PatternStyle")) {
                    n = jRObjectResult.getTemplate().getPatternStyle(jRObjectResult);
                } else if (string.equals("FieldType")) {
                    n = jRObjectResult.getTemplate().getFieldType(jRObjectResult);
                } else {
                    logger.info("this property is not existed! -- " + string);
                }
            }
        }
        return n;
    }

    public static String getStringPropertyByName(JRObjectResult jRObjectResult, String string) {
        if (RenderUtil.I(jRObjectResult)) {
            return (String)RenderUtil.getPropertyByName(jRObjectResult, string);
        }
        if (string.equals("Format")) {
            return jRObjectResult.getTemplate().getFormat(jRObjectResult).trim();
        }
        if (string.equals("FontFace")) {
            short s = jRObjectResult.getTemplate().getFontFaceChangeByType();
            if (s < 2) {
                return jRObjectResult.getTemplate().getFontFace(jRObjectResult);
            }
            return (String)RenderUtil.getPropertyByName(jRObjectResult, string);
        }
        if (string.equals("RuntimeColumnName")) {
            return jRObjectResult.getTemplate().getColumnName(jRObjectResult);
        }
        logger.info("this property is not existed! -- " + string);
        return null;
    }

    public static boolean getBooleanPropertyByName(JRObjectResult jRObjectResult, String string) {
        boolean bl = false;
        if (RenderUtil.I(jRObjectResult)) {
            return (Boolean)RenderUtil.getPropertyByName(jRObjectResult, string);
        }
        if (string.equals("Underlay")) {
            jRObjectResult.getTemplate().getUnderlay(jRObjectResult);
        } else if (string.equals("Invisible")) {
            bl = jRObjectResult.getTemplate().getInvisible(jRObjectResult);
        } else {
            if (string.equals("Bold")) {
                short s = jRObjectResult.getTemplate().getBoldChangeByType();
                if (s < 2) {
                    return jRObjectResult.getTemplate().getBold(jRObjectResult);
                }
                return (Boolean)RenderUtil.getPropertyByName(jRObjectResult, string);
            }
            if (string.equals("Italic")) {
                short s = jRObjectResult.getTemplate().getItalicChangeByType();
                if (s < 2) {
                    return jRObjectResult.getTemplate().getItalic(jRObjectResult);
                }
                return (Boolean)RenderUtil.getPropertyByName(jRObjectResult, string);
            }
            if (string.equals("StrikeOut")) {
                bl = jRObjectResult.getTemplate().getStrikeOut(jRObjectResult);
            } else {
                if (string.equals("Underline")) {
                    short s = jRObjectResult.getTemplate().getUnderlineChangeByType();
                    if (s < 2) {
                        return jRObjectResult.getTemplate().getUnderline(jRObjectResult);
                    }
                    return (Boolean)RenderUtil.getPropertyByName(jRObjectResult, string);
                }
                if (string.equals("Shadow")) {
                    bl = jRObjectResult.getTemplate().getShadow(jRObjectResult);
                } else if (string.equals("WordWrap")) {
                    bl = jRObjectResult.getTemplate().getWordWrap(jRObjectResult);
                } else if (string.equals("AutoFit")) {
                    bl = jRObjectResult.getTemplate().getAutoFit(jRObjectResult);
                } else {
                    if (string.equals("TitleUnderline")) {
                        return (Boolean)RenderUtil.getPropertyByName(jRObjectResult, string);
                    }
                    logger.info("this property is not existed! -- " + string);
                }
            }
        }
        return bl;
    }

    public static Color getColorPropertyByName(JRObjectResult jRObjectResult, String string) {
        if (RenderUtil.I(jRObjectResult)) {
            return (Color)RenderUtil.getPropertyByName(jRObjectResult, string);
        }
        if (string.equals("BorderColor")) {
            return jRObjectResult.getTemplate().getBorderColor(jRObjectResult);
        }
        if (string.equals("Background")) {
            short s = jRObjectResult.getTemplate().getBackgroundByType();
            if (s < 2) {
                return jRObjectResult.getTemplate().getBackground(jRObjectResult);
            }
            return (Color)RenderUtil.getPropertyByName(jRObjectResult, string);
        }
        if (string.equals("Foreground")) {
            short s = jRObjectResult.getTemplate().getForegroundChangeByType();
            if (s < 2) {
                return jRObjectResult.getTemplate().getForeground(jRObjectResult);
            }
            return (Color)RenderUtil.getPropertyByName(jRObjectResult, string);
        }
        if (string.equals("LineColor")) {
            return jRObjectResult.getTemplate().getLineColor(jRObjectResult);
        }
        if (string.equals("ShadowColor")) {
            return jRObjectResult.getTemplate().getShadowColor(jRObjectResult);
        }
        if (string.equals("PatternColor")) {
            return jRObjectResult.getTemplate().getPatternColor(jRObjectResult);
        }
        logger.info("this property is not existed! -- " + string);
        return null;
    }

    public static int parseAlignment(int n, int n2) {
        int n3 = 5;
        if (n == 0 && n2 == 1) {
            n3 = 1;
            return 1;
        }
        if (n == 0 && n2 == 0) {
            n3 = 4;
            return 4;
        }
        if (n == 0 && n2 == 2) {
            n3 = 7;
            return 7;
        }
        if (n == 1 && n2 == 1) {
            n3 = 3;
            return 3;
        }
        if (n == 1 && n2 == 0) {
            n3 = 6;
            return 6;
        }
        if (n == 1 && n2 == 2) {
            n3 = 9;
            return 9;
        }
        if (n == 2 && n2 == 1) {
            n3 = 2;
            return 2;
        }
        if (n == 2 && n2 == 0) {
            n3 = 5;
            return 5;
        }
        if (n == 2 && n2 == 2) {
            n3 = 8;
            return 8;
        }
        if (n == 3 && n2 == 1) {
            n3 = 10;
            return 10;
        }
        if (n == 3 && n2 == 0) {
            n3 = 11;
            return 11;
        }
        if (n == 3 && n2 == 2) {
            n3 = 12;
            return 12;
        }
        return n3;
    }

    public static int[] getClipScaleRect(int n, int n2, int n3, int n4, Image image, int n5, float f) {
        if (image == null) {
            return null;
        }
        int[] nArray = new int[2];
        int n6 = Unit.getResolution();
        float f2 = ImageTool.getResolutionRatio(n6);
        int n7 = image.getWidth(null);
        int n8 = image.getHeight(null);
        int n9 = Unit.convertPixelToUnit(n7, (int)((float)n6 / f2));
        int n10 = Unit.convertPixelToUnit(n8, (int)((float)n6 / f2));
        Dimension dimension = ImageTool.getScalingSize(n, n2, n9, n10, n5, f);
        int n11 = dimension.width;
        int n12 = dimension.height;
        int n13 = n11;
        int n14 = n12;
        if (n11 > n) {
            n13 = n;
        }
        if (n13 > n3 && n3 != -1) {
            n13 = n3;
        }
        if (n12 > n2) {
            n14 = n2;
        }
        if (n14 > n4 && n4 != -1) {
            n14 = n4;
        }
        nArray[0] = n13;
        nArray[1] = n14;
        return nArray;
    }

    private static boolean I(JRObjectResult jRObjectResult) {
        boolean bl = false;
        int n = jRObjectResult.getObjectType();
        if (n == 65541 || n == 65540) {
            bl = true;
        }
        return bl;
    }
}

