/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import jet.datastream.render.barcode.BarcodeTable;
import jet.datastream.render.barcode.linearBarcode.Barcode128;

public class BarcodeUtil {
    public static int centreX;
    public static int centreY;

    public static StringBuffer code128Tran(String string, int n) {
        Barcode128 barcode128 = new Barcode128();
        barcode128.setBarcodeData(string);
        barcode128.setStartType(n);
        int n2 = string.length();
        byte[] byArray = new byte[n2 * 2 + 1];
        byArray = barcode128.getCombinedIndex();
        StringBuffer stringBuffer = new StringBuffer();
        byte by = BarcodeUtil.check128(byArray, barcode128.getDefaultStartType());
        stringBuffer.append(BarcodeUtil.getcode((byte)(103 + barcode128.getDefaultStartType())));
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            stringBuffer.append(BarcodeUtil.getcode(byArray[i]));
        }
        stringBuffer.append(BarcodeUtil.getcode(by));
        stringBuffer.append("1100011101011");
        return stringBuffer;
    }

    public static StringBuffer codabarTran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = BarcodeTable.codabar.length;
        if (!(string.indexOf(0) != 65 && string.indexOf(0) != 66 && string.indexOf(0) != 67 && string.indexOf(0) != 68 || string.indexOf(string.length() - 1) != 65 && string.indexOf(string.length() - 1) != 66 && string.indexOf(string.length() - 1) != 67 && string.indexOf(string.length() - 1) != 68)) {
            stringBuffer2.append(string);
        } else {
            stringBuffer2.append('A').append(string).append('A');
        }
        for (int i = 0; i < stringBuffer2.length(); ++i) {
            for (int j = 0; j < n; ++j) {
                if (stringBuffer2.charAt(i) != BarcodeTable.codabar[j]) continue;
                stringBuffer.append(BarcodeTable.codabarTranslate[j]);
            }
        }
        return stringBuffer;
    }

    public static StringBuffer[] EAN13Tran(String string) {
        int n;
        int n2;
        String string2 = "";
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        for (n2 = 0; n2 <= 9; ++n2) {
            if (string.charAt(0) != BarcodeTable.EAN13[n2]) continue;
            string2 = BarcodeTable.EAN13MTable[n2];
        }
        stringBufferArray[0] = stringBufferArray[0].append("101");
        for (n2 = 1; n2 <= 6; ++n2) {
            if (string2.charAt(n2 - 1) == '0') {
                for (n = 0; n <= 9; ++n) {
                    if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                    stringBufferArray[0].append(BarcodeTable.EAN13Translate[0][n]);
                }
                continue;
            }
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                stringBufferArray[0].append(BarcodeTable.EAN13Translate[1][n]);
            }
        }
        stringBufferArray[1].append("01010");
        for (n2 = 7; n2 < 13; ++n2) {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                stringBufferArray[1].append(BarcodeTable.EAN13Translate[2][n]);
            }
        }
        stringBufferArray[1].append("101");
        return stringBufferArray;
    }

    public static StringBuffer[] EAN8Tran(String string) {
        int n;
        int n2;
        String string2 = "";
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        stringBufferArray[0] = stringBufferArray[0].append("101");
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                stringBufferArray[0].append(BarcodeTable.EAN13Translate[0][n]);
            }
        }
        stringBufferArray[1].append("01010");
        for (n2 = 4; n2 < 8; ++n2) {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                stringBufferArray[1].append(BarcodeTable.EAN13Translate[2][n]);
            }
        }
        stringBufferArray[1].append("101");
        return stringBufferArray;
    }

    public static StringBuffer UPCETran(String string) {
        int n;
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (string.charAt(0) == '0') {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(7) != BarcodeTable.EAN13[n]) continue;
                string2 = BarcodeTable.UPCEMTable[0][n];
            }
        } else {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(7) != BarcodeTable.EAN13[n]) continue;
                string2 = BarcodeTable.UPCEMTable[1][n];
            }
        }
        stringBuffer.append("101");
        for (n = 1; n <= 6; ++n) {
            int n2;
            if (string2.charAt(n - 1) == '0') {
                for (n2 = 0; n2 <= 9; ++n2) {
                    if (string.charAt(n) != BarcodeTable.EAN13[n2]) continue;
                    stringBuffer.append(BarcodeTable.EAN13Translate[0][n2]);
                }
                continue;
            }
            for (n2 = 0; n2 <= 9; ++n2) {
                if (string.charAt(n) != BarcodeTable.EAN13[n2]) continue;
                stringBuffer.append(BarcodeTable.EAN13Translate[1][n2]);
            }
        }
        stringBuffer.append("010101");
        return stringBuffer;
    }

    public static StringBuffer[] UPCATran(String string) {
        int n;
        int n2;
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        stringBufferArray[0].append("101");
        for (n2 = 0; n2 < 6; ++n2) {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                stringBufferArray[0].append(BarcodeTable.EAN13Translate[0][n]);
            }
        }
        stringBufferArray[1].append("01010");
        for (n2 = 6; n2 < 12; ++n2) {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                stringBufferArray[1].append(BarcodeTable.EAN13Translate[2][n]);
            }
        }
        stringBufferArray[1].append("101");
        return stringBufferArray;
    }

    public static StringBuffer Code39Tran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (n > 0 && string.charAt(0) != '*') {
            stringBuffer.append(BarcodeTable.code39STranslate[7]);
            stringBuffer.append("0");
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') {
                for (n2 = 0; n2 < 10; ++n2) {
                    if (string.charAt(i) != BarcodeTable.code39N[n2]) continue;
                    stringBuffer.append(BarcodeTable.code39NTranslate[n2]);
                }
            } else if (string.charAt(i) >= 'A' && string.charAt(i) <= 'Z') {
                for (n2 = 0; n2 < 26; ++n2) {
                    if (string.charAt(i) != BarcodeTable.code39C[n2]) continue;
                    stringBuffer.append(BarcodeTable.code39CTranslate[n2]);
                }
            } else {
                for (n2 = 0; n2 < 8; ++n2) {
                    if (string.charAt(i) != BarcodeTable.code39S[n2]) continue;
                    stringBuffer.append(BarcodeTable.code39STranslate[n2]);
                }
            }
            stringBuffer.append("0");
        }
        if (string.charAt(n - 1) != '*') {
            stringBuffer.append(BarcodeTable.code39STranslate[7]);
        }
        return stringBuffer;
    }

    public static StringBuffer supplement2Tran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        int n = BarcodeUtil.checkSupplement2(string);
        string2 = BarcodeTable.supplement2MTable[n];
        stringBuffer.append("1011");
        for (int i = 0; i <= 1; ++i) {
            int n2;
            if (string2.charAt(i) == '0') {
                for (n2 = 0; n2 <= 9; ++n2) {
                    if (string.charAt(i) != BarcodeTable.EAN13[n2]) continue;
                    stringBuffer.append(BarcodeTable.EAN13Translate[0][n2]);
                }
            } else {
                for (n2 = 0; n2 <= 9; ++n2) {
                    if (string.charAt(i) != BarcodeTable.EAN13[n2]) continue;
                    stringBuffer.append(BarcodeTable.EAN13Translate[1][n2]);
                }
            }
            if (i == 1) continue;
            stringBuffer.append("01");
        }
        return stringBuffer;
    }

    public static StringBuffer supplement5Tran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        int n = BarcodeUtil.checkSupplement5(string);
        string2 = BarcodeTable.supplement5MTable[n];
        stringBuffer.append("1011");
        for (int i = 0; i <= 4; ++i) {
            int n2;
            if (string2.charAt(i) == '0') {
                for (n2 = 0; n2 <= 9; ++n2) {
                    if (string.charAt(i) != BarcodeTable.EAN13[n2]) continue;
                    stringBuffer.append(BarcodeTable.EAN13Translate[0][n2]);
                }
            } else {
                for (n2 = 0; n2 <= 9; ++n2) {
                    if (string.charAt(i) != BarcodeTable.EAN13[n2]) continue;
                    stringBuffer.append(BarcodeTable.EAN13Translate[1][n2]);
                }
            }
            if (i == 4) continue;
            stringBuffer.append("01");
        }
        return stringBuffer;
    }

    public static int checkCode(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = string.length() + 1;
        for (int i = 2; i <= n2; ++i) {
            int n5 = 0;
            if (i % 2 == 0) {
                n5 = new Integer(String.valueOf(string.charAt(n2 - i)));
                n3 += n5;
                continue;
            }
            n5 = new Integer(String.valueOf(string.charAt(n2 - i)));
            n4 += n5;
        }
        n = n3 * 3 + n4;
        n = n % 10 != 0 ? 10 - n % 10 : 0;
        return n;
    }

    public static char checkCode2(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') {
                for (n3 = 0; n3 < 10; ++n3) {
                    if (string.charAt(i) != BarcodeTable.code39N[n3]) continue;
                    n += n3;
                }
                continue;
            }
            if (string.charAt(i) >= 'A' && string.charAt(i) <= 'Z') {
                for (n3 = 0; n3 < 26; ++n3) {
                    if (string.charAt(i) != BarcodeTable.code39C[n3]) continue;
                    n = n + n3 + 10;
                }
                continue;
            }
            if (string.charAt(i) == '*') continue;
            for (n3 = 0; n3 < 8; ++n3) {
                if (string.charAt(i) != BarcodeTable.code39S[n3]) continue;
                n = n + n3 + 10 + 26;
            }
        }
        char c = (n %= 43) <= 9 ? BarcodeTable.code39N[n] : (n <= 35 ? BarcodeTable.code39C[n - 10] : BarcodeTable.code39S[n - 10 - 26]);
        return c;
    }

    public static byte check128(byte[] byArray, int n) {
        int n2 = byArray.length;
        int n3 = 0;
        byte by = 0;
        for (int i = 1; i <= n2; ++i) {
            if (byArray[i - 1] == -1) continue;
            n3 += i * byArray[i - 1];
        }
        n3 = n + 103 + n3;
        by = (byte)(n3 % 103);
        return by;
    }

    public static int checkSupplement2(String string) {
        int n = new Integer(String.valueOf(string));
        return n %= 4;
    }

    public static int checkSupplement5(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 5; ++i) {
            int n3 = 0;
            if (i % 2 == 0) {
                n3 = new Integer(String.valueOf(string.charAt(i)));
                n2 += n3 * 3;
                continue;
            }
            n3 = new Integer(String.valueOf(string.charAt(i)));
            n += n3 * 9;
        }
        int n4 = (n2 + n) % 10;
        return n4;
    }

    public static StringBuffer getcode(byte by) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = BarcodeTable.code128table1[by];
        int[] nArray = new int[11];
        for (n = 0; n < 11; ++n) {
            nArray[10 - n] = n2 % 2;
            n2 /= 2;
        }
        for (n = 0; n < 11; ++n) {
            stringBuffer.append(nArray[n]);
        }
        return stringBuffer;
    }

    public static String convertUPCAtoUPCE(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() < 12) {
            String string2 = "000000000000" + string;
            string = string2.substring(string2.length() - 12, string2.length());
        }
        if (string.length() == 12) {
            if (string.charAt(0) != '0' && string.charAt(0) != '1') {
                stringBuffer.append("Invalid Number System (only 0 & 1 are valid)");
            } else if (string.substring(3, 6).equals("000") || string.substring(3, 6).equals("100") || string.substring(3, 6).equals("200")) {
                stringBuffer.append(string.substring(1, 3) + string.substring(8, 11) + string.substring(3, 4));
            } else if (string.substring(4, 6).equals("00")) {
                stringBuffer.append(string.substring(1, 4) + string.substring(9, 11) + "3");
            } else if (string.substring(5, 6).equals("0")) {
                stringBuffer.append(string.substring(1, 5) + string.substring(10, 11) + "4");
            } else if (string.charAt(11) >= '5') {
                stringBuffer.append(string.substring(1, 6) + string.substring(10, 11));
            } else {
                stringBuffer.append("Invalid product code (00005 to 00009 are valid)");
            }
        } else {
            stringBuffer.append("Invalid product code ");
        }
        if (stringBuffer.substring(0, 1).equals("I")) {
            return stringBuffer.toString();
        }
        return string.charAt(0) + stringBuffer.toString() + string.charAt(string.length() - 1);
    }

    public static void printBarcodeDataM(String string, Graphics2D graphics2D, int n, int n2, int n3) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = n2;
        int n5 = (int)fontMetrics.getStringBounds(string, graphics2D).getHeight();
        for (int i = 0; i < string.length(); ++i) {
            int n6 = n - n3 / 2 + n3 / string.length() * i + n3 / (2 * string.length());
            int n7 = fontMetrics.stringWidth(string.charAt(i) + "");
            graphics2D.drawString(string.charAt(i) + "", n6 - n7 / 2, n4 + n5 * 3 / 4);
        }
    }

    public static void printBarcodeDataB(String string, Graphics2D graphics2D, int n, int n2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = (int)fontMetrics.getStringBounds(string, graphics2D).getHeight();
        graphics2D.drawString(string, n - n3, n2 - n4 / 4);
    }

    public static void printBarcodeDataA(String string, Graphics2D graphics2D, int n, int n2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = (int)fontMetrics.getStringBounds(string, graphics2D).getHeight();
        graphics2D.drawString(string, n + n3 / 4, n2 - n4 / 4);
    }

    public static void printBarcodeDataU(String string, Graphics2D graphics2D, int n, int n2, int n3) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = n2;
        int n5 = (int)fontMetrics.getStringBounds(string, graphics2D).getHeight();
        for (int i = 0; i < string.length(); ++i) {
            int n6 = n - n3 / 2 + n3 / string.length() * i + n3 / (2 * string.length());
            int n7 = fontMetrics.stringWidth(string.charAt(i) + "");
            graphics2D.drawString(string.charAt(i) + "", n6 - n7 / 2, n4 - n5 / 4);
        }
    }

    public static void setCentre(int n, int n2) {
        centreX = n;
        centreY = n2;
    }

    public static int getCodabarLength(StringBuffer stringBuffer, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if ((i + 1) % 7 % 2 != 0 || (i + 1) % 7 == 0) {
                n3 = stringBuffer.charAt(i) == '1' ? (n3 += n2) : ++n3;
                if ((i + 1) % 7 != 0) continue;
                ++n3;
                continue;
            }
            if (stringBuffer.charAt(i) == '1') {
                n3 += n2;
                continue;
            }
            ++n3;
        }
        return n3;
    }

    public static float getUserDimFromMils(int n, int n2) {
        float f;
        if (n2 == 0) {
            f = (float)n * 72.0f / 1000.0f;
            if ((float)n - f * 1000.0f / 72.0f > 0.0f) {
                f += 1.0f;
            }
        } else {
            f = n2 == 1 ? (float)((double)n * 1312.3 / 3333.33 * 72.0 / 1000.0) : (float)n;
        }
        return f;
    }

    public static void drawbar(Graphics2D graphics2D, float f, float f2, float f3, float f4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f + f3, f2);
        generalPath.lineTo(f + f3, f2 + f4);
        generalPath.lineTo(f, f2 + f4);
        generalPath.closePath();
        graphics2D.fill(generalPath);
    }
}

