/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode.linearBarcode;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.barcode.BarcodeUtil;
import jet.datastream.render.barcode.linearBarcode.BarcodeConstraints;
import jet.datastream.render.barcode.linearBarcode.LinearBarcode;

public class Barcode128
extends LinearBarcode {
    protected int iStartType;
    protected int iSwapedType;
    protected int iSymIndex;
    protected int iInfoInfex;
    protected int iSetType;
    protected String data;
    public int centreX;
    public int centreY;
    String barcodeString;
    public int startType;
    private float S;

    public Barcode128() {
    }

    public Barcode128(BarcodeConstraints barcodeConstraints) {
        this.paper = barcodeConstraints;
    }

    @Override
    public void init() {
        block2: {
            this.data = this.barcodeString = this.paper.getBarMessage();
            this.centreX = this.paper.getCenterX();
            this.centreY = this.paper.getCenterY();
            this.foreColor = this.paper.getForeground();
            this.unit = this.paper.getUnit();
            this.barHeight = this.paper.getBarHeight();
            this.showBottomText = this.paper.getBarHRDisplay();
            this.narrowWidth = this.paper.getBarNarrowWidth();
            this.enableCheckDigit = this.paper.getBarCheckEnable();
            this.scaleMode = this.paper.getBarScaleMode();
            this.startingQuietZone = this.paper.getBarQuietZone();
            this.bottomLabelFont = this.paper.getBarHRFont();
            try {
                this.setStartType(this.paper.getBar128Type());
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block2;
                JRLog.error(2, 300018, (Throwable)exception);
            }
        }
        this.backColor = this.paper.getBackground();
        this.isExPDF = this.paper.getIsExportToPDF();
    }

    protected StringBuffer code128Tran(String string, int n) {
        int n2 = string.length();
        byte[] byArray = new byte[n2 * 2 + 1];
        byArray = this.getCombinedIndex();
        StringBuffer stringBuffer = new StringBuffer();
        byte by = BarcodeUtil.check128(byArray, this.iStartType);
        stringBuffer.append(BarcodeUtil.getcode((byte)(103 + this.iStartType)).toString());
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0 && byArray[i] != -1) {
                stringBuffer.append(BarcodeUtil.getcode(byArray[i]).toString());
                continue;
            }
            if (byArray[i] != -1) continue;
            stringBuffer.append(BarcodeUtil.getcode((byte)(byArray[i] + 1)).toString());
        }
        if (this.enableCheckDigit) {
            stringBuffer.append(BarcodeUtil.getcode(by).toString());
        }
        stringBuffer.append("1100011101011");
        return stringBuffer;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        try {
            this.printCode128(graphics2D, this.barcodeString, this.startType);
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 300018, (Throwable)exception);
            }
            return;
        }
    }

    @Override
    public void calculateWidth() {
        try {
            this.calculateBarcode128Width(this.barcodeString, this.startType);
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 300018, (Throwable)exception);
            }
            return;
        }
    }

    protected void calculateBarcode128Width(String string, int n) {
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 0.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == 0) {
            return;
        }
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f6 *= this.unit;
        stringBuffer = this.code128Tran(string, n);
        f = f2 = (float)this.centreX - (float)stringBuffer.length() * (f5 *= this.unit) / 2.0f;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        this.barcodeWidth = (int)((float)stringBuffer.length() * f5);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            f += f5;
        }
        Rectangle2D rectangle2D = RenderGraphicsToolkit.getBounds("" + string.charAt(0), this.bottomLabelFont);
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (int)rectangle2D.getHeight();
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n2 * 2)), (int)(f3 + (float)(n3 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    protected void printCode128(Graphics2D graphics2D, String string, int n) {
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 0.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == 0) {
            return;
        }
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f6 *= this.unit;
        stringBuffer = this.code128Tran(string, n);
        f = f2 = (float)this.centreX - (float)stringBuffer.length() * (f5 *= this.unit) / 2.0f;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        this.barcodeWidth = (int)((float)stringBuffer.length() * f5);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '1') {
                if (this.foreColor != null) {
                    graphics2D.setColor(this.foreColor);
                } else {
                    graphics2D.setColor(Color.black);
                }
                BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
            } else if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
                BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
            }
            f += f5;
        }
        if (this.showBottomText) {
            graphics2D.setColor(this.foreColor);
            graphics2D.setFont(this.bottomLabelFont);
            BarcodeUtil.printBarcodeDataM(string, graphics2D, (int)(f / 2.0f + f2 / 2.0f), (int)(f3 + f4), (int)(f - f2));
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.stringWidth("" + string.charAt(0));
        int n3 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n2 * 2)), (int)(f3 + (float)(n3 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    protected void checkASegment(int n, String string, byte[] byArray) {
        int n2 = string.length() - this.iSymIndex;
        int n3 = 0;
        int n4 = string.length();
        char[] cArray = new char[n4];
        string.getChars(0, n4, cArray, 0);
        while (!(n3 >= n2 || string.length() == ++n3 + this.iSymIndex || cArray[n3 + this.iSymIndex] >= '`' && cArray[n3 + this.iSymIndex] <= '\u007f' || cArray[n3 + this.iSymIndex] >= '0' && cArray[n3 + this.iSymIndex] <= '9' || (byte)cArray[n3 + this.iSymIndex] == 134)) {
        }
        if (n3 > 1) {
            byArray[this.iInfoInfex] = 101;
            for (int i = 0; i < n3; ++i) {
                byArray[this.iInfoInfex + 1 + i] = (byte)this.findABIndex(cArray[this.iSymIndex + i]);
            }
            this.iInfoInfex += 1 + n3;
            this.iSymIndex += n3;
            this.iSwapedType = 0;
        } else if (n3 == 1) {
            if (this.iSwapedType != 1 || this.iStartType == 2) {
                byArray[this.iInfoInfex] = 101;
                this.iSwapedType = 0;
            } else {
                byArray[this.iInfoInfex] = 98;
            }
            byArray[this.iInfoInfex + 1] = (byte)this.findABIndex(cArray[this.iSymIndex]);
            this.iInfoInfex += 2;
            ++this.iSymIndex;
        }
    }

    protected void checkBSegment(int n, String string, byte[] byArray) {
        int n2 = string.length() - this.iSymIndex;
        int n3 = 0;
        int n4 = string.length();
        char[] cArray = new char[n4];
        string.getChars(0, n4, cArray, 0);
        while (n3 < n2 && string.length() != ++n3 + this.iSymIndex && cArray[n3 + this.iSymIndex] >= ' ' && (cArray[n3 + this.iSymIndex] < '0' || cArray[n3 + this.iSymIndex] > '9') && (byte)cArray[n3 + this.iSymIndex] != 134) {
        }
        if (n3 > 1) {
            byArray[this.iInfoInfex] = 100;
            for (int i = 0; i < n3; ++i) {
                byArray[this.iInfoInfex + 1 + i] = (byte)this.findABIndex(cArray[this.iSymIndex + i]);
            }
            this.iInfoInfex += 1 + n3;
            this.iSymIndex += n3;
            this.iSwapedType = 1;
        } else if (n3 == 1) {
            if (this.iSwapedType != 0 || this.iStartType == 2) {
                byArray[this.iInfoInfex] = 100;
                this.iSwapedType = 1;
            } else {
                byArray[this.iInfoInfex] = 98;
            }
            byArray[this.iInfoInfex + 1] = (byte)this.findABIndex(cArray[this.iSymIndex]);
            this.iInfoInfex += 2;
            ++this.iSymIndex;
        }
    }

    protected boolean checkCSegment(int n, String string, byte[] byArray) {
        int n2;
        int n3 = 0;
        int n4 = string.length() - this.iSymIndex;
        int n5 = string.length();
        char[] cArray = new char[n5];
        string.getChars(0, n5, cArray, 0);
        for (n2 = 0; n2 < n4 && cArray[this.iSymIndex + n2] >= '0' && cArray[this.iSymIndex + n2] <= '9'; ++n2) {
        }
        if (n2 <= 3 || n2 % 2 != 0) {
            if (n2 <= 3) {
                for (int i = 0; i < n2; ++i) {
                    byArray[this.iInfoInfex] = (byte)this.findABIndex(cArray[this.iSymIndex + i]);
                    ++this.iInfoInfex;
                }
                this.iSymIndex += n2;
                return false;
            }
            byArray[this.iInfoInfex] = (byte)this.findABIndex(cArray[this.iSymIndex]);
            ++this.iInfoInfex;
            ++this.iSymIndex;
        }
        this.iSwapedType = 2;
        n3 = n2 / 2;
        byte[] byArray2 = new byte[3];
        byArray[this.iInfoInfex] = 99;
        ++this.iInfoInfex;
        for (int i = 0; i < n3; ++i) {
            Integer n6 = new Integer(new String(cArray, i * 2 + this.iSymIndex, 2));
            byArray[this.iInfoInfex] = (byte)n6.intValue();
            if (n6 == 0) {
                byArray[this.iInfoInfex] = -1;
            }
            ++this.iInfoInfex;
        }
        this.iSymIndex += 2 * n3;
        return true;
    }

    protected int findABIndex(char c) {
        int n = -1;
        if (c >= ' ' && c <= '/') {
            n = c - 32;
        } else if (c >= '0' && c <= '_') {
            n = 16 + c - 48;
        } else if (c >= '\u0000' && c <= '\u001f') {
            n = 64 + c;
        } else if (c >= '`' && c <= '\u007f') {
            n = 64 + c - 96;
        } else if ((byte)c >= 128) {
            n = 96 + ((byte)c - 128);
        }
        if (n == 0) {
            n = -1;
        }
        return n;
    }

    public byte[] getCombinedIndex() {
        int n = this.data.length();
        this.iInfoInfex = 0;
        byte[] byArray = new byte[n * 2 + 1];
        this.iInfoInfex = 0;
        char[] cArray = new char[n];
        this.data.getChars(0, n, cArray, 0);
        this.iSwapedType = this.iStartType;
        if (this.iStartType == 0 || this.iStartType == 1) {
            this.iSymIndex = 0;
            while (this.iSymIndex < n) {
                if (this.iStartType == 0) {
                    if (cArray[this.iSymIndex] >= '`' && cArray[this.iSymIndex] <= '\u007f') {
                        this.checkBSegment(this.iStartType, this.data, byArray);
                        continue;
                    }
                    if (cArray[this.iSymIndex] >= '0' && cArray[this.iSymIndex] <= '9') {
                        this.checkCSegment(this.iStartType, this.data, byArray);
                        continue;
                    }
                    if ((byte)cArray[this.iSymIndex] != 134) {
                        if (this.iSwapedType != 0) {
                            this.iSwapedType = 0;
                            byArray[this.iInfoInfex] = 101;
                            ++this.iInfoInfex;
                        }
                        byArray[this.iInfoInfex] = (byte)this.findABIndex(cArray[this.iSymIndex]);
                    } else {
                        byArray[this.iInfoInfex] = -122;
                    }
                    ++this.iInfoInfex;
                    ++this.iSymIndex;
                    continue;
                }
                if (this.iStartType != 1) continue;
                if (cArray[this.iSymIndex] >= '\u0000' && cArray[this.iSymIndex] <= ' ') {
                    this.checkASegment(this.iStartType, this.data, byArray);
                    continue;
                }
                if (cArray[this.iSymIndex] >= '0' && cArray[this.iSymIndex] <= '9') {
                    this.checkCSegment(this.iStartType, this.data, byArray);
                    continue;
                }
                if ((byte)cArray[this.iSymIndex] != 134) {
                    if (this.iSwapedType != 1) {
                        this.iSwapedType = 1;
                        byArray[this.iInfoInfex] = 101;
                        ++this.iInfoInfex;
                    }
                    byArray[this.iInfoInfex] = (byte)this.findABIndex(cArray[this.iSymIndex]);
                } else {
                    byArray[this.iInfoInfex] = -122;
                }
                ++this.iInfoInfex;
                ++this.iSymIndex;
            }
        } else {
            byte[] byArray2 = new byte[3];
            this.iSymIndex = 0;
            this.iSwapedType = 2;
            while (this.iSymIndex < n) {
                if (cArray[this.iSymIndex] <= '9' && cArray[this.iSymIndex] >= '0' && this.iSymIndex + 1 < n && cArray[this.iSymIndex + 1] >= '0' && cArray[this.iSymIndex + 1] <= '9') {
                    if (this.iSwapedType != 2) {
                        byArray[this.iInfoInfex] = 99;
                        ++this.iInfoInfex;
                    }
                    this.iSwapedType = 2;
                    byArray[this.iInfoInfex] = (byte)new Integer(new String(cArray, this.iSymIndex, 2)).intValue();
                    if (new Integer(new String(cArray, this.iSymIndex, 2)) == 0) {
                        byArray[this.iInfoInfex] = -1;
                    }
                    ++this.iInfoInfex;
                    this.iSymIndex += 2;
                    continue;
                }
                if (cArray[this.iSymIndex] >= '`' && cArray[this.iSymIndex] <= '\u007f') {
                    this.checkBSegment(this.iStartType, this.data, byArray);
                    continue;
                }
                if (cArray[this.iSymIndex] >= '\u0000' && cArray[this.iSymIndex] <= ' ') {
                    this.checkASegment(this.iStartType, this.data, byArray);
                    continue;
                }
                if ((byte)cArray[this.iSymIndex] != 134) {
                    if (this.iSwapedType == 2) {
                        this.iSwapedType = 1;
                        byArray[this.iInfoInfex] = 100;
                        ++this.iInfoInfex;
                    }
                    byArray[this.iInfoInfex] = (byte)this.findABIndex(cArray[this.iSymIndex]);
                } else {
                    byArray[this.iInfoInfex] = -122;
                }
                ++this.iSymIndex;
                ++this.iInfoInfex;
            }
        }
        return byArray;
    }

    protected int getDefaultType() {
        int n = 0;
        int n2 = 65535;
        for (int i = 0; i < 3; ++i) {
            this.iStartType = i;
            byte[] byArray = this.getCombinedIndex();
            if (this.iInfoInfex >= n2) continue;
            n2 = this.iInfoInfex;
            n = i;
        }
        this.iStartType = n;
        return n;
    }

    public int getStartType() {
        return this.iSetType;
    }

    public int getDefaultStartType() {
        return this.iStartType;
    }

    public int isPropertyValid(long l) {
        if (l == 12L || l == 10L) {
            return 2;
        }
        return l != 6L ? 0 : 1;
    }

    public void setStartType(int n) {
        this.iSetType = n;
        this.validate();
    }

    public boolean validate() {
        if (this.iSetType >= 3 || this.iSetType < 0) {
            this.iSetType = 3;
            this.getDefaultType();
        } else {
            this.iStartType = this.iSetType;
        }
        return true;
    }

    public void setBarcodeData(String string) {
        this.data = string;
    }

    @Override
    public int getBarcodeWidth() {
        return this.barcodeWidth;
    }
}

