/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode.linearBarcode;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.barcode.BarcodeTable;
import jet.datastream.render.barcode.BarcodeUtil;
import jet.datastream.render.barcode.linearBarcode.BarcodeConstraints;
import jet.datastream.render.barcode.linearBarcode.LinearBarcode;

public class BarcodeCodabar
extends LinearBarcode {
    public int centreX;
    public int centreY;
    String barcodeString = "12345";

    public BarcodeCodabar(BarcodeConstraints barcodeConstraints) {
        this.paper = barcodeConstraints;
    }

    @Override
    public void init() {
        this.barcodeString = this.paper.getBarMessage();
        this.centreX = this.paper.getCenterX();
        this.centreY = this.paper.getCenterY();
        this.foreColor = this.paper.getForeground();
        this.barHeight = this.paper.getBarHeight();
        this.showBottomText = this.paper.getBarHRDisplay();
        this.narrowWidth = this.paper.getBarNarrowWidth();
        this.scaleMode = this.paper.getBarScaleMode();
        this.bottomLabelFont = this.paper.getBarHRFont();
        this.startingQuietZone = this.paper.getBarQuietZone();
        this.unit = this.paper.getUnit();
        this.wideToNarrowRatio = (int)this.paper.getBarRatio();
        if (this.wideToNarrowRatio != 3) {
            this.wideToNarrowRatio = 2;
        }
        this.backColor = this.paper.getBackground();
        this.isExPDF = this.paper.getIsExportToPDF();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.printCodabar(graphics2D, this.barcodeString);
    }

    @Override
    public void calculateWidth() {
        this.F(this.barcodeString);
    }

    private void F(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == 0) {
            return;
        }
        for (n = 0; n < string.length(); ++n) {
            boolean bl = false;
            for (int i = 0; i < BarcodeTable.codabar.length; ++i) {
                if (string.charAt(n) != BarcodeTable.codabar[i]) continue;
                bl = true;
            }
            if (bl) continue;
            return;
        }
        stringBuffer = this.codabarTran(string);
        n = stringBuffer.length();
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f6 *= this.unit;
        f = f2 = (float)this.centreX - (float)BarcodeUtil.getCodabarLength(stringBuffer, n, this.wideToNarrowRatio) * (f5 *= this.unit) / 2.0f;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        for (int i = 0; i < n; ++i) {
            if ((i + 1) % 7 % 2 != 0 || (i + 1) % 7 == 0) {
                f = stringBuffer.charAt(i) == '1' ? (f += (float)this.wideToNarrowRatio * f5) : (f += f5);
                if ((i + 1) % 7 != 0) continue;
                f += f5;
                continue;
            }
            if (stringBuffer.charAt(i) == '1') {
                f += (float)this.wideToNarrowRatio * f5;
                continue;
            }
            f += f5;
        }
        Rectangle2D rectangle2D = RenderGraphicsToolkit.getBounds("" + string.charAt(0), this.bottomLabelFont);
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (int)rectangle2D.getHeight();
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n2 * 2)), (int)(f3 + (float)(n3 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    public StringBuffer codabarTran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = BarcodeTable.codabar.length;
        if (!(string.charAt(0) != 'A' && string.charAt(0) != 'B' && string.charAt(0) != 'C' && string.charAt(0) != 'D' || string.charAt(string.length() - 1) != 'A' && string.charAt(string.length() - 1) != 'B' && string.charAt(string.length() - 1) != 'C' && string.charAt(string.length() - 1) != 'D')) {
            stringBuffer2.append(string);
        } else if (string.charAt(0) != 'A' && string.charAt(0) != 'B' && string.charAt(0) != 'C' && string.charAt(0) != 'D' && string.charAt(string.length() - 1) != 'A' && string.charAt(string.length() - 1) != 'B' && string.charAt(string.length() - 1) != 'C' && string.charAt(string.length() - 1) != 'D') {
            stringBuffer2.append('A').append(string).append('A');
        }
        for (int i = 0; i < stringBuffer2.length(); ++i) {
            for (int j = 0; j < n; ++j) {
                if (stringBuffer2.charAt(i) != BarcodeTable.codabar[j]) continue;
                stringBuffer.append(BarcodeTable.codabarTranslate[j]);
            }
        }
        return stringBuffer;
    }

    public void printCodabar(Graphics2D graphics2D, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == 0) {
            return;
        }
        for (n = 0; n < string.length(); ++n) {
            boolean bl = false;
            for (int i = 0; i < BarcodeTable.codabar.length; ++i) {
                if (string.charAt(n) != BarcodeTable.codabar[i]) continue;
                bl = true;
            }
            if (bl) continue;
            return;
        }
        stringBuffer = this.codabarTran(string);
        if (stringBuffer.length() == 0) {
            return;
        }
        n = stringBuffer.length();
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f6 *= this.unit;
        f = f2 = (float)this.centreX - (float)BarcodeUtil.getCodabarLength(stringBuffer, n, this.wideToNarrowRatio) * (f5 *= this.unit) / 2.0f;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        for (int i = 0; i < n; ++i) {
            if ((i + 1) % 7 % 2 != 0 || (i + 1) % 7 == 0) {
                graphics2D.setColor(this.foreColor);
                if (stringBuffer.charAt(i) == '1') {
                    BarcodeUtil.drawbar(graphics2D, f, f4, (float)this.wideToNarrowRatio * f5, f3);
                    f += (float)this.wideToNarrowRatio * f5;
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
                    f += f5;
                }
                if ((i + 1) % 7 != 0) continue;
                f += f5;
                continue;
            }
            if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
            }
            if (stringBuffer.charAt(i) == '1') {
                if (this.isExPDF) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, (float)this.wideToNarrowRatio * f5, f3);
                }
                f += (float)this.wideToNarrowRatio * f5;
                continue;
            }
            if (this.isExPDF) {
                BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
            }
            f += f5;
        }
        if (this.showBottomText) {
            graphics2D.setColor(this.foreColor);
            graphics2D.setFont(this.bottomLabelFont);
            BarcodeUtil.printBarcodeDataM(string, graphics2D, (int)(f / 2.0f + f2 / 2.0f), (int)(f3 + f4), (int)(f - f2));
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.stringWidth("" + string.charAt(0));
        int n3 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n2 * 2)), (int)(f3 + (float)(n3 * 2)));
        this.paper.setBarDimension(this.barD);
    }
}

