/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode.linearBarcode;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import jet.datastream.render.barcode.linearBarcode.Barcode128;
import jet.datastream.render.barcode.linearBarcode.Barcode39;
import jet.datastream.render.barcode.linearBarcode.BarcodeCodabar;
import jet.datastream.render.barcode.linearBarcode.BarcodeEAN13;
import jet.datastream.render.barcode.linearBarcode.BarcodeEAN8;
import jet.datastream.render.barcode.linearBarcode.BarcodeObject;
import jet.datastream.render.barcode.linearBarcode.BarcodeUPCA;
import jet.datastream.render.barcode.linearBarcode.BarcodeUPCE;

public class BarcodeConstraints
extends JComponent {
    private int SEDU;
    private String calculateWidth = "";
    private String init = "";
    protected BarcodeObject[] barcodes;
    public boolean runtime = true;
    private String locate;
    public short barHeight = (short)72;
    private int paint = 1;
    private float rotate;
    private String I;
    private Color Z;
    private Color C;
    private boolean B;
    private boolean D = true;
    private int F;
    private int J;
    private int S;
    private int A;
    private int E;
    private Font G;
    private int H;
    private int K;
    private short L;
    private short M;
    private int N = 2;
    private int O;
    private boolean P = true;
    private int Q;
    private int R;
    private int T = 3;
    private Graphics g;
    private int U = 2;
    private boolean V;
    private int W;
    private double X;
    private Dimension Y = new Dimension();
    private float i = 1.0f;
    private boolean z;

    public BarcodeConstraints() {
    }

    public BarcodeConstraints(int n, String string) {
        this.SEDU = n;
        this.init = string;
        this.init();
    }

    public void locate() {
        this.Q = this.getBounds().width / 2;
        this.R = this.getBounds().height / 2;
    }

    public void init() {
        this.X = (double)this.W * Math.PI / 180.0;
        this.barcodes = new BarcodeObject[1];
        this.SEDU(this.SEDU, this.init);
        this.locate();
    }

    private void SEDU(int n, String string) {
        switch (n) {
            case 6: {
                this.barcodes[0] = new BarcodeCodabar(this);
                break;
            }
            case 5: {
                this.barcodes[0] = new Barcode128(this);
                break;
            }
            case 4: {
                this.barcodes[0] = new Barcode39(this);
                break;
            }
            case 2: {
                this.barcodes[0] = new BarcodeEAN13(this);
                break;
            }
            case 3: {
                this.barcodes[0] = new BarcodeEAN8(this);
                break;
            }
            case 1: {
                this.barcodes[0] = new BarcodeUPCE(this);
                break;
            }
            case 0: {
                this.barcodes[0] = new BarcodeUPCA(this);
            }
        }
        this.barcodes[0].init();
    }

    public void paint(Graphics2D graphics2D) {
        this.init();
        graphics2D.rotate(this.X);
        this.barcodes[0].paint(graphics2D);
        graphics2D.rotate(-this.X);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paint(graphics2D);
    }

    public void calculateWidth() {
        this.init();
        this.barcodes[0].calculateWidth();
    }

    public void setType(int n) {
        this.SEDU = n;
    }

    public int getType() {
        return this.SEDU;
    }

    public void setBodeCodeData(String string) {
        this.init = string;
    }

    public String getBodeCodeData() {
        return this.init;
    }

    public Object clone() {
        return null;
    }

    public void updateProperties() {
    }

    public void updateBounds() {
    }

    public void setBarOrientation(int n) {
        this.W = n;
    }

    public int getBarOrientation() {
        return this.W;
    }

    public void setBarHRFont(Font font) {
        this.G = font;
    }

    public Font getBarHRFont() {
        return this.G;
    }

    public void setBar128Type(int n) {
        this.T = n;
    }

    public int getBar128Type() {
        return this.T;
    }

    public void setBarCheckEnable(boolean bl) {
        this.D = bl;
    }

    public boolean getBarCheckEnable() {
        return this.D;
    }

    public void setBarNarrowWidth(short s) {
        this.paint = s;
    }

    public short getBarNarrowWidth() {
        return (short)this.paint;
    }

    public void setBarMessage(String string) {
        this.init = string;
    }

    public String getBarMessage() {
        return this.init;
    }

    public void setBarQuietZone(short s) {
        this.L = s;
        this.M = s;
    }

    public short getBarQuietZone() {
        return this.L;
    }

    public void setBarRatio(float f) {
        this.N = (int)f;
    }

    public float getBarRatio() {
        return this.N;
    }

    public void setBarScaleMode(int n) {
        this.U = n;
    }

    public int getBarScaleMode() {
        return this.U;
    }

    public void setBarSupplement(String string) {
        this.I = string;
    }

    public String getBarSupplement() {
        return this.I;
    }

    public void setBarSymbology(int n) {
        this.SEDU = n;
    }

    public int getBarSymbology() {
        return this.SEDU;
    }

    public void setBarHeight(short s) {
        this.barHeight = s;
    }

    public short getBarHeight() {
        return this.barHeight;
    }

    public void setBarHRDisplay(boolean bl) {
        this.P = bl;
    }

    public boolean getBarHRDisplay() {
        return this.P;
    }

    public void setBarTransparent(boolean bl) {
        this.V = bl;
    }

    public boolean getBarTransparent() {
        return this.V;
    }

    @Override
    public void setBackground(Color color) {
        this.Z = color;
    }

    @Override
    public Color getBackground() {
        return this.Z;
    }

    @Override
    public void setForeground(Color color) {
        this.C = color;
    }

    @Override
    public Color getForeground() {
        return this.C;
    }

    public void setCenterXY(int n, int n2) {
        this.Q = n;
        this.R = n2;
    }

    public int getCenterX() {
        return this.Q;
    }

    public int getCenterY() {
        return this.R;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.Y;
    }

    public void setBarDimension(Dimension dimension) {
        this.Y = dimension;
    }

    public void setUnit(float f) {
        this.i = f / 100.0f;
    }

    public float getUnit() {
        return this.i;
    }

    public void setIsExportToPDF(boolean bl) {
        this.z = bl;
    }

    public boolean getIsExportToPDF() {
        return this.z;
    }
}

