/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode.linearBarcode;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.barcode.BarcodeTable;
import jet.datastream.render.barcode.BarcodeUtil;
import jet.datastream.render.barcode.linearBarcode.BarcodeConstraints;
import jet.datastream.render.barcode.linearBarcode.LinearBarcode;

public class BarcodeEAN13
extends LinearBarcode {
    public int centreX;
    public int centreY;
    String barcodeString;
    boolean useSupplement = false;

    public BarcodeEAN13(BarcodeConstraints barcodeConstraints) {
        this.paper = barcodeConstraints;
    }

    @Override
    public void init() {
        this.barcodeString = this.paper.getBarMessage();
        this.centreX = this.paper.getCenterX();
        this.centreY = this.paper.getCenterY();
        this.foreColor = this.paper.getForeground();
        this.barHeight = this.paper.getBarHeight();
        this.showBottomText = this.paper.getBarHRDisplay();
        this.narrowWidth = this.paper.getBarNarrowWidth();
        this.scaleMode = this.paper.getBarScaleMode();
        this.bottomLabelFont = this.paper.getBarHRFont();
        this.supplementText = this.paper.getBarSupplement();
        this.enableCheckDigit = this.paper.getBarCheckEnable();
        this.startingQuietZone = this.paper.getBarQuietZone();
        this.unit = this.paper.getUnit();
        if (this.supplementText != null && (this.supplementText.length() == 2 || this.supplementText.length() == 5)) {
            this.useSupplement = true;
        }
        this.backColor = this.paper.getBackground();
        this.isExPDF = this.paper.getIsExportToPDF();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.printEAN13(graphics2D, this.barcodeString);
    }

    @Override
    public void calculateWidth() {
        this.EAN13(this.barcodeString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void EAN13(String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f5 *= this.unit;
        f6 *= this.unit;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        float f7 = f3 / 10.0f;
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
            return;
        }
        if (this.useSupplement && this.supplementText.length() == 2) {
            stringBuffer = BarcodeUtil.supplement2Tran(this.supplementText);
        } else if (this.useSupplement && this.supplementText.length() == 5) {
            stringBuffer = BarcodeUtil.supplement5Tran(this.supplementText);
        }
        if (string.length() == 12) {
            n = BarcodeUtil.checkCode(string);
            stringBufferArray = BarcodeEAN13.EAN13Tran(string + String.valueOf(n));
        } else {
            if (string.length() != 13) return;
            n = BarcodeUtil.checkCode(string.substring(0, 12));
            if (String.valueOf(n).equals(String.valueOf(string.charAt(12)))) {
                stringBufferArray = BarcodeEAN13.EAN13Tran(string);
            } else {
                if (this.enableCheckDigit) return;
                stringBufferArray = BarcodeEAN13.EAN13Tran(string);
            }
        }
        Rectangle2D rectangle2D = RenderGraphicsToolkit.getBounds("" + string.charAt(0), this.bottomLabelFont);
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (int)rectangle2D.getHeight();
        f = this.useSupplement ? (f2 = (float)this.centreX - ((float)(stringBufferArray[0].length() + stringBufferArray[1].length() + stringBuffer.length()) * f5 / 2.0f + (float)(n2 / 2))) : (f2 = (float)this.centreX - (float)(stringBufferArray[0].length() + stringBufferArray[1].length()) * f5 / 2.0f);
        for (int i = 0; i < stringBufferArray[0].length(); ++i) {
            f += f5;
        }
        float f8 = f;
        for (int i = 0; i < stringBufferArray[1].length(); ++i) {
            f += f5;
        }
        if (this.useSupplement) {
            float f9 = f += (float)n2;
            for (int i = 0; i < stringBuffer.length(); ++i) {
                f += f5;
            }
        }
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n2 * 2)), (int)(f3 + (float)(n3 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    public static StringBuffer[] EAN13Tran(String string) {
        int n;
        int n2;
        String string2 = "";
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        for (n2 = 0; n2 <= 9; ++n2) {
            if (string.charAt(0) != BarcodeTable.EAN13[n2]) continue;
            string2 = BarcodeTable.EAN13MTable[n2];
        }
        stringBufferArray[0] = stringBufferArray[0].append("101");
        for (n2 = 1; n2 <= 6; ++n2) {
            if (string2.charAt(n2 - 1) == '0') {
                for (n = 0; n <= 9; ++n) {
                    if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                    stringBufferArray[0].append(BarcodeTable.EAN13Translate[0][n]);
                }
                continue;
            }
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                stringBufferArray[0].append(BarcodeTable.EAN13Translate[1][n]);
            }
        }
        stringBufferArray[1].append("01010");
        for (n2 = 7; n2 < 13; ++n2) {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(n2) != BarcodeTable.EAN13[n]) continue;
                stringBufferArray[1].append(BarcodeTable.EAN13Translate[2][n]);
            }
        }
        stringBufferArray[1].append("101");
        return stringBufferArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printEAN13(Graphics2D graphics2D, String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f5 *= this.unit;
        f6 *= this.unit;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        float f7 = f3 / 10.0f;
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        graphics2D.setFont(this.bottomLabelFont);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
            return;
        }
        if (this.useSupplement && this.supplementText.length() == 2) {
            stringBuffer = BarcodeUtil.supplement2Tran(this.supplementText);
        } else if (this.useSupplement && this.supplementText.length() == 5) {
            stringBuffer = BarcodeUtil.supplement5Tran(this.supplementText);
        }
        if (string.length() == 12) {
            n = BarcodeUtil.checkCode(string);
            stringBufferArray = BarcodeEAN13.EAN13Tran(string + String.valueOf(n));
        } else {
            if (string.length() != 13) return;
            n = BarcodeUtil.checkCode(string.substring(0, 12));
            if (String.valueOf(n).equals(String.valueOf(string.charAt(12)))) {
                stringBufferArray = BarcodeEAN13.EAN13Tran(string);
            } else {
                if (this.enableCheckDigit) return;
                stringBufferArray = BarcodeEAN13.EAN13Tran(string);
            }
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.stringWidth("" + string.charAt(0));
        int n3 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        f = this.useSupplement ? (f2 = (float)this.centreX - ((float)(stringBufferArray[0].length() + stringBufferArray[1].length() + stringBuffer.length()) * f5 / 2.0f + (float)(n2 / 2))) : (f2 = (float)this.centreX - (float)(stringBufferArray[0].length() + stringBufferArray[1].length()) * f5 / 2.0f);
        for (int i = 0; i < stringBufferArray[0].length(); ++i) {
            if (stringBufferArray[0].charAt(i) == '1') {
                graphics2D.setColor(this.foreColor);
                if (i <= 2) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
                }
            } else if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
                if (i <= 2) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                }
            }
            f += f5;
        }
        float f8 = f;
        graphics2D.setColor(this.foreColor);
        BarcodeUtil.printBarcodeDataB(String.valueOf(string.charAt(0)), graphics2D, (int)f2, (int)(f3 + f4));
        BarcodeUtil.printBarcodeDataM(string.substring(1, 7), graphics2D, (int)(f / 2.0f + (f2 + f5 * 3.0f) / 2.0f), (int)(f3 + f4), (int)(f - f2 - f5 * 3.0f));
        for (int i = 0; i < stringBufferArray[1].length(); ++i) {
            if (stringBufferArray[1].charAt(i) == '1') {
                graphics2D.setColor(this.foreColor);
                if (i <= 4 || i >= stringBufferArray[1].length() - 3) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
                }
            } else if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
                if (i <= 4 || i >= stringBufferArray[1].length() - 3) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                }
            }
            f += f5;
        }
        graphics2D.setColor(this.foreColor);
        if (string.length() == 12) {
            BarcodeUtil.printBarcodeDataM(string.substring(7) + String.valueOf(n), graphics2D, (int)((f8 + 5.0f * f5) / 2.0f + (f - 3.0f * f5) / 2.0f), (int)(f3 + f4), (int)(f - 3.0f * f5 - f8 - 5.0f * f5));
        } else {
            BarcodeUtil.printBarcodeDataM(string.substring(7), graphics2D, (int)((f8 + 5.0f * f5) / 2.0f + (f - 3.0f * f5) / 2.0f), (int)(f3 + f4), (int)(f - 3.0f * f5 - f8 - 5.0f * f5));
        }
        if (this.useSupplement) {
            float f9 = f += (float)n2;
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) == '1') {
                    graphics2D.setColor(this.foreColor);
                    BarcodeUtil.drawbar(graphics2D, f, f4 + f7, f5, f3 - f7);
                } else if (this.isExPDF) {
                    if (this.backColor != null) {
                        graphics2D.setColor(this.backColor);
                    } else {
                        graphics2D.setColor(Color.white);
                    }
                    BarcodeUtil.drawbar(graphics2D, f, f4 + f7, f5, f3 - f7);
                }
                f += f5;
            }
            graphics2D.setColor(this.foreColor);
            BarcodeUtil.printBarcodeDataU(this.supplementText, graphics2D, (int)((f9 + f) / 2.0f), (int)(f4 + f7), (int)(f - f9));
        }
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n2 * 2)), (int)(f3 + (float)(n3 * 2)));
        this.paper.setBarDimension(this.barD);
    }
}

