/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.util;

import com.jinfonet.util.JRLog;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import jet.connect.DbBigInt;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.datastream.DSTemplatible;
import toolkit.db.gui.MappingSQLType;

public class SliderValueCollector {
    private static final int HALF_UP = 1000;
    private static final int SEDU = 60000;
    private static final int ZERO = 3600000;
    private static final int add = 86400000;
    private static final int clear = 604800000;
    private static final int clone = 16;
    private DSTemplatible compareTo;
    private Locale contains;

    public void setTemplate(DSTemplatible dSTemplatible) {
        this.compareTo = dSTemplatible;
    }

    public List cleanupSelectedValues(List list, List list2) {
        List<DbValue> list3 = new ArrayList();
        if ((Integer)this.compareTo.getPropertyByName("SliderType").getObject() == 0) {
            list3 = this.HALF_UP(list, list2);
        } else {
            int n = ((DbValue)list.get(0)).getSqlType();
            if (n == 12 || n == 1 || n == -1 || n == 2005) {
                for (int i = 0; i < list.size(); ++i) {
                    if (list2.contains(list.get(i))) {
                        list3.add((DbValue)list.get(i));
                        continue;
                    }
                    list3.clear();
                }
            } else {
                DbValue dbValue = (DbValue)list2.get(0);
                DbValue dbValue2 = (DbValue)list2.get(list2.size() - 1);
                DbValue dbValue3 = (DbValue)list.get(0);
                DbValue dbValue4 = (DbValue)list.get(list.size() - 1);
                if (dbValue3.compareTo(dbValue) <= 0) {
                    list3.add(dbValue);
                } else if (dbValue3.compareTo(dbValue2) >= 0) {
                    list3.add(dbValue2);
                } else {
                    list3.add(dbValue3);
                }
                if (dbValue4.compareTo(dbValue) <= 0) {
                    list3.add(dbValue);
                } else if (dbValue4.compareTo(dbValue2) >= 0) {
                    list3.add(dbValue2);
                } else {
                    list3.add(dbValue4);
                }
            }
        }
        return list3;
    }

    private List HALF_UP(List list, List list2) {
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        DbValue dbValue = (DbValue)list.get(0);
        if (list2.contains(dbValue)) {
            arrayList.add(dbValue);
        }
        return arrayList;
    }

    public List extractIntRangeValues(List list) {
        List<Long> list2 = new ArrayList<Long>();
        for (int i = 0; i < list.size(); ++i) {
            list2.add(((DbBigInt)list.get(i)).get());
        }
        list2 = this.SEDU((Long)list2.get(0), (Long)list2.get(list2.size() - 1));
        DbColDesc dbColDesc = ((DbValue)list.get(0)).getColDesc();
        List list3 = this.contains(dbColDesc, list2);
        return list3;
    }

    public List extractDateRangeValues(List list, int n) {
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        List list2 = new ArrayList<Long>();
        for (int i = 0; i < list.size(); ++i) {
            list2.add(((DbDateTime)list.get(i)).get());
        }
        DbDateTime dbDateTime = (DbDateTime)list.get(0);
        DbDateTime dbDateTime2 = (DbDateTime)list.get(list.size() - 1);
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTimeInMillis(dbDateTime.get());
        calendar2.setTimeInMillis(dbDateTime2.get());
        int[] nArray = this.clone(n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        long l = this.add(dbDateTime, dbDateTime2, n);
        list2 = this.SEDU(0L, l);
        boolean bl = n == 21;
        DbColDesc dbColDesc = (DbColDesc)((DbValue)list.get(0)).getColDesc().clone();
        int n4 = list2.size();
        for (int i = 0; i < n4; ++i) {
            int n5;
            long l2 = (Long)list2.get(i);
            if (bl) {
                n5 = (int)((long)n3 * l2 / 2L);
                calendar.add(n2, n5);
                int n6 = (int)(l2 % 2L);
                if (n6 > 0) {
                    calendar.add(6, 15);
                }
            } else {
                n5 = (int)((long)n3 * l2);
                calendar.add(n2, n5);
            }
            long l3 = calendar.getTimeInMillis();
            DbValue dbValue = DbValue.makeDbValue(dbColDesc);
            ((DbDateTime)dbValue).set(l3);
            arrayList.add(dbValue);
        }
        return arrayList;
    }

    public List extractNumberRangeValues(List list) {
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
        if (((DbValue)list.get(0)).getSqlType() == 3) {
            arrayList.add(((DbDecimal)list.get(0)).get());
            arrayList.add(((DbDecimal)list.get(list.size() - 1)).get());
        } else {
            arrayList.add(BigDecimal.valueOf(((DbNumber)list.get(0)).doubleValue()));
            arrayList.add(BigDecimal.valueOf(((DbNumber)list.get(list.size() - 1)).doubleValue()));
        }
        List list2 = this.ZERO((BigDecimal)arrayList.get(0), (BigDecimal)arrayList.get(arrayList.size() - 1));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < list2.size(); ++i) {
            arrayList2.add(((BigDecimal)list2.get(i)).toPlainString());
        }
        DbColDesc dbColDesc = ((DbValue)list.get(0)).getColDesc();
        return this.contains(dbColDesc, arrayList2);
    }

    private List SEDU(long l, long l2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l3 = l2 - l;
        long l4 = 1L;
        long l5 = 1L + l3 / l4;
        int n = 0;
        while ((long)n < l5) {
            arrayList.add(l + l4 * (long)n);
            ++n;
        }
        return arrayList;
    }

    private List ZERO(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal bigDecimal3;
        float f = ((Float)this.compareTo.getPropertyByName("NumberSliderUnitIncrement").getObject()).floatValue();
        BigDecimal bigDecimal4 = f > (bigDecimal3 = bigDecimal2.subtract(bigDecimal)).floatValue() ? BigDecimal.valueOf(0.01) : new BigDecimal(Float.toString(f));
        BigDecimal[] bigDecimalArray = bigDecimal.divideAndRemainder(bigDecimal4);
        BigDecimal bigDecimal5 = bigDecimalArray[1];
        BigDecimal bigDecimal6 = bigDecimal5.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal.subtract(bigDecimal5) : (bigDecimal5.compareTo(BigDecimal.ZERO) < 0 ? bigDecimal.subtract(bigDecimal4).subtract(bigDecimal5) : bigDecimal);
        bigDecimalArray = bigDecimal2.divideAndRemainder(bigDecimal4);
        bigDecimal5 = bigDecimalArray[1];
        BigDecimal bigDecimal7 = bigDecimal5.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2.add(bigDecimal4).subtract(bigDecimal5) : (bigDecimal5.compareTo(BigDecimal.ZERO) < 0 ? bigDecimal2.subtract(bigDecimal5) : bigDecimal2);
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
        arrayList.add(bigDecimal6);
        arrayList.add(bigDecimal7);
        return arrayList;
    }

    private long add(DbDateTime dbDateTime, DbDateTime dbDateTime2, int n) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTimeInMillis(dbDateTime.get());
        calendar2.setTimeInMillis(dbDateTime2.get());
        long l = 0L;
        switch (n) {
            case 1: {
                l = this.clear(calendar2) - this.clear(calendar);
                break;
            }
            case 20: {
                l = (this.clear(calendar2) - this.clear(calendar)) * 2;
                l -= (long)(calendar.get(2) / 6);
                l += (long)(calendar2.get(2) / 6);
                break;
            }
            case 22: {
                l = (this.clear(calendar2) - this.clear(calendar)) * 4;
                l -= (long)(calendar.get(2) / 3);
                l += (long)(calendar2.get(2) / 3);
                break;
            }
            case 2: {
                l = this.clear(calendar2) - this.clear(calendar);
                l *= 12L;
                l += (long)(calendar2.get(2) - calendar.get(2));
                break;
            }
            case 21: {
                l = this.clear(calendar2) - this.clear(calendar);
                l *= 12L;
                l += (long)(calendar2.get(2) - calendar.get(2));
                l *= 2L;
                if (calendar.get(5) >= 16) {
                    --l;
                }
                if (calendar2.get(5) < 16) break;
                ++l;
                break;
            }
            case 23: {
                l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
                long l2 = l % 1209600000L;
                l = (l /= 1209600000L) > 0L ? (l2 == 0L ? l : l + 1L) : (long)(l2 == 0L ? 0 : 1);
                break;
            }
            case 24: {
                l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
                long l3 = l % 604800000L;
                l = (l /= 604800000L) > 0L ? (l3 == 0L ? l : l + 1L) : (long)(l3 == 0L ? 0 : 1);
                break;
            }
            case 5: {
                l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
                long l4 = l % 86400000L;
                l = (l /= 86400000L) > 0L ? (l4 == 0L ? l : l + 1L) : (long)(l4 == 0L ? 0 : 1);
                break;
            }
            case 10: {
                l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
                long l5 = l % 3600000L;
                l = (l /= 3600000L) > 0L ? (l5 == 0L ? l : l + 1L) : (long)(l5 == 0L ? 0 : 1);
                break;
            }
            case 12: {
                l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
                long l6 = l % 60000L;
                l = (l /= 60000L) > 0L ? (l6 == 0L ? l : l + 1L) : (long)(l6 == 0L ? 0 : 1);
                break;
            }
            case 13: {
                l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
                long l7 = l % 1000L;
                l = (l /= 1000L) > 0L ? (l7 == 0L ? l : l + 1L) : (long)(l7 == 0L ? 0 : 1);
                break;
            }
            default: {
                l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
            }
        }
        return l;
    }

    private int clear(Calendar calendar) {
        int n = calendar.get(1);
        if (calendar.get(0) == 0) {
            n = 1 - n;
        }
        return n;
    }

    private int[] clone(int n) {
        int[] nArray = new int[2];
        int n2 = 14;
        int n3 = 1;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 20: {
                n2 = 2;
                n3 = 6;
                break;
            }
            case 22: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 21: {
                n2 = 2;
                break;
            }
            case 23: {
                n2 = 6;
                n3 = 14;
                break;
            }
            case 24: {
                n2 = 6;
                n3 = 7;
                break;
            }
            case 5: {
                n2 = 6;
                break;
            }
            case 10: {
                n2 = 10;
                break;
            }
            case 12: {
                n2 = 12;
                break;
            }
            case 13: {
                n2 = 13;
                break;
            }
            default: {
                n2 = 14;
            }
        }
        nArray[0] = n2;
        nArray[1] = n3;
        return nArray;
    }

    public double calRangeThumbPosScale(DbValue dbValue, List list, int n) {
        if (list.size() == 1) {
            return 1.0;
        }
        double d = 0.0;
        DbValue dbValue2 = (DbValue)list.get(0);
        DbValue dbValue3 = (DbValue)list.get(list.size() - 1);
        switch (dbValue.getSqlType()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                int n2 = list.indexOf(dbValue);
                d = (float)(n2 + 1) / (float)list.size();
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                BigDecimal bigDecimal = BigDecimal.valueOf(((DbNumber)dbValue).longValue() - ((DbNumber)dbValue2).longValue());
                BigDecimal bigDecimal2 = BigDecimal.valueOf(((DbNumber)dbValue3).longValue() - ((DbNumber)dbValue2).longValue());
                d = bigDecimal.divide(bigDecimal2, 4, RoundingMode.HALF_UP).doubleValue();
                break;
            }
            case 91: {
                if (n == -1) {
                    n = 5;
                }
                d = this.compareTo((DbDateTime)dbValue, (DbDateTime)list.get(0), (DbDateTime)list.get(list.size() - 1), n);
                break;
            }
            case 92: 
            case 93: {
                if (n == -1) {
                    n = 13;
                }
                d = this.compareTo((DbDateTime)dbValue, (DbDateTime)list.get(0), (DbDateTime)list.get(list.size() - 1), n);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                d = (((DbNumber)dbValue).doubleValue() - ((DbNumber)dbValue2).doubleValue()) / (((DbNumber)dbValue3).doubleValue() - ((DbNumber)dbValue2).doubleValue());
                break;
            }
            case 3: {
                BigDecimal bigDecimal = BigDecimal.valueOf(((DbNumber)dbValue2).doubleValue());
                BigDecimal bigDecimal3 = BigDecimal.valueOf(((DbNumber)dbValue3).doubleValue());
                BigDecimal bigDecimal4 = BigDecimal.valueOf(((DbNumber)dbValue).doubleValue());
                BigDecimal bigDecimal5 = bigDecimal4.subtract(bigDecimal);
                BigDecimal bigDecimal6 = bigDecimal3.subtract(bigDecimal);
                d = bigDecimal5.divide(bigDecimal6, 4, RoundingMode.HALF_UP).doubleValue();
                break;
            }
        }
        return d;
    }

    private double compareTo(DbDateTime dbDateTime, DbDateTime dbDateTime2, DbDateTime dbDateTime3, int n) {
        double d = 0.0;
        long l = this.add(dbDateTime2, dbDateTime, n);
        long l2 = this.add(dbDateTime2, dbDateTime3, n);
        BigDecimal bigDecimal = BigDecimal.valueOf(l);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(l2);
        d = bigDecimal.divide(bigDecimal2, 4, RoundingMode.HALF_UP).doubleValue();
        return d;
    }

    private List contains(DbColDesc dbColDesc, List list) {
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        DbColDesc dbColDesc2 = (DbColDesc)dbColDesc.clone();
        boolean bl = false;
        int n = dbColDesc.getSqlType();
        if (n == 91 || n == 92 || n == 93) {
            bl = true;
        }
        for (int i = 0; i < list.size(); ++i) {
            DbValue dbValue = DbValue.makeDbValue(dbColDesc2);
            if (bl) {
                ((DbDateTime)dbValue).set(Long.parseLong(list.get(i).toString()));
            } else {
                dbValue.setValue(list.get(i).toString());
            }
            arrayList.add(dbValue);
        }
        return arrayList;
    }

    public List convertStrToDbValue(List list, String string) {
        int n = MappingSQLType.mergeParamTypeToSQLType(string);
        DbColDesc dbColDesc = new DbColDesc(null, n, 0, 0, 2);
        List list2 = this.contains(dbColDesc, list);
        return list2;
    }

    public long parseDateTime(String string, int n) {
        long l;
        block9: {
            String string2;
            l = 0L;
            switch (n) {
                case 91: {
                    string2 = "yyyy-MM-dd";
                    break;
                }
                case 92: {
                    string2 = "HH:mm:ss";
                    break;
                }
                case 93: {
                    string2 = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
                default: {
                    string2 = "yyyy-MM-dd";
                }
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, this.contains);
                l = simpleDateFormat.parse(string).getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, illegalArgumentException);
                }
            }
            catch (ParseException parseException) {
                if (!JRLog.isError(2)) break block9;
                JRLog.error(2, parseException);
            }
        }
        return l;
    }

    public void setLocale(Locale locale) {
        this.contains = locale;
    }
}

