/*
 * Decompiled with CFR 0.152.
 */
package jet.export;

import com.jinfonet.util.JRLog;
import java.io.OutputStream;
import java.util.List;
import jet.JRStopEngineException;
import jet.bean.ExcelParameter;
import jet.datastream.Communicator;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.ExportEngineForViewer;
import jet.export.excel.type1.ExportToXlsType1;
import jet.export.excel.v7x.ExportToXlsBiff8;
import jet.export.excel.v7x.NormalXls;
import jet.export.util.ExportUtil;
import jet.util.EngineErrorListener;
import jet.util.JRInterruptedException;

public class ExportEngine
extends ExportEngineForViewer {
    public static List exportToExcelFile(Communicator communicator, String string, ExcelParameter excelParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        return ExportEngine.exportToExcelFile(new Communicator[]{communicator}, string, excelParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static void exportToExcelStream(Communicator communicator, OutputStream outputStream, ExcelParameter excelParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngine.checkAuxInfo(exportAuxInfo);
        ExportUtil.checkStop(communicator);
        String string = "Export Engine: Export to Excel Files.";
        JRLog.indent(string);
        long l = ExportEngine.logExportTime("Excel Stream", true);
        try {
            AbstractExporter abstractExporter = excelParameter.isNewExcelLayout() ? new ExportToXlsType1(new Communicator[]{communicator}, excelParameter) : (excelParameter.isBiff8() ? new ExportToXlsBiff8(new Communicator[]{communicator}, excelParameter) : new NormalXls(new Communicator[]{communicator}, excelParameter));
            abstractExporter.setListeners(new EngineErrorListener[][]{engineErrorListenerArray});
            abstractExporter.setAuxiliaryInfo(exportAuxInfo);
            abstractExporter.exportToStream(outputStream);
            long l2 = ExportEngine.logExportTime("Excel Stream", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Excel Stream", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngine.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngine.logError(expException);
            ExportUtil.checkStop(communicator);
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngine.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngine.logError(exception);
            ExportUtil.checkStop(communicator);
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string);
        }
    }

    public static List exportToExcelFile(Communicator[] communicatorArray, String string, ExcelParameter excelParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngine.checkAuxInfo(exportAuxInfo);
        String string2 = "Export Engine: Export to Excel Files.";
        JRLog.indent(string2);
        long l = ExportEngine.logExportTime("Excel File", true);
        try {
            AbstractExporter abstractExporter = excelParameter.isNewExcelLayout() ? new ExportToXlsType1(communicatorArray, excelParameter) : (excelParameter.isBiff8() ? new ExportToXlsBiff8(communicatorArray, excelParameter) : new NormalXls(communicatorArray, excelParameter));
            abstractExporter.setListeners(engineErrorListenerArray);
            abstractExporter.setAuxiliaryInfo(exportAuxInfo);
            List list = abstractExporter.exportToFile(string);
            long l2 = ExportEngine.logExportTime("Excel File", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Excel File", Long.toString(l2 - l)});
            }
            List list2 = list;
            return list2;
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngine.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngine.logError(expException);
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngine.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngine.logError(exception);
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string2);
        }
    }
}

