/*
 * Decompiled with CFR 0.152.
 */
package jet.export;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jet.JRStopEngineException;
import jet.bean.HtmlParameter;
import jet.bean.PDFParameter;
import jet.bean.PSParameter;
import jet.bean.RtfParameter;
import jet.bean.TextParameter;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.html.HtmlExporter;
import jet.export.pdf.ExportToPDF;
import jet.export.ps.ExportToPS;
import jet.export.rtf.RTFExporter;
import jet.export.text.ExportToText;
import jet.export.text.SDFText;
import jet.export.util.ExportUtil;
import jet.util.EngineErrorListener;
import jet.util.JRInterruptedException;

public class ExportEngineForViewer {
    static void checkAuxInfo(ExportAuxInfo exportAuxInfo) throws ExpException {
        if (exportAuxInfo == null) {
            throw new ExpException(406011);
        }
        exportAuxInfo.checkArgument();
    }

    public static List exportDSPagetoFile(Communicator communicator, String string, HtmlParameter htmlParameter, DSPage dSPage, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        return ExportEngineForViewer.exportDSPagetoFile(new Communicator[]{communicator}, string, htmlParameter, dSPage, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static List exportDSPagetoFile(Communicator[] communicatorArray, String string, HtmlParameter htmlParameter, DSPage dSPage, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string2 = "Export Engine: Export DSPage to HTML Files.";
        JRLog.indent(string2);
        long l = ExportEngineForViewer.logExportTime("Html Stream", true);
        HtmlExporter htmlExporter = htmlParameter == null ? new HtmlExporter(communicatorArray, new HtmlParameter()) : new HtmlExporter(communicatorArray, htmlParameter);
        htmlExporter.setListeners(engineErrorListenerArray);
        htmlExporter.setAuxiliaryInfo(exportAuxInfo);
        try {
            List list = htmlExporter.exportDSPagetoFile(dSPage, string);
            return list;
        }
        catch (IOException iOException) {
            ExportEngineForViewer.logError(iOException);
            long l2 = ExportEngineForViewer.logExportTime("Html Stream", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Html DSPage to file", Long.toString(l2 - l)});
            }
            return null;
        }
    }

    public static List exportToPlsHtmlFile(Communicator communicator, String string, HtmlParameter htmlParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        return ExportEngineForViewer.exportToPlsHtmlFile(new Communicator[]{communicator}, string, htmlParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static List exportToPlsHtmlFile(Communicator[] communicatorArray, String string, HtmlParameter htmlParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        List list = null;
        String string2 = "Export Engine: Export to pls HTML Files.";
        JRLog.indent(string2);
        long l = ExportEngineForViewer.logExportTime("Html pls Files to interim result", true);
        try {
            HtmlExporter htmlExporter;
            if (htmlParameter == null) {
                htmlParameter = new HtmlParameter();
                htmlParameter.setisPlsExporter(true);
                htmlExporter = new HtmlExporter(communicatorArray, htmlParameter);
            } else {
                htmlExporter = new HtmlExporter(communicatorArray, htmlParameter);
            }
            htmlExporter.setListeners(engineErrorListenerArray);
            htmlExporter.setAuxiliaryInfo(exportAuxInfo);
            list = htmlExporter.exportToPlsReslut(string);
            long l2 = ExportEngineForViewer.logExportTime("Html Files", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Html PLS Files", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngineForViewer.logError(expException);
            if (JRLog.isError(2)) {
                JRLog.error(2, 2406003, "HTML", (Throwable)expException);
            }
            throw expException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string2);
        }
        return list;
    }

    public static List exportToHtmlFile(Communicator communicator, String string, HtmlParameter htmlParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        return ExportEngineForViewer.exportToHtmlFile(new Communicator[]{communicator}, string, htmlParameter, (EngineErrorListener[][])new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static List exportHtmlBodyToStream(Communicator communicator, OutputStream outputStream, OutputStream outputStream2, HtmlParameter htmlParameter, String string, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, IOException, JRStopEngineException {
        List list;
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        ExportUtil.checkStop(communicator);
        String string2 = "Export Engine: Export to HTML Files.";
        JRLog.indent(string2);
        long l = ExportEngineForViewer.logExportTime("Html Stream", true);
        HtmlExporter htmlExporter = htmlParameter == null ? new HtmlExporter(communicator, new HtmlParameter()) : new HtmlExporter(communicator, htmlParameter);
        try {
            htmlExporter.setListeners(new EngineErrorListener[][]{engineErrorListenerArray});
            htmlExporter.setAuxiliaryInfo(exportAuxInfo);
            list = htmlExporter.exportHtmlBodyToStream(outputStream, outputStream2, string);
            long l2 = ExportEngineForViewer.logExportTime("Html Stream", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Html Stream", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngineForViewer.logError(expException);
            ExportUtil.checkStop(communicator);
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            ExportUtil.checkStop(communicator);
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string2);
        }
        return list;
    }

    public static void exportToPDFStream(Communicator communicator, OutputStream outputStream, PDFParameter pDFParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.exportToPDFStream(new Communicator[]{communicator}, outputStream, pDFParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static void exportToPDFStream(Communicator[] communicatorArray, OutputStream outputStream, PDFParameter pDFParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string = "Export Engine: Export to PDF File.";
        JRLog.indent(string);
        long l = ExportEngineForViewer.logExportTime("PDF Stream", true);
        ExportToPDF exportToPDF = pDFParameter == null ? new ExportToPDF(communicatorArray, new PDFParameter()) : new ExportToPDF(communicatorArray, pDFParameter);
        try {
            exportToPDF.setListeners(engineErrorListenerArray);
            exportToPDF.setAuxiliaryInfo(exportAuxInfo);
            exportToPDF.exportToStream(outputStream);
            long l2 = ExportEngineForViewer.logExportTime("PDF Stream", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"PDF Stream", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngineForViewer.logError(expException);
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string);
        }
    }

    static void logError(Error error) {
        if (JRLog.isError(2)) {
            JRLog.error(2, error);
        }
    }

    static void logError(Exception exception) {
        if (JRLog.isError(2)) {
            JRLog.error(2, exception);
        }
    }

    public static List exportToPDFFile(Communicator communicator, String string, PDFParameter pDFParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        return ExportEngineForViewer.exportToPDFFile(new Communicator[]{communicator}, string, pDFParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static void exportToRtfStream(Communicator communicator, OutputStream outputStream, RtfParameter rtfParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.exportToRtfStream(new Communicator[]{communicator}, outputStream, rtfParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static void exportToRtfStream(Communicator[] communicatorArray, OutputStream outputStream, RtfParameter rtfParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string = "Export Engine: Export to RTF Files.";
        JRLog.indent(string);
        long l = ExportEngineForViewer.logExportTime("RTF Stream", true);
        try {
            RTFExporter rTFExporter = rtfParameter == null ? new RTFExporter(communicatorArray, new RtfParameter()) : new RTFExporter(communicatorArray, rtfParameter);
            rTFExporter.setListeners(engineErrorListenerArray);
            rTFExporter.setAuxiliaryInfo(exportAuxInfo);
            rTFExporter.exportToStream(outputStream);
            long l2 = ExportEngineForViewer.logExportTime("RTF Stream", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"RTF Stream", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngineForViewer.logError(expException);
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string);
        }
    }

    public static List exportToRtfFile(Communicator[] communicatorArray, String string, RtfParameter rtfParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        List list;
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string2 = "Export Engine: Export to RTF Files.";
        JRLog.indent(string2);
        long l = ExportEngineForViewer.logExportTime("RTF File", true);
        try {
            RTFExporter rTFExporter = rtfParameter == null ? new RTFExporter(communicatorArray, new RtfParameter()) : new RTFExporter(communicatorArray, rtfParameter);
            rTFExporter.setListeners(engineErrorListenerArray);
            rTFExporter.setAuxiliaryInfo(exportAuxInfo);
            list = rTFExporter.exportToFile(string);
            long l2 = ExportEngineForViewer.logExportTime("RTF File", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"RTF File", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngineForViewer.logError(expException);
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string2);
        }
        return list;
    }

    public static List exportToRtfFile(Communicator communicator, String string, RtfParameter rtfParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        return ExportEngineForViewer.exportToRtfFile(new Communicator[]{communicator}, string, rtfParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static List exportToTextFile(Communicator communicator, String string, TextParameter textParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        return ExportEngineForViewer.exportToTextFile(new Communicator[]{communicator}, string, textParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static List exportToTextFile(Communicator[] communicatorArray, String string, TextParameter textParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        List list;
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string2 = "Export Engine: Export to Text Files.";
        JRLog.indent(string2);
        long l = ExportEngineForViewer.logExportTime("Text File", true);
        AbstractExporter abstractExporter = null;
        try {
            abstractExporter = textParameter.isNormalTextFile() ? new ExportToText(communicatorArray, textParameter) : new SDFText(communicatorArray, textParameter);
            abstractExporter.setListeners(engineErrorListenerArray);
            abstractExporter.setAuxiliaryInfo(exportAuxInfo);
            list = abstractExporter.exportToFile(string);
            long l2 = ExportEngineForViewer.logExportTime("Text File", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Text File", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngineForViewer.logError(expException);
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string2);
        }
        return list;
    }

    public static void exportToTextStream(Communicator communicator, OutputStream outputStream, TextParameter textParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.exportToTextStream(new Communicator[]{communicator}, outputStream, textParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static void exportToTextStream(Communicator[] communicatorArray, OutputStream outputStream, TextParameter textParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string = "Export Engine: Export to Text Files.";
        JRLog.indent(string);
        long l = ExportEngineForViewer.logExportTime("Text Stream", true);
        AbstractExporter abstractExporter = null;
        try {
            abstractExporter = textParameter.isNormalTextFile() ? new ExportToText(communicatorArray, textParameter) : new SDFText(communicatorArray, textParameter);
            abstractExporter.setListeners(engineErrorListenerArray);
            abstractExporter.exportToStream(outputStream);
            abstractExporter.setAuxiliaryInfo(exportAuxInfo);
            long l2 = ExportEngineForViewer.logExportTime("Text Stream", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Text Stream", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngineForViewer.logError(expException);
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string);
        }
    }

    public static List exportToPsFile(Communicator communicator, String string, PSParameter pSParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        return ExportEngineForViewer.exportToPsFile(new Communicator[]{communicator}, string, pSParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static void exportToPsStream(Communicator communicator, OutputStream outputStream, PSParameter pSParameter, EngineErrorListener[] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.exportToPsStream(new Communicator[]{communicator}, outputStream, pSParameter, new EngineErrorListener[][]{engineErrorListenerArray}, exportAuxInfo);
    }

    public static void exportToPsStream(Communicator[] communicatorArray, OutputStream outputStream, PSParameter pSParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string = "Export Engine: Export to Ps Files.";
        JRLog.indent(string);
        long l = ExportEngineForViewer.logExportTime("Ps Stream", true);
        try {
            ExportToPS exportToPS = new ExportToPS(communicatorArray, pSParameter);
            exportToPS.setListeners(engineErrorListenerArray);
            exportToPS.setAuxiliaryInfo(exportAuxInfo);
            exportToPS.exportToStream(outputStream);
            long l2 = ExportEngineForViewer.logExportTime("Ps Stream", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Ps Stream", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngineForViewer.logError(expException);
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string);
        }
    }

    public static List exportToHtmlFile(Communicator[] communicatorArray, String string, HtmlParameter htmlParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string2 = "Export Engine: Export to HTML Files.";
        List list = null;
        ExportUtil.checkStop(communicatorArray[0]);
        JRLog.indent(string2);
        long l = ExportEngineForViewer.logExportTime("Html Files", true);
        try {
            HtmlExporter htmlExporter = htmlParameter == null ? new HtmlExporter(communicatorArray, new HtmlParameter()) : new HtmlExporter(communicatorArray, htmlParameter);
            htmlExporter.setListeners(engineErrorListenerArray);
            htmlExporter.setAuxiliaryInfo(exportAuxInfo);
            list = htmlExporter.exportToFile(string);
            long l2 = ExportEngineForViewer.logExportTime("Html Files", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Html Files", Long.toString(l2 - l)});
            }
            List list2 = list;
            return list2;
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2406003, "HTML", (Throwable)expException);
            }
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string2);
        }
    }

    public static List exportToHtmlFile(Communicator[] communicatorArray, String[] stringArray, HtmlParameter htmlParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < communicatorArray.length; ++i) {
            Communicator communicator = communicatorArray[i];
            if (communicator == null) continue;
            EngineErrorListener[] engineErrorListenerArray2 = engineErrorListenerArray != null ? engineErrorListenerArray[i] : null;
            String string = stringArray[i];
            List list = ExportEngineForViewer.exportToHtmlFile(communicator, string, htmlParameter, engineErrorListenerArray2, exportAuxInfo);
            communicatorArray[i] = null;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static List exportToPDFFile(Communicator[] communicatorArray, String string, PDFParameter pDFParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string2 = "Export Engine: Export to PDF File.";
        List list = null;
        ExportUtil.checkStop(communicatorArray[0]);
        JRLog.indent(string2);
        long l = ExportEngineForViewer.logExportTime("PDF File", true);
        ExportToPDF exportToPDF = null;
        try {
            exportToPDF = pDFParameter == null ? new ExportToPDF(communicatorArray, new PDFParameter()) : new ExportToPDF(communicatorArray, pDFParameter);
            exportToPDF.setListeners(engineErrorListenerArray);
            exportToPDF.setAuxiliaryInfo(exportAuxInfo);
            list = exportToPDF.exportToFile(string);
            long l2 = ExportEngineForViewer.logExportTime("PDF File", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"PDF File", Long.toString(l2 - l)});
            }
            List list2 = list;
            return list2;
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2406003, "PDF", (Throwable)expException);
            }
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2406003, "PDF", (Throwable)exception);
            }
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string2);
        }
    }

    public static List exportToPsFile(Communicator[] communicatorArray, String string, PSParameter pSParameter, EngineErrorListener[][] engineErrorListenerArray, ExportAuxInfo exportAuxInfo) throws ExpException, JRStopEngineException {
        List list;
        ExportEngineForViewer.checkAuxInfo(exportAuxInfo);
        String string2 = "Export Engine: Export to Ps Files.";
        ExportUtil.checkStop(communicatorArray[0]);
        JRLog.indent(string2);
        long l = ExportEngineForViewer.logExportTime("Ps File", true);
        try {
            ExportToPS exportToPS = new ExportToPS(communicatorArray, pSParameter);
            exportToPS.setListeners(engineErrorListenerArray);
            exportToPS.setAuxiliaryInfo(exportAuxInfo);
            list = exportToPS.exportToFile(string);
            long l2 = ExportEngineForViewer.logExportTime("Ps File", false);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4406001, new Object[]{"Ps File", Long.toString(l2 - l)});
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            ExportEngineForViewer.logError(jRInterruptedException);
            throw jRInterruptedException;
        }
        catch (ExpException expException) {
            ExportEngineForViewer.logError(expException);
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            ExportEngineForViewer.logError(jRStopEngineException);
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportEngineForViewer.logError(exception);
            if (communicatorArray[0] != null) {
                ExportUtil.checkStop(communicatorArray[0]);
            }
            throw new ExpException(exception);
        }
        finally {
            JRLog.deIndent(string2);
        }
        return list;
    }

    protected static final long logExportTime(String string, boolean bl) {
        int n = 0;
        n = bl ? 4406002 : 4406003;
        long l = System.currentTimeMillis();
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, n, new Object[]{string, l});
        }
        return l;
    }
}

