/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.api;

import java.awt.Color;
import java.awt.Image;
import jet.export.excel.api.BlankCell;
import jet.export.excel.api.BooleanCell;
import jet.export.excel.api.CellGradient;
import jet.export.excel.api.CellPattern;
import jet.export.excel.api.CellStyle;
import jet.export.excel.api.ColorFillInfo;
import jet.export.excel.api.DocumentException;
import jet.export.excel.api.ExcelFont;
import jet.export.excel.api.ExcelImageInfo;
import jet.export.excel.api.ExcelShapeInfo;
import jet.export.excel.api.ExcelWorkBook;
import jet.export.excel.api.ExcelWorkSheet;
import jet.export.excel.api.FormulaCell;
import jet.export.excel.api.GradientInfo;
import jet.export.excel.api.HyperLink;
import jet.export.excel.api.LabelCell;
import jet.export.excel.api.LineStyle;
import jet.export.excel.api.LocInfo;
import jet.export.excel.api.NumberCell;
import jet.export.excel.api.PageInfoSetup;
import jet.export.excel.api.PatternFillInfo;
import jet.export.excel.api.PerformanceConfig;
import jet.export.excel.api.PictureFillInfo;
import jet.export.excel.api.RichTextLabelCell;
import jet.export.excel.api.SparklineGroup;
import jet.export.excel.api.WindowsOptions;
import jet.export.excel.api.chart.ChartFactory;
import jet.export.excel.imp.xls.BiffFactory;
import jet.export.excel.imp.xlsx.XmlFactory;
import jet.export.util.Cache;

public abstract class ExcelFactory {
    public static ExcelFactory createXlsFactory(Cache cache, int n) throws DocumentException {
        return new BiffFactory(cache, n);
    }

    public static ExcelFactory createXlsxFactory(Cache cache, PerformanceConfig performanceConfig) throws DocumentException {
        return new XmlFactory(cache, performanceConfig);
    }

    public abstract ExcelWorkBook getWorkBook();

    public abstract ExcelWorkSheet createSheet(String var1) throws DocumentException;

    public abstract ExcelFont createFont(String var1, double var2);

    public abstract CellPattern createCellPattern(Color var1);

    public abstract CellPattern createCellPattern(int var1, Color var2, Color var3);

    public abstract CellGradient createCellGradient();

    public abstract BlankCell createBlankCell(int var1, int var2);

    public abstract HyperLink createHyperLink(String var1, String var2, int var3);

    public abstract NumberCell createNumberCell(int var1, int var2);

    public abstract LabelCell createLabelCell(int var1, int var2);

    public abstract RichTextLabelCell createRichLabelCell(int var1, int var2);

    public abstract FormulaCell createFormulaCell(int var1, int var2, String var3);

    public abstract BooleanCell createBooleanCell(int var1, int var2);

    public abstract LocInfo createLocInfo(int var1, int var2, int var3, int var4);

    public abstract ExcelShapeInfo createShapeInfo(int var1, LineStyle var2);

    public abstract LineStyle createLineStyle(int var1);

    public abstract ExcelImageInfo createImageInfo(Image var1);

    public abstract ChartFactory getChartFactory();

    public abstract ColorFillInfo createColorFill(Color var1);

    public abstract GradientInfo createGradientFill(byte var1);

    public abstract PatternFillInfo createPatternFill(int var1);

    public abstract PictureFillInfo createPictureFill(Image var1, byte var2) throws DocumentException;

    public abstract CellStyle createCellStyle();

    public abstract PageInfoSetup creatPageInfoSetup();

    public abstract WindowsOptions createWindowsOptions();

    public abstract SparklineGroup createSparklineGroup(String var1, int var2, int var3);
}

