/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.chart;

import com.jinfonet.util.JRLog;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.datastream.Communicator;
import jet.datastream.DSBody;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSField;
import jet.datastream.DSGroup;
import jet.datastream.DSPage;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.export.excel.Chart;
import jet.export.excel.ExcelCache;
import jet.export.excel.ExcelChartInfo;
import jet.export.excel.api.DocumentException;
import jet.export.excel.api.LocInfo;
import jet.export.excel.api.chart.ChartFactory;
import jet.export.excel.api.chart.ChartInfo;
import jet.export.excel.chart.ChartDataInfo;
import jet.export.excel.v7x.xlsAffix.ExcelChartWriter;
import jet.export.relayout.table.LogicGroup;
import jet.export.relayout.table.LogicObj;
import jet.export.relayout.table.LogicRow;
import jet.export.relayout.table.TableCellWrap;
import jet.export.relayout.table.VisibleRowTable;

public class NmChart
implements Chart {
    private int addToNeedHandleTable;
    private Hashtable append = new Hashtable();
    protected Hashtable notSupportChart = new Hashtable();
    protected Hashtable supportChart = new Hashtable();
    protected Communicator commu;
    protected GroupInfo curGroup;
    protected GroupInfo nullGroup;
    protected static int logError = 2;
    protected static boolean isError = JRLog.isError(logError);
    private boolean clear = false;
    protected ExcelCache excelCache;
    private ChartFactory containsKey;
    protected List readyWriter;

    public NmChart(ExcelCache excelCache) {
        this.excelCache = excelCache;
    }

    @Override
    public void setCommunicator(Communicator communicator) {
        this.commu = communicator;
    }

    @Override
    public Object getChartInfo(DSChartPlatform dSChartPlatform, int n) {
        String string = this.getKey(dSChartPlatform, n);
        if (this.notSupportChart.containsKey(string)) {
            return this.notSupportChart.get(string);
        }
        return this.supportChart.get(string);
    }

    @Override
    public void readyWrite() {
        this.append.clear();
    }

    @Override
    public void register(DSPage dSPage, int n) throws DocumentException {
        this.addToNeedHandleTable = n;
        for (int i = 0; i < dSPage.size(); ++i) {
            JRObjectResult jRObjectResult = this.getErrorImage(dSPage.getObject(i));
            if (!this.getGroup(jRObjectResult)) continue;
            int n2 = jRObjectResult.getObjectType();
            if (jRObjectResult instanceof DSSection) {
                this.SEDU((DSSection)jRObjectResult, -1);
                continue;
            }
            if (n2 != 262177) continue;
            DSBody dSBody = (DSBody)jRObjectResult;
            this.SEDU(dSBody, dSBody.getDataStream().getSubIndex());
        }
    }

    private void SEDU(DSContainer dSContainer, int n) throws DocumentException {
        List list = this.add(dSContainer.getChildren());
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            JRObjectResult jRObjectResult = this.getErrorImage((JRObjectResult)list.get(i));
            if (!this.getGroup(jRObjectResult)) continue;
            int n3 = jRObjectResult.getObjectType();
            this.addAll(jRObjectResult, n3, n);
        }
    }

    private List add(List list) {
        return list;
    }

    private void addAll(JRObjectResult jRObjectResult, int n, int n2) throws DocumentException {
        if (jRObjectResult instanceof DSContainer) {
            switch (n) {
                case 71: {
                    DSChartPlatform dSChartPlatform = (DSChartPlatform)jRObjectResult;
                    String string = this.getKey(dSChartPlatform, this.addToNeedHandleTable);
                    ExcelChartWriter excelChartWriter = new ExcelChartWriter(this.containsKey, this.excelCache);
                    excelChartWriter.createChartInfo(dSChartPlatform);
                    if (excelChartWriter.isError()) {
                        this.notSupportChart.put(string, excelChartWriter.getErrorImage());
                        break;
                    }
                    short s = dSChartPlatform.getTemplateIndex();
                    DynamicChartInfo dynamicChartInfo = this.getDyInfo(dSChartPlatform, n2, s);
                    this.supportChart.put(string, excelChartWriter.getChartInfo());
                    if (dynamicChartInfo == null) break;
                    this.addToNeedHandleTable(string, excelChartWriter.getChartInfo(), dynamicChartInfo, this.getChartData(dSChartPlatform));
                    break;
                }
                case 45: {
                    this.searchSectionObj((DSSubReport)jRObjectResult);
                    if (!this.excelCache.isSplit(jRObjectResult)) break;
                    this.clear = true;
                    break;
                }
                case 262179: {
                    this.searchNewTable((DSTableObject)jRObjectResult);
                    break;
                }
                case 34: {
                    this.searchCrossTab((DSCrossTab)jRObjectResult);
                    break;
                }
                case 36: 
                case 40: 
                case 0x2000021: {
                    break;
                }
                default: {
                    this.SEDU((DSContainer)jRObjectResult, n2);
                    if (!this.excelCache.isSplit((DSContainer)jRObjectResult)) break;
                    this.clear = true;
                }
            }
        }
    }

    protected void addToNeedHandleTable(String string, ChartInfo chartInfo, DynamicChartInfo dynamicChartInfo, ChartDataInfo chartDataInfo) {
    }

    protected void searchCrossTab(DSCrossTab dSCrossTab) {
    }

    protected String getKey(DSChartPlatform dSChartPlatform, int n) {
        String string = dSChartPlatform.getTemplateIndex() + "*" + dSChartPlatform.getX() + "*" + dSChartPlatform.getY() + "*" + n;
        if (this.append.get(string) != null) {
            int n2 = (Integer)this.append.get(string) + 1;
            this.append.put(string, n2);
            string = string + '_' + n2;
        } else {
            this.append.put(string, 0);
            string = string + '_' + 0;
        }
        return string;
    }

    protected DynamicChartInfo getDyInfo(DSChartPlatform dSChartPlatform, int n, int n2) {
        return null;
    }

    protected ChartDataInfo getChartData(DSChartPlatform dSChartPlatform) {
        return null;
    }

    protected void searchNewTable(DSTableObject dSTableObject) throws DocumentException {
        int n = dSTableObject.getSubIdx();
        Vector vector = dSTableObject.getChildren();
        if (vector.size() == 0) {
            return;
        }
        this.getDSObjectType(dSTableObject);
        VisibleRowTable visibleRowTable = VisibleRowTable.getInstance(dSTableObject, this.excelCache, (byte)1);
        block4: while (visibleRowTable.hasMoreChild()) {
            LogicObj logicObj = visibleRowTable.nextChild();
            if (logicObj.getType() == 1) {
                DSGroup dSGroup = ((LogicGroup)logicObj).getGroup();
                if (this.isGpBegin(dSGroup.getObjectType(), dSGroup)) {
                    this.putToGroups(dSGroup);
                    continue;
                }
                if (!this.isGpEnd(dSGroup.getObjectType(), dSGroup)) continue;
                this.popGroups();
                continue;
            }
            LogicRow logicRow = (LogicRow)logicObj;
            int n2 = logicRow.getDSObjectType();
            switch (n2) {
                case 0x1000004: 
                case 0x1000005: {
                    this.addToReadyWriter(logicRow, n);
                    continue block4;
                }
                case 0x1000001: {
                    this.addToNeedHandleTable(logicRow, n);
                    continue block4;
                }
            }
            this.addToCurGroup(logicRow, n);
        }
    }

    private void addToCurGroup(LogicRow logicRow, int n) throws DocumentException {
        this.append(logicRow, this.curGroup, true, n);
    }

    private void addToNeedHandleTable(LogicRow logicRow, int n) throws DocumentException {
        this.append(logicRow, this.curGroup, false, n);
    }

    private void addToReadyWriter(LogicRow logicRow, int n) throws DocumentException {
        this.append(logicRow, this.nullGroup, true, n);
    }

    private void append(LogicRow logicRow, GroupInfo groupInfo, boolean bl, int n) throws DocumentException {
        while (logicRow.hasMoreChild()) {
            TableCellWrap tableCellWrap = logicRow.nextChild();
            List list = tableCellWrap.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
                if (!this.getGroup(jRObjectResult)) continue;
                int n2 = jRObjectResult.getObjectType();
                if (jRObjectResult instanceof DSField) {
                    this.addToCurGroup((DSField)jRObjectResult, groupInfo, n);
                    continue;
                }
                if (n2 == 71) {
                    this.error((DSChartPlatform)jRObjectResult, bl, groupInfo, n);
                    continue;
                }
                this.addAll(jRObjectResult, n2, n);
            }
        }
    }

    private void clear(DSTableRow dSTableRow, int n) throws DocumentException {
        this.createChartInfo(dSTableRow, this.curGroup, true, n);
    }

    private void commu(DSTableRow dSTableRow, int n) throws DocumentException {
        this.createChartInfo(dSTableRow, this.curGroup, false, n);
    }

    private void containsKey(DSTableRow dSTableRow, int n) throws DocumentException {
        this.createChartInfo(dSTableRow, this.nullGroup, true, n);
    }

    private void createChartInfo(DSTableRow dSTableRow, GroupInfo groupInfo, boolean bl, int n) throws DocumentException {
        Vector vector = dSTableRow.getChildren();
        if (vector.size() == 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            DSTableCell dSTableCell = (DSTableCell)vector.get(i);
            if (!this.getGroup(dSTableCell)) continue;
            Vector vector2 = dSTableCell.getChildren();
            for (int j = 0; j < vector2.size(); ++j) {
                JRObjectResult jRObjectResult = (JRObjectResult)vector2.get(j);
                if (!this.getGroup(jRObjectResult)) continue;
                int n2 = jRObjectResult.getObjectType();
                if (jRObjectResult instanceof DSField) {
                    this.addToCurGroup((DSField)jRObjectResult, groupInfo, n);
                    continue;
                }
                if (n2 == 71) {
                    this.error((DSChartPlatform)jRObjectResult, bl, groupInfo, n);
                    continue;
                }
                this.addAll(jRObjectResult, n2, n);
            }
        }
    }

    protected void searchSectionObj(DSSubReport dSSubReport) throws DocumentException {
        JRObjectResult[] jRObjectResultArray = this.getChildren(dSSubReport.getChildren());
        int n = 0;
        if (jRObjectResultArray != null) {
            n = jRObjectResultArray.length;
        }
        if (n == 0) {
            return;
        }
        int n2 = dSSubReport.getSubIdx();
        block4: for (int i = 0; i < n; ++i) {
            this.getCurPageChartInfo(dSSubReport);
            JRObjectResult jRObjectResult = jRObjectResultArray[i];
            int n3 = jRObjectResult.getObjectType();
            if (this.isGroup(n3)) {
                if (this.isGpBegin(n3, jRObjectResult)) {
                    this.putToGroups((DSGroup)jRObjectResult);
                    continue;
                }
                if (!this.isGpEnd(n3, jRObjectResult)) continue;
                this.popGroups();
                continue;
            }
            if (!this.getGroup(jRObjectResult) || !(jRObjectResult instanceof DSSection)) continue;
            switch (n3) {
                case 2561: 
                case 2562: 
                case 2563: 
                case 2564: {
                    this.excelCache((DSSection)jRObjectResult, n2);
                    continue block4;
                }
                case 519: {
                    this.getChartData((DSSection)jRObjectResult, n2);
                    continue block4;
                }
                default: {
                    this.getChartInfo((DSSection)jRObjectResult, n2);
                }
            }
        }
    }

    private void curGroup(DSSection dSSection, GroupInfo groupInfo, boolean bl, int n) throws DocumentException {
        List list = this.order(dSSection.getChildren());
        for (int i = 0; i < list.size(); ++i) {
            JRObjectResult jRObjectResult = this.getErrorImage((JRObjectResult)list.get(i));
            if (!this.getGroup(jRObjectResult)) continue;
            int n2 = jRObjectResult.getObjectType();
            if (jRObjectResult instanceof DSField) {
                this.addToCurGroup((DSField)jRObjectResult, groupInfo, n);
                continue;
            }
            if (n2 == 71) {
                this.error((DSChartPlatform)jRObjectResult, bl, groupInfo, n);
                continue;
            }
            this.addAll(jRObjectResult, n2, n);
        }
    }

    private List order(List list) {
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>(list.size());
        Vector<JRObjectResult> vector2 = new Vector<JRObjectResult>();
        for (int i = 0; i < list.size(); ++i) {
            JRObjectResult jRObjectResult = this.getErrorImage((JRObjectResult)list.get(i));
            int n = jRObjectResult.getObjectType();
            if (jRObjectResult instanceof DSField || n == 71) {
                vector.add(jRObjectResult);
                continue;
            }
            vector2.add(jRObjectResult);
        }
        vector.addAll(vector2);
        return vector;
    }

    private void error(DSChartPlatform dSChartPlatform, boolean bl, GroupInfo groupInfo, int n) throws DocumentException {
        String string = this.getKey(dSChartPlatform, this.addToNeedHandleTable);
        ExcelChartWriter excelChartWriter = this.get(dSChartPlatform);
        if (excelChartWriter.isError()) {
            this.notSupportChart.put(string, excelChartWriter.getErrorImage());
        } else {
            DynamicChartInfo dynamicChartInfo;
            this.supportChart.put(string, excelChartWriter.getChartInfo());
            if (bl && (dynamicChartInfo = this.getDyInfo(dSChartPlatform, n, dSChartPlatform.getTemplateIndex())) != null) {
                this.addToCurGroup(string, excelChartWriter.getChartInfo(), dynamicChartInfo, groupInfo, this.getChartData(dSChartPlatform));
            }
        }
    }

    private void excelCache(DSSection dSSection, int n) throws DocumentException {
        this.curGroup(dSSection, this.nullGroup, true, n);
    }

    protected void addToCurGroup(String string, ChartInfo chartInfo, DynamicChartInfo dynamicChartInfo, GroupInfo groupInfo, ChartDataInfo chartDataInfo) {
    }

    private ExcelChartWriter get(DSChartPlatform dSChartPlatform) throws DocumentException {
        ExcelChartWriter excelChartWriter = new ExcelChartWriter(this.containsKey, this.excelCache);
        excelChartWriter.createChartInfo(dSChartPlatform);
        return excelChartWriter;
    }

    protected void addToCurGroup(DSField dSField, GroupInfo groupInfo, int n) {
    }

    private void getChartData(DSSection dSSection, int n) throws DocumentException {
        this.curGroup(dSSection, this.curGroup, false, n);
    }

    private void getChartInfo(DSSection dSSection, int n) throws DocumentException {
        this.curGroup(dSSection, this.curGroup, true, n);
    }

    protected void popGroups() {
    }

    protected void putToGroups(DSGroup dSGroup) {
    }

    private JRObjectResult[] getChildren(List list) {
        int n;
        int n2 = list.size();
        if (n2 == 0) {
            return null;
        }
        JRObjectResult[] jRObjectResultArray = new JRObjectResult[n2];
        boolean bl = false;
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                JRObjectResult jRObjectResult;
                jRObjectResultArray[i] = jRObjectResult = this.getErrorImage((JRObjectResult)list.get(i));
            }
            return jRObjectResultArray;
        }
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            JRObjectResult jRObjectResult = this.getErrorImage((JRObjectResult)list.get(n));
            int n4 = jRObjectResult.getObjectType();
            if (n4 == 2564) {
                if (n3 == -1) {
                    n3 = n;
                }
                vector.add(jRObjectResult);
                continue;
            }
            jRObjectResultArray[n] = jRObjectResult;
        }
        for (n = vector.size() - 1; n >= 0; --n) {
            jRObjectResultArray[n3] = (JRObjectResult)vector.get(n);
            ++n3;
        }
        return jRObjectResultArray;
    }

    private void getCurPageChartInfo(DSSubReport dSSubReport) {
        DSTemplatible dSTemplatible = this.getDataStream(dSSubReport);
        this.handleSceneOb(dSTemplatible);
    }

    private void getDSObjectType(DSTableObject dSTableObject) {
        DSTemplatible dSTemplatible = this.getDyInfo(dSTableObject);
        this.handleSceneOb(dSTemplatible);
    }

    protected void handleSceneOb(DSTemplatible dSTemplatible) {
    }

    private DSTemplatible getDataStream(DSSubReport dSSubReport) {
        return dSSubReport.getTemplate();
    }

    private DSTemplatible getDyInfo(DSTableObject dSTableObject) {
        return dSTableObject.getTemplate();
    }

    @Override
    public boolean hasDynamicChart() {
        return false;
    }

    @Override
    public boolean hasChartBindTo(JRObjectResult jRObjectResult) {
        return false;
    }

    private JRObjectResult getErrorImage(JRObjectResult jRObjectResult) {
        JRObjectResult jRObjectResult2 = jRObjectResult;
        int n = jRObjectResult2.getObjectType();
        while (n == 8192 && !(((DSReference)jRObjectResult2).getRefData() instanceof DSChartPlatform)) {
            jRObjectResult2 = ((DSReference)jRObjectResult2).getRefData();
            n = jRObjectResult2.getObjectType();
        }
        return jRObjectResult2;
    }

    private final boolean getGroup(JRObjectResult jRObjectResult) {
        boolean bl = this.excelCache.isExport(jRObjectResult);
        if (bl) {
            switch (jRObjectResult.getObjectType()) {
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 40: 
                case 128: 
                case 129: 
                case 65540: 
                case 65541: 
                case 65542: 
                case 262184: 
                case 262185: 
                case 0x2000021: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean isGpBegin(int n, JRObjectResult jRObjectResult) {
        return this.isGroup(n);
    }

    private boolean isGroup(int n) {
        return n == 44;
    }

    protected boolean isGpEnd(int n, JRObjectResult jRObjectResult) {
        return this.isGroup(n);
    }

    @Override
    public void addField(DSField dSField, String string, int n, int n2, DSTemplatible dSTemplatible, DSGroup dSGroup, int n3) {
    }

    @Override
    public void handleGroup(DSGroup dSGroup, DSTemplatible dSTemplatible) {
    }

    @Override
    public void addChart(DSChartPlatform dSChartPlatform, LocInfo locInfo, short s, String string, int n, int n2) {
        String string2 = this.getKey(dSChartPlatform, n);
        if (this.notSupportChart.containsKey(string2)) {
            this.addToReadyWriter(new XlsChart(s, (Image)this.notSupportChart.get(string2), locInfo));
        } else if (this.supportChart.containsKey(string2)) {
            this.addToReadyWriter(new XlsChart(s, (ChartInfo)this.supportChart.get(string2), locInfo));
        } else {
            JRLog.error(logError, "This is chart(" + dSChartPlatform + ") is missing");
        }
    }

    protected void addToReadyWriter(ExcelChartInfo excelChartInfo) {
        if (excelChartInfo != null) {
            if (this.readyWriter == null) {
                this.readyWriter = new ArrayList();
            }
            this.readyWriter.add(excelChartInfo);
        }
    }

    @Override
    public List getCurPageChartInfo() {
        if (this.readyWriter != null) {
            ArrayList arrayList = new ArrayList(this.readyWriter.size());
            for (int i = 0; i < this.readyWriter.size(); ++i) {
                arrayList.add(this.readyWriter.get(i));
            }
            this.readyWriter = null;
            return arrayList;
        }
        return null;
    }

    @Override
    public List getAllChartInfo() {
        return this.getCurPageChartInfo();
    }

    @Override
    public boolean beSplit() {
        return this.clear;
    }

    @Override
    public void setChartFactory(ChartFactory chartFactory) {
        this.containsKey = chartFactory;
    }

    private class XlsChart
    implements ExcelChartInfo {
        private short SEDU;
        private ChartInfo I;
        private boolean Z = false;
        private Image C;
        private LocInfo B;

        XlsChart(short s, ChartInfo chartInfo, LocInfo locInfo) {
            this.SEDU = s;
            this.B = locInfo;
            this.I = chartInfo;
        }

        XlsChart(short s, Image image, LocInfo locInfo) {
            this.SEDU = s;
            this.B = locInfo;
            this.C = image;
        }

        @Override
        public short getSheetNum() {
            return this.SEDU;
        }

        @Override
        public boolean isImage() {
            return this.Z;
        }

        @Override
        public ChartInfo getChartInfo() {
            return this.I;
        }

        @Override
        public Image getImage() {
            return this.C;
        }

        @Override
        public LocInfo getLocInfo() {
            return this.B;
        }
    }

    class DynamicChartInfo {
        String seriesCols;
        String catCols;
        String bindObj;
        boolean isDetail = true;
        String[] y1;
        String[] y2;
        List y1Sum;
        List y2Sum;
        DSTemplatible chartTemplatible;
        private boolean SEDU;
        private boolean append;

        DynamicChartInfo() {
        }

        public String toString() {
            String string = "Ser(" + this.seriesCols + ")Cat(" + this.catCols + ")bind(" + this.bindObj + ")isDetail(" + this.isDetail + ")templatible(" + this.chartTemplatible + ")";
            return string;
        }

        public boolean needDynamic() {
            return true;
        }

        public boolean hasCatSpFun() {
            return this.SEDU;
        }

        public boolean hasSerSpFun() {
            return this.append;
        }

        public void setChartTemplatible(DSTemplatible dSTemplatible) {
            this.chartTemplatible = dSTemplatible;
        }

        public void setBindKey(String string) {
            this.bindObj = string;
        }

        public void setSeriesName(String string, String string2) {
            this.seriesCols = string != null ? string.toUpperCase() : null;
            if (string2 != null && string2.length() != 0) {
                this.seriesCols = this.seriesCols + " " + string2.toUpperCase();
                this.append = true;
            }
        }

        public void setCategory(String string, String string2) {
            this.catCols = string != null ? string.toUpperCase() : null;
            if (string2 != null && string2.length() != 0) {
                this.catCols = this.catCols + " " + string2.toUpperCase();
                this.SEDU = true;
            }
        }

        public void setY1(List list) {
            this.isDetail = false;
            this.y1Sum = list;
        }

        public void setY2(List list) {
            this.isDetail = false;
            this.y2Sum = list;
        }

        public void setY1SeriesValue(String[] stringArray) {
            this.y1 = stringArray;
        }

        public void setY2SeriesValue(String[] stringArray) {
            this.y2 = stringArray;
        }
    }

    class GroupInfo {
        private String SEDU;
        private String toUpperCase;

        GroupInfo(String string, String string2) {
            if (string != null) {
                this.SEDU = string.toUpperCase();
            }
            if (string2 != null) {
                this.toUpperCase = string2.toUpperCase();
            }
        }

        public String getName() {
            return this.SEDU;
        }

        public String getSp() {
            return this.toUpperCase;
        }
    }
}

