/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.awt.Color;
import java.io.IOException;
import java.util.Hashtable;
import jet.export.excel.api.ExcelFont;
import jet.export.excel.imp.xls.BUnicode;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import util.RandomAccessStream;

public class BFont
extends Biff
implements ExcelFont {
    public static final int ITALIC = 2;
    public static final int STRIKEOUT = 8;
    public static final int OUTLINE = 16;
    public static final int SHADOW = 32;
    public static final short SS_NONE = 0;
    public static final short SS_SUPER = 1;
    public static final short SS_SUB = 2;
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    private short SEDU;
    private short addColor;
    private short append;
    private short equal;
    private byte get;
    private byte getLength;
    private short isChart;
    protected short icv;
    BUnicode rfch;
    protected ColorTable colorTable;
    private static Hashtable needUpdateIndex = new Hashtable();

    public BFont(ColorTable colorTable, String string) {
        this.colorTable = colorTable;
        this.setFontName(string);
    }

    public BFont(ColorTable colorTable) {
        this(200, 0, Short.MAX_VALUE, 400, 0, 0, 0, 0, "Arial");
        this.colorTable = colorTable;
    }

    private BFont(short s, short s2, short s3, short s4, short s5, byte by, byte by2, short s6, String string) {
        this.SEDU = s;
        this.addColor = s2;
        this.icv = s3;
        this.append = s4;
        this.equal = s5;
        this.get = by;
        this.getLength = by2;
        this.isChart = s6;
        this.setFontName(string);
    }

    @Override
    public final int opcode() {
        return 49;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        if (this.colorTable.needUpdateIndex() && this.icv >= 0 && this.icv != Short.MAX_VALUE) {
            this.icv = this.colorTable.updateColorIndex(this.icv);
        }
        this.writeShort(randomAccessStream, this.SEDU);
        this.writeShort(randomAccessStream, this.addColor);
        this.writeShort(randomAccessStream, this.icv);
        this.writeShort(randomAccessStream, this.append);
        this.writeShort(randomAccessStream, this.equal);
        randomAccessStream.writeByte(this.get);
        randomAccessStream.writeByte(this.getLength);
        this.writeShort(randomAccessStream, this.isChart);
        this.rfch.setHighByte(true);
        this.rfch.output(randomAccessStream, this);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
    }

    @Override
    public int getLength() {
        this.rfch.setHighByte(true);
        this.length = 14 + this.rfch.getLength();
        return this.length + 4;
    }

    public void setFontHeight(short s) {
        this.SEDU = s;
    }

    public boolean getItalic() {
        return (this.addColor & 2) == 2;
    }

    public boolean getStrickout() {
        return (this.addColor & 8) == 8;
    }

    public boolean getOutline() {
        return (this.addColor & 0x10) == 16;
    }

    public boolean getShadow() {
        return (this.addColor & 0x20) == 32;
    }

    @Override
    public void setSuperSubScript(short s) {
        this.equal = s;
    }

    @Override
    public void setUnderline(byte by) {
        this.get = by;
    }

    private static short SEDU(String string) {
        Short s = (Short)needUpdateIndex.get(string);
        if (s != null) {
            return s;
        }
        return 0;
    }

    public void setFontName(String string) {
        this.isChart = BFont.SEDU(string);
        this.rfch = new BUnicode(string, true);
        this.rfch.setHighByte(true);
    }

    int getFontNameLength() {
        return this.rfch.rgb.length;
    }

    public String toString() {
        return "" + this.SEDU + this.addColor + this.icv + this.append + this.equal + this.get + this.getLength + this.isChart + this.rfch.toString();
    }

    boolean equal(BFont bFont, boolean bl) {
        return bl || this.isChart() == bFont.isChart() ? (this.SEDU == bFont.SEDU ? (this.rfch.equal(bFont.rfch) ? (this.addColor == bFont.addColor ? (this.icv == bFont.icv ? (this.append == bFont.append ? (this.equal == bFont.equal ? (this.getLength == bFont.getLength ? (this.get == bFont.get ? this.isChart == bFont.isChart : false) : false) : false) : false) : false) : false) : false) : false) : false;
    }

    @Override
    public void setFontColor(Color color) {
        this.icv = this.colorTable.addColor(color);
    }

    @Override
    public void setIsBold(boolean bl) {
        this.append = (short)(bl ? 700 : 400);
    }

    @Override
    public void setIsItalic(boolean bl) {
        this.addColor = (short)(bl ? this.addColor | 2 : this.addColor & 0xFFFFFFFD);
    }

    @Override
    public void setIsStruckout(boolean bl) {
        this.addColor = (short)(bl ? this.addColor | 8 : this.addColor & 0xFFFFFFF7);
    }

    boolean isChart() {
        return false;
    }

    @Override
    public void setIsShadow(boolean bl) {
        this.addColor = (short)(bl ? this.addColor | 0x20 : this.addColor & 0xFFFFFFDF);
    }

    public short getHeight() {
        return this.SEDU;
    }

    @Override
    public void setIsOutline(boolean bl) {
        this.addColor = (short)(bl ? this.addColor | 0x10 : this.addColor & 0xFFFFFFEF);
    }

    static {
        needUpdateIndex.put("Arial", (short)0);
        needUpdateIndex.put("SimHei", (short)134);
        needUpdateIndex.put("STXingkai", (short)134);
        needUpdateIndex.put("STSong", (short)134);
        needUpdateIndex.put("STXihei", (short)134);
        needUpdateIndex.put("NSimSun", (short)134);
        needUpdateIndex.put("SimSun", (short)134);
        needUpdateIndex.put("DFPMingLight-B5", (short)134);
        needUpdateIndex.put("Arial Unicode MS", (short)134);
        needUpdateIndex.put("Simplified Arabic", (short)178);
        needUpdateIndex.put("Traditional Arabic", (short)178);
        needUpdateIndex.put("Arial (Arabic)", (short)178);
        needUpdateIndex.put("Simplified Arabic", (short)178);
        needUpdateIndex.put("Batang", (short)129);
        needUpdateIndex.put("MS UI Gothic", (short)128);
        needUpdateIndex.put("MS PMincho", (short)128);
        needUpdateIndex.put("MS PGothic", (short)128);
        needUpdateIndex.put("MS Mincho", (short)128);
        needUpdateIndex.put("MS Gothic", (short)128);
        needUpdateIndex.put("Wingdings 3", (short)2);
        needUpdateIndex.put("Wingdings 2", (short)2);
        needUpdateIndex.put("Wingdings", (short)2);
        needUpdateIndex.put("Webdings", (short)2);
        needUpdateIndex.put("Symbol", (short)2);
        needUpdateIndex.put("MT Extra", (short)2);
        needUpdateIndex.put("MS Reference Specialty", (short)2);
        needUpdateIndex.put("MS Outlook", (short)2);
        needUpdateIndex.put("Marlett", (short)2);
        needUpdateIndex.put("Kingsoft Phonetic", (short)2);
        needUpdateIndex.put("Bookshelf Symbol 7", (short)2);
        needUpdateIndex.put("PMingLiU", (short)136);
        needUpdateIndex.put("MingLiU", (short)136);
    }
}

