/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import util.RandomAccessStream;

class ColInfo
extends Biff {
    public static final short HIDDEN = 1;
    public static final short OUTLEVEL = 1792;
    public static final short COLLAPSED = 4096;
    short colFirst;
    short colLast;
    short coldx;
    short ixfe;
    short grbit;

    public ColInfo() {
    }

    public ColInfo(short s, short s2, short s3, short s4, short s5) {
        this.length = 12;
        this.colFirst = s;
        this.colLast = s2;
        this.coldx = s3;
        this.ixfe = s4;
        this.grbit = s5;
    }

    @Override
    public final int opcode() {
        return 125;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeShort(randomAccessStream, this.colFirst);
        this.writeShort(randomAccessStream, this.colLast);
        this.writeShort(randomAccessStream, this.coldx);
        this.writeShort(randomAccessStream, this.ixfe);
        this.writeShort(randomAccessStream, this.grbit);
        this.writeShort(randomAccessStream, (short)0);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.colFirst = this.readShort(randomAccessStream);
        this.colLast = this.readShort(randomAccessStream);
        this.coldx = this.readShort(randomAccessStream);
        this.ixfe = this.readShort(randomAccessStream);
        this.grbit = this.readShort(randomAccessStream);
        this.readShort(randomAccessStream);
    }

    public void setCollapsed(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x1000 : this.grbit & 0xFFFFEFFF);
    }

    public boolean getCollapsed() {
        return (this.grbit & 0x1000) == 4096;
    }

    public void setOutLevel(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x700 : this.grbit & 0xFFFFF8FF);
    }

    public boolean getOutLevel() {
        return (this.grbit & 0x700) == 1792;
    }

    public void setHidden(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE);
    }

    public boolean getHidden() {
        return (this.grbit & 1) == 1;
    }
}

