/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.io.IOException;
import jet.export.excel.imp.xls.Blank;
import util.RandomAccessStream;

class Formula
extends Blank {
    public static final short ALWAYSCALC = 1;
    public static final short CALCONLOAD = 2;
    public static final short SHRFMLA = 8;
    double num;
    short grbit;
    int chn = 0;
    short cce;
    byte[] rgce;
    private String I;
    private boolean SEDU = false;

    Formula(int n, int n2, short s) {
        super(n, n2, s);
        this.grbit = (short)2;
    }

    Formula() {
    }

    @Override
    public final int opcode() {
        return 6;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        this.length = 22 + this.rgce.length;
        super.output(randomAccessStream);
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.num));
        this.writeShort(randomAccessStream, this.grbit);
        this.writeInt(randomAccessStream, this.chn);
        this.writeShort(randomAccessStream, this.cce);
        randomAccessStream.writeByteArray(this.rgce);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        super.input(randomAccessStream);
        this.num = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.grbit = this.readShort(randomAccessStream);
        this.chn = this.readInt(randomAccessStream);
        this.cce = this.readShort(randomAccessStream);
        this.rgce = new byte[this.cce];
        this.rgce = randomAccessStream.readByteArray(this.cce);
    }

    @Override
    public int getLength() {
        this.length = 22 + this.rgce.length;
        return this.length + 4;
    }

    public void setFormulaStr(String string) {
        this.I = string;
    }

    public String getFormulaStr() {
        return this.I;
    }

    public void setAlwaysCalc(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE);
    }

    public boolean isAlwaysCalc() {
        return (this.grbit & 1) == 1;
    }

    public void setCalcOnLoad(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 2 : this.grbit & 0xFFFFFFFD);
    }

    public boolean isCalcOnLoad() {
        return (this.grbit & 2) == 2;
    }

    public void setShrFmla(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 8 : this.grbit & 0xFFFFFFF7);
    }

    public boolean isShrFmla() {
        return (this.grbit & 8) == 8;
    }

    public double getValue() {
        return this.num;
    }

    void setValue(double d) {
        this.num = d;
    }

    void setIsError(boolean bl) {
        this.SEDU = bl;
    }

    boolean isError() {
        return this.SEDU;
    }
}

