/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.io.IOException;
import jet.export.excel.api.LocInfo;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import jet.export.excel.imp.xls.HLink;
import jet.export.excel.imp.xls.LocInfoImp;
import jet.export.excel.imp.xls.PicPath;
import util.RandomAccessStream;

class MsoDrawing
extends Biff {
    public static final int CHARTOBJ = 1;
    public static final int SHAPEOBJ = 2;
    public static final int PICOBJ = 3;
    short[] msoDw1;
    PicPath picPath;
    byte[] msoDw2;
    short locType;
    short left;
    short leftOffset;
    short right;
    short rightOffset;
    short topOffset;
    short bottomOffset;
    int top;
    int bottom;
    int objType;
    HLink link;
    boolean hasLink;
    boolean isRBox = false;
    private ColorTable SEDU;

    public MsoDrawing(ColorTable colorTable, short[] sArray, byte[] byArray) {
        this.SEDU = colorTable;
        this.msoDw1 = sArray;
        this.msoDw2 = byArray;
        this.picPath = new PicPath();
        this.link = new HLink();
    }

    private MsoDrawing(short[] sArray, byte[] byArray, LocInfo locInfo) {
        this.msoDw1 = sArray;
        this.msoDw2 = byArray;
        this.setLocInfo(locInfo);
        this.objType = 1;
        this.length = sArray.length * 2 + byArray.length + 16;
    }

    public MsoDrawing(ColorTable colorTable, short[] sArray, byte[] byArray, LocInfo locInfo, PicPath picPath, int n) {
        this(sArray, byArray, locInfo);
        this.SEDU = colorTable;
        this.picPath = picPath;
        this.objType = n;
        this.length = sArray.length * 2 + byArray.length + picPath.getLength() + 26;
        if (n == 3) {
            this.locType = (short)2;
            this.msoDw1[2] = (short)(this.length - 8);
            if (sArray.length == 53) {
                this.msoDw1[14] = (short)(this.length - 32);
                this.msoDw1[42] = (short)(this.length - 88);
            }
        }
    }

    @Override
    public final int opcode() {
        return 236;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeShortArray(randomAccessStream, this.msoDw1);
        if (this.SEDU.needUpdateIndex()) {
            this.picPath.updateIndex(this.SEDU);
        }
        this.picPath.output(randomAccessStream, this);
        if (this.hasLink) {
            this.link._output(randomAccessStream);
        }
        this.writeShort(randomAccessStream, (short)0);
        this.writeShort(randomAccessStream, (short)-4080);
        this.writeShort(randomAccessStream, (short)18);
        this.writeShort(randomAccessStream, (short)0);
        this.writeShort(randomAccessStream, this.locType);
        this.writeShort(randomAccessStream, this.left);
        this.writeShort(randomAccessStream, this.leftOffset);
        this.writeShort(randomAccessStream, this.top);
        this.writeShort(randomAccessStream, this.topOffset);
        this.writeShort(randomAccessStream, this.right);
        this.writeShort(randomAccessStream, this.rightOffset);
        this.writeShort(randomAccessStream, this.bottom);
        this.writeShort(randomAccessStream, this.bottomOffset);
        randomAccessStream.writeByteArray(this.msoDw2);
        int n = this.msoDw1.length * 2 + this.msoDw2.length + this.picPath.getLength() + 26 + 4;
        return n += this.link == null ? 0 : this.link.length;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        int n;
        for (n = 0; n < this.msoDw1.length; ++n) {
            this.msoDw1[n] = this.readShort(randomAccessStream);
        }
        n = this.msoDw1.length;
        if (this.msoDw1[n - 1] == 147) {
            this.hasLink = false;
        } else if (this.msoDw1[n - 9] == 34) {
            this.hasLink = false;
            this.isRBox = true;
        } else {
            this.hasLink = true;
        }
        this.picPath.input(randomAccessStream, this, this.hasLink, this.isRBox);
        if (this.hasLink) {
            this.link._input(randomAccessStream);
        }
        this.readLong(randomAccessStream);
        this.locType = this.readShort(randomAccessStream);
        this.left = this.readShort(randomAccessStream);
        this.leftOffset = this.readShort(randomAccessStream);
        this.top = this.readIntWithShortFormat(randomAccessStream);
        this.topOffset = this.readShort(randomAccessStream);
        this.right = this.readShort(randomAccessStream);
        this.rightOffset = this.readShort(randomAccessStream);
        this.bottom = this.readIntWithShortFormat(randomAccessStream);
        this.bottomOffset = this.readShort(randomAccessStream);
        this.msoDw2 = randomAccessStream.readByteArray(this.msoDw2.length);
    }

    public void setMsoDw1(short[] sArray) {
        this.msoDw1 = sArray;
    }

    public short[] getMsoDw1() {
        return this.msoDw1;
    }

    void setLocInfo(LocInfo locInfo) {
        LocInfoImp locInfoImp = (LocInfoImp)locInfo;
        this.left = (short)locInfoImp.getLeft();
        this.leftOffset = locInfoImp.getLeftOffsetValue();
        this.right = (short)locInfoImp.getRight();
        this.rightOffset = locInfoImp.getRightOffsetValue();
        this.top = locInfoImp.getTop();
        this.topOffset = locInfoImp.getTopOffsetValue();
        this.bottom = locInfoImp.getBottom();
        this.bottomOffset = locInfoImp.getBottomOffsetValue();
    }

    public void setLeft(short s) {
        this.left = s;
    }

    public short getLeft() {
        return this.left;
    }

    public void setLeftOffset(short s) {
        this.leftOffset = s;
    }

    public short getLeftOffset() {
        return this.leftOffset;
    }

    public void setRight(short s) {
        this.right = s;
    }

    public short getRight() {
        return this.right;
    }

    public void setRightOffset(short s) {
        this.rightOffset = s;
    }

    public short getRightOffset() {
        return this.rightOffset;
    }

    public void setTop(int n) {
        this.top = n;
    }

    public int getTop() {
        return this.top;
    }

    public void setTopOffset(short s) {
        this.topOffset = s;
    }

    public short getTopOffset() {
        return this.topOffset;
    }

    public void setBottom(int n) {
        this.bottom = n;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setBottomOffset(short s) {
        this.bottomOffset = s;
    }

    public short getBottomOffset() {
        return this.bottomOffset;
    }

    public void setHLink(HLink hLink) {
        this.link = hLink;
        this.length += hLink.length;
        this.picPath.len += hLink.length;
        this.hasLink = true;
        if (this.objType == 3) {
            this.msoDw1[2] = (short)(this.length - 8);
            if (this.msoDw1.length == 53) {
                this.msoDw1[14] = (short)(this.length - 32);
                this.msoDw1[42] = (short)(this.length - 88);
            }
        }
    }
}

