/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.io.IOException;
import jet.export.excel.api.PageInfoSetup;
import jet.export.excel.api.PaperSize;
import jet.export.excel.imp.xls.Biff;
import util.RandomAccessStream;

class Setup
extends Biff
implements PageInfoSetup {
    private static final int SEDU = 1;
    private static final int doubleToLongBits = 2;
    private static final int getIndex = 4;
    private static final int longBitsToDouble = 8;
    private static final int output = 16;
    private static final int readLong = 32;
    private static final int readShort = 64;
    private static final int writeLong = 128;
    private static final int writeShort = 512;
    private static final int I = 62463;
    private static final int Z = 63487;
    private static final int C = 64511;
    private static final int B = 65535;
    short iPaperSize = 0;
    short iScale = (short)100;
    short iPageStart = 1;
    short iFitWidth = 1;
    short iFitHeight = 1;
    short grbit;
    short iRes = (short)1200;
    short iVRes = (short)1200;
    short iCopies = 1;
    double numHdr = 0.5;
    double numFtr = 0.5;
    private boolean D = false;
    private String F;
    private String J;

    public Setup() {
        this.length = 34;
        this.SEDU(true);
        this.getIndex(false);
        this.doubleToLongBits(true);
    }

    public Setup(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, double d, double d2, short s9) {
        this();
        this.iPaperSize = s;
        this.iScale = s2;
        this.iPageStart = s3;
        this.iFitWidth = s4;
        this.iFitHeight = s5;
        this.grbit = s6;
        this.iRes = s7;
        this.iVRes = s8;
        this.numHdr = d;
        this.numFtr = d2;
        this.iCopies = s9;
    }

    @Override
    public final int opcode() {
        return 161;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeShort(randomAccessStream, this.iPaperSize);
        this.writeShort(randomAccessStream, this.iScale);
        this.writeShort(randomAccessStream, this.iPageStart);
        this.writeShort(randomAccessStream, this.iFitWidth);
        this.writeShort(randomAccessStream, this.iFitHeight);
        this.writeShort(randomAccessStream, this.grbit);
        this.writeShort(randomAccessStream, this.iRes);
        this.writeShort(randomAccessStream, this.iVRes);
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.numHdr));
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.numFtr));
        this.writeShort(randomAccessStream, this.iCopies);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.iPaperSize = this.readShort(randomAccessStream);
        this.iScale = this.readShort(randomAccessStream);
        this.iPageStart = this.readShort(randomAccessStream);
        this.iFitWidth = this.readShort(randomAccessStream);
        this.iFitHeight = this.readShort(randomAccessStream);
        this.grbit = this.readShort(randomAccessStream);
        this.iRes = this.readShort(randomAccessStream);
        this.iVRes = this.readShort(randomAccessStream);
        this.numHdr = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.numFtr = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.iCopies = this.readShort(randomAccessStream);
    }

    private void SEDU(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 4 : this.grbit & 0xFFFFFFFB);
    }

    private void doubleToLongBits(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x40 : this.grbit & 0xFFFFFFBF);
    }

    private void getIndex(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x80 : this.grbit & 0xFFFFFF7F);
    }

    public boolean getLeftToRight() {
        return (this.grbit & 1) == 1;
    }

    public boolean getLandscape() {
        return (this.grbit & 2) != 2;
    }

    public boolean getNoPls() {
        return (this.grbit & 4) == 4;
    }

    public boolean getNoColor() {
        return (this.grbit & 8) == 8;
    }

    public boolean getDraft() {
        return (this.grbit & 0x10) == 16;
    }

    public boolean getNotes() {
        return (this.grbit & 0x20) == 32;
    }

    public boolean getNoOrient() {
        return (this.grbit & 0x40) == 64;
    }

    public boolean getUsePage() {
        return (this.grbit & 0x80) == 128;
    }

    @Override
    public void setPaperSize(PaperSize paperSize) {
        if (paperSize != null) {
            this.iPaperSize = paperSize.getIndex();
            this.SEDU(false);
        }
    }

    @Override
    public void setScale(short s) {
        if (s >= 10 && s <= 400) {
            this.iScale = s;
            this.SEDU(false);
        }
    }

    @Override
    public void setPageStart(short s) {
        if (s <= Short.MAX_VALUE && s >= -32765) {
            this.iPageStart = s;
            this.getIndex(true);
        }
    }

    @Override
    public void setFitHeight(short s) {
        if (s >= 1 && s <= Short.MAX_VALUE) {
            this.iFitHeight = s;
        }
    }

    @Override
    public void setFitWidth(short s) {
        if (s >= 1 && s <= Short.MAX_VALUE) {
            this.iFitWidth = s;
        }
    }

    @Override
    public void setPrintOrder(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE);
    }

    @Override
    public void setIsLandscape(boolean bl) {
        if (bl) {
            this.doubleToLongBits(false);
            this.SEDU(false);
            this.grbit = (short)(this.grbit & 0xFFFFFFFD);
        } else {
            this.doubleToLongBits(true);
            this.grbit = (short)(this.grbit | 2);
        }
    }

    @Override
    public void setIsNoColor(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 8 : this.grbit & 0xFFFFFFF7);
    }

    @Override
    public void setIsDraftPrint(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x10 : this.grbit & 0xFFFFFFEF);
    }

    private void grbit(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x20 : this.grbit & 0xFFFFFFDF);
    }

    @Override
    public void setPrintCommentFormat(byte by) {
        if (by != 0) {
            this.grbit(true);
            this.grbit = (short)(by == 1 ? this.grbit | 0x200 : this.grbit & 0xFFFFFDFF);
        } else {
            this.grbit(false);
        }
    }

    @Override
    public void setPrintErrorFormat(byte by) {
        switch (by) {
            case 1: {
                this.grbit = (short)(this.grbit | 0xF7FF);
                break;
            }
            case 2: {
                this.grbit = (short)(this.grbit | 0xFBFF);
                break;
            }
            case 3: {
                this.grbit = (short)(this.grbit | 0xFFFF);
                break;
            }
            default: {
                this.grbit = (short)(this.grbit | 0xF3FF);
            }
        }
    }

    @Override
    public void setPrintDPI(int n) {
        this.iRes = (short)n;
        this.iVRes = (short)n;
        this.SEDU(false);
    }

    @Override
    public void setFooterMargin(short s) {
        if (s >= 0 && s <= 3528) {
            this.numFtr = (double)s / 72.0;
        }
    }

    @Override
    public void setHeaderMargin(short s) {
        if (s >= 0 && s <= 3528) {
            this.numHdr = (double)s / 72.0;
        }
    }

    @Override
    public void setIsPrintGridlines(boolean bl) {
        this.D = bl;
    }

    boolean isPrintGridLine() {
        return this.D;
    }

    String getPrintHeader() {
        return this.F;
    }

    @Override
    public void setPrinterFooter(String string) {
        this.J = string;
    }

    @Override
    public void setPrinterHeader(String string) {
        this.F = string;
    }

    public String getPrintFooter() {
        return this.J;
    }
}

