/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.awt.Color;
import java.io.IOException;
import jet.export.excel.api.WindowsOptions;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import jet.export.excel.imp.xls.Pane;
import util.RandomAccessStream;

class Window2
extends Biff
implements WindowsOptions {
    public static final int DSPFMLA = 1;
    public static final int DSPGRID = 2;
    public static final int DSPRWCOL = 4;
    public static final int FROZEN = 8;
    public static final int DSPZEROS = 16;
    public static final int DEFAULTHDR = 32;
    public static final int ARABIC = 64;
    public static final int DSPGUTS = 128;
    public static final int FROZENNOSPLIT = 256;
    public static final int SELECTED = 512;
    public static final int PAGED = 1024;
    public static final int SLV = 2048;
    short grbit;
    short rwTop;
    short colLeft;
    short wScaleSLV = 0;
    short wScaleNormal = 0;
    int icvHdr;
    private ColorTable SEDU;
    private int addColor;
    private Pane needUpdateIndex;

    private Window2() {
        this.length = 18;
        this.grbit = (short)182;
        this.rwTop = 0;
        this.colLeft = 0;
        this.icvHdr = 64;
    }

    Window2(ColorTable colorTable) {
        this();
        this.SEDU = colorTable;
    }

    @Override
    public final int opcode() {
        return 574;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        if (this.SEDU.needUpdateIndex() && this.icvHdr != 64) {
            this.icvHdr = this.SEDU.updateColorIndex((short)this.icvHdr);
        }
        this.writeShort(randomAccessStream, this.grbit);
        this.writeShort(randomAccessStream, this.rwTop);
        this.writeShort(randomAccessStream, this.colLeft);
        this.writeInt(randomAccessStream, this.icvHdr);
        this.writeShort(randomAccessStream, this.wScaleSLV);
        this.writeShort(randomAccessStream, this.wScaleNormal);
        this.writeInt(randomAccessStream, 0);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.grbit = this.readShort(randomAccessStream);
        this.rwTop = this.readShort(randomAccessStream);
        this.colLeft = this.readShort(randomAccessStream);
        this.icvHdr = this.readInt(randomAccessStream);
        this.wScaleSLV = this.readShort(randomAccessStream);
        this.wScaleNormal = this.readShort(randomAccessStream);
        this.readInt(randomAccessStream);
    }

    public void setDspFmla(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE);
    }

    private void SEDU(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 8 : this.grbit & 0xFFFFFFF7);
    }

    public void setDspZeros(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x10 : this.grbit & 0xFFFFFFEF);
    }

    void setDefaultHdr(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x20 : this.grbit & 0xFFFFFFDF);
    }

    public void setArabic(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x40 : this.grbit & 0xFFFFFFBF);
    }

    public void setDspGuts(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x80 : this.grbit & 0xFFFFFF7F);
    }

    private void addColor(boolean bl) {
        if (bl) {
            this.SEDU(true);
            this.grbit = (short)(this.grbit | 0x100);
        } else {
            this.grbit = (short)(this.grbit & 0xFFFFFEFF);
        }
    }

    public void setSelected(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x200 : this.grbit & 0xFFFFFDFF);
        this.colLeft(bl);
    }

    private void colLeft(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x400 : this.grbit & 0xFFFFFBFF);
    }

    public void setSLV(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x800 : this.grbit & 0xFFFFF7FF);
    }

    public boolean getDspFmla() {
        return (this.grbit & 1) == 1;
    }

    public boolean getDspGrid() {
        return (this.grbit & 2) == 2;
    }

    public boolean getDspRwColw() {
        return (this.grbit & 4) == 4;
    }

    public boolean getFrozen() {
        return (this.grbit & 8) == 8;
    }

    public boolean getDspZeros() {
        return (this.grbit & 0x10) == 16;
    }

    public boolean getDefaultHdr() {
        return (this.grbit & 0x20) == 32;
    }

    public boolean getArabic() {
        return (this.grbit & 0x40) == 64;
    }

    public boolean getDspGuts() {
        return (this.grbit & 0x80) == 128;
    }

    public boolean getFrozenNoSplit() {
        return (this.grbit & 0x100) == 256;
    }

    public boolean getSelected() {
        return (this.grbit & 0x200) == 512;
    }

    public boolean getPaged() {
        return (this.grbit & 0x400) == 1024;
    }

    public boolean getSLV() {
        return (this.grbit & 0x800) == 2048;
    }

    @Override
    public void setZoomValue(int n) {
        this.addColor = n;
    }

    public int getZoomValue() {
        return this.addColor;
    }

    @Override
    public void setFreezePane(int n, int n2, int n3, int n4) {
        if (n2 >= 255 || n >= 65535 || n < 0 || n2 < 0) {
            this.SEDU(false);
            this.addColor(false);
            this.needUpdateIndex = null;
        } else {
            this.SEDU(true);
            this.addColor(true);
            this.colLeft = (short)(n2 - n4);
            this.rwTop = (short)(n - n3);
            if (this.colLeft < 0) {
                this.colLeft = 0;
                n4 = n2;
            }
            if (this.rwTop < 0) {
                this.rwTop = 0;
                n3 = n;
            }
            this.needUpdateIndex = new Pane(n4, n3, n2, n);
        }
    }

    Pane getPane() {
        return this.needUpdateIndex;
    }

    @Override
    public void setGridLineColor(Color color) {
        this.setDefaultHdr(false);
        this.icvHdr = this.SEDU.addColor(color);
    }

    @Override
    public void setIsShowGridLine(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 2 : this.grbit & 0xFFFFFFFD);
    }

    @Override
    public void setIsShowRowColHeading(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 4 : this.grbit & 0xFFFFFFFB);
    }
}

