/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jet.export.excel.api.DocumentException;
import jet.export.excel.api.ExcelWorkSheet;
import jet.export.excel.imp.xls.BaseWorkbook;
import jet.export.excel.imp.xls.CachListener;
import jet.export.excel.imp.xls.CacheClear;
import jet.export.excel.imp.xls.ChartStore;
import jet.export.excel.imp.xls.DataConstants;
import jet.export.excel.imp.xls.Formula;
import jet.export.excel.imp.xls.GlobalWorksheet;
import jet.export.excel.imp.xls.ImageStore;
import jet.export.excel.imp.xls.ShapeStore;
import jet.export.excel.imp.xls.WorkbookFooter;
import jet.export.excel.imp.xls.WorkbookHeader;
import jet.export.excel.imp.xls.Worksheet;
import jet.export.util.Cache;
import util.RandomAccessStream;

class Workbook
extends BaseWorkbook
implements DataConstants {
    private WorkbookHeader SEDU = new WorkbookHeader();
    private WorkbookFooter add = new WorkbookFooter();
    private ArrayList check = new ArrayList(4);
    private GlobalWorksheet clear;
    private RandomAccessStream close = new RandomAccessStream();
    private CacheClear equalsIgnoreCase;

    Workbook(CacheClear cacheClear, Cache cache) throws DocumentException {
        this.equalsIgnoreCase = cacheClear;
        try {
            this.clear = new GlobalWorksheet(cache);
        }
        catch (IOException iOException) {
            throw new DocumentException(iOException);
        }
        this.clear.setSheetInfo(this.check);
    }

    @Override
    GlobalWorksheet getGlobalWorksheet() {
        return this.clear;
    }

    @Override
    public void output(OutputStream outputStream) throws DocumentException {
        try {
            int n;
            int n2;
            int n3 = this.check.size();
            if (n3 == 0) {
                Worksheet worksheet = new Worksheet(this.clear);
                worksheet.setCacheListener(new NullCachListener());
                this.add(worksheet);
                n3 = 1;
            }
            this.clear.updateBoundSheetName(this.check);
            for (n2 = 0; n2 < this.check.size(); ++n2) {
                Worksheet worksheet = (Worksheet)this.check.get(n2);
                worksheet.update();
            }
            this.clear.handleFormula();
            this.clear.registerColorFinished();
            n2 = this.add.check(this.check, this.clear, this.SEDU);
            this.SEDU.output(outputStream);
            this.SEDU.free();
            this.SEDU = null;
            this.clear.output(outputStream, this.close);
            this.clear.free();
            this.clear = null;
            for (n = 0; n < n3; ++n) {
                Worksheet worksheet = this.getSheet(n);
                worksheet.output(outputStream, this.close);
                this.close.seek(0);
                worksheet.free();
            }
            if (n2 < 4096) {
                for (n = 0; n < 4096 - n2; ++n) {
                    outputStream.write(0);
                }
            } else if (n2 >= 4096 && n2 % 512 != 0) {
                n3 = 512 - n2 % 512;
                for (n = 0; n < n3; ++n) {
                    outputStream.write(255);
                }
            }
            this.add.output(outputStream);
            this.add = null;
        }
        catch (IOException iOException) {
            throw new DocumentException(iOException);
        }
    }

    @Override
    public void free() throws DocumentException {
        try {
            this.close.close();
            this.SEDU = null;
            this.check.clear();
            this.check = null;
            this.equalsIgnoreCase.clear();
            this.add = null;
        }
        catch (IOException iOException) {
            throw new DocumentException(iOException);
        }
    }

    private void add(Worksheet worksheet) throws DocumentException {
        worksheet.setSheetIndex(this.check.size());
        if (worksheet.getSheetIndex() == 0) {
            worksheet.setIsSelected(true);
        }
        this.check.add(worksheet);
    }

    @Override
    public Worksheet getSheet(int n) {
        if (n < this.check.size()) {
            return (Worksheet)this.check.get(n);
        }
        return null;
    }

    @Override
    public Worksheet getSheet(String string) {
        for (int i = 0; i < this.check.size(); ++i) {
            Worksheet worksheet = (Worksheet)this.check.get(i);
            if (!string.equalsIgnoreCase(worksheet.getSheetName()) && !string.equalsIgnoreCase(worksheet.getNoneRegularName())) continue;
            return worksheet;
        }
        return null;
    }

    @Override
    public int getSheetSize() {
        return this.check.size();
    }

    @Override
    public void addSheet(ExcelWorkSheet excelWorkSheet) throws DocumentException {
        this.add((Worksheet)excelWorkSheet);
    }

    class NullCachListener
    implements CachListener {
        NullCachListener() {
        }

        @Override
        public void registerSheetKey(Integer n) {
        }

        @Override
        public void readFromFile() throws IOException, DocumentException {
        }

        @Override
        public void addFormular(Formula formula2) {
        }

        @Override
        public List removeAllFormular() {
            return null;
        }

        @Override
        public boolean needUpdate() {
            return false;
        }

        @Override
        public boolean hasStoreCharts() {
            return false;
        }

        @Override
        public boolean hasStoreImages() {
            return false;
        }

        @Override
        public boolean hasStoreShapes() {
            return false;
        }

        @Override
        public void addChart(ChartStore chartStore) {
        }

        @Override
        public List removeAllChart() {
            return null;
        }

        @Override
        public void addImage(ImageStore imageStore) {
        }

        @Override
        public List removeAllImage() {
            return null;
        }

        @Override
        public void addShape(ShapeStore shapeStore) {
        }

        @Override
        public List removeAllShape() {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }
    }
}

