/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import jet.export.excel.api.DocumentException;
import jet.export.excel.imp.xls.DataConstants;
import jet.export.excel.imp.xls.DirectoryProperty;
import jet.export.excel.imp.xls.DocumentProperty;
import jet.export.excel.imp.xls.GlobalWorksheet;
import jet.export.excel.imp.xls.Property;
import jet.export.excel.imp.xls.RootProperty;
import jet.export.excel.imp.xls.WorkbookHeader;

class WorkbookFooter
implements DataConstants {
    public static int BLOCKSPERBAT = 128;
    public static int BLOCKSPERXBAT = BLOCKSPERBAT - 1;
    public static int XBATCHAINOFFSET = BLOCKSPERXBAT * 4;
    int docBCount;
    int propBCount;
    int batBCount;
    int xbatBCount;
    int batStart;
    int xbatStart;
    int offset = 0;
    byte[] bat = new byte[512];
    DirectoryProperty property = new RootProperty();

    void output(OutputStream outputStream) throws IOException {
        int n;
        this.property.output(outputStream);
        int n2 = this.propBCount * 4 - this.property.count();
        if (n2 != 0) {
            Property property = new Property();
            for (n = 0; n < n2; ++n) {
                property.output(outputStream);
            }
        }
        this.addBlocks(outputStream, 0, this.docBCount - 1);
        this.addBlocks(outputStream, this.docBCount, this.batStart - 1);
        this.addBlocks(outputStream, this.batStart, this.xbatStart - 1);
        if (this.xbatBCount > 0) {
            this.addBlocks(outputStream, this.xbatStart, this.xbatStart + this.xbatBCount - 1);
        }
        if (this.offset < 512) {
            for (n = this.offset; n < 512; n += 4) {
                this.offset += this.putNumber(this.offset, -1, 4);
            }
            outputStream.write(this.bat);
        }
        if (this.xbatBCount > 0) {
            this.offset = 0;
            int n3 = 1;
            for (n = this.batStart + 109; n < this.batStart + this.batBCount; ++n) {
                this.offset += this.putNumber(this.offset, n, 4);
                if (this.offset < XBATCHAINOFFSET) continue;
                this.putNumber(XBATCHAINOFFSET, this.xbatStart + n3++, 4);
                outputStream.write(this.bat);
                this.offset = 0;
            }
            for (n = this.offset; n < 508; n += 4) {
                this.offset += this.putNumber(this.offset, -1, 4);
            }
            this.putNumber(XBATCHAINOFFSET, -2, 4);
            outputStream.write(this.bat);
        }
    }

    void addBlocks(OutputStream outputStream, int n, int n2) throws IOException {
        for (int i = n; i < n2; ++i) {
            this.offset += this.putNumber(this.offset, i + 1, 4);
            if (this.offset < 512) continue;
            outputStream.write(this.bat);
            this.offset = 0;
        }
        this.offset += this.putNumber(this.offset, -2, 4);
        if (this.offset >= 512) {
            outputStream.write(this.bat);
            this.offset = 0;
        }
    }

    int putNumber(int n, int n2, int n3) {
        int n4 = n3 + n;
        long l = n2;
        for (int i = n; i < n4; ++i) {
            this.bat[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return n3;
    }

    int check(ArrayList arrayList, GlobalWorksheet globalWorksheet, WorkbookHeader workbookHeader) throws IOException, DocumentException {
        int n = 0;
        int n2 = 0;
        int n3 = globalWorksheet.updateBoundsheetInfo(arrayList);
        this.property.add(new DocumentProperty("Workbook", n3 < 4096 ? 4096 : n3));
        this.property.sort();
        this.docBCount = ((n3 < 4096 ? 4096 : n3) + 512 - 1) / 512;
        this.propBCount = (this.property.count() + 3) / 4;
        this.batBCount = (this.docBCount + this.propBCount) / BLOCKSPERBAT + 1;
        this.batBCount = (this.docBCount + this.propBCount + this.batBCount) / BLOCKSPERBAT + 1;
        this.batStart = this.docBCount + this.propBCount;
        workbookHeader.putNumber(48, this.docBCount, 4);
        int n4 = this.batBCount < 109 ? this.batBCount : 109;
        int n5 = 76;
        for (int i = 0; i < n4; ++i) {
            n5 += workbookHeader.putNumber(n5, this.batStart + i, 4);
        }
        if (this.batBCount > 109) {
            this.xbatBCount = (this.batBCount - 109 + BLOCKSPERXBAT - 1) / BLOCKSPERXBAT;
            while (this.batBCount != n || this.xbatBCount != n2) {
                n = this.batBCount;
                n2 = this.xbatBCount;
                this.batBCount = (this.docBCount + this.propBCount + this.xbatBCount + this.batBCount) / BLOCKSPERBAT + 1;
                this.xbatBCount = (this.batBCount - 109 + BLOCKSPERXBAT - 1) / BLOCKSPERXBAT;
            }
            this.xbatStart = this.batStart + this.batBCount;
            workbookHeader.putNumber(72, this.xbatBCount, 4);
            workbookHeader.putNumber(68, this.xbatStart, 4);
        } else {
            this.xbatStart = this.batStart + this.batBCount;
        }
        workbookHeader.putNumber(44, this.batBCount, 4);
        return n3;
    }
}

