/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.awt.Color;
import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import util.RandomAccessStream;

public class AreaFormat
extends Biff {
    public static final short AUTOFORMAT = 1;
    public static final short SWAP = 2;
    public static final short ROUND = 2;
    short pattern;
    short grbit;
    short icvFore;
    short icvBack;
    int rgbFore;
    int rgbBack;
    private ColorTable SEDU;

    public AreaFormat(ColorTable colorTable) {
        this.SEDU = colorTable;
        this.length = 16;
    }

    public AreaFormat(Color color, Color color2, short s, ColorTable colorTable) {
        this(colorTable);
        if (color != null) {
            this.rgbFore = colorTable.getColorRGB(color);
            this.icvFore = colorTable.addColor(color);
        } else {
            this.rgbFore = 0;
            this.icvFore = colorTable.addColor(Color.black);
        }
        if (color2 != null) {
            this.rgbBack = colorTable.getColorRGB(color2);
            this.icvBack = colorTable.addColor(color2);
        } else {
            this.rgbBack = 0;
            this.icvBack = colorTable.addColor(Color.black);
        }
        this.pattern = s;
    }

    public void setIsRound(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 2 : this.grbit & 0xFFFFFFFD);
    }

    public AreaFormat(int n, int n2, short s, short s2, short s3, short s4, ColorTable colorTable) {
        this(colorTable);
        this.rgbFore = n;
        this.rgbBack = n2;
        this.pattern = s;
        this.grbit = s2;
        this.icvFore = s3;
        this.icvBack = s4;
    }

    @Override
    public final int opcode() {
        return 4106;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        if (this.SEDU.needUpdateIndex()) {
            if (this.icvFore > 0) {
                this.icvFore = this.SEDU.updateColorIndex(this.icvFore);
            }
            if (this.icvBack > 0) {
                this.icvBack = this.SEDU.updateColorIndex(this.icvBack);
            }
        }
        this.writeInt(randomAccessStream, this.rgbFore);
        this.writeInt(randomAccessStream, this.rgbBack);
        this.writeShort(randomAccessStream, this.pattern);
        this.writeShort(randomAccessStream, this.grbit);
        this.writeShort(randomAccessStream, this.icvFore);
        this.writeShort(randomAccessStream, this.icvBack);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.rgbFore = this.readInt(randomAccessStream);
        this.rgbBack = this.readInt(randomAccessStream);
        this.pattern = this.readShort(randomAccessStream);
        this.grbit = this.readShort(randomAccessStream);
        this.icvFore = this.readShort(randomAccessStream);
        this.icvBack = this.readShort(randomAccessStream);
    }

    public void setPattern(short s) {
        this.pattern = s;
    }

    public short getPattern() {
        return this.pattern;
    }

    public boolean isAutoFormat() {
        return (this.grbit & 1) == 1;
    }

    public void setAutoFormat(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE);
    }

    public boolean isSwap() {
        return (this.grbit & 2) == 2;
    }

    public int getIcvFore() {
        return this.icvFore;
    }

    public int getIcvBack() {
        return this.icvBack;
    }
}

