/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import util.RandomAccessStream;

public class AttachedLabel
extends Biff {
    public static final short SHOWVALUE = 1;
    public static final short SHOWPERCENT = 2;
    public static final short SHOWLABPER = 4;
    public static final short SMOOTHLINE = 8;
    public static final short SHOWLABEL = 16;
    public static final short SHOWBUBBLESIZE = 32;
    public static final short SHOWSERIESNAME = 64;
    short grbit;

    public AttachedLabel() {
        this.length = 2;
    }

    public AttachedLabel(short s) {
        this.length = 2;
        this.grbit = s;
    }

    @Override
    public final int opcode() {
        return 4108;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeShort(randomAccessStream, this.grbit);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.grbit = this.readShort(randomAccessStream);
    }

    public boolean isShowValue() {
        return (this.grbit & 1) == 1;
    }

    public void setShowValue(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE);
    }

    public boolean isShowPercent() {
        return (this.grbit & 2) == 2;
    }

    public void setShowPercent(boolean bl) {
        if (bl) {
            this.setShowValue(false);
        }
        this.grbit = (short)(bl ? this.grbit | 2 : this.grbit & 0xFFFFFFFD);
    }

    public boolean isShowLabPer() {
        return (this.grbit & 4) == 4;
    }

    public void setShowLabPer(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 4 : this.grbit & 0xFFFFFFFB);
    }

    public boolean isSmoothLine() {
        return (this.grbit & 8) == 8;
    }

    public void setSmoothLine(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 8 : this.grbit & 0xFFFFFFF7);
    }

    public boolean isShowLabel() {
        return (this.grbit & 0x10) == 16;
    }

    public void setShowLabel(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x10 : this.grbit & 0xFFFFFFEF);
    }

    public boolean isShowBubbleSize() {
        return (this.grbit & 0x20) == 32;
    }

    public void setShowBubbleSize(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x20 : this.grbit & 0xFFFFFFDF);
    }

    public void setShowSeriesName(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x40 : this.grbit & 0xFFFFFFBF);
    }

    public boolean isNeed() {
        return this.grbit != 0;
    }
}

