/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import util.RandomAccessStream;

public class Chart3D
extends Biff {
    public static final short PERSPECTIVE = 1;
    public static final short CLUSTER = 2;
    public static final short AUTOSCALING = 4;
    private static final short I = 16;
    public static final short WALLS = 32;
    short anRot;
    short anElev;
    short pcDist;
    short pcHeight = (short)100;
    short pcDepth = (short)100;
    short pcGap;
    short grbit;

    public Chart3D() {
        this.length = 14;
        this.setNotPie(true);
        this.setScaling(true);
        this.setPerspective(true);
        this.setCluster(false);
    }

    public Chart3D(short s, short s2, short s3, short s4, short s5, short s6, short s7) {
        this.anRot = s;
        this.anElev = s2;
        this.pcDist = s3;
        this.pcHeight = s4;
        this.pcDepth = s5;
        this.pcGap = s6;
        this.grbit = s7;
        this.length = 14;
    }

    public void setDistance(short s) {
        if (s < 0) {
            s = 0;
        }
        if (s > 100) {
            s = (short)100;
        }
        this.setPerspective(true);
        this.pcDist = s;
    }

    public void setRotation(short s) {
        if (s < 0) {
            s = (short)(360 + s);
        }
        this.anRot = s;
    }

    public void setElevation(short s) {
        if (s > 90) {
            s = (short)(s - 90);
        } else if (s < -90) {
            s = (short)(s + 90);
        }
        this.anElev = s;
    }

    public void setDepth(short s) {
        if (s < 1) {
            s = 1;
        }
        if (s > 2000) {
            s = (short)2000;
        }
        this.pcDepth = s;
    }

    public void setGap(short s) {
        this.pcGap = s;
    }

    public void setHeight(short s) {
        this.pcHeight = s;
    }

    @Override
    public final int opcode() {
        return 4154;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeShort(randomAccessStream, this.anRot);
        this.writeShort(randomAccessStream, this.anElev);
        this.writeShort(randomAccessStream, this.pcDist);
        this.writeShort(randomAccessStream, this.pcHeight);
        this.writeShort(randomAccessStream, this.pcDepth);
        this.writeShort(randomAccessStream, this.pcGap);
        this.writeShort(randomAccessStream, this.grbit);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.anRot = this.readShort(randomAccessStream);
        this.anElev = this.readShort(randomAccessStream);
        this.pcDist = this.readShort(randomAccessStream);
        this.pcHeight = this.readShort(randomAccessStream);
        this.pcDepth = this.readShort(randomAccessStream);
        this.pcGap = this.readShort(randomAccessStream);
        this.grbit = this.readShort(randomAccessStream);
    }

    public boolean isPerspective() {
        return (this.grbit & 1) == 1;
    }

    public void setPerspective(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE);
    }

    public boolean isCluster() {
        return (this.grbit & 2) == 2;
    }

    public void setCluster(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 2 : this.grbit & 0xFFFFFFFD);
    }

    public boolean isScaling() {
        return (this.grbit & 4) == 4;
    }

    public void setScaling(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 4 : this.grbit & 0xFFFFFFFB);
    }

    public void setNotPie(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x10 : this.grbit & 0xFFFFFFEF);
        if (!bl) {
            this.setPerspective(false);
            this.setScaling(false);
        }
    }

    public boolean isWall() {
        return (this.grbit & 0x20) == 32;
    }

    public void setWall(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x20 : this.grbit & 0xFFFFFFDF);
    }
}

