/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.awt.Color;
import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import util.RandomAccessStream;

public class LineFormat
extends Biff {
    public static final short AUTOFORMAT = 1;
    public static final short DRAWTICK = 4;
    private static final short SEDU = 8;
    public static final short PATTERN_SOLID = 0;
    public static final short PATTERN_DASH = 1;
    public static final short PATTERN_DOT = 2;
    public static final short PATTERN_DASH_DOT = 3;
    public static final short PATTERN_DASHDOT_DOT = 4;
    public static final short PATTERN_NONE = 5;
    public static final short PATTERN_DARKGRAYPATTERN = 6;
    public static final short PATTERN_MEDIUMGRAYPATTERN = 7;
    public static final short PATTERN_LIGHTGRAYPATTERN = 8;
    public static final short WEIGHT_HAIRLINE = -1;
    public static final short WEIGHT_NARROW = 0;
    public static final short WEIGHT_MEDIUM = 1;
    public static final short WEIGHT_WIDE = 2;
    short pattern;
    short weight;
    short grbit;
    short icv;
    int rgb;
    private ColorTable addColor;

    public LineFormat(ColorTable colorTable) {
        this.length = 12;
        this.addColor = colorTable;
    }

    public void setColorIndex(short s) {
        this.icv = s;
    }

    public void setColorRgb(int n) {
        this.rgb = n;
    }

    public LineFormat(int n, short s, short s2, short s3, short s4, ColorTable colorTable) {
        this(colorTable);
        this.rgb = n;
        this.pattern = s;
        this.weight = s2;
        this.grbit = s3;
        this.icv = s4;
    }

    public LineFormat(Color color, byte by, int n, ColorTable colorTable) {
        this(colorTable);
        this.rgb = colorTable.getColorRGB(color);
        this.pattern = by;
        this.icv = colorTable.addColor(color);
        this.weight = (short)(n < 20 ? (n < 10 ? -1 : 0) : (n > 35 ? 2 : 1));
    }

    @Override
    public final int opcode() {
        return 4103;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        if (this.addColor.needUpdateIndex() && this.icv >= 0) {
            this.icv = this.addColor.updateColorIndex(this.icv);
        }
        if (this.rgb == -1) {
            this.rgb = 0;
        }
        this.writeInt(randomAccessStream, this.rgb);
        this.writeShort(randomAccessStream, this.pattern);
        this.writeShort(randomAccessStream, this.weight);
        this.writeShort(randomAccessStream, this.grbit);
        this.writeShort(randomAccessStream, this.icv);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.rgb = this.readInt(randomAccessStream);
        this.pattern = this.readShort(randomAccessStream);
        this.weight = this.readShort(randomAccessStream);
        this.grbit = this.readShort(randomAccessStream);
        this.icv = this.readShort(randomAccessStream);
    }

    public void setPattern(short s) {
        this.pattern = s;
    }

    public short getPattern() {
        return this.pattern;
    }

    public void setWeight(short s) {
        this.weight = s;
    }

    public short getWeight() {
        return this.weight;
    }

    public boolean isAutoFormat() {
        return (this.grbit & 1) == 1;
    }

    public boolean isDrawTick() {
        return (this.grbit & 4) == 4;
    }

    public void setDrawTick(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 4 : this.grbit & 0xFFFFFFFB);
    }

    public void setAutoColor(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 8 : this.grbit & 0xFFFFFFF7);
    }
}

