/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.awt.Color;
import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import util.RandomAccessStream;

public class MarkerFormat
extends Biff {
    public static final short NONE = 0;
    public static final short SQUARE = 1;
    public static final short DIAMOND = 2;
    public static final short TRIANGLE = 3;
    public static final short X = 4;
    public static final short STAR = 5;
    public static final short DOWJONES = 6;
    public static final short DEVIATION = 7;
    public static final short CIRCLE = 8;
    public static final short PLUSSIGN = 9;
    public static final short AUTOCOLOR = 1;
    public static final short NOBACK = 16;
    public static final short NOFORE = 32;
    int rgbFore;
    int rgbBack;
    int size;
    short type;
    short grbit;
    short icvFore;
    short icvBack;
    private ColorTable SEDU;

    public MarkerFormat(ColorTable colorTable) {
        this.length = 20;
        this.SEDU = colorTable;
    }

    public MarkerFormat(int n, int n2, short s, short s2, short s3, short s4, int n3, ColorTable colorTable) {
        this.SEDU = colorTable;
        this.rgbFore = n;
        this.rgbBack = n2;
        this.type = s;
        this.grbit = s2;
        this.icvFore = s3 == -1 ? (short)77 : s3;
        this.icvBack = s4 == -1 ? (short)78 : s4;
        this.size = n3;
        this.length = 20;
    }

    public MarkerFormat(short s, Color color, Color color2, int n, ColorTable colorTable) {
        this.SEDU = colorTable;
        if (color != null) {
            this.rgbFore = colorTable.getColorRGB(color);
            this.icvFore = colorTable.addColor(color);
        } else {
            this.icvFore = (short)77;
            this.setNofore(true);
        }
        if (color2 != null) {
            this.rgbBack = colorTable.getColorRGB(color2);
            this.icvBack = colorTable.addColor(color2);
        } else {
            this.icvBack = (short)78;
            this.setNoback(true);
        }
        this.setType((byte)s);
        this.size = n;
        this.length = 20;
    }

    @Override
    public final int opcode() {
        return 4105;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        if (this.SEDU.needUpdateIndex()) {
            if (this.icvFore > 0) {
                this.icvFore = this.SEDU.updateColorIndex(this.icvFore);
            }
            if (this.icvBack > 0) {
                this.icvBack = this.SEDU.updateColorIndex(this.icvBack);
            }
        }
        this.writeInt(randomAccessStream, this.rgbFore);
        this.writeInt(randomAccessStream, this.rgbBack);
        this.writeShort(randomAccessStream, this.type);
        this.writeShort(randomAccessStream, this.grbit);
        this.writeShort(randomAccessStream, this.icvFore);
        this.writeShort(randomAccessStream, this.icvBack);
        this.writeInt(randomAccessStream, this.size);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.rgbFore = this.readInt(randomAccessStream);
        this.rgbBack = this.readInt(randomAccessStream);
        this.type = this.readShort(randomAccessStream);
        this.grbit = this.readShort(randomAccessStream);
        this.icvFore = this.readShort(randomAccessStream);
        this.icvBack = this.readShort(randomAccessStream);
        this.size = this.readInt(randomAccessStream);
    }

    public void setType(byte by) {
        this.type = by;
    }

    public short getType() {
        return this.type;
    }

    public boolean isAutoColor() {
        return (this.grbit & 1) == 1;
    }

    public void setAutoColor(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE);
    }

    public boolean isNoback() {
        return (this.grbit & 0x10) == 16;
    }

    public void setNoback(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x10 : this.grbit & 0xFFFFFFEF);
    }

    public boolean isNofore() {
        return (this.grbit & 0x20) == 32;
    }

    public void setNofore(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x20 : this.grbit & 0xFFFFFFDF);
    }
}

