/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.awt.Color;
import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import util.RandomAccessStream;

public class Tick
extends Biff {
    public static final byte NONE = 0;
    public static final byte INSIDE = 1;
    public static final byte OUTSIDE = 2;
    public static final byte CROSS = 3;
    public static final byte SHOWNONE = 0;
    public static final byte LOWAREA = 1;
    public static final byte HIGHAREA = 2;
    public static final byte NEXTAXIS = 3;
    public static final byte TRANSPARENT = 1;
    public static final byte OPAQUE = 2;
    public static final short AUTOCOLOR = 1;
    public static final short AUTOBG = 2;
    public static final short DEFAULT = -29;
    public static final short NOROTATION = 0;
    public static final short UPRIGHT = 4;
    public static final short ROT90COUNTERCLOCK = 8;
    public static final short ROT90CLOCK = 12;
    public static final short AUTOROT = 32;
    public static final int TEX_ORDER_DEFAULT = 63;
    public static final int TEX_ORDER_LEFT_RIGHT = 16447;
    public static final int TEX_ORDER_RIGHT_LEFT = 32831;
    byte tktMajor = (byte)2;
    byte tktMinor = 0;
    byte tlt = (byte)3;
    byte bgMode = 1;
    int rgb;
    int grbit;
    short icv;
    short rot;
    private ColorTable SEDU;

    public Tick(ColorTable colorTable) {
        this.SEDU = colorTable;
        this.length = 30;
        this.SEDU(true);
        this.addColor(true);
        this.rgb = 0;
        this.icv = colorTable.addColor(Color.black);
    }

    @Override
    public final int opcode() {
        return 4126;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        if (this.SEDU.needUpdateIndex()) {
            this.icv = this.SEDU.updateColorIndex(this.icv);
        }
        randomAccessStream.writeByte(this.tktMajor);
        randomAccessStream.writeByte(this.tktMinor);
        randomAccessStream.writeByte(this.tlt);
        randomAccessStream.writeByte(this.bgMode);
        this.writeInt(randomAccessStream, this.rgb);
        this.writeInt(randomAccessStream, 0);
        this.writeInt(randomAccessStream, 0);
        this.writeInt(randomAccessStream, 0);
        this.writeInt(randomAccessStream, 0);
        this.writeShort(randomAccessStream, this.grbit);
        this.writeShort(randomAccessStream, this.icv);
        this.writeShort(randomAccessStream, this.rot);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.tktMajor = randomAccessStream.readByte();
        this.tktMinor = randomAccessStream.readByte();
        this.tlt = randomAccessStream.readByte();
        this.bgMode = randomAccessStream.readByte();
        this.rgb = this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.grbit = this.readIntWithShortFormat(randomAccessStream);
        this.icv = this.readShort(randomAccessStream);
        this.rot = this.readShort(randomAccessStream);
    }

    public void setTickMajor(byte by) {
        this.tktMajor = by;
    }

    public byte getTickMajor() {
        return this.tktMajor;
    }

    public void setTickMinor(byte by) {
        this.tktMinor = by;
    }

    public byte getTickMinor() {
        return this.tktMinor;
    }

    public void setTlt(byte by) {
        this.tlt = by;
    }

    public byte getTlt() {
        return this.tlt;
    }

    public void setBgMode(byte by) {
        this.bgMode = by;
    }

    public byte getBgMode() {
        return this.bgMode;
    }

    public void setRotation(short s) {
        this.rot = s;
        this.addColor(false);
    }

    public short getRotation() {
        return this.rot;
    }

    public boolean isAutoColor() {
        return (this.grbit & 1) == 1;
    }

    private void SEDU(boolean bl) {
        this.grbit = bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE;
    }

    public boolean isAutoBg() {
        return (this.grbit & 2) == 2;
    }

    public void setAutoBg(boolean bl) {
        this.grbit = bl ? this.grbit | 2 : this.grbit & 0xFFFFFFFD;
    }

    public void setRot(short s) {
        this.grbit = (short)(this.grbit & 0xFFFFFFE3);
        this.grbit = (short)(this.grbit | s);
    }

    public short getRot() {
        return (short)(this.grbit | 0x1C);
    }

    public boolean isAutoRot() {
        return (this.grbit & 0x20) == 32;
    }

    private void addColor(boolean bl) {
        this.grbit = bl ? this.grbit | 0x20 : this.grbit & 0xFFFFFFDF;
    }

    public void setTextOrder(int n) {
        this.grbit |= n;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.rgb = this.SEDU.getColorRGB(color);
            this.icv = this.SEDU.addColor(color);
            this.SEDU(false);
        } else {
            this.SEDU(true);
        }
    }

    public boolean isShow() {
        return this.tktMajor != 0 ? true : (this.tktMinor != 0 ? true : this.tlt != 0);
    }
}

