/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import util.RandomAccessStream;

public class ValueRange
extends Biff {
    public static final short AUTOMIN = 1;
    public static final short AUTOMAX = 2;
    public static final short AUTOMAJOR = 4;
    public static final short AUTOMINOR = 8;
    public static final short AUTOCROSS = 16;
    public static final short LOGSCALE = 32;
    public static final short REVERSE = 64;
    public static final short MAXCROSS = 128;
    double numMin;
    double numMax;
    double numMajor;
    double numMinor;
    double numCross;
    short grbit;

    public ValueRange() {
    }

    public ValueRange(double d, double d2, double d3, double d4, double d5, short s) {
        this.numMin = d;
        this.numMax = d2;
        this.numMajor = d3;
        this.numMinor = d4;
        this.numCross = d5;
        this.grbit = s;
        this.length = 42;
    }

    @Override
    public final int opcode() {
        return 4127;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.numMin));
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.numMax));
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.numMajor));
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.numMinor));
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.numCross));
        this.writeShort(randomAccessStream, this.grbit);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.numMin = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.numMax = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.numMajor = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.numMinor = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.numCross = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.grbit = this.readShort(randomAccessStream);
    }

    public boolean isAutoMin() {
        return (this.grbit & 1) == 1;
    }

    public void setAutoMin(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 1 : this.grbit & 0xFFFFFFFE);
    }

    public boolean isAutoMax() {
        return (this.grbit & 2) == 2;
    }

    public void setAutoMax(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 2 : this.grbit & 0xFFFFFFFD);
    }

    public boolean isAutoMajor() {
        return (this.grbit & 4) == 4;
    }

    public void setAutoMajor(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 4 : this.grbit & 0xFFFFFFFB);
    }

    public boolean isAutoMinor() {
        return (this.grbit & 8) == 8;
    }

    public void setAutoMinor(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 8 : this.grbit & 0xFFFFFFF7);
    }

    public boolean isAutoCross() {
        return (this.grbit & 0x10) == 16;
    }

    public void setAutoCross(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x10 : this.grbit & 0xFFFFFFEF);
    }

    public boolean isLogScale() {
        return (this.grbit & 0x20) == 32;
    }

    public void setLogScale(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x20 : this.grbit & 0xFFFFFFDF);
    }

    public boolean isReverse() {
        return (this.grbit & 0x40) == 64;
    }

    public void setReverse(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x40 : this.grbit & 0xFFFFFFBF);
    }

    public boolean isMaxCross() {
        return (this.grbit & 0x80) == 128;
    }

    public void setMaxCross(boolean bl) {
        this.grbit = (short)(bl ? this.grbit | 0x80 : this.grbit & 0xFFFFFF7F);
    }
}

